#ifndef HDR_xspice_h
#define HDR_xspice_h

#include "basic.h"
#include <stdio.h>

#ifndef APP_MSG
#include "ewbmdefs.h"
#endif

#include "instance.h"
#undef  TF_OUTPOS
#undef  TF_OUTNEG
#undef  TF_OUTSRC
#undef  SENS_DC
#undef  SHIFT_LEFT
#undef  SHIFT_RIGHT

#ifdef EWB_IIT
  #define BUILD_VERSION  "(DLL version)"
  // #define USE_MEMORY_POOLS
  #define DOCHECKHEAP
  #define USE_HEAPAGENT
#else
  #define BUILD_VERSION  "(DOS32 version)"
#endif

#ifdef DEBUG_XSPICE
extern FILE* debug_file;
#endif

#define DEBUG_FILE_NAME       "debug.xsp"
#define DEBUG_FILE_OPEN()     (debug_file=fopen(DEBUG_FILE_NAME,"a"))
#define DEBUG_FILE_FLUSH()    fflush(debug_file)
#define DEBUG_FILE_CLOSE()    fclose(debug_file)

#define DEBUG_VOID(x)         ((void)(x))

#ifdef DEBUG_XSPICE
  #define DEBUG_INIT()                    DEBUG_VOID( debug_file=fopen(DEBUG_FILE_NAME,"w"), fprintf(debug_file,"THIS IS THE DEBUGING OUTPUT FOR XSPICE "  BUILD_VERSION "\n"), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT(str)                DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\n",str), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT1(str,x)             DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g\n",str,(double)x), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT2(str,x,y)           DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g\n",str,(double)x,(double)y), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT3(str,x,y,z)         DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g,\t %g\n",str,(double)x,(double)y,(double)z), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT4(str,x,y,z,a)       DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g,\t %g,\t %g\n",str,(double)x,(double)y,(double)z,(double)a), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT5(str,x,y,z,a,b)     DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g,\t %g,\t %g,\t %g\n",str,(double)x,(double)y,(double)z,(double)a,(double)b), DEBUG_FILE_CLOSE() )

  #define DEBUG_PRINTs(str,s)             DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s ::= %s",str,s), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT1s(str,s,x)          DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g\n",str,s,(double)x), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT2s(str,s,x,y)        DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g\n",str,s,(double)x,(double)y), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT3s(str,s,x,y,z)      DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g,\t %g\n",str,s,(double)x,(double)y,(double)z), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT4s(str,s,x,y,z,a)    DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g,\t %g,\t %g\n",str,s,(double)x,(double)y,(double)z,(double)a), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT5s(str,s,x,y,z,a,b)  DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g,\t %g,\t %g,\t %g\n",str,s,(double)x,(double)y,(double)z,(double)a,(double)b), DEBUG_FILE_CLOSE() )

  struct CKTcircuit_tag;

  #define DEBUG_MATRIX(ckt)                                   \
     DEBUG_VOID(                                              \
       DEBUG_FILE_OPEN(),                                     \
       fprintf(debug_file,"\n\n\n (%s,%d):THE FOLLOWING IS VALUE OF 'CKTmatrix'\n",__FILE__,__LINE__),   \
       SMPprintWithRHS(((struct CKTcircuit_tag*)ckt)->CKTmatrix, ((struct CKTcircuit_tag*)ckt)->CKTrhs, ((struct CKTcircuit_tag*)ckt)->CKTirhs, debug_file), \
       fprintf(debug_file,"\n\n"),                            \
       DEBUG_FILE_CLOSE()                                     \
     )

  #define DEBUG_MATRIX_ARG1(ckt,fmt,arg)                      \
     DEBUG_VOID(                                              \
       DEBUG_FILE_OPEN(),                                     \
       fprintf(debug_file,"\n\n\n(%s,%d):THE FOLLOWING IS VALUE OF '" #ckt "->CKTmatrix' :: ",__FILE__,__LINE__),   \
       fprintf(debug_file,(fmt),(arg)),   \
       fprintf(debug_file,"\n"),          \
       SMPprintWithRHS(((struct CKTcircuit_tag*)ckt)->CKTmatrix, ((struct CKTcircuit_tag*)ckt)->CKTrhs, ((struct CKTcircuit_tag*)ckt)->CKTirhs, debug_file), \
       fprintf(debug_file,"\n\n"),                            \
       DEBUG_FILE_CLOSE()                                     \
     )

  extern void dump_circuit_summary(FILE* file,struct CKTcircuit_tag* ckt);

  #define DEBUG_DUMP_CIRCUIT(ckt)                       \
     DEBUG_VOID(                                        \
       DEBUG_FILE_OPEN(),                               \
       fprintf(debug_file,"\n\n\n(%s,%d):THE FOLLOWING IS CONNECTION LIST OF '" #ckt "'\n",__FILE__,__LINE__),   \
       dump_circuit_summary(debug_file,(struct CKTcircuit_tag*) ckt),   \
       fprintf(debug_file,"\n\n"),                      \
       DEBUG_FILE_CLOSE()                               \
     )

  #define DEBUG_EXPR(x)                       DEBUG_VOID(x)
  #define DEBUG_DO_ONLY_FIRST_PASS(x)         { static int done=0; if (!done) x; done=1; }

#else
  #define DEBUG_INIT()                    DEBUG_VOID(0)
  #define DEBUG_PRINT(str)                DEBUG_VOID(0)
  #define DEBUG_PRINT1(str,x)             DEBUG_VOID(0)
  #define DEBUG_PRINT2(str,x,y)           DEBUG_VOID(0)
  #define DEBUG_PRINT3(str,x,y)           DEBUG_VOID(0)
  #define DEBUG_PRINT4(str,x,y,z)         DEBUG_VOID(0)
  #define DEBUG_PRINT5(str,x,y,z,w)       DEBUG_VOID(0)

  #define DEBUG_PRINTs(str,s)             DEBUG_VOID(0)
  #define DEBUG_PRINT1s(str,s,x)          DEBUG_VOID(0)
  #define DEBUG_PRINT2s(str,s,x,y)        DEBUG_VOID(0)
  #define DEBUG_PRINT3s(str,s,x,y,z)      DEBUG_VOID(0)
  #define DEBUG_PRINT4s(str,s,x,y,z,a)    DEBUG_VOID(0)
  #define DEBUG_PRINT5s(str,s,x,y,z,a,b)  DEBUG_VOID(0)

  #define DEBUG_MATRIX(ckt)               DEBUG_VOID(0)
  #define DEBUG_MATRIX_ARG1(ckt,fmt,arg)  DEBUG_VOID(0)

  #define DEBUG_DUMP_CIRCUIT(ckt)         DEBUG_VOID(0)

  #define DEBUG_EXPR(x)                       DEBUG_VOID(0)
  #define DEBUG_DO_ONLY_FIRST_PASS(x)         {}
#endif









#ifdef IIT
  /* KLUDGE: WE REALLY SHOULD ITERATE THROUGH THE PARAMETERS, BUT ASSUMING
   *         THAT THIS FUNCTION ONLY APPLIES TO XSPICE MODELS, EVERYTHING
   *         SHOULD BE OKAY.
   */
  #define IIT_KLUDGE_ARRAY [0]
#else
  #define IIT_KLUDGE_ARRAY
#endif


#if !defined(WIN32) && defined(EWB_IIT)
	#undef FAR
	#define FAR far
#elif defined(MSVC)
	#undef FAR
	#define FAR
#else
	#ifndef FAR
		#define FAR
	#endif
#endif


//#define DOCHECKHEAP
#ifdef DOCHECKHEAP
  extern void checkHeapSizedPtr(char const* ptr,int size);
  extern void checkHeap(char const* file,int lineno);
  extern void checkPtr(void* ptr);
  #define CHECKHEAP()           checkHeap(__FILE__,__LINE__)
  #define CHECKPTR(p)           checkHeapPtr((void*)(p))
  #define CHECKNPTR(p)          { if ((void*)(p)) checkHeapPtr((void*)(p)); }
  #define CHECKSIZEDNPTR(p,s)   { if ((void*)(p)) checkHeapSizedPtr((char*)(p),s); }
  #define CHECKSIZEDPTR(p,s)    checkHeapSizedPtr((char*)(p),s)
#else
  #define CHECKHEAP()           (void)0
  #define CHECKPTR(p)           (void)0
  #define CHECKHEAP()           (void)0
  #define CHECKSIZEDPTR(p,s)    (void)0
#endif

#ifdef MEM_ALLOC_CHECK_HEAP
  #define MEM_ALLOC_CHECKHEAP()           checkHeap(__FILE__,__LINE__)
#else
  #define MEM_ALLOC_CHECKHEAP()           (void)0
#endif


#define IPC_DEBUG_VIA_STDIO


#ifndef G_IPC_NOT_ENABLED
  #define G_IPC_NOT_ENABLED
#endif

#ifndef SPICE_BUILD
#ifndef XSPICE
  #define XSPICE
#endif
#endif

#ifndef IIT
  #define IIT
#endif

#ifdef IIT
typedef int (*qsort_cmp_t)(const void *, const void *);
#include <assert.h>
#endif

#ifdef IIT
  // Remove Microsoft's complex definition
  #ifndef _COMPLEX_DEFINED
     #define _COMPLEX_DEFINED
  #endif
  extern int NUM_SPICE3_MODELS;
#endif



/* gtri - modify - wbk - 10/8/90 - change paths */
#define BUGADDR "xspice@prism.gatech.edu"    /* Where to send bugs. */
#define HELPPATH "\\spice\\lib\\sim\\helpdir"
#define SPICEDLOG "\\tmp\\logfile"
#define NEWSFILE "\\spice\\lib\\sim\\news"    /* The message of the day. */

#if 0
#define LIBPATH "\\xspice~1\\lib\\sim\\scripts"
#define DEFAULTMFBCAP "\\xspice~1\\lib\\sim\\mfbcap"    /* The mfbcap file. */
#define SPICEHOST ""        /* Where to do rspice, "" = nowhere */
#define SPICEPATH "\\xspice~1\\bin" /* Where the binary is kept */

#else

#define LIBPATH "/usr/local/xspice-1-0/lib/sim/scripts"
#define DEFAULTMFBCAP "/usr/local/xspice-1-0/lib/sim/mfbcap"    /* The mfbcap file. */
#define SPICEHOST ""        /* Where to do rspice, "" = nowhere */
#define SPICEPATH "/usr/local/xspice-1-0/bin" /* Where the binary is kept */

#endif


/* THESE FILES NEED TO BE INCLUDED TO PROPERLY PROTOTYPE ALL FUNCTIONS
 */
#include "cm.h"
#include "enh.h"
#include "ipc.h"
#include "mif.h"
#include "mifproto.h"
#include "cmconst.h"
#include "evt.h"
#include "ipcproto.h"
#include "mifcmdat.h"
#include "miftypes.h"
#include "cmproto.h"
#include "evtproto.h"
#include "ipctiein.h"
#include "mifdefs.h"
#include "cmtypes.h"
#include "evtudn.h"
#include "mifparse.h"

#include "misc.h"


#if defined(IIT) && defined(EWB_IIT) && defined(XSPICE)
extern void free_Mif_Info(InstanceHandle inst, struct Mif_Info_s* g_mif_info);
extern void free_Enh_Ckt_Data(InstanceHandle inst, struct Enh_Ckt_Data_t* enh,CKTcircuit *ckt);
extern void free_Evt_Ckt_Data(InstanceHandle inst, struct Evt_Ckt_Data_s* evt,CKTcircuit *ckt);
#endif

#define XSPICE_PI   3.14159265358979323846

#endif

#define QUIT_CURRENT_ANALYSIS -1942
#define NON_RECOVERABLE_ERROR -1969

#define serious_error(error) ( (error)==NON_RECOVERABLE_ERROR || (error==QUIT_CURRENT_ANALYSIS) )

#define MIN_DIV_CONST 1e-12

extern double checked_divide_variable;

#define MIN_DENOMINATOR_OF(x) ( checked_divide_variable=(x),                                                            \
                                checked_divide_variable=   (0<=checked_divide_variable && checked_divide_variable<MIN_DIV_CONST)  ? MIN_DIV_CONST   \
                                                        :  (0>checked_divide_variable  && checked_divide_variable>-MIN_DIV_CONST) ? -MIN_DIV_CONST  \
                                                        :  checked_divide_variable                                      \
                              )

#define CHECKED_DIVIDE(x,y)  (MIN_DENOMINATOR_OF(y),         \
                              (x)/checked_divide_variable    \
                             )
#ifdef EWB_IIT
   #define IIT_NL       "   "
#else
   #define IIT_NL       "\n"
#endif




