//insert file>> #include "xspice.h"

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef DEV
#define DEV

//insert file>> #include "optdefs.h"
//insert file>> #include "xspice.h"

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "gendefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

//insert file>> #include "cktdefs.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CKT
#define CKT "CKTdefs.h $Revision: 1.13 $  on $Date: 89/04/05 13:09:39 $ "
  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing CKTdefs.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

//insert file>>   #include "basic.h"
//insert file>>   #include "xspice.h"

  #ifdef XSPICE
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
//insert file>>     #include "EVT.h"
#ifndef EVT_HEADER
#define EVT_HEADER 

/* ===========================================================================
FILE    EVT.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of the evt data structure and all
    its substructures.  The single evt structure is housed inside of
    the main 3C1 circuit structure 'ckt' and contains virtually all
    information about the event-driven simulation.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFdefs.h"
//insert file>> #include "MIFcmdat.h"
//insert file>> #include "MIFtypes.h"


/* ************** */
/* Info structure */
/* ************** */


typedef struct Evt_Output_Info_s {
    struct Evt_Output_Info_s  *next;  /* the next in the linked list */
    int  node_index;                  /* index into node info struct for this output */
    int  output_subindex;             /* index into output data in node data struct  */
    int  inst_index;                  /* Index of instance the port is on */
    int  port_index;                  /* Index of port the output corresponds to */
} Evt_Output_Info_t;

typedef struct Evt_Port_Info_s {
    struct Evt_Port_Info_s  *next;        /* the next in the linked list of node info */
    int                     inst_index;   /* Index of instance the port is on */
    int                     node_index;   /* index of node the port is connected to */
    char                    *node_name;   /* name of node port is connected to */
    char                    *inst_name;   /* instance name */
    char                    *conn_name;   /* connection name on instance */
    int                     port_num;     /* port number of instance connector */
} Evt_Port_Info_t;

typedef struct Evt_Inst_Index_s {
    struct Evt_Inst_Index_s  *next;           /* the next in the linked list */
    int                      index_value;     /* the value of the index */
} Evt_Inst_Index_t;

typedef struct Evt_Node_Info_s {
    struct Evt_Node_Info_s  *next;     /* the next in the linked list */
    char              *name;           /* Name of node in deck */
    int               udn_index;       /* Index of the node type */
    Mif_BOOLEAN_t     invert;          /* True if need to make inverted copy */
    int               num_ports;       /* Number of ports connected to this node */
    int               num_outputs;     /* Number of outputs connected to this node */
    int               num_insts;       /* The number of insts receiving node as input */
    Evt_Inst_Index_t  *inst_list;      /* Linked list of indexes of these instances */
} Evt_Node_Info_t;

typedef struct Evt_Inst_Info_s {
    struct Evt_Inst_Info_s  *next;      /* the next in the linked list of node info */
    struct sMIFinstance     *inst_ptr;  /* Pointer to MIFinstance struct for this instance */
} Evt_Inst_Info_t;

typedef struct Evt_Info_ {
    Evt_Inst_Info_t    *inst_list;         /* static info about event/hybrid instances */
    Evt_Node_Info_t    *node_list;         /* static info about event nodes */
    Evt_Port_Info_t    *port_list;         /* static info about event ports */
    Evt_Output_Info_t  *output_list;       /* static info about event outputs */
    int                *hybrid_index;      /* vector of inst indexs for hybrids */
    Evt_Inst_Info_t    **inst_table;       /* vector of pointers to elements in inst_list */
    Evt_Node_Info_t    **node_table;       /* vector of pointers to elements in node_list */
    Evt_Port_Info_t    **port_table;       /* vector of pointers to elements in port_list */
    Evt_Output_Info_t  **output_table;     /* vector of pointers to elements in output_list */
} Evt_Info_t;








/* *************** */
/* Queue structure */
/* *************** */



typedef struct Evt_Inst_Event_s {
    struct Evt_Inst_Event_s  *next; /* the next in the linked list */
    double            event_time;   /* Time for this event to happen */
    double            posted_time;  /* Time at which event was entered in queue */
} Evt_Inst_Event_t; 

typedef struct Evt_Inst_Queue_s {
    Evt_Inst_Event_t  **head;          /* Beginning of linked lists */
    Evt_Inst_Event_t  ***current;      /* Beginning of pending events */
    Evt_Inst_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Inst_Event_t  **free;          /* Linked lists of items freed by backups */
    double            last_time;       /* Time at which last_step was set */
    double            next_time;       /* Earliest next event time in queue */
    int               num_modified;    /* Number modified since last accepted timepoint */
    int               *modified_index; /* Indexes of modified instances */
    Mif_BOOLEAN_t     *modified;       /* Flags used to prevent multiple entries */
    int               num_pending;     /* Count of number of pending events in lists */
    int               *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t     *pending;        /* Flags used to prevent multiple entries */
    int               num_to_call;     /* Count of number of instances that need to be called */
    int               *to_call_index;  /* Indexes of instances to be called */
    Mif_BOOLEAN_t     *to_call;        /* Flags used to prevent multiple entries */
} Evt_Inst_Queue_t;




typedef struct Evt_Node_Queue_s {
    int               num_to_eval;    /* Count of number of nodes that need to be evaluated */
    int               *to_eval_index; /* Indexes of nodes to be evaluated */
    Mif_BOOLEAN_t     *to_eval;       /* Flags used to prevent multiple entries */
    int               num_changed;    /* Count of number of nodes that changed */
    int               *changed_index; /* Indexes of nodes that changed */
    Mif_BOOLEAN_t     *changed;       /* Flags used to prevent multiple entries */
} Evt_Node_Queue_t;




typedef struct Evt_Output_Event_s {
    struct Evt_Output_Event_s  *next; /* the next in the linked list */
    double            event_time;     /* Time for this event to happen */
    double            posted_time;    /* Time at which event was entered in queue */
    Mif_BOOLEAN_t     removed;        /* True if event has been deactivated */
    double            removed_time;   /* Time at which event was deactivated */
    void              *value;         /* The delayed value sent to this output */
} Evt_Output_Event_t; 

typedef struct Evt_Output_Queue_s {
    Evt_Output_Event_t  **head;          /* Beginning of linked lists */
    Evt_Output_Event_t  ***current;      /* Beginning of pending events */
    Evt_Output_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Output_Event_t  **free;          /* Linked lists of items freed by backups */
    double              last_time;       /* Time at which last_step was set */
    double              next_time;       /* Earliest next event time in queue */
    int                 num_modified;    /* Number modified since last accepted timepoint */
    int                 *modified_index; /* Indexes of modified outputs */
    Mif_BOOLEAN_t       *modified;       /* Flags used to prevent multiple entries */
    int                 num_pending;     /* Count of number of pending events in lists */
    int                 *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t       *pending;        /* Flags used to prevent multiple entries */
    int                 num_changed;     /* Count of number of outputs that changed */
    int                 *changed_index;  /* Indexes of outputs that changed */
    Mif_BOOLEAN_t       *changed;        /* Flags used to prevent multiple entries */
} Evt_Output_Queue_t;




typedef struct Evt_Queue_s {
    Evt_Inst_Queue_t   inst;               /* dynamic queue for instances */
    Evt_Node_Queue_t   node;               /* dynamic queue of changing nodes */
    Evt_Output_Queue_t output;             /* dynamic queue of delayed outputs */
} Evt_Queue_t;




/* ************** */
/* Data structure */
/* ************** */




typedef struct Evt_Node_s {
    struct Evt_Node_s *next;          /* pointer to next in linked list */
    Mif_BOOLEAN_t    op;              /* true if computed from op analysis */
    double           step;            /* DC step or time at which data was computed */
    void             **output_value;  /* Array of outputs posted to this node */
    void             *node_value;     /* Resultant computed from output values */
    void             *inverted_value; /* Inverted copy of node_value */
} Evt_Node_t;

typedef struct {
    Evt_Node_t     **head;          /* Beginning of linked lists */
    Evt_Node_t     ***tail;         /* Location of last item added to list */
    Evt_Node_t     ***last_step;    /* 'tail' at last accepted timepoint */
    Evt_Node_t     **free;          /* Linked lists of items freed by backups */
    int            num_modified;    /* Number modified since last accepted timepoint */
    int            *modified_index; /* Indexes of modified nodes */
    Mif_BOOLEAN_t  *modified;       /* Flags used to prevent multiple entries */
    Evt_Node_t     *rhs;            /* Location where model outputs are placed */
    Evt_Node_t     *rhsold;         /* Location where model inputs are retrieved */
    double         *total_load;     /* Location where total load inputs are retrieved */
} Evt_Node_Data_t;




typedef struct Evt_State_s {
    struct Evt_State_s   *next;        /* Pointer to next state */
    struct Evt_State_s   *prev;        /* Pointer to previous state */
    double               step;         /* Time at which state was assigned (0 for DC) */
    void                 *block;       /* Block of memory holding all states on inst */
} Evt_State_t;


typedef struct Evt_State_Desc_s {
    struct Evt_State_Desc_s *next;   /* Pointer to next description */
    int                     tag;     /* Tag for this state */
    int                     size;    /* Size of this state */
    int                     offset;  /* Offset of this state into the state block */
} Evt_State_Desc_t;


typedef struct Evt_State_Data_s {
    Evt_State_t    **head;              /* Beginning of linked lists */
    Evt_State_t    ***tail;             /* Location of last item added to list */
    Evt_State_t    ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_State_t    **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
    int            *total_size;         /* Total bytes for all states allocated */
    Evt_State_Desc_t **desc;            /* Lists of description structures */
} Evt_State_Data_t;




typedef struct Evt_Msg_s {
    struct Evt_Msg_s     *next;      /* Pointer to next state */
    Mif_BOOLEAN_t        op;         /* true if output from op analysis */
    double               step;       /* DC step or time at which message was output */
    char                 *text;      /* The value of the message text */
    int                  port_index; /* The index of the port from which the message came */
} Evt_Msg_t;


typedef struct Evt_Msg_Data_s {
    Evt_Msg_t      **head;              /* Beginning of linked lists */
    Evt_Msg_t      ***tail;             /* Location of last item added to list */
    Evt_Msg_t      ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_Msg_t      **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
} Evt_Msg_Data_t;


typedef struct Evt_Statistic_s {
    int                op_alternations;    /* Total alternations between event and analog */
    int                op_load_calls;      /* Total load calls in DCOP analysis */
    int                op_event_passes;    /* Total passes through event iteration loop */
    int                tran_load_calls;    /* Total inst calls in transient analysis */
    int                tran_time_backups;  /* Number of transient timestep cuts */
} Evt_Statistic_t;




typedef struct Evt_Data_s {
    Evt_Node_Data_t    *node;               /* dynamic event solution vector */
    Evt_State_Data_t   *state;              /* dynamic event instance state data */
    Evt_Msg_Data_t     *msg;                /* dynamic event message data */
    Evt_Statistic_t    *statistics;         /* Statistics for events, etc. */
} Evt_Data_t;



/* **************** */
/* Counts structure */
/* **************** */


typedef struct Evt_Count_s {
    int          num_insts;             /* number of event/hybrid instances parsed */
    int          num_hybrids;           /* number of hybrids parsed */
    int          num_hybrid_outputs;    /* number of outputs on all hybrids parsed */
    int          num_nodes;             /* number of event nodes parsed */
    int          num_ports;             /* number of event ports parsed */
    int          num_outputs;           /* number of event outputs parsed */
} Evt_Count_t;



/* **************** */
/* Limits structure */
/* **************** */


typedef struct Evt_Limit_s {
    int         max_event_passes;    /* maximum loops in attempting convergence of event nodes */
    int         max_op_alternations; /* maximum loops through event/analog alternation */
} Evt_Limit_t;


/* ************** */
/* Jobs structure */
/* ************** */


typedef struct Evt_Job_s {
    int                num_jobs;           /* Number of jobs run */
    char               **job_name;         /* Names of different jobs */
    Evt_Node_Data_t    **node_data;        /* node_data for different jobs */
    Evt_State_Data_t   **state_data;       /* state_data for different jobs */
    Evt_Msg_Data_t     **msg_data;         /* messages for different jobs */
    Evt_Statistic_t    **statistics;       /* Statistics for different jobs */
} Evt_Job_t;



/* ***************** */
/* Options structure */
/* ***************** */


typedef struct Evt_Option_s {
    Mif_BOOLEAN_t   op_alternate;        /* Alternate analog/event solutions in OP analysis */
} Evt_Option_t;


/* ****************** */
/* Main evt structure */
/* ****************** */

typedef struct Evt_Ckt_Data_s {
    Evt_Count_t     counts;         /* Number of insts, nodes, etc. */
    Evt_Info_t      info;           /* Static info about insts, etc. */
    Evt_Queue_t     queue;          /* Dynamic queued events */
    Evt_Data_t      data;           /* Results and state data */
    Evt_Limit_t     limits;         /* Iteration limits, etc. */
    Evt_Job_t       jobs;           /* Data held from multiple job runs */
    Evt_Option_t    options;        /* Data input on .options cards */
} Evt_Ckt_Data_t;



#endif /* EVT_HEADER */
//insert file>>     #include "ENH.h"
#ifndef ENH_HEADER
#define ENH_HEADER 

/* ===========================================================================
FILE    ENH.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains typedefs used by the event-driven algorithm.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFtypes.h"
//insert file>> #include "FTEinp.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 *
 * Note that this definition must be the same as struct card in INPdefs.h...
 */


/*
The following data is used in implementing various enhancements made to the
simulator.  The main struct is dynamically allocated in ckt so that incremental additions
can be made more easily without the need to recompile multiple modules.
Allocation and initialization is done in CKTinit.c which should be the only
module needed to recompile after additions are made here.
*/


typedef enum Enh_Conv_Source_t {
    ENH_ANALOG_NODE,            /* An analog node */
    ENH_EVENT_NODE,             /* An event-driven node */
    ENH_ANALOG_BRANCH,          /* A branch current */
    ENH_ANALOG_INSTANCE,        /* An analog instance */
    ENH_EVENT_INSTANCE,         /* An event-driven instance */
    ENH_HYBRID_INSTANCE,        /* A hybrid (analog/event-driven) instance */
} Enh_Conv_Source_t;


typedef struct Enh_Bkpt_t {
   double           current;    /* The current dynamic breakpoint time */
   double           last;       /* The last used dynamic breakpoint time */
} Enh_Bkpt_t;

typedef struct Enh_Ramp_t {
    double           ramptime;    /* supply ramping time specified on .options */
} Enh_Ramp_t;

typedef struct Enh_Conv_Debug_t {
    Mif_BOOLEAN_t    last_NIiter_call;  /* True if this is the last call to NIiter() */
    Mif_BOOLEAN_t    report_conv_probs; /* True if conv test functions should send debug info */
} Enh_Conv_Debug_t;


typedef struct Enh_Conv_Limit_t {
    Mif_BOOLEAN_t    enabled;           /* True if convergence limiting enabled on code models */
    double           abs_step;          /* Minimum limiting step size */
    double           step;              /* Fractional step amount */
} Enh_Conv_Limit_t;


typedef struct Enh_Rshunt_t {
    Mif_BOOLEAN_t    enabled;      /* True if rshunt option used */
    double           gshunt;       /* 1.0 / rshunt */
    int              num_nodes;    /* Number of nodes in matrix */
    double           **diag;       /* Pointers to matrix diagonals */
} Enh_Rshunt_t;


typedef struct Enh_Ckt_Data_t {
    Enh_Bkpt_t       breakpoint;   /* Data used by dynamic breakpoints */
    Enh_Ramp_t       ramp;         /* New options added to simulator */
    Enh_Conv_Debug_t conv_debug;   /* Convergence debug info dumping data */
    Enh_Conv_Limit_t conv_limit;   /* Convergence limiting info */
    Enh_Rshunt_t     rshunt_data;  /* Shunt conductance from nodes to ground */
} Enh_Ckt_Data_t;



void ENHreport_conv_prob(Enh_Conv_Source_t type, char *name, char *msg);
struct line *ENHtranslate_poly(InstanceHandle inst, struct line *deck);


#endif /* ENH_HEADER */
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
  #endif


  #define MAXNUMDEVS 32
  extern int DEVmaxnum;
  #define MAXNUMDEVNODES 4

//insert file>>   #include "smpdefs.h"
//insert file>>   #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

//insert file>>   #include "acdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "gendefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "trcvdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */
//insert file>>   #include "optdefs.h"
//insert file>> #include "xspice.h"

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "sen2defs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/
/*
 * SENdefs.h - structures for sensitivity package
 */

//insert file>>   #include "pzdefs.h"
#ifndef PZDEFS
#define PZDEFS "PZdefs.h $Revision: 1.3 $  on $Date: 88/11/16 21:55:29 $ "

    /* structure used to describe an PZ analysis to be performed */

//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "complex.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CMPLX
#define CMPLX "complex.h $Revision: 1.5 $  on $Date: 88/11/22 02:51:07 $ "

/*  header file containing definitions for complex functions
 *
 *  Each expects two arguments for each complex number - a real and an
 *  imaginary part.
 */
typedef struct {
    double real;
    double imag;
} SPcomplex;


#define DC_ABS(a,b) (FABS(a) + FABS(b))

#ifdef notdef
#define DC_DIV(a,b,c,d,x,y) { \
    double r,s;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((a)+(b)*r)/s;\
        y=((b)-(a)*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((a)*r+(b))/s;\
        y=((b)*r-(a))/s;\
    }\
}
#endif /*notdef */

#ifndef HAS_SHORTMACRO
#define DC_DIVEQ(a,b,c,d) { \
    double r,s,x,y;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((*(a))+(*(b))*r)/s;\
        y=((*(b))-(*(a))*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((*(a))*r+(*(b)))/s;\
        y=((*(b))*r-(*(a)))/s;\
    }\
    (*(a)) = x; \
    (*(b)) = y; \
}
#else /*HAS_SHORTMACRO*/
#define DC_DIVEQ DCdiveq
#ifdef IIT
extern void DCdiveq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCdiveq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifndef HAS_SHORTMACRO
#define DC_MULT(a,b,c,d,x,y) { \
    *(x) = (a) * (c) - (b) * (d) ;\
    *(y) = (a) * (d) + (b) * (c) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MULT DCmult
#ifdef IIT
extern void DCmult(InstanceHandle inst, double,double,double,double,double*,double*);
#else /* stdc */
extern void DCmult(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifdef notdef 
#define DC_MINUS(a,b,c,d,x,y) { \
    (x) = (a) - (c) ;\
    (y) = (b) - (d) ;\
}
#endif /*notdef*/

#ifndef HAS_SHORTMACRO
#define DC_MINUSEQ(a,b,c,d) { \
    *(a) -= (c) ;\
    *(b) -= (d) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MINUSEQ DCminusEq
#ifdef IIT
extern void DCminusEq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCminusEq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#define	C_SQRT(A) {							      \
	double	_mag, _a;						      \
	if ((A).imag == 0.0) {						      \
	    if ((A).real < 0.0) {					      \
		(A).imag = sqrt(-(A).real);				      \
		(A).real = 0.0;						      \
	    } else {							      \
		(A).real = sqrt((A).real);				      \
		(A).imag = 0.0;						      \
	    }								      \
	} else {							      \
	    _mag = sqrt((A).real * (A).real + (A).imag * (A).imag);	      \
	    _a = (_mag - (A).real) / 2.0;				      \
	    if (_a <= 0.0) {						      \
		(A).real = sqrt(_mag);					      \
		(A).imag /= (2.0 * (A).real); /*XXX*/			      \
	    } else {							      \
		_a = sqrt(_a);						      \
		(A).real = (A).imag / (2.0 * _a);			      \
		(A).imag = _a;						      \
	    }								      \
	}								      \
    }

#define	C_MAG2(A) (((A).real = (A).real * (A).real + (A).imag * (A).imag),    \
	(A).imag = 0.0)

#define	C_CONJ(A) ((A).imag *= -1.0)

#define	C_CONJEQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = - (B.imag);						      \
    }

#define	C_EQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = (B.imag);						      \
    }

#define	C_NORM(A,B) {							      \
	if ((A).real == 0.0 && (A).imag == 0.0) {			      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS((A).real) > 1.0 || FABS((A).imag) > 1.0) {	      \
		(B) += 1;						      \
		(A).real /= 2.0;					      \
		(A).imag /= 2.0;					      \
	    }								      \
	    while (FABS((A).real) <= 0.5 && FABS((A).imag) <= 0.5) {	      \
		(B) -= 1;						      \
		(A).real *= 2.0;					      \
		(A).imag *= 2.0;					      \
	    }								      \
	}								      \
    }

#define	C_ABS(A) (sqrt((A).real * (A.real) + (A.imag * A.imag)))

#define	C_MUL(A,B) {							      \
	double	TMP1, TMP2;						      \
	TMP1 = (A.real);						      \
	TMP2 = (B.real);						      \
	(A).real = TMP1 * TMP2 - (A.imag) * (B.imag);			      \
	(A).imag = TMP1 * (B.imag) + (A.imag) * TMP2;			      \
    }

#define	C_MULEQ(A,B,C) {						      \
	(A).real = (B.real) * (C.real) - (B.imag) * (C.imag);		      \
	(A).imag = (B.real) * (C.imag) + (B.imag) * (C.real);		      \
    }

#define	C_DIV(A,B) {							      \
	double	_tmp, _mag;						      \
	_tmp = (A.real);						      \
	(A).real = _tmp * (B.real) + (A).imag * (B.imag);		      \
	(A).imag = - _tmp * (B.imag) + (A.imag) * (B.real);		      \
	_mag = (B.real) * (B.real) + (B.imag) * (B.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_DIVEQ(A,B,C) {						      \
	double	_mag;							      \
	(A).real = (B.real) * (C.real) + (B.imag) * (C.imag);		      \
	(A).imag = (B.imag) * (C.real) - (B.real) * (C.imag) ;		      \
	_mag = (C.real) * (C.real) + (C.imag) * (C.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_ADD(A,B) {							      \
	(A).real += (B.real);						      \
	(A).imag += (B.imag);						      \
    }

#define	C_ADDEQ(A,B,C) {						      \
	(A).real = (B.real) + (C.real);					      \
	(A).imag = (B.imag) + (C.imag);					      \
    }

#define	C_SUB(A,B) {							      \
	(A).real -= (B.real);						      \
	(A).imag -= (B.imag);						      \
    }

#define	C_SUBEQ(A,B,C) {						      \
	(A).real = (B.real) - (C.real);					      \
	(A).imag = (B.imag) - (C.imag);					      \
    }



#endif /*CMPLX*/

typedef struct strial {
    SPcomplex	s, f_raw, f_def;
    struct strial *next, *prev;
    int		mag_raw, mag_def;
    int		multiplicity;
    int		flags;
    int		seq_num;
    int		count;
} PZtrial;

typedef struct {
    int JOBtype;
    JOB *JOBnextJob;
    IFuid JOBname;
    int PZin_pos;
    int PZin_neg;
    int PZout_pos;
    int PZout_neg;
    int PZinput_type;
    int PZwhich;
    int PZnumswaps;
    int PZbalance_col;
    int PZsolution_col;
    PZtrial *PZpoleList;
    PZtrial *PZzeroList;
    int PZnPoles;
    int PZnZeros;
    double *PZdrive_pptr;
    double *PZdrive_nptr;
} PZAN;

#define PZ_DO_POLES	0x1
#define PZ_DO_ZEROS	0x2
#define PZ_IN_VOL	1
#define PZ_IN_CUR	2

#define PZ_NODEI 1
#define PZ_NODEG 2
#define PZ_NODEJ 3
#define PZ_NODEK 4
#define PZ_V 5
#define PZ_I 6
#define PZ_POL 7
#define PZ_ZER 8
#define PZ_PZ 9

#endif /*PZDEFS*/



  typedef struct sCKTnode {
      IFuid name;
      int type;

      #define SP_VOLTAGE 3
      #define SP_CURRENT 4
      #define NODE_VOLTAGE SP_VOLTAGE
      #define NODE_CURRENT SP_CURRENT

      int number;
      double ic;
      double nodeset;
      double *ptr;
      struct sCKTnode *next;
      unsigned int icGiven:1;
      unsigned int nsGiven:1;
  } CKTnode;

  /* defines for node parameters */
  #define PARM_NS 1
  #define PARM_IC 2
  #define PARM_NODETYPE 3


  struct CKTcircuit_tag {
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif

     #ifdef XSPICE
     /* gtri - begin - wbk - change declaration to allow dynamic sizing */

     /* An associated change is made in CKTinit.c to alloc the space */
     /* required for the pointers.  No changes are needed to the source */
     /* code at the 3C1 level, although the compiler will generate */
     /* slightly different code for references to this data. */

     /*  GENmodel *CKThead[MAXNUMDEVS];  */
         struct sGENmodel **CKThead;

     /* gtri - end   - wbk - change declaration to allow dynamic sizing */
     #else
         struct sGENmodel *CKThead[MAXNUMDEVS];
     #endif
         STATistics *CKTstat;
         double *(CKTstates[8]);
     #define CKTstate0 CKTstates[0]
     #define CKTstate1 CKTstates[1]
     #define CKTstate2 CKTstates[2]
     #define CKTstate3 CKTstates[3]
     #define CKTstate4 CKTstates[4]
     #define CKTstate5 CKTstates[5]
     #define CKTstate6 CKTstates[6]
     #define CKTstate7 CKTstates[7]
         double CKTtime;
         double CKTdelta;
         double CKTdeltaOld[7];
         double CKTtemp;
         double CKTnomTemp;
         double CKTvt;
         double CKTag[7];        /* the gear variable coefficient matrix */
     #ifdef PREDICTOR
         double CKTagp[7];       /* the gear predictor variable coefficient matrix */
     #endif /*PREDICTOR*/
         int CKTorder;           /* the integration method order */
         int CKTmaxOrder;        /* maximum integration method order */
         int CKTintegrateMethod; /* the integration method to be used */

     /* known integration methods */
     #define TRAPEZOIDAL 1
     #define GEAR 2

         SMPmatrix *CKTmatrix;   /* pointer to sparse matrix */
         int CKTniState;         /* internal state */
         double *CKTrhs;         /* current rhs value - being loaded */
         double *CKTrhsOld;      /* previous rhs value for convergence testing */
         double *CKTrhsSpare;    /* spare rhs value for reordering */
         double *CKTirhs;        /* current rhs value - being loaded (imag) */
         double *CKTirhsOld;     /* previous rhs value (imaginary)*/
         double *CKTirhsSpare;   /* spare rhs value (imaginary)*/
     #ifdef PREDICTOR
         double *CKTpred;        /* predicted solution vector */
         double *CKTsols[8];     /* previous 8 solutions */
     #endif /* PREDICTOR */

         double *CKTrhsOp;      /* operating point values */
         double *CKTsenRhs;      /* current sensitivity rhs  values */
         double *CKTseniRhs;      /* current sensitivity rhs  values (imag)*/


     /*
      *  symbolic constants for CKTniState
      *      Note that they are bitwise disjoint
      */

     #define NISHOULDREORDER 0x1
     #define NIREORDERED 0x2
     #define NIUNINITIALIZED 0x4
     #define NIACSHOULDREORDER 0x10
     #define NIACREORDERED 0x20
     #define NIACUNINITIALIZED 0x40
     #define NIDIDPREORDER 0x100
     #define NIPZSHOULDREORDER 0x200

         int CKTmaxEqNum;
         int CKTcurrentAnalysis; /* the analysis in progress (if any) */

     /* defines for the value of  CKTcurrentAnalysis */
     /* are in TSKdefs.h */

         CKTnode *CKTnodes;
         CKTnode *CKTlastNode;
     #define NODENAME(ckt,nodenum) CKTnodName(ckt,nodenum)
         int CKTnumStates;
         long CKTmode;

     /* defines for CKTmode */

     /* old 'mode' parameters */
     #define MODE 0x3
     #define MODETRAN 0x1
     #define MODEAC 0x2

     /* old 'modedc' parameters */
     #define MODEDC 0x70
     #define MODEDCOP 0x10
     #define MODETRANOP 0x20
     #define MODEDCTRANCURVE 0x40

     /* old 'initf' parameters */
     #define INITF 0x3f00
     #define MODEINITFLOAT 0x100
     #define MODEINITJCT 0x200
     #define MODEINITFIX 0x400
     #define MODEINITSMSIG 0x800
     #define MODEINITTRAN 0x1000
     #define MODEINITPRED 0x2000

     /* old 'nosolv' paramater */
     #define MODEUIC 0x10000l

         int CKTbypass;
         int CKTdcMaxIter;       /* iteration limit for dc op.  (itl1) */
         int CKTdcTrcvMaxIter;   /* iteration limit for dc tran. curv (itl2) */
         int CKTtranMaxIter;     /* iteration limit for each timepoint for tran*/
                                 /* (itl4) */
         int CKTbreakSize;
         int CKTbreak;
         double CKTsaveDelta;
         double CKTminBreak;
         double *CKTbreaks;
         double CKTabstol;
         double CKTpivotAbsTol;
         double CKTpivotRelTol;
         double CKTreltol;
         double CKTchgtol;
         double CKTvoltTol;
     #ifdef NEWTRUNC
         double CKTlteReltol;
         double CKTlteAbstol;
     #endif /* NEWTRUNC */
         double CKTgmin;
         double CKTdelmin;
         double CKTtrtol;
         double CKTfinalTime;
         double CKTstep;
         double CKTmaxStep;
         double CKTinitTime;
         double CKTomega;
         double CKTsrcFact;
         double CKTdiagGmin;
         int CKTnumSrcSteps;
         int CKTnumGminSteps;
         int CKTnoncon;
         double CKTdefaultMosL;
         double CKTdefaultMosW;
         double CKTdefaultMosAD;
         double CKTdefaultMosAS;
         unsigned int CKThadNodeset:1;
         unsigned int CKTfixLimit:1; /* flag to indicate that the limiting of
                                      * MOSFETs should be done as in SPICE2 */
         unsigned int CKTnoOpIter:1; /* flag to indicate not to try the operating
                                      * point brute force, but to use gmin stepping
                                      * first */
         unsigned int CKTisSetup:1;  /* flag to indicate if CKTsetup done */
         JOB *CKTcurJob;

         SENstruct *CKTsenInfo;	/* the sensitivity information */
         double *CKTtimePoints;	/* list of all accepted timepoints in the
				        current transient simulation */
         double *CKTdeltaList;	/* list of all timesteps in the current
				        transient simulation */
         int CKTtimeListSize;	/* size of above lists */
         int CKTtimeIndex;		/* current position in above lists */
         int CKTsizeIncr;		/* amount to increment size of above arrays
				        when you run out of space */
         unsigned int CKTtryToCompact:1; /* try to compact past history for LTRA
				        lines */
         unsigned int CKTbadMos3:1; /* Use old, unfixed MOS3 equations */
         unsigned int CKTkeepOpInfo:1; /* flag for small signal analyses */
         int CKTtroubleNode;		/* Non-convergent node number */
         struct sGENinstance *CKTtroubleElt;	/* Non-convergent device instance */
     #ifdef EWB_IIT
	     double CKTiitBreakPoint;
	     double CKTiitSaveDelta;
     #endif
     #ifdef XSPICE
     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */

         struct Evt_Ckt_Data_s *evt;  /* all data about event driven stuff */
         struct Enh_Ckt_Data_t *enh;  /* data used by general enhancements */

     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
     #endif
     #ifdef IIT
         int oldCKTmaxEqNum;
     #endif

#ifdef IIT
     //* Transient analysis options
     #define EXT_MODE_ZERO_IC    0x00000l
     #define EXT_MODE_AUTO_IC    0x000002
     #define EXT_MODE_AUTO_TMAX  0x000004
     #define EXT_MODE_AUTO_TSTEP 0x000008
     long CKText_mode;
#endif
  };

  #ifdef IIT
    #define CKTcircuit_has_been_defined
//insert file>>     #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/


    struct s_sgen* sgen_init(CKTcircuit* ckt,int is_dc);
    int sgen_next(InstanceHandle INST, struct s_sgen **xsg);
    int sens_getp(InstanceHandle INST, struct s_sgen *sg, CKTcircuit *ckt,union uIFvalue* val);
  #endif

  #ifdef EWB_IIT
    int EXPORT getMatrixElement( GENERIC*, GENERIC*, GENERIC*, double**);
    int EXPORT getVoltage(GENERIC*, GENERIC*, GENERIC*, double*);
    int EXPORT addVoltage(GENERIC*, GENERIC*, double);
    int EXPORT getCurrent(GENERIC*, GENERIC*, double*);
    int EXPORT addCurrent(GENERIC*, GENERIC*, GENERIC*, double);
    int EXPORT setBreakPoint(GENERIC*, double);
    int EXPORT setRelativeBreakPoint(GENERIC*, double);
    int EXPORT changeCapacitorValue(GENERIC*, GENERIC*, double);
    int EXPORT changeInductorValue(GENERIC*, GENERIC*, double);
    int EXPORT isFirstIteration(GENERIC*, int*);
    int EXPORT setMaxStep(GENERIC*, double);
  #endif

  #ifdef DLL
    #if defined(MSVC) || !defined(WIN32)
      #undef FAR
    #endif

    #include <windows.h>

    #if defined(MSVC)
      #undef FAR
      #define FAR
	#elif !defined(WIN32)
      #undef FAR
      #define FAR far
    #endif

    #ifdef MSVC
      int EXPORT  SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #else
      int CALLBACK _export SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #endif
  #else
    int SPIinit(InstanceHandle inst);
  #endif

  int ACan(CKTcircuit *, int );
  int ACaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int ACsetParm( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int CKTacDump( CKTcircuit *, double , GENERIC *);
  int CKTacLoad( CKTcircuit *);
  int CKTaccept( CKTcircuit *);
  int CKTacct( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int EXPORT CKTask( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskAnalQ( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskNodQst( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTbindNode( GENERIC *, GENERIC *, int , GENERIC *);
  void CKTbreakDump( CKTcircuit *);
  int CKTclrBreak( CKTcircuit *);
  int CKTconvTest( CKTcircuit *);
  int EXPORT CKTcrtElt( GENERIC *, GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTdelTask( GENERIC *, GENERIC *);
  int EXPORT CKTdestroy( GENERIC *);
  int CKTdltAnal( GENERIC *, GENERIC *, GENERIC *);
  int EXPORT CKTdltInst( GENERIC *, GENERIC *);
  int EXPORT CKTdltMod( GENERIC *, GENERIC *);
  int EXPORT CKTdltNod( GENERIC *, GENERIC *);
  int EXPORT CKTdoJob( GENERIC *, int , GENERIC *);
  void CKTdump( CKTcircuit *, double, GENERIC *);
  int EXPORT CKTfndAnal( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int CKTfndBranch( CKTcircuit *, IFuid);
  int EXPORT CKTfndDev( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int EXPORT CKTfndMod( GENERIC *, int *, GENERIC **, IFuid );
  int EXPORT CKTfndNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTfndTask( GENERIC *, GENERIC **, IFuid  );
  int EXPORT CKTground( GENERIC *, GENERIC **, IFuid );
  int CKTic( CKTcircuit *);
  int EXPORT CKTinit(InstanceHandle handle, GENERIC **);
  int EXPORT CKTinst2Node( GENERIC *, GENERIC *, int , GENERIC **, IFuid *);
  int CKTlinkEq(CKTcircuit*,CKTnode*);
  int CKTload( CKTcircuit *);
  int CKTmapNode( GENERIC *, GENERIC **, IFuid );
  int CKTmkCur( CKTcircuit  *, CKTnode **, IFuid , char *);
  int CKTmkNode(CKTcircuit*,CKTnode**);
  int CKTmkVolt( CKTcircuit  *, CKTnode **, IFuid , char *);
  int EXPORT CKTmodAsk( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTmodCrt( GENERIC *, int , GENERIC **, IFuid );
  int EXPORT CKTmodParam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTnames(CKTcircuit *, int *, IFuid **);
  int EXPORT CKTnewAnal( GENERIC *, int , IFuid , GENERIC **, GENERIC *);
  int CKTnewEq( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewTask( GENERIC *, GENERIC **, IFuid );
  IFuid CKTnodName( CKTcircuit *, int );
  void CKTnodOut( CKTcircuit *);
  CKTnode * CKTnum2nod( CKTcircuit *, int );
  int CKTop(CKTcircuit *, long, long, int );
  int CKTpModName( char *, union uIFvalue *, CKTcircuit *, int , IFuid , struct sGENmodel **);
  int CKTpName( char *, union uIFvalue *, CKTcircuit *, int , char *, struct sGENinstance **);
  int EXPORT CKTparam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTpzFindZeros( CKTcircuit *, PZtrial **, int * );
  int CKTpzLoad( CKTcircuit *, SPcomplex * );
  int CKTpzSetup( CKTcircuit *, int);
  int CKTsenAC( CKTcircuit *);
  int CKTsenComp( CKTcircuit *);
  int CKTsenDCtran( CKTcircuit *);
  int CKTsenLoad( CKTcircuit *);
  void CKTsenPrint( CKTcircuit *);
  int CKTsenSetup( CKTcircuit *);
  int CKTsenUpdate( CKTcircuit *);
  int EXPORT CKTsetAnalPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetBreak( CKTcircuit *, double );
  int EXPORT CKTsetNodPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetOpt( GENERIC *, GENERIC *, int , union uIFvalue *);
  int CKTsetup( CKTcircuit *);
  int CKTunsetup(CKTcircuit *ckt);
  int CKTtemp( CKTcircuit *);
  char * EXPORT CKTtrouble(GENERIC *, char *);
  void CKTterr( int , CKTcircuit *, double *);
  int CKTtrunc( CKTcircuit *, double *);
  int CKTtypelook( char *);
  int DCOaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCOsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCTaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCTsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCop(CKTcircuit *);
  int DCtrCurv(CKTcircuit *, int );
  int DCtran(CKTcircuit *, int );
  int DISTOan(CKTcircuit *, int);
  int NOISEan(CKTcircuit *, int);
  int PZan(CKTcircuit *, int );
  int PZinit(CKTcircuit * );
  int PZpost(CKTcircuit * );
  int PZaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int PZsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  void SENdestroy(InstanceHandle, SENstruct *);
  int SENsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENstartup(CKTcircuit *);
  char* SPerror(InstanceHandle INST, int type);
  int TFanal(CKTcircuit *, int );
  int TFaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TFsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANinit(CKTcircuit *, JOB *);
  int NIacIter(CKTcircuit * );
  int NIcomCof(CKTcircuit * );
  int NIconvTest(CKTcircuit * );
  void NIdestroy(CKTcircuit * );
  int NIinit(CKTcircuit  * );
  int NIintegrate(CKTcircuit *, double *, double *, double , int );
  int NIiter(CKTcircuit * , int );
  int NIpzMuller(InstanceHandle, PZtrial **, PZtrial *);
  int NIpzComplex(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym2(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIreinit(CKTcircuit *);
  int NIsenReinit(CKTcircuit *);
  int EXPORT isFirstIteration (GENERIC *inCkt, int *first_iteration);

  #ifdef EWB_IIT
    int EXPORT modelInitialize(InstanceHandle INST, int modelType,GENERIC* model, IFuid modelUid);
  #endif

//insert file>>   #include "noisedef.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Gary W. Ng
**********/


  int CKTnoise (CKTcircuit *ckt,int mode, int operation, Ndata *data);
  int CKTdisto(CKTcircuit *ckt,int mode);
  int NIdIter(CKTcircuit *ckt);
  void NInzIter(CKTcircuit *ckt, int posDrive, int negDrive);
#ifndef IIT
  extern struct sIFfrontEnd *SPfrontEnd;
#endif

#ifndef IIT
#ifdef DO_RAWFILE_ALSO
  extern struct sIFfrontEnd *EWB_frontEnd;
  extern struct sIFfrontEnd nutmeginfo;
#endif /* DO_RAWFILE_ALSO */
#endif

#endif /*CKT*/
//insert file>> #include "noisedef.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Gary W. Ng
**********/

//insert file>> #include "complex.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CMPLX
#define CMPLX "complex.h $Revision: 1.5 $  on $Date: 88/11/22 02:51:07 $ "

/*  header file containing definitions for complex functions
 *
 *  Each expects two arguments for each complex number - a real and an
 *  imaginary part.
 */
typedef struct {
    double real;
    double imag;
} SPcomplex;


#define DC_ABS(a,b) (FABS(a) + FABS(b))

#ifdef notdef
#define DC_DIV(a,b,c,d,x,y) { \
    double r,s;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((a)+(b)*r)/s;\
        y=((b)-(a)*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((a)*r+(b))/s;\
        y=((b)*r-(a))/s;\
    }\
}
#endif /*notdef */

#ifndef HAS_SHORTMACRO
#define DC_DIVEQ(a,b,c,d) { \
    double r,s,x,y;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((*(a))+(*(b))*r)/s;\
        y=((*(b))-(*(a))*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((*(a))*r+(*(b)))/s;\
        y=((*(b))*r-(*(a)))/s;\
    }\
    (*(a)) = x; \
    (*(b)) = y; \
}
#else /*HAS_SHORTMACRO*/
#define DC_DIVEQ DCdiveq
#ifdef IIT
extern void DCdiveq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCdiveq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifndef HAS_SHORTMACRO
#define DC_MULT(a,b,c,d,x,y) { \
    *(x) = (a) * (c) - (b) * (d) ;\
    *(y) = (a) * (d) + (b) * (c) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MULT DCmult
#ifdef IIT
extern void DCmult(InstanceHandle inst, double,double,double,double,double*,double*);
#else /* stdc */
extern void DCmult(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifdef notdef 
#define DC_MINUS(a,b,c,d,x,y) { \
    (x) = (a) - (c) ;\
    (y) = (b) - (d) ;\
}
#endif /*notdef*/

#ifndef HAS_SHORTMACRO
#define DC_MINUSEQ(a,b,c,d) { \
    *(a) -= (c) ;\
    *(b) -= (d) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MINUSEQ DCminusEq
#ifdef IIT
extern void DCminusEq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCminusEq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#define	C_SQRT(A) {							      \
	double	_mag, _a;						      \
	if ((A).imag == 0.0) {						      \
	    if ((A).real < 0.0) {					      \
		(A).imag = sqrt(-(A).real);				      \
		(A).real = 0.0;						      \
	    } else {							      \
		(A).real = sqrt((A).real);				      \
		(A).imag = 0.0;						      \
	    }								      \
	} else {							      \
	    _mag = sqrt((A).real * (A).real + (A).imag * (A).imag);	      \
	    _a = (_mag - (A).real) / 2.0;				      \
	    if (_a <= 0.0) {						      \
		(A).real = sqrt(_mag);					      \
		(A).imag /= (2.0 * (A).real); /*XXX*/			      \
	    } else {							      \
		_a = sqrt(_a);						      \
		(A).real = (A).imag / (2.0 * _a);			      \
		(A).imag = _a;						      \
	    }								      \
	}								      \
    }

#define	C_MAG2(A) (((A).real = (A).real * (A).real + (A).imag * (A).imag),    \
	(A).imag = 0.0)

#define	C_CONJ(A) ((A).imag *= -1.0)

#define	C_CONJEQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = - (B.imag);						      \
    }

#define	C_EQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = (B.imag);						      \
    }

#define	C_NORM(A,B) {							      \
	if ((A).real == 0.0 && (A).imag == 0.0) {			      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS((A).real) > 1.0 || FABS((A).imag) > 1.0) {	      \
		(B) += 1;						      \
		(A).real /= 2.0;					      \
		(A).imag /= 2.0;					      \
	    }								      \
	    while (FABS((A).real) <= 0.5 && FABS((A).imag) <= 0.5) {	      \
		(B) -= 1;						      \
		(A).real *= 2.0;					      \
		(A).imag *= 2.0;					      \
	    }								      \
	}								      \
    }

#define	C_ABS(A) (sqrt((A).real * (A.real) + (A.imag * A.imag)))

#define	C_MUL(A,B) {							      \
	double	TMP1, TMP2;						      \
	TMP1 = (A.real);						      \
	TMP2 = (B.real);						      \
	(A).real = TMP1 * TMP2 - (A.imag) * (B.imag);			      \
	(A).imag = TMP1 * (B.imag) + (A.imag) * TMP2;			      \
    }

#define	C_MULEQ(A,B,C) {						      \
	(A).real = (B.real) * (C.real) - (B.imag) * (C.imag);		      \
	(A).imag = (B.real) * (C.imag) + (B.imag) * (C.real);		      \
    }

#define	C_DIV(A,B) {							      \
	double	_tmp, _mag;						      \
	_tmp = (A.real);						      \
	(A).real = _tmp * (B.real) + (A).imag * (B.imag);		      \
	(A).imag = - _tmp * (B.imag) + (A.imag) * (B.real);		      \
	_mag = (B.real) * (B.real) + (B.imag) * (B.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_DIVEQ(A,B,C) {						      \
	double	_mag;							      \
	(A).real = (B.real) * (C.real) + (B.imag) * (C.imag);		      \
	(A).imag = (B.imag) * (C.real) - (B.real) * (C.imag) ;		      \
	_mag = (C.real) * (C.real) + (C.imag) * (C.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_ADD(A,B) {							      \
	(A).real += (B.real);						      \
	(A).imag += (B.imag);						      \
    }

#define	C_ADDEQ(A,B,C) {						      \
	(A).real = (B.real) + (C.real);					      \
	(A).imag = (B.imag) + (C.imag);					      \
    }

#define	C_SUB(A,B) {							      \
	(A).real -= (B.real);						      \
	(A).imag -= (B.imag);						      \
    }

#define	C_SUBEQ(A,B,C) {						      \
	(A).real = (B.real) - (C.real);					      \
	(A).imag = (B.imag) - (C.imag);					      \
    }



#endif /*CMPLX*/

double DEVlimvds(InstanceHandle inst, double,double);
double DEVpnjlim(InstanceHandle inst, double,double,double,double,int*);
double DEVfetlim(InstanceHandle inst, double,double,double);
void DEVcmeyer(InstanceHandle inst, double,double,double,double,double,double,double,double,double,
        double,double,double*,double*,double*,double,double,double,double);
void DEVqmeyer(InstanceHandle inst, double,double,double,double,double,double*,double*,double*,
        double,double);
#ifdef notdef
void DEVcap(InstanceHandle inst, CKTcircuit*, double, double, double, double, double, double,
        double, double, double, double, double, double, double, double,
        double*, double*, double*, double*, double*, double*, double*,
        double*, double*, double*, double*, double*, double, double,
        double, double*, double*, double);
#endif
double DEVpred(InstanceHandle inst, CKTcircuit*,int);

#if defined(IIT) || defined(IIT) 
typedef int (*SPICEdev_DEVparam_t)(int,IFvalue*,GENinstance*,IFvalue *);
        /* routine to input a parameter to a device instance */
typedef int (*SPICEdev_DEVmodParam_t)(int,IFvalue*,GENmodel*);
        /* routine to input a paramater to a model */
typedef int (*SPICEdev_DEVload_t)(GENmodel*,CKTcircuit*);
        /* routine to load the device into the matrix */
typedef int (*SPICEdev_DEVsetup_t)(SMPmatrix*,GENmodel*,CKTcircuit*,int*);
        /* setup routine to preprocess devices once before soloution begins */
//...
typedef int (*SPICEdev_DEVunsetup_t)(GENmodel*,CKTcircuit*);
	/* clean up before running again */
//...
typedef int (*SPICEdev_DEVpzSetup_t)(SMPmatrix*,GENmodel*,CKTcircuit*,int*);
        /* setup routine to process devices specially for pz analysis */
typedef int (*SPICEdev_DEVtemperature_t)(GENmodel*,CKTcircuit*);
        /* subroutine to do temperature dependent setup processing */
typedef int (*SPICEdev_DEVtrunc_t)(GENmodel*,CKTcircuit*,double*);
        /* subroutine to perform truncation error calc. */
typedef int (*SPICEdev_DEVfindBranch_t)(CKTcircuit*,GENmodel*,IFuid);
        /* subroutine to search for device branch eq.s */
typedef int (*SPICEdev_DEVacLoad_t)(GENmodel*,CKTcircuit*);
        /* ac analysis loading function */
typedef int (*SPICEdev_DEVaccept_t)(CKTcircuit*,GENmodel*);
        /* subroutine to call on acceptance of a timepoint */
typedef void (*SPICEdev_DEVdestroy_t)(GENmodel**);
        /* subroutine to destroy all models and instances */

typedef int (*SPICEdev_DEVmodDelete_t)(GENmodel**,IFuid,GENmodel*);
        /* subroutine to delete a model and all instances */
typedef int (*SPICEdev_DEVdelete_t)(GENmodel*,IFuid,GENinstance**);
        /* subroutine to delete an instance */
typedef int (*SPICEdev_DEVsetic_t)(GENmodel*,CKTcircuit*);
        /* routine to pick up device init conds from rhs */
typedef int (*SPICEdev_DEVask_t)(CKTcircuit*,GENinstance*,int,IFvalue*,IFvalue*);
        /* routine to ask about device details*/
typedef int (*SPICEdev_DEVmodAsk_t)(CKTcircuit*,GENmodel*,int,IFvalue*);
        /* routine to ask about model details*/

typedef int (*SPICEdev_DEVpzLoad_t)(GENmodel*,CKTcircuit*,SPcomplex*);
	/* routine to load for pole-zero analysis */
typedef int (*SPICEdev_DEVconvTest_t)(GENmodel*,CKTcircuit*);
	/* convergence test function */
typedef int (*SPICEdev_DEVsenSetup_t)(SENstruct*,GENmodel*);
	/* routine to setup the device sensitivity info */
typedef int (*SPICEdev_DEVsenLoad_t)(GENmodel*,CKTcircuit*);
	/* routine to load the device sensitivity info */
typedef int (*SPICEdev_DEVsenUpdate_t)(GENmodel*,CKTcircuit*);
	/* routine to update the device sensitivity info */

typedef int (*SPICEdev_DEVsenAcLoad_t)(GENmodel*,CKTcircuit*);
	/* routine to load  the device ac sensitivity info */
typedef void (*SPICEdev_DEVsenPrint_t)(GENmodel*,CKTcircuit*);
	/* subroutine to print out sensitivity info */
typedef int (*SPICEdev_DEVsenTrunc_t)(GENmodel*,CKTcircuit*,double*);
	/* subroutine to print out sensitivity info */
//...
typedef int (*SPICEdev_DEVdisto_t)(int,GENmodel*,CKTcircuit*);
	/* procedure to do distortion operations */
typedef int (*SPICEdev_DEVnoise_t)(int, int, GENmodel*,CKTcircuit*, Ndata *, double *);
	/* noise routine */
//...
#endif

typedef struct SPICEdev {
    IFdevice DEVpublic;

#if defined(IIT) || defined(IIT)
        SPICEdev_DEVparam_t DEVparam;
        /* routine to input a parameter to a device instance */
        SPICEdev_DEVmodParam_t DEVmodParam;
        /* routine to input a paramater to a model */
        SPICEdev_DEVload_t DEVload;
        /* routine to load the device into the matrix */
        SPICEdev_DEVsetup_t DEVsetup;
        /* setup routine to preprocess devices once before soloution begins */
//...
        SPICEdev_DEVunsetup_t DEVunsetup;
	/* clean up before running again */
//...
        SPICEdev_DEVpzSetup_t DEVpzSetup;
        /* setup routine to process devices specially for pz analysis */
        SPICEdev_DEVtemperature_t DEVtemperature;
        /* subroutine to do temperature dependent setup processing */
        SPICEdev_DEVtrunc_t DEVtrunc;
        /* subroutine to perform truncation error calc. */
        SPICEdev_DEVfindBranch_t DEVfindBranch;
        /* subroutine to search for device branch eq.s */
        SPICEdev_DEVacLoad_t DEVacLoad;
        /* ac analysis loading function */
        SPICEdev_DEVaccept_t DEVaccept;
        /* subroutine to call on acceptance of a timepoint */
        SPICEdev_DEVdestroy_t DEVdestroy;
        /* subroutine to destroy all models and instances */

        SPICEdev_DEVmodDelete_t DEVmodDelete;
        /* subroutine to delete a model and all instances */
        SPICEdev_DEVdelete_t DEVdelete;
        /* subroutine to delete an instance */
        SPICEdev_DEVsetic_t DEVsetic;
        /* routine to pick up device init conds from rhs */
        SPICEdev_DEVask_t DEVask;
        /* routine to ask about device details*/
        SPICEdev_DEVmodAsk_t DEVmodAsk;
        /* routine to ask about model details*/

        SPICEdev_DEVpzLoad_t DEVpzLoad;
	/* routine to load for pole-zero analysis */
        SPICEdev_DEVconvTest_t DEVconvTest;
	/* convergence test function */
        SPICEdev_DEVsenSetup_t DEVsenSetup;
	/* routine to setup the device sensitivity info */
        SPICEdev_DEVsenLoad_t DEVsenLoad;
	/* routine to load the device sensitivity info */
        SPICEdev_DEVsenUpdate_t DEVsenUpdate;
	/* routine to update the device sensitivity info */

        SPICEdev_DEVsenAcLoad_t DEVsenAcLoad;
	/* routine to load  the device ac sensitivity info */
        SPICEdev_DEVsenPrint_t DEVsenPrint;
	/* subroutine to print out sensitivity info */
        SPICEdev_DEVsenTrunc_t DEVsenTrunc;
	/* subroutine to print out sensitivity info */
//...
        SPICEdev_DEVdisto_t DEVdisto;
	/* procedure to do distortion operations */
        SPICEdev_DEVnoise_t DEVnoise;
	/* noise routine */
//...
#endif /* IIT */

#if defined(IIT) || !defined(XSPICE)
    int *DEVinstSize;    /* size of an instance */
    int *DEVmodSize;     /* size of a model */
#else
    int DEVinstSize;    /* size of an instance */
    int DEVmodSize;     /* size of a model */
#endif

} SPICEdev;  /* instance of structure for each possible type of device */

/* IOP( )	Input/output parameter
 * IOPP( )	IO parameter which the principle value of a device (used
 *			for naming output variables in sensetivity)
 * IOPA( )	IO parameter significant for time-varying (non-dc) analyses
 * IOPAP( )	Principle value is significant for time-varying analyses
 * IOPAA( )	IO parameter significant for ac analyses only
 * IOPAAP( )	IO parameter principle value for ac analyses only
 * IOPN( )	IO parameter significant for noise analyses only
 * IOPR( )	Redundant IO parameter name (e.g. "vto" vs. "vt0")
 * IOPX( )	IO parameter which is not used by sensetivity in any case
 *
 * IOPQ( )	This (Q) parameter must be non-zero for sensetivity of
 *			following Z parameter (model params done first)
 * IOPZ( )	Prev. 'Q' parameter must be non-zero for sensetivity
 * IOPQO( )	Like Q, but or-ed with previous Q value
 * ....U( )	uninteresting for default "show" command output
 */

#ifndef HAS_MINDATA

# define IOP(a,b,c,d)   { a, b, c|IF_SET|IF_ASK,			d }
# define IOPU(a,b,c,d)   { a, b, c|IF_SET|IF_ASK|IF_UNINTERESTING,	d }
# define IOPP(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_PRINCIPAL,		d }
# define IOPA(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_AC,			d }
# define IOPAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_UNINTERESTING,d }
# define IOPAP(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_PRINCIPAL,	d }
# define IOPAA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY,		d }
# define IOPAAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_UNINTERESTING,d}
# define IOPPA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_PRINCIPAL, d }
# define IOPN(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NOISE,		d }
//# define IOPR(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_REDUNDANT,       NULL }
# define IOPR(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_REDUNDANT,       d }
# define IOPX(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE,		d }
# define IOPXU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE|IF_UNINTERESTING,\
									d }
# define IOPQ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY,		d }
# define IOPQU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY|IF_UNINTERESTING,\
									d }
# define IOPZ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY,		d }
# define IOPZU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY|IF_UNINTERESTING,\
									d }
# define IOPQO(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_ORQUERY,		d }

# define IP(a,b,c,d) { a , b , c|IF_SET , d }
# define OP(a,b,c,d) { a , b , c|IF_ASK , d }
# define OPU(a,b,c,d) { a , b , c|IF_ASK|IF_UNINTERESTING , d }
# define OPR(a,b,c,d) { a , b , c|IF_ASK|IF_REDUNDANT , d }
# define P(a,b,c,d) { a , b , c , d }

#else /* HAS_MINDATA */

/*
 * these are for the IBM PC which gets upset by the long description 
 * strings used in IFparm definitions because they add up to more than
 * 64k of static data
 */

# define IOP(a,b,c,d)   { a, b, c|IF_SET|IF_ASK,            NULL }
# define IOPU(a,b,c,d)   { a, b, c|IF_SET|IF_ASK|IF_UNINTERESTING,	NULL }
# define IOPP(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_PRINCIPAL,		NULL }
# define IOPA(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_AC,			NULL }
# define IOPAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_UNINTERESTING, NULL }
# define IOPAP(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC|IF_PRINCIPAL,	NULL }
# define IOPAA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY,		NULL }
# define IOPAAU(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_UNINTERESTING,\
									NULL }
# define IOPPA(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_AC_ONLY|IF_PRINCIPAL,NULL }
# define IOPN(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NOISE,		NULL }
# define IOPR(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_REDUNDANT,		NULL }
# define IOPX(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE,		NULL }
# define IOPXU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_NONSENSE|IF_UNINTERESTING,\
									NULL }
# define IOPQ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY,		NULL }
# define IOPQU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_SETQUERY|IF_UNINTERESTING,\
									NULL }
# define IOPZ(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY,		NULL }
# define IOPZU(a,b,c,d)  { a, b, c|IF_SET|IF_ASK|IF_CHKQUERY|IF_UNINTERESTING,\
									NULL }
# define IOPQO(a,b,c,d) { a, b, c|IF_SET|IF_ASK|IF_ORQUERY,		NULL }

# define IP(a,b,c,d) { a, b, c|IF_SET , NULL }
# define OP(a,b,c,d) { a, b, c|IF_ASK , NULL }
# define OPU(a,b,c,d) { a , b , c|IF_ASK|IF_UNINTERESTING , NULL }
# define OPR(a,b,c,d) { a , b , c|IF_ASK|IF_REDUNDANT , NULL }
# define P(a,b,c,d) { a, b, c , NULL }

#endif /* HAS_MINDATA */

#define DEV_DEFAULT	0x1


#ifdef IIT
    //* THE FOLLOWING PARAMETERS MAY BE DEFINED FOR ANY DEVICE
    #define GENDEV_TMAX        -1
    #define GENDEV_IS_LINEAR   -2
#endif

#endif /*DEV*/
