//insert file>> #include "instance.h"
#ifndef HDR_instance_h
#define HDR_instance_h

#ifdef _DEBUG
#ifdef _MSC_VER
#pragma message( "  parsing Instance.H" )
#endif /*_MSC_VER*/
#endif /*_DEBUG*/

#include <stdio.h>
#include <string.h>

//insert file>> #include "confdef.h"

#ifndef HDR_confdef_h
#define HDR_confdef_h

#ifdef _DEBUG
#ifdef _MSC_VER
#pragma message( "  parsing ConfDef.H" )
#endif /*_MSC_VER*/
#endif /*_DEBUG*/

// -DEWB_IIT
// -DIIT_BSPICE
// -DINSIDE_XSPICE

#ifdef INSIDE_XSPICE
   #define IIT
   #define IIT_WIN32
   #define XSPICE_BUILD
   #define DOS
   #define MSDOS
   #define _COMPLEX_DEFINED
   #define __STDC__              1
   #define XSPICE

   #define MSVC

#endif//*INSIDE_XSPICE

#endif//*HDR_confdef_h

#ifdef __cplusplus
  #define INSTANCE_class class

  #define INSTANCE_DECLARE_CLASS_MEMBERS                     \
          friend class CSpiceSession;                     \
          friend class CSpiceCircuit;                        \
        public:                                              \
          Instance() { memset(this, 0, sizeof(*this)); }     \
          class CSpiceSession* GetSession()            \
              { return m_CNC_SpiceSimulation; }              \
          class ISpiceFrontEnd*   GetFrontEnd()              \
              { return m_CNC_SpiceFrontEnd; }                \
        private:

#else
  #define INSTANCE_class struct
  #define INSTANCE_DECLARE_CLASS_MEMBERS

#endif

  #define hInst(ckt)             ((ckt)->m_instance_handle)
  #define iGLOBAL(inst,member)   ((inst)->m_##member)
  #define cGLOBAL(ckt,member)    iGLOBAL(hInst(ckt), member)

typedef INSTANCE_class Instance
{

INSTANCE_DECLARE_CLASS_MEMBERS

    struct sIFfrontEnd*  m_CNC_frontEnd;    // NEW
    struct sIFfrontEnd*  m_SPfrontEnd;      // Replaces SPfrontEnd
    struct sIFsimulator* m_ft_sim;          // Replaces ft_sim
    struct circ*         m_ft_curckt;       // Replaces ft_curckt
    struct circ*         m_ft_circuits;     // Replaces ft_circuits
    struct subcirc*      m_ft_subcircuits;  // Replaces ft_subcircuits
    char*                m_ft_rawfile;      // Replaces ft_rawfile
    struct Mif_Info_s*   m_g_mif_info;      // Replaces g_mif_info

    char* m_errMsg;    /* descriptive message about what went wrong */
                       /* MUST be malloc()'d - front end will free() */
                       /* this should be a detailed message,and is assumed */
                       /* malloc()'d so that you will feel free to add */
                       /* lots of descriptive information with sprintf*/

    char* m_errRtn;    /* name of the routine declaring error */
                       /* should not be malloc()'d, will not be free()'d */
                       /* This should be a simple constant in your routine */
                       /* and thus can be set correctly even if we run out */
                       /* of memory */

    /******************************************************************/
    /******************************************************************/
    // NUTMEG COMMAND STACK, used for nested "while", "if", and other
    // "scoped" structures.
    /******************************************************************/
      /* We have to keep the control structures in a stack, so that when
       * we do a 'source', we can push a fresh set onto the top...
       * Actually there have to be two stacks -- one for the pointer
       * to the list of control structs, and one for the 'current command'
       * pointer...
       */

      #define CONTROLSTACKSIZE 256    /* Better be enough. */
      struct control* m_control[CONTROLSTACKSIZE];
      struct control* m_cend[CONTROLSTACKSIZE];
      int             m_stackp;
      int             m_level_indent;
    /*----------------------------------------------------------------*/
    /*----------------------------------------------------------------*/

    /******************************************************************/
    /******************************************************************/
    // Data associated with the CNC.
    /******************************************************************/
    INSTANCE_class CSpiceSession* m_CNC_SpiceSimulation; // CNC's interface to m_CNC_frontEnd
    INSTANCE_class ISpiceFrontEnd*   m_CNC_SpiceFrontEnd;   // CNC's interface to m_ft_sim
    /*----------------------------------------------------------------*/
    /*----------------------------------------------------------------*/

    /******************************************************************/
    /******************************************************************/
    // Data associated with rawfile reading/writing.
    /******************************************************************/
    FILE *m_rawfileFp;
    int   m_rawfileBinary;
    /*----------------------------------------------------------------*/
    /*----------------------------------------------------------------*/


} Instance;

typedef void GENERIC;
typedef Instance* InstanceHandle;
typedef GENERIC *IFuid;


#undef INSTANCE_class

  typedef enum ANALYSIS_TYPE {
      AT_NONE,
      AT_DC_OP,
      AT_AC,
      AT_TRAN,
      AT_NOISE,
      AT_DISTO,
      AT_PZ,
      AT_TF,
      AT_SENS,
      AT_DC_SWEEP,
      NUM_ANALYSIS_TYPES
  } ANALYSIS_TYPE;

  typedef enum NODE_TYPE {
      NT_NOTYPE,
      NT_TIME,
      NT_FREQUENCY,
      NT_VOLTAGE,
      NT_CURRENT,
      NT_ONOISE_SPECTRUM,
      NT_ONOISE_INTEGRATED,
      NT_INOISE_SPECTRUM,
      NT_INOISE_INTEGRATED,
      NT_OUTPUT_NOISE,
      NT_INPUT_NOISE,
      NT_POLE,
      NT_ZERO,
      NT_S_PARAM,
      NT_NUM_TYPES
  } NODE_TYPE;

  typedef struct AnalysisNode {
      NODE_TYPE      m_node_type;
      IFuid           m_name;
  } AnalysisNode;

  typedef enum COMPONENT_TYPES {
      CT_NONE                = 0x0000,
      CT_VOLTAGE             = 0x0001,
      CT_CURRENT             = 0x0002,
      CT_SPICE_COMPONENT     = 0x0004,
      CT_XSPICE_COMPONENT    = 0x0008,
      CT_ANALOG_COMPONENT    = 0x0010,
      CT_DIGITAL_COMPONENT   = 0x0020,
      CT_NOISE_SOURCE        = 0x0040,
      CT_ACTIVE              = 0x0080,
      CT_PASSIVE             = 0x0100,
      CT_INDEPENDENT_VOLTAGE = 0x0200,
      CT_INDEPENDENT_CURRENT = 0x0400,
      CT_ALL                 = ~CT_NONE
  } COMPONENT_TYPES;

  typedef struct AnalysisComponents {
      COMPONENT_TYPES      m_component_types ;
      char const*          m_name ;
      struct sGENinstance* m_instance ;
  } AnalysisComponents;


  typedef enum AnalysisParameterType
  {
     APT_EXECUTE_SETUP,   //* ANALYSIS_TYPE, this is the analysis to perform setup
     APT_EXECUTE,         //* ANALYSIS_TYPE, this is the analysis to perform

     //* General analysis
     APT_RSHUNT,          //* (optional) double
     APT_SAVE,            //* (optional) string

     //* AC analysis
     APT_AC_SWEEP_TYPE,   //* string (LIN | OCT | DEC)
     APT_AC_POINTS_VALUE, //* double
     APT_AC_START_FREQ,   //* double
     APT_AC_END_FREQ,     //* double

     //* Transient analysis
     APT_TRAN_TSTEP,      //* double
     APT_TRAN_TSTOP,      //* double
     APT_TRAN_TSTART,     //* (optional) double (default 0)
     APT_TRAN_TMAX,       //* (optional) double
     APT_TRAN_UIC,        //* (optional) string
  } AnalysisParameterType;


#endif
//insert file>> #include "spice.h"
#ifndef HDR_spice_h
#define HDR_spice_h

//insert file>> #include "confdef.h"


//insert file>> #include "xspice.h"
#ifndef HDR_xspice_h
#define HDR_xspice_h

//insert file>> #include "basic.h"
#ifndef HDR_basic_h
#define HDR_basic_h

  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing Basic.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

//insert file>>   #include "confdef.h"


      /* using an ansi C compiler, so we have the void* construct */
  typedef void GENERIC;

  #ifdef XSPICE_BUILD
    #ifndef EXPORT
      #ifdef EWB_IIT
         #if defined(IIT) && defined(DLL)
             #ifdef MSVC
                 #define EXPORT      __stdcall
             #elif defined(IIT_WIN32)
                 #define EXPORT      __stdcall _export
             #else
                 #define EXPORT      far pascal _export
             #endif
         #else
            #define EXPORT
         #endif
      #else
         #define EXPORT
      #endif
    #endif
  #else
    #ifndef EXPORT
            #ifdef MSVC
//                   #define EXPORT      __stdcall 
                   #define EXPORT      __stdcall __declspec(dllexport) 
            #elif defined(WIN32)
                   #define EXPORT      __stdcall _export
            #else
                   #define EXPORT      far pascal _export
            #endif
    #endif
    #ifndef IIT
      #define IIT
    #endif
    #ifndef EWB_IIT
      #define EWB_IIT
    #endif
    #ifndef ERR_WARNING
      #define ERR_WARNING ERR_WARN
    #endif
  #endif

#if defined(MSVC)
    #define IITEXPORT(type,name)        type (EXPORT *name)
#else
    #define IITEXPORT(type,name)        type EXPORT (*name)
#endif

  typedef struct CKTcircuit_tag CKTcircuit;

  typedef struct sMIFmodel    MIFmodel;
  typedef struct sMIFinstance MIFinstance;

  /*
   * Some preliminary definitions:
   *
   * IFnode's are returned by the simulator, thus we don't really
   * know what they look like, just that we get to carry pointers
   * to them around all the time, and will need to save them occasionally
   *
   */

  typedef void * IFnode;

  /*
   *
   * datatype: IFuid
   *
   * unique identifier for all name-type data in the simulator.
   * this permits the front end to use something other than
   * a unique, fully qualified character string to identify
   * an object.
   *
   */

  typedef GENERIC *IFuid;


#endif
#include <stdio.h>

#ifndef APP_MSG
//insert file>> #include "ewbmdefs.h"
/***************************************************************
 * WARNING: This file was automatically generated
 * Do not edit this file, or your changes will be stomped
 **************************************************************/
#define EWB_STDERR                0
#define MENU_HELP                 1
#define MENU_CUT                  2
#define MENU_COPY                 3
#define MENU_MODEL                4
#define MENU_MACRO                5
#define MENU_DESCRIPT             6
#define MENU_ZOOM                 7
#define MENU_ROTATE               8
#define MENU_LABEL                9
#define MENU_PREF                 10
#define PREF_ACTIVE_COMP_SIM      11
#define MENU_PRINT                12
#define MENU_QUIT                 13
#define MENU_VALUE                14
#define PREF_TRANS                15
#define MENU_WIRE_COLOUR          16
#define PREF_SS                   17
#define PREF_ASSUME_LINEAR        18
#define PREF_NONE                 19
#define PREFERENCES               20
#define PREF_OUTPUT               21
#define MENU_IMPORT               22
#define PREF_PAUSE                23
#define PREF_PREC                 24
#define PREF_POINTS               25
#define MENU_UNDO                 26
#define LOW_MEM_STARTUP           27
#define MSG_FREQUENCY             28
#define PREF_SIZE                 29
#define PREF_GRID                 30
#define PREF_LABELS               31
#define PREF_MODELS               32
#define PREF_VALUES               33
#define ERR_LOAD                  34
#define MSG_PHASE                 35
#define MENU_FAULTS               36
#define MSG_FAULTS                37
#define MSG_OPEN_CIRC             38
#define MSG_SHORT_CIRC            39
#define MSG_VALUE_ERROR           40
#define MSG_MOD_CLASH_RENAME      41
#define TIME_FORMAT               42
#define CHOOSE_WIRE_COLOUR        43
#define CANT_COPY_INST            44
#define NO_SELECTED               45
#define LOW_MEMORY                46
#define MSG_RANDOM                47
#define CONFIRM_CLEAR             48
#define CONFIRM_QUIT              49
#define HELP_TPX                  50
#define CONFIRM_DELETE            51
#define MENU_HELP_INDEX           52
#define MSG_TRUTH_INDET           53
#define MENU_RESUME               54
#define MENU_SAVE_AS              55
#define MENU_CLOSE                56
#define LOAD_CIRCUIT              57
#define CIRCUIT_FILTER            58
#define SAVE_CIRCUIT              59
#define CIRCUIT_DEF_EXT           60
#define LOAD_CIRC_FROM            61
#define SAVE_CIRC_TO              62
#define LOAD_BIN_FROM             63
#define LIBRARY_FILTER            64
#define LOAD_PAT_FROM             65
#define SAVE_PAT_TO               66
#define MENU_REVERT               67
#define MENU_GLOSSARY             68
#define LOAD                      69
#define SAVE                      70
#define PATTERN_FILTER            71
#define DEMO_MESSAGE              72
#define SAVE_DISABLED             73
#define PRINT_DISABLED            74
#define TOO_MANY_COMP1            75
#define TOO_MANY_COMP2            76
#define HOME                      77
#define PATTERN_DEF_EXT           78
#define MACRO                     79
#define MENU_PRTSC                80
#define MENU_PRT_SETUP            81
#define MENU_EDIT_TEXT            82
#define CANT_OPEN_HELP            83
#define CANT_FIND_HELP            84
#define CANT_OPEN_TBL             85
#define NO_BUTTON_TEXT            86
#define NO_BUTTON_KEY             87
#define CONTRADICTION             88
#define RACE_CONDITIONS           89
#define NOT_GROUNDED              90
#define ZERO_DIMEN                91
#define DIV_BY_ZERO               92
#define SHORT_CIRCUIT1            93
#define SHORT_CIRCUIT2            94
#define OPEN_CIRCUIT1             95
#define OPEN_CIRCUIT2             96
#define TIME_STEP_ERR             97
#define ITERATIONS_ERR            98
#define CIRC_CONF_ERR             99
#define INST_METER                100
#define INST_WGEN                 101
#define INST_LOGIC                102
#define INST_TRUTH                103
#define INST_FGEN                 104
#define INST_SCOPE                105
#define INST_BODE                 106
#define PART0                     107
#define PART1                     108
#define PART2                     109
#define PART3                     110
#define PART4                     111
#define PART5                     112
#define PART6                     113
#define PART7                     114
#define PART8                     115
#define PART9                     116
#define PART10                    117
#define PART11                    118
#define PART12                    119
#define PART13                    120
#define PART14                    121
#define PART15                    122
#define PART16                    123
#define PART17                    124
#define PART18                    125
#define PART19                    126
#define PART20                    127
#define PART21                    128
#define PART22                    129
#define PART23                    130
#define PART24                    131
#define PART25                    132
#define PART26                    133
#define PART27                    134
#define PART28                    135
#define PART29                    136
#define PART30                    137
#define PART31                    138
#define PART32                    139
#define PART33                    140
#define PART34                    141
#define PART35                    142
#define PART36                    143
#define PART37                    144
#define PART38                    145
#define PART39                    146
#define PART40                    147
#define PART41                    148
#define PART42                    149
#define PART43                    150
#define PART44                    151
#define PART45                    152
#define ABORT_SIM                 153
#define MENU_CIRCUIT              154
#define MENU_WINDOW               155
#define MSG_LIBRARY               156
#define NUM_SEPARATOR             157
#define LIBRARY_DEF_EXT           158
#define MSG_PARTS_BIN             159
#define CANT_FIND_PB              160
#define ERR_EV                    161
#define CIRCUIT_LABEL             162
#define NO_NAME                   163
#define AMMETER_RES               164
#define VOLTMETER_RES             165
#define OHMMETER_CURR             166
#define DECIBEL_STAND             167
#define LABEL                     168
#define MENU_PRT_SETUP_WIN        169
#define MODEL1                    170
#define MSG_MOD_CLASH_CIRC        171
#define MSG_MOD_CLASH_TITLE       172
#define MSG_MOD_CLASH_DESC        173
#define NO_MODEL_NAME             174
#define MSG_MOD_CLASH_LIB         175
#define MSG_MOD_PUT               176
#define MSG_MOD_NOLIB_TITLE       177
#define MSG_MOD_NOLIB_DESC        178
#define MSG_MOD_NOLIB_CR          179
#define MSG_MOD_NOMOD_TITLE       180
#define MSG_MOD_NOMOD_DESC        181
#define MSG_MOD_NOMOD_PUT         182
#define PR_SCHEMATIC              183
#define COPY_FROM_CIRC            184
#define MOVE_FROM_CIRC            185
#define NO_INST_IN_MAC            186
#define CREATE_MACRO              187
#define MSG_BIN2LIB               188
#define NO_MAC_IN_MAC             189
#define MACRO_TOO_BIG             190
#define MACRO_NAME                191
#define CONT_FEED                 192
#define LETTER_SIZE               193
#define LEGAL_SIZE                194
#define ANALYSIS_PREF             195
#define ANALYSIS_DIALOG           196
#define PREF_ONE_CYCLE            197
#define MACRO_EXISTS_WARNING      198
#define MSG_SPECTRUM              199
#define PR_PARTS_LIST             200
#define PR_CIRCUIT                201
#define PR_MACROS                 202
#define PR_FGEN                   203
#define PR_METER                  204
#define PR_SCOPE                  205
#define PR_BODE                   206
#define PR_WGEN                   207
#define PR_LOGIC                  208
#define PR_TRUTH                  209
#define PR_BOOL                   210
#define MSG_NEW_LIB_BUT           211
#define MSG_EDIT_MODEL            212
#define PRINT_TITLE               213
#define PR_INSTRUMENTS            214
#define MSG_NEW_LIB               215
#define ERR_Ihd_LT_Ion            216
#define MSG_VER_PLACEHOLDER       217
#define NO_BOOL_ERR               218
#define NO_TRUTH_ERR              219
#define MSG_CLEARING              220
#define MSG_QUITTING              221
#define PR_PARTS_ERR              222
#define NO_ELEM_ERR               223
#define PR_CIRC_ERR               224
#define PR_LABEL_LIST             225
#define PR_MODEL_LIST             226
#define CIRCUIT_TITL              227
#define PARTS_LIST                228
#define LABEL_LIST                229
#define MODEL_LIST                230
#define USAGE_MESSAGE             231
#define NOT_ENUF_MEMORY           232
#define MSG_PAUSE                 233
#define MSG_STEADY_STATE          234
#define P_Key_DESCR               235
#define MSG_RESTRICT_FAULTS       236
#define MSG_PASSWORD              237
#define PREF_ANAL_TYPE            238
#define MSG_AC_ANAL               239
#define ERR_LATER_VERSION         240
#define FALSE_CLS                 241
#define CHECK_ACTIV               242
#define MSG_SAVE_PCX              243
#define MENU_SAVE_PCX             244
#define MSG_STOP                  245
#define MSG_COPY_MODEL            246
#define NO_FNT_FILE               247
#define INITIAL_ERR               248
#define MSG_RESTRICT              249
#define MSG_RESTRICT_VAL          250
#define MSG_RESTRICT_MACRO        251
#define MSG_RESTRICT_PBIN         252
#define MENU_PASTE                253
#define MENU_DELETE               254
#define MSG_PASTE_MODEL_BUT       255
#define MSG_DELETE_MODEL          256
#define MODEL_EXISTS              257
#define MSG_RENAME_MODEL_BUT      258
#define DELETE_BUTTON             259
#define BODE_NEEDS_SOURCE         260
#define MSG_COMP_VALUE            261
#define LIB_NAME_ERROR            262
#define LIB_EXISTS                263
#define MSG_RESTRICT_INST         264
#define MSG_RENAME_MODEL          265
#define MENU_HELP_HIDE            266
#define MSG_ERROR                 267
#define MSG_PAUSED                268
#define MSG_STOPPED               269
#define MENU_PARTS                270
#define INSTS_TO_FRONT            271
#define SUBCIRC_TO_FRONT          272
#define MENU_CIRCUIT_TITLE        273
#define HELP_TO_FRONT             274
#define WIN_DESCRIPT              275
#define MSG_CHOOSE_MOD            276
#define MSG_CHOOSE_LIB            277
#define MSG_MODEL_REDEFINE        278
#define ERR_CHK_GT_0              279
#define ERR_CHK_GE_0              280
#define ERR_CHK_LT_1              281
#define WAIT_SS                   282
#define ACSS_WARNING              283
#define P_FRE_DESCR               284
#define P_FRE_UNIT                285
#define P_PHA_DESCR               286
#define P_MOD_DESCR               287
#define ERR_CHK_LE_0              288
#define PARAM_FMT                 289
#define MAC_FILE                  290
#define MAC_EDIT                  291
#define MAC_WB                    292
#define WB_NAME                   293
#define CANT_CUT_INST             294
#define CANT_MOVE_INST            295
#define CANT_CREATE_MACRO         296
#define CANT_ROTATE_INST          297
#define NOTHING_TO_PRINT          298
#define NEED_OUTPUT_FNAME         299
#define MENU_ARRANGE              300
#define PR_CIRC_LABEL             301
#define CONFIRM_CUT               302
#define ERR_INVALID_NUM           303
#define MSG_COMP_LABEL            304
#define ERR_INVALID_KEY           305
#define UNMATCHED_PAREN           306
#define MISPLACED_OPS             307
#define BAD_REGISTRATION          308
#define LOCK_MESSAGE              309
#define MODULE_NAME               310
#define VERSION_MESSAGE           311
#define MENU_ABOUT                312
#define MENU_SIMULATE             313
#define MENU_NEW                  314
#define MENU_SELECT_ALL           315
#define MENU_SHOW_CLIP            316
#define REGISTERED_TO             317
#define CANT_DEL_INST             318
#define MODEL_IN_USE              319
#define MSG_PASTE_MODEL           320
#define MENU_HIDE_CLIPBOARD       321
#define GEN_CIRC_TOO_BIG          322
#define INTERNAL_ERROR            323
#define MENU_SYSTEM               324
#define MENU_RESTRICT             325
#define SYSTEM_COMMAND            326
#define DEL_CONTACT_WARNING       327
#define REPLACE_IN_CIRCUIT        328
#define P_CAP_DESCR               329
#define P_CAP_NAME                330
#define P_CAP_UNIT                331
#define P_IND_DESCR               332
#define P_IND_NAME                333
#define P_IND_UNIT                334
#define P_POW_DESCR               335
#define P_POW_NAME                336
#define P_POW_UNIT                337
#define P_DEG_DESCR               338
#define P_DEG_NAME                339
#define P_DEG_UNIT                340
#define P_CUR_DESCR               341
#define P_CUR_NAME                342
#define P_CUR_UNIT                343
#define P_RES_DESCR               344
#define P_RES_NAME                345
#define P_RES_UNIT                346
#define P_VLT_DESCR               347
#define P_VLT_NAME                348
#define P_VLT_UNIT                349
#define P_NO_UNIT                 350
#define P_TME_UNIT                351
#define P_Is_DESCR                352
#define P_Is_NAME                 353
#define P_rd_DESCR                354
#define P_rd_NAME                 355
#define P_Cj_DESCR                356
#define P_Cj_NAME                 357
#define P_P_DESCR                 358
#define P_P_NAME                  359
#define P_T_DESCR                 360
#define P_T_NAME                  361
#define P_m_DESCR                 362
#define P_m_NAME                  363
#define P_BF_DESCR                364
#define P_BF_NAME                 365
#define P_BR_DESCR                366
#define P_BR_NAME                 367
#define P_rb_DESCR                368
#define P_rb_NAME                 369
#define P_re_DESCR                370
#define P_re_NAME                 371
#define P_rc_DESCR                372
#define P_rc_NAME                 373
#define P_Cs_DESCR                374
#define P_Cs_NAME                 375
#define P_Ce_DESCR                376
#define P_Ce_NAME                 377
#define P_Cc_DESCR                378
#define P_Cc_NAME                 379
#define P_Pe_DESCR                380
#define P_Pe_NAME                 381
#define P_Pc_DESCR                382
#define P_Pc_NAME                 383
#define P_TF_DESCR                384
#define P_TF_NAME                 385
#define P_TR_DESCR                386
#define P_TR_NAME                 387
#define P_me_DESCR                388
#define P_me_NAME                 389
#define P_mc_DESCR                390
#define P_mc_NAME                 391
#define P_VA_DESCR                392
#define P_VA_NAME                 393
#define P_VTO_DESCR               394
#define P_VTO_NAME                395
#define P_B_DESCR                 396
#define P_B_NAME                  397
#define P_B_UNIT                  398
#define P_Lm_DESCR                399
#define P_Lm_NAME                 400
#define P_Lm_UNIT                 401
#define P_Jrd_DESCR               402
#define P_Jrd_NAME                403
#define P_rs_DESCR                404
#define P_rs_NAME                 405
#define P_JIs_DESCR               406
#define P_Cgd_DESCR               407
#define P_Cgd_NAME                408
#define P_Cgs_DESCR               409
#define P_Cgs_NAME                410
#define P_PhB_DESCR               411
#define P_PhB_NAME                412
#define P_Phi_DESCR               413
#define P_Phi_NAME                414
#define P_Gam_DESCR               415
#define P_Gam_NAME                416
#define P_Gam_UNIT                417
#define P_MIs_DESCR               418
#define P_Cgb_DESCR               419
#define P_Cgb_NAME                420
#define P_Cbd_DESCR               421
#define P_Cbd_NAME                422
#define P_Cbs_DESCR               423
#define P_Cbs_NAME                424
#define P_MPB_DESCR               425
#define P_n_DESCR                 426
#define P_n_NAME                  427
#define P_Le_DESCR                428
#define P_Le_NAME                 429
#define P_XLm_DESCR               430
#define P_XLm_NAME                431
#define P_Rp_DESCR                432
#define P_Rp_NAME                 433
#define P_Rs_DESCR                434
#define P_Rs_NAME                 435
#define P_A_DESCR                 436
#define P_A_NAME                  437
#define P_Ri_DESCR                438
#define P_Ri_NAME                 439
#define P_Ro_DESCR                440
#define P_Ro_NAME                 441
#define P_Vpp_DESCR               442
#define P_Vpp_NAME                443
#define P_Vpn_DESCR               444
#define P_Vpn_NAME                445
#define P_Vos_DESCR               446
#define P_Vos_NAME                447
#define P_Ibs_DESCR               448
#define P_Ibs_NAME                449
#define P_Ios_DESCR               450
#define P_Ios_NAME                451
#define P_SR_DESCR                452
#define P_SR_NAME                 453
#define P_SR_UNIT                 454
#define P_fu_DESCR                455
#define P_fu_NAME                 456
#define P_fu_UNIT                 457
#define P_fp2_DESCR               458
#define P_fp2_NAME                459
#define P_CcO_DESCR               460
#define P_CcO_NAME                461
#define P_Vzt_DESCR               462
#define P_Vzt_NAME                463
#define P_Izt_DESCR               464
#define P_Izt_NAME                465
#define P_Ion_DESCR               466
#define P_Ion_NAME                467
#define P_Pmx_DESCR               468
#define P_Pmx_NAME                469
#define P_Vmx_DESCR               470
#define P_Vmx_NAME                471
#define P_Imx_DESCR               472
#define P_Imx_NAME                473
#define P_Rof_DESCR               474
#define P_Rof_NAME                475
#define P_Ron_DESCR               476
#define P_Ron_NAME                477
#define P_Ton_DESCR               478
#define P_Ton_NAME                479
#define P_Tof_DESCR               480
#define P_Tof_NAME                481
#define P_Lc_DESCR                482
#define P_Lc_NAME                 483
#define P_Ihd_DESCR               484
#define P_Ihd_NAME                485
#define P_VV_DESCR                486
#define P_VV_NAME                 487
#define P_VV_UNIT                 488
#define P_II_DESCR                489
#define P_II_NAME                 490
#define P_II_UNIT                 491
#define P_IV_DESCR                492
#define P_IV_NAME                 493
#define P_mho_UNIT                494
#define P_VI_DESCR                495
#define P_VI_NAME                 496
#define P_Von_DESCR               497
#define P_Von_NAME                498
#define P_Vof_DESCR               499
#define P_Vof_NAME                500
#define P_Iof_DESCR               501
#define P_Iof_NAME                502
#define MSG_DC_ANAL               503
#define ERR_LOCK_DIR              504
#define ERR_LOCK_CREATE           505
#define ERR_LOCK_NONET            506
#define ERR_LOCK_TOOMANY          507
#define KEY_HELP                  508
#define KEY_HELP_IDX              509
#define KEY_ABOUT                 510
#define KEY_NEW                   511
#define KEY_OPEN                  512
#define KEY_CLOSE                 513
#define KEY_SAVE                  514
#define KEY_SAVEAS                515
#define KEY_REVERT                516
#define KEY_PRINT                 517
#define KEY_PRTSC                 518
#define KEY_PRTSETUP              519
#define KEY_SAVEPCX               520
#define KEY_SYSTEM                521
#define KEY_QUIT                  522
#define KEY_SIMULATE              523
#define KEY_STOP                  524
#define KEY_PAUSE                 525
#define KEY_LABEL                 526
#define KEY_VALUE                 527
#define KEY_MODEL                 528
#define KEY_ZOOM                  529
#define KEY_ROTATE                530
#define KEY_SUBCIRCUIT            531
#define KEY_WIRECOLOR             532
#define KEY_DISPOPT               533
#define KEY_ANALOPT               534
#define KEY_FAULTS                535
#define KEY_RESTRICT              536
#define KEY_ARRANGE               537
#define KEY_INSTFRONT             538
#define KEY_SUBFRONT              539
#define KEY_CIRC                  540
#define KEY_PARTS                 541
#define KEY_DESCR                 542
#define KEY_UNDO                  543
#define KEY_CUT                   544
#define KEY_COPY                  545
#define KEY_PASTE                 546
#define KEY_DELETE                547
#define KEY_SELECTALL             548
#define KEY_SHOWCLIP              549
#define MSG_CYCLE                 550
#define MSG_BURST                 551
#define MSG_STEP                  552
#define KEY_HELP_HIDE             553
#define KEY_20_CUT                554
#define KEY_20_COPY               555
#define KEY_20_PASTE              556
#define KEY_20_SUBCIRCUIT         557
#define KEY_20_LABEL              558
#define KEY_20_ZOOM               559
#define KEY_20_ROTATE             560
#define KEY_20_DISPOPT            561
#define ERR_INVALID_NODE          562
#define ERR_INVALID_VNUM          563
#define ERR_INVALID_COMP          564
#define ERR_INVALID_INPUT         565
#define ERR_INVALID_OUTPUT        566
#define ERR_INVALID_VOLT          567
#define ERR_HOLD                  568
#define ERR_FANOUT                569
#define P_VBR_NAME                570
#define P_VBR_DESCR               571
#define P_VS_NAME                 572
#define P_VS_DESCR                573
#define P_VDRM_NAME               574
#define P_VDRM_DESCR              575
#define P_TQ_NAME                 576
#define P_TQ_DESCR                577
#define P_DVDT_NAME               578
#define P_DVDT_DESCR              579
#define P_IH_NAME                 580
#define P_IH_DESCR                581
#define P_VCC_NAME                582
#define P_VCC_DESCR               583
#define P_VEE_NAME                584
#define P_VEE_DESCR               585
#define P_CMRR_NAME               586
#define P_CMRR_DESCR              587
#define P_ISC_NAME                588
#define P_ISC_DESCR               589
#define P_VCC_HI_NAME             590
#define P_VCC_LO_NAME             591
#define P_ISOUT_NAME              592
#define P_ROUT_HI_NAME            593
#define P_ROUT_LO_NAME            594
#define P_RSW_HI_NAME             595
#define P_RSW_LO_NAME             596
#define P_RIN_NAME                597
#define P_ISIN_NAME               598
#define P_VIN_NAME                599
#define P_VIH_NAME                600
#define P_VIL_NAME                601
#define P_TRI_NAME                602
#define P_TFL_NAME                603
#define P_TPLH_NAME               604
#define P_TPHL_NAME               605
#define P_VIMIN_NAME              606
#define P_VIMAX_NAME              607
#define P_VIK_NAME                608
#define EXT_MISSING               609
#define CIRCUIT_FILTER31          610
#define P_VGT_NAME                611
#define P_VGT_DESCR               612
#define P_IGT_NAME                613
#define P_IGT_DESCR               614
#define KEYWORD_MSG               615
#define LICENSE_VALIDATION        616
#define P_IDRM_DESCR              617
#define P_IDRM_NAME               618
#define P_VDIGT_DESCR             619
#define P_VDIGT_NAME              620
#define P_PCT_UNIT                621
#define P_SETTING_DESCR           622
#define P_INCREMENT_DESCR         623
#define P_VTM_DESCR               624
#define P_VTM_NAME                625
#define P_ITM_DESCR               626
#define P_ITM_NAME                627
#define P_PM_DESCR                628
#define P_PM_NAME                 629
#define P_VIH_DESCR               630
#define P_VIL_DESCR               631
#define P_TRISE_DESCR             632
#define P_TFALL_DESCR             633
#define P_TPLH_DESCR              634
#define P_TPHL_DESCR              635
#define P_VIMN_DESCR              636
#define P_VIMX_DESCR              637
#define P_VIK_DESCR               638
#define PAGE                      639
#define P_SRNEW_UNIT              640
#define P_CMRR_UNIT               641
#define MSG_DIGMODL_WAR           642
#define P_bv_DESCR                643
#define P_bv_NAME                 644
#define P_Ise_DESCR               645
#define P_Ise_NAME                646
#define P_Ikf_DESCR               647
#define P_Ikf_NAME                648
#define P_ne_DESCR                649
#define P_ne_NAME                 650
#define P_BIN_00                  651
#define P_BIN_01                  652
#define P_BIN_02                  653
#define P_BIN_03                  654
#define P_BIN_04                  655
#define P_BIN_05                  656
#define P_BIN_06                  657
#define P_BIN_07                  658
#define P_BIN_08                  659
#define P_BIN_09                  660
#define P_BIN_10                  661
#define P_BIN_11                  662
#define P_BIN_12                  663
#define P_BIN_13                  664
#define P_BIN_14                  665
#define P_BIN_15                  666
#define P_BIN_16                  667
#define P_BIN_17                  668
#define P_BIN_18                  669
#define P_BIN_19                  670
#define P_BIN_20                  671
#define P_BIN_21                  672
#define P_BIN_22                  673
#define P_BIN_23                  674
#define REVERT_MSG                675
#define MULT_IN_MSG               676
#define BEEP_SET_MSG              677
#define MENU_COPYBITS             678
#define KEY_COPYBITS              679
#define P_74XX_SERIES             680
#define P_74XXX_SERIES            681
#define P_4000_SERIES             682
#define SAVE_BODE_TO              683
#define BODE_FILTER               684
#define BODE_DEF_EXT              685
#define FILE_SAVE_EXT_CHANGE      686
#define SAVE_SCOPE_TO             687
#define SCOPE_FILTER              688
#define SCOPE_DEF_EXT             689
#define MACRO_TOO_MANY_PINS       690
#define PREF_BODE_POINTS          691
#define PREF_OPTIMIZATIONS        692
#define MENU_INSTALL              693
#define KEY_INSTALL               694
#define P_nf_DESCR                695
#define P_nf_NAME                 696
#define P_BIN_LONG_00             697
#define P_BIN_LONG_01             698
#define P_BIN_LONG_02             699
#define P_BIN_LONG_03             700
#define P_BIN_LONG_04             701
#define P_BIN_LONG_05             702
#define P_BIN_LONG_06             703
#define P_BIN_LONG_07             704
#define P_BIN_LONG_08             705
#define P_BIN_LONG_09             706
#define P_BIN_LONG_10             707
#define P_BIN_LONG_11             708
#define P_BIN_LONG_12             709
#define P_BIN_LONG_13             710
#define P_BIN_LONG_14             711
#define P_BIN_LONG_15             712
#define P_BIN_LONG_16             713
#define P_BIN_LONG_17             714
#define P_BIN_LONG_18             715
#define P_BIN_LONG_19             716
#define P_BIN_LONG_20             717
#define P_BIN_LONG_21             718
#define P_BIN_LONG_22             719
#define P_BIN_LONG_23             720
#define SAVE_AS_CIRCUIT_FILTER    721
#define SAVE_AS_DEFAULT_NAME      722
#define INSTALL_MSG_TITLE         723
#define INSTALL_MSG               724
#define INSTALL_MSG_DRIVE_A       725
#define INSTALL_MSG_DRIVE_B       726
#define INSTALL_RETRY_MSG         727
#define INSTALL_APP_NAME          728
#define PR_XY_PLOT                729
#define MENU_EXPORT_SPICE         730
#define SCOPE_NO_MEMORY           731
#define SCOPE_DISK_FULL           732
#define SCOPE_DATA_01             733
#define SCOPE_DATA_02             734
#define SCOPE_DATA_03             735
#define SCOPE_DATA_04             736
#define SCOPE_DATA_05             737
#define SCOPE_DATA_06             738
#define SCOPE_DATA_07             739
#define SCOPE_DATA_08             740
#define SCOPE_DATA_09             741
#define SCOPE_DATA_10             742
#define SCOPE_DATA_11             743
#define SCOPE_NO_DATA             744
#define BODE_NO_DATA              745
#define BODE_DATA_01              746
#define BODE_DATA_02              747
#define BODE_DATA_03              748
#define BODE_DATA_04              749
#define BODE_DATA_05              750
#define BODE_DATA_06              751
#define BODE_DATA_07              752
#define BODE_DATA_08              753
#define BODE_DATA_09              754
#define UNTITLED_FILENAME         755
#define FAULT_STRIP_WARNING       756
#define MSG_LEAKAGE               757
#define FAULTS_OPEN               758
#define FAULTS_SHORT              759
#define FAULTS_LEAKAGE            760
#define VARRAY_NO_MEMORY          761
#define VARRAY_DISK_FULL          762
#define VARRAY_FILE_FULL          763
#define PREF_TEMP_SIZE            764
#define VARRAY_FILE_1             765
#define VARRAY_FILE_2             766
#define VARRAY_FILE_3             767
#define VARRAY_FILE_4             768
#define VARRAY_FILE_5             769
#define VARRAY_DISK_1             770
#define VARRAY_DISK_2             771
#define VARRAY_DISK_3             772
#define VARRAY_DISK_4             773
#define PREF_STORE_RESULTS        774
#define MODEL_MSG_1               775
#define MODEL_MSG_2               776
#define MODEL_MSG_3               777
#define MODEL_MSG_4               778
#define EDU_WARNING               779
#define DEMO40_NO_INSTALL         780
#define DEMO40_NO_CUT             781
#define DEMO40_NO_COPY            782
#define DEMO40_NO_PASTE           783
#define DEMO40_NO_MACRO           784
#define DEMO40_NO_PRINT           785
#define DEMO40_NO_SAVE            786
#define DEMO40_NO_DOS             787
#define DEMO40_NO_SAVE_PCX        788
#define DEMO40_INVALID_PART1      789
#define DEMO40_INVALID_PART2      790
#define DEMO40_NO_EDIT            791
#define DEMO40_MAX_PARTS          792
#define DEMO40_TIME_LIMIT         793
#define STUDENT_NO_EDIT           794
#define STUDENT_MAX_PARTS         795
#define STUDENT_RESTRICTED        796
#define STUDENT_BANNER            797
#define DEMO40_TIME_WARNING       798
#define DEMO40_INFO               799
#define DEL_SEL_MODEL             800
#define XY_PLOT_00                801
#define XY_PLOT_01                802
#define XY_PLOT_02                803
#define XY_PLOT_03                804
#define XY_PLOT_04                805
#define XY_PLOT_05                806
#define XY_PLOT_06                807
#define XY_PLOT_07                808
#define XY_PLOT_08                809
#define XY_PLOT_09                810
#define XY_PLOT_10                811
#define XY_PLOT_11                812
#define XY_PLOT_12                813
#define XY_PLOT_13                814
#define XY_PLOT_14                815
#define XY_PLOT_15                816
#define XY_PLOT_16                817
#define XY_PLOT_17                818
#define SECONDARY_NO_EDIT         819
#define SECONDARY_NO_PART         820
#define PERCENT_ERR               821
#define STUDENT_KEY_MSG           822
#define IGNORE_BUTTON             823
#define SECONDS                   824
#define VOLTS                     825
#define NOT_USED                  826
#define TRACE_1                   827
#define TRACE_2                   828
#define MSG_RESTRICT_CPBIN        829
#define MSG_RESTRICT_DPBIN        830
#define NOT_V40_COMPONENTS        831
#define SAVE_AS_FILTER2           832
#define P_MICRO_SIGN              833
#define P_DEGREE_UNIT             834
#define P_COMMENT                 835
#define MENU_IMPORT_SPICE         836
#define MENU_EXPORT_PCB           837
#define KEY_S3OPT                 838
#define SPICE3_PREF               839
#define SPICE3_DIALOG             840
#define OPT_DEFAULT               841
#define OPT_TOGGLE                842
#define OPT_ALL_OFF               843
#define OPT_METHOD                844
#define OPT_GEAR                  845
#define OPT_TRAP                  846
#define OPT_TMAX                  847
#define OPT_RESET                 848
#define OPT_HELP                  849
#define OPT_VALUE                 850
#define OPT_FLAG                  851
#define OPT_TSTEP                 852
#define OPT_EDIT_OPT              853
#define OPT_EVALUE                854
#define ANALYSIS_STARTF           855
#define ANALYSIS_ENDF             856
#define ANALYSIS_SWEEP            857
#define ANALYSIS_SCALE            858
#define ANALYSIS_NUMPTS           859
#define FOURIER_DIALOG            860
#define FOURIER_OUTVAR            861
#define FOURIER_FUNDF             862
#define FOURIER_HARM              863
#define AC_FREQ_DIALOG            864
#define AC_FREQ_TP                865
#define NOISE_DIALOG              866
#define NOISE_INPSRC              867
#define NOISE_OUTNODE             868
#define NOISE_OUTCCHECKREF        869
#define NOISE_OUTREF              870
#define NOISE_PTSPERSUM           871
#define DIST_DIALOG               872
#define DIST_CCHECKF2OF1          873
#define PAR_DIALOG                874
#define PAR_SWEEP_TYPE            875
#define PAR_TEMP                  876
#define PAR_TIMEDOMAIN            877
#define PAR_AC_FREQ               878
#define PAR_NOISE                 879
#define PAR_HARM                  880
#define PAR_SPECTRUM              881
#define PAR_STARTVAL              882
#define PAR_ENDVAL                883
#define PAR_NUMSTEPS              884
#define PAR_SWEEP_AN              885
#define PAR_GLOBAL                886
#define PAR_COMPONENT             887
#define PZ_DIALOG                 888
#define PZ_PINPUT                 889
#define PZ_NINPUT                 890
#define PZ_POUTPUT                891
#define PZ_NOUTPUT                892
#define PZ_ANALYSISTYPE           893
#define PZ_GAIN                   894
#define PZ_IMPED                  895
#define PZ_POLE                   896
#define PZ_ZERO                   897
#define TF_DIALOG                 898
#define TF_OUTPOS                 899
#define TF_OUTNEG                 900
#define TF_OUTVARNAME             901
#define TF_INPSRC                 902
#define TF_OUTSRC                 903
#define TF_NO_TESTPTS             904
#define SENS_DIALOG               905
#define SENS_OUTPOS               906
#define SENS_OUTNEG               907
#define SENS_OUTSRC               908
#define SENS_OUTVARNAME           909
#define SENS_DC                   910
#define SENS_AC                   911
#define MONTE_DIALOG              912
#define MONTE_NUMRUNS             913
#define MONTE_XLOWER              914
#define MONTE_XUPPER              915
#define MONTE_YLOWER              916
#define MONTE_YUPPER              917
#define MONTE_DIST_TYPE           918
#define MENU_ANALYSIS_TITLE       919
#define MENU_TIME_DOMAIN          920
#define MENU_FOURIER              921
#define MENU_AC_FREQ              922
#define MENU_NOISE                923
#define MENU_DISTORT              924
#define MENU_PARAMETRIC           925
#define MENU_POLE                 926
#define MENU_TRANSF               927
#define MENU_SENS                 928
#define MENU_MONTE                929
#define MENU_WORST_CASE           930
#define MENU_ZOOM_IN              931
#define MENU_ZOOM_OUT             932
#define KEY_ZOOM_IN               933
#define KEY_ZOOM_OUT              934
#define BUT_SIMULATE              935
#define TD_DIALOG                 936
#define TD_START_TIME             937
#define TD_END_TIME               938
#define WORST_DIALOG              939
#define CANT_FLIP_INST            940
#define CANT_MIRROR_INST          941
#define INSTRUM_DIALOG            942
#define GLOBAL_DIALOG             943
#define DC_AN_DIALOG              944
#define DEVICE_EVAL_DIALOG        945
#define OUTPUT_DIALOG             946
#define OTHER_DIALOG              947
#define OPT_BUT_EDIT              948
#define OPT_CCT_NODES             949
#define OPT_AN_NODES              950
#define OPT_BUT_ADD               951
#define OPT_BUT_REMOVE            952
#define OPT_PAR_INCR              953
#define MENU_DC_OP                954
#define PAR_DC                    955
#define PZ_INP_IMPED              956
#define PZ_OUT_IMPED              957
#define OPT_AN_TYPE               958
#define MONTE_OUT_VAR             959
#define MONTE_OUT_NODE            960
#define MONTE_OUT_TYPE            961
#define OPT_AN_NONE               962
#define MONTE_ALL                 963
#define MONTE_FIRST               964
#define MONTE_EVERY               965
#define MONTE_RUNS                966
#define MONTE_SEED                967
#define OPT_AN_COLLATE            968
#define MONTE_N                   969
#define MONTE_X                   970
#define MONTE_Y                   971
#define TD_UIC                    972
#define TD_TMAX                   973
#define TD_TSTEP                  974
#define WORST_ALL                 975
#define WORST_DEV                 976
#define WORST_LOT                 977
#define WORST_BOTH                978
#define WORST_VARY                979
#define MENU_PROPERTIES           980
#define MENU_EXPORT               981
#define MENU_VERT_FLIP            982
#define MENU_HORIZ_FLIP           983
#define OUT_FILENAME              984
#define INHOUSE_DIALOG            985
#define TRANS_DIALOG              986
#define MENU_ADD_TEXT             987
#define MENU_JUMP_TO              988
#define AN_OPT_DEFAULT            989
#define AN_OPT_FILENAME           990
#define AN_OPT_PRE_TRIGGER        991
#define AN_OPT_POST_TRIGGER       992
#define AN_OPT_THRESH_VOLT        993
#define AN_OPT_BODE_PLOT          994
#define AN_OPT_LOGIC_AN           995
#define AN_OPT_CONSTRAIN          996
#define PAR_TRANS_BUT             997
#define MONTE_TOL                 998
#define DIST_INPUT                999
#define DIST_FREQ1                1000
#define DIST_FREQ2                1001
#define DIST_MAGNITUDE            1002
#define DIST_PHASE                1003
#define MSG_NO_TP                 1004
#define MSG_TO_SEL_NODE           1005
#define MSG_NO_COMP               1006
#define MSG_TO_SEL_PAR            1007
#define MSG_TO_SEL_SRC            1008
#define MSG_DISTO_ANAL            1009
#define MSG_SWEEP_ANAL            1010
#define MSG_MONTE_ANAL            1011
#define GRAPH_TAB_FREQ            1012
#define GRAPH_AXIS_GAIN           1013
#define GRAPH_AXIS_GAIN_DB        1014
#define GRAPH_TAB_DISTORT         1015
#define GRAPH_TAB_IM_DISTO        1016
#define GRAPH_AXIS_2F1MF2         1017
#define GRAPH_AXIS_TRANS          1018
#define GRAPH_AXIS_TIME           1019
#define GRAPH_AXIS_VOLTAGE        1020
#define GRAPH_TAB_SWEEP           1021
#define GRAPH_TAB_MONTE           1022
#define SCHEM_DIALOG              1023
#define SCHEM_GRID                1024
#define SCHEM_LABELS              1025
#define SCHEM_FONTS               1026
#define SCHEM_LABEL               1027
#define SCHEM_VALUES              1028
#define SCHEM_BUT_LFONT           1029
#define SCHEM_BUT_MFONT           1030
#define SCHEM_SHOW_REFID          1031
#define ANALYSIS_VERT             1032
#define ANALYSIS_HORIZ            1033
#define PAR_AC_BUTTON             1034
#define NODE_TAB_DIALOG           1035
#define PROP_COLOUR               1036
#define PROP_BUT_COLOUR           1037
#define NODE_STORE_DATA           1038
#define NODE_INIT_VOLT            1039
#define NODE_NEWT_RAPH            1040
#define PROP_USE_SCHEM            1041
#define WIRE_DISP_DIALOG          1042
#define MSG_TP_REQUIRED           1043
#define MSG_COMP_REQUIRED         1044
#define MSG_INVALID_PAR           1045
#define MSG_INVALID_INT           1046
#define MSG_POS_NEG_INPUT         1047
#define MSG_POS_NEG_OUT           1048
#define TRANS_DC_OP               1049
#define P_SPEED_RPM_UNIT          1050
#define P_INERTIA_UNIT            1051
#define P_FRICTION_COEFF_UNIT     1052
#define PROP_LABEL                1053
#define PROP_REFID                1054
#define PROP_USE_TP               1055
#define PROP_VALUE                1056
#define PROP_MODELS               1057
#define ACCEPT_DEF_DIALOG         1058
#define PRMPT_ACCEPT_DEF          1059
#define NEW_PREFERENCES           1060
#define MSG_PROP_LABEL            1061
#define MENU_UNDO_REDO            1062
#define MENU_DISP_GRAPH           1063
#define SENS_OUTPUT               1064
#define SENS_ANALYSIS             1065
#define TD_USE_TMAX               1066
#define MENU_TEMPERATURE          1067
#define AN_SETUP_DIALOG           1068
#define AN_SET_USEGLOB            1069
#define AN_SET_INITCOND_BUT       1070
#define AN_SET_USE_AC             1071
#define AN_SET_AC_MAG             1072
#define AN_SET_AC_PHASE           1073
#define AN_SET_USE_DIST           1074
#define DIST_INPSRC               1075
#define ANALYSIS_DECADE           1076
#define ANALYSIS_OCTAVE           1077
#define P_EV_UNIT                 1078
#define P_TMP_UNIT                1079
#define P_nf_2_DESCR              1080
#define P_nf_2_NAME               1081
#define P_nr_DESCR                1082
#define P_nr_NAME                 1083
#define P_var_DESCR               1084
#define P_var_NAME                1085
#define P_ikr_DESCR               1086
#define P_ikr_NAME                1087
#define P_isc_2_DESCR             1088
#define P_isc_2_NAME              1089
#define P_nc_DESCR                1090
#define P_nc_NAME                 1091
#define P_irb_DESCR               1092
#define P_irb_NAME                1093
#define P_rbm_DESCR               1094
#define P_rbm_NAME                1095
#define P_xtf_DESCR               1096
#define P_xtf_NAME                1097
#define P_vtf_DESCR               1098
#define P_vtf_NAME                1099
#define P_itf_DESCR               1100
#define P_itf_NAME                1101
#define P_ptf_DESCR               1102
#define P_ptf_NAME                1103
#define P_xcjc_DESCR              1104
#define P_xcjc_NAME               1105
#define P_vjs_DESCR               1106
#define P_vjs_NAME                1107
#define P_mjs_DESCR               1108
#define P_mjs_NAME                1109
#define P_xtb_DESCR               1110
#define P_xtb_NAME                1111
#define P_eg_DESCR                1112
#define P_eg_NAME                 1113
#define P_xti_DESCR               1114
#define P_xti_NAME                1115
#define P_kf_DESCR                1116
#define P_kf_NAME                 1117
#define P_af_DESCR                1118
#define P_af_NAME                 1119
#define P_fc_DESCR                1120
#define P_fc_NAME                 1121
#define P_tnom_DESCR              1122
#define P_tnom_NAME               1123
#define P_eg_2_DESCR              1124
#define P_eg_2_NAME               1125
#define P_ibv_DESCR               1126
#define P_ibv_NAME                1127
#define P_b_2_DESCR               1128
#define P_b_2_NAME                1129
#define P_rsh_DESCR               1130
#define P_rsh_NAME                1131
#define P_cj_2_DESCR              1132
#define P_cj_2_NAME               1133
#define P_mj_DESCR                1134
#define P_mj_NAME                 1135
#define P_cjsw_DESCR              1136
#define P_cjsw_NAME               1137
#define P_mjsw_DESCR              1138
#define P_mjsw_NAME               1139
#define P_js_DESCR                1140
#define P_js_NAME                 1141
#define P_tox_DESCR               1142
#define P_tox_NAME                1143
#define P_nsub_DESCR              1144
#define P_nsub_NAME               1145
#define P_nss_DESCR               1146
#define P_nss_NAME                1147
#define P_nfs_DESCR               1148
#define P_nfs_NAME                1149
#define P_tpg_DESCR               1150
#define P_tpg_NAME                1151
#define P_xj_DESCR                1152
#define P_xj_NAME                 1153
#define P_ld_DESCR                1154
#define P_ld_NAME                 1155
#define P_uo_DESCR                1156
#define P_uo_NAME                 1157
#define P_vmax_DESCR              1158
#define P_vmax_NAME               1159
#define P_F_M2_UNIT               1160
#define P_F_M_UNIT                1161
#define P_A_M2_UNIT               1162
#define P_1_CM3_UNIT              1163
#define P_1_CM2_UNIT              1164
#define P_CM2_VS_UNIT             1165
#define P_VELOCITY_UNIT           1166
#define P_LENGTH_UNIT             1167
#define CLK_STP                   1168
#define CLK_EDG                   1169
#define POS                       1170
#define NEG                       1171
#define CLK_MOD                   1172
#define EXTERNAL                  1173
#define INTERNAL                  1174
#define CLK_QUAL                  1175
#define TRIG_PATS                 1176
#define TRIG_COMB                 1177
#define TRIG_QUAL                 1178
#define PRESAVED_PATS             1179
#define CLR_BUFF                  1180
#define LOAD_FILE                 1181
#define SAVE_FILE                 1182
#define UP_COUNT                  1183
#define DOWN_COUNT                1184
#define SHIFT_RIGHT               1185
#define SHIFT_LEFT                1186
#define SHOW_NODES                1187
#define WIRE_NAME                 1188
#define GEN_SIM_ERR               1189
#define SIM_ERR                   1190
#define SHEET_1                   1191
#define SHEET_2                   1192
#define SHEET_3                   1193
#define SHEET_4                   1194
#define SHEET_5                   1195
#define SHEET_6                   1196
#define SHEET_7                   1197
#define SHEET_8                   1198
#define SHEET_9                   1199
#define P_AREA_UNIT               1200
#define P_MAG_FIELD_UNIT          1201
#define P_FLUX_DENSITY_UNIT       1202
#define P_HZ_PER_V_UNIT           1203
#define P_TORQUE_UNIT             1204
#define P_V_PER_RAD_UNIT          1205
#define SET_W_COLOR               1206
#define SET_N_COLOR               1207
#define SET_ZERO_UIC              1208
#define AUTO_DC_UIC               1209
#define MSG_INIT_TSTEP            1210
#define MSG_INIT_TMAX             1211
#define MSG_OPT_TNOM              1212
#define MSG_OPT_TEMP              1213
#define MSG_OPT_ITERS             1214
#define MSG_OPT_TRANIT            1215
#define MSG_OPT_EQNS              1216
#define MSG_OPT_TRANPTS           1217
#define MSG_OPT_TRANACCPT         1218
#define MSG_OPT_TRANRJCT          1219
#define MSG_OPT_TOTANALTIME       1220
#define MSG_OPT_TRANTIME          1221
#define MSG_OPT_REORDTIME         1222
#define MSG_OPT_DECOMP            1223
#define MSG_OPT_SOLVE             1224
#define MSG_OPT_TRANDECOMP        1225
#define MSG_OPT_TRANSOLVE         1226
#define MSG_OPT_TRANCURITER       1227
#define MSG_OPT_LOADTIME          1228
#define MSG_PARAM                 1229
#define MSG_VALUE                 1230
#define MSG_STAT_DIGITAL          1231
#define MSG_STAT_MIXED            1232
#define MSG_STAT_ANALOG           1233
#define MSG_ERROR_LOG             1234
#define MSG_ERRORS                1235
#define MSG_INITIAL_TIME_PTS      1236
#define MSG_INITIAL_COND          1237
#define MSG_LOAD_FROM_TRAN        1238
#define MSG_LOAD_FROM_AC          1239
#define MSG_NODES                 1240
#define MSG_TSTPT_COMP_REQD       1241
#define MSG_DISPLAY_PHASE         1242
#define MSG_OUTPUT_LN_GR          1243
#define MSG_AN_RESULTS            1244
#define P_INTERTIA2_UNIT          1245
#define P_TEMP_DESCR              1246
#define P_TEMP_NAME               1247
#define P_TEMP_UNIT               1248
#define TEMP_DIALOG               1249
#define MSG_READY                 1250
#define MSG_POLE_ZERO             1251
#define MSG_NOISE                 1252
#define MSG_SENSITIVITY           1253
#define MSG_DC_BIAS               1254
#define MSG_TRANSFER_FCN          1255
#define MSG_FOURIER               1256
#define MSG_SWEEPING              1257
#define PARAMETER_TAB             1258
#define TEMPERATURE_TAB           1259
#define MONTE_CARLO_TAB           1260
#define WORST_CASE_TAB            1261
#define P_kp_NAME                 1262
#define P_cgdo_DESCR              1263
#define P_cgdo_NAME               1264
#define P_cgso_DESCR              1265
#define P_cgso_NAME               1266
#define P_ucrit_DESCR             1267
#define P_ucrit_NAME              1268
#define P_uexp_DESCR              1269
#define P_uexp_NAME               1270
#define P_utra_DESCR              1271
#define P_utra_NAME               1272
#define P_neff_DESCR              1273
#define P_neff_NAME               1274
#define P_delta_DESCR             1275
#define P_delta_NAME              1276
#define P_theta_DESCR             1277
#define P_theta_NAME              1278
#define P_eta_DESCR               1279
#define P_eta_NAME                1280
#define P_kappa_DESCR             1281
#define P_kappa_NAME              1282
#define P_vfb_DESCR               1283
#define P_vfb_NAME                1284
#define P_k1_DESCR                1285
#define P_k1_NAME                 1286
#define P_k2_DESCR                1287
#define P_k2_NAME                 1288
#define P_muz_DESCR               1289
#define P_muz_NAME                1290
#define TEMP_STARTVAL             1291
#define TEMP_ENDVAL               1292
#define MSG_MIN_TIME_PTS          1293
#define MSG_SET_PLOT_INCR         1294
#define MSG_PLOT_INCR_TSTEP       1295
#define MACRO_TITLE               1296
#define MENU_WIRE_PROP            1297
#define TITLE_PROP                1298
#define USE_NODE_COND             1299
#define FULL_MENU_HELP            1300
#define FULL_MENU_CUT             1301
#define FULL_MENU_COPY            1302
#define FULL_MENU_MODEL           1303
#define FULL_MENU_MACRO           1304
#define FULL_MENU_DESCRIPT        1305
#define FULL_MENU_ZOOM            1306
#define FULL_MENU_ROTATE          1307
#define FULL_MENU_LABEL           1308
#define FULL_MENU_PREF            1309
#define FULL_MENU_PRINT           1310
#define FULL_MENU_QUIT            1311
#define FULL_MENU_VALUE           1312
#define FULL_MENU_WIRE_COLOUR     1313
#define FULL_MENU_IMPORT          1314
#define FULL_MENU_UNDO            1315
#define FULL_MENU_FAULTS          1316
#define FULL_MENU_HELP_INDEX      1317
#define FULL_MENU_RESUME          1318
#define FULL_MENU_SAVE_AS         1319
#define FULL_MENU_CLOSE           1320
#define FULL_MENU_REVERT          1321
#define FULL_MENU_GLOSSARY        1322
#define FULL_MENU_PRTSC           1323
#define FULL_MENU_PRT_SETUP       1324
#define FULL_MENU_EDIT_TEXT       1325
#define FULL_MENU_CIRCUIT         1326
#define FULL_MENU_WINDOW          1327
#define FULL_MENU_PRT_SETUP_WIN   1328
#define FULL_MENU_SAVE_PCX        1329
#define FULL_MENU_HELP_HIDE       1330
#define FULL_MENU_PARTS           1331
#define FULL_MENU_CIRCUIT_TITLE   1332
#define FULL_MENU_ARRANGE         1333
#define FULL_MENU_PASTE           1334
#define FULL_MENU_ABOUT           1335
#define FULL_MENU_SIMULATE        1336
#define FULL_MENU_NEW             1337
#define FULL_MENU_SELECT_ALL      1338
#define FULL_MENU_SHOW_CLIP       1339
#define FULL_MENU_DELETE          1340
#define FULL_MENU_HIDE_CLIPBOARD  1341
#define FULL_MENU_SYSTEM          1342
#define FULL_MENU_RESTRICT        1343
#define FULL_MENU_COPYBITS        1344
#define FULL_MENU_INSTALL         1345
#define FULL_MENU_EXPORT_SPICE    1346
#define FULL_MENU_IMPORT_SPICE    1347
#define FULL_MENU_EXPORT_PCB      1348
#define FULL_MENU_ANALYSIS_TITLE  1349
#define FULL_MENU_TIME_DOMAIN     1350
#define FULL_MENU_FOURIER         1351
#define FULL_MENU_AC_FREQ         1352
#define FULL_MENU_NOISE           1353
#define FULL_MENU_DISTORT         1354
#define FULL_MENU_PARAMETRIC      1355
#define FULL_MENU_POLE            1356
#define FULL_MENU_TRANSF          1357
#define FULL_MENU_SENS            1358
#define FULL_MENU_MONTE           1359
#define FULL_MENU_WORST_CASE      1360
#define FULL_MENU_ZOOM_IN         1361
#define FULL_MENU_ZOOM_OUT        1362
#define FULL_MENU_PROPERTIES      1363
#define FULL_MENU_EXPORT          1364
#define FULL_MENU_VERT_FLIP       1365
#define FULL_MENU_HORIZ_FLIP      1366
#define FULL_MENU_ADD_TEXT        1367
#define FULL_MENU_JUMP_TO         1368
#define FULL_MENU_UNDO_REDO       1369
#define FULL_MENU_DISP_GRAPH      1370
#define FULL_MENU_DC_OP           1371
#define FULL_MENU_TEMPERATURE     1372
#define FULL_MENU_WIRE_PROP       1373
#define FULL_LOAD_CIRCUIT         1374
#define FULL_SAVE_CIRCUIT         1375
#define FULL_MSG_PAUSE            1376
#define FULL_MSG_STOP             1377
#define FULL_ANALYSIS_PREF        1378
#define MAX_APPMSG_NUMBER2        1379
#define WIRING_PROBLEM            1380
#define ELEMENT_DOESNT_EXIST      1381
#define WITH_REFERENCE_ID         1382
#define TERMINAL_DOESNT_EXIST     1383
#define UNRECOGNIZED_COMPONENT    1384
#define UNRECOGNIZED_FILE_ITEM    1385
#define FILE_LOAD_ERROR_MSG       1386
#define MSG_AUTO_TSTEP            1387
#define FILE_LOAD_WARN_MSG        1388
#define ERR_CHK_LT_0              1389
#define P_Relay_Rc_DESCR          1390
#define P_Relay_Rc_NAME           1391
#define MSG_DISPLAY_NODE_LBL      1392
#define MSG_NODE_ID               1393
#define MSG_PROCEED               1394
#define MSG_SUGGEST               1395
#define MSG_CHECK_ERROR_LOG       1396
#define P_SW_Default_DESCR        1397
#define P_SW_Default_NAME         1398
#define ASRC_INVALID_ERROR        1399
#define DIGITAL_NOT_SUPPORT_ANA   1400
#define BUT_BROWSE                1401
#define MSG_DISPLAY_ERROR_LOG     1402
#define MSG_FOR_FURTHER_ERR_INFO  1403
#define P_TC1_DESCR               1404
#define P_TC1_NAME                1405
#define P_TC2_DESCR               1406
#define P_TC2_NAME                1407
#define P_TC1_UNIT                1408
#define P_TC2_UNIT                1409
#define MENU_RELEASE_NOTES        1410
#define KEY_RELEASE_NOTES         1411
#define MSG_VOLTAGE_V             1412
#define MSG_VOLTAGE_DB            1413
#define MSG_FREQUENCY_HZ          1414
#define MSG_PHASE_DEG             1415
#define MSG_SECOND_HARMONIC       1416
#define MSG_THIRD_HARMONIC        1417
#define MSG_INTERMOD_DISTO        1418
#define MSG_F1_PLUS_F2            1419
#define MSG_F1_MINUS_F2           1420
#define MSG_TWO_F1_MINUS_F2       1421
#define MSG_TOTL_HRMNC_DISTO_PCT  1422
#define MSG_MAGNITUDE_V           1423
#define MSG_MAGNITUDE_DB          1424
#define MSG_SENSTVTY_VLT          1425
#define MSG_SENSTVTY_AMP          1426
#define MSG_SENSTVTY_TO           1427
#define MSG_OUT_NOISE_PWR         1428
#define MSG_IN_NOISE_PWR          1429
#define MSG_OUTPUT_NOISE          1430
#define MSG_INPUT_NOISE           1431
#define MSG_NOISE_DUE_TO          1432
#define MSG_NODE_OR_BRANCH        1433
#define MSG_VOLTAGE_OR_CURRENT    1434
#define MSG_QUANTITY              1435
#define MSG_VALUES                1436
#define MSG_REAL                  1437
#define MSG_IMAGINARY             1438
#define SWEEP_STATUS              1439
#define MSG_TIME_S                1440
#define MSG_TEMPERATURE_DEG_C     1441
#define MSG_RUN_NUMBER            1442
#define RUN_NUMBER                1443
#define MSG_NOMINAL_RUN           1444
#define MSG_WORST_CASE_RUN        1445
#define MSG_WORST_CASE_VALUE      1446
#define MSG_POLE_OR_ZERO          1447
#define SWITCH_ON_TOOLTIP         1448
#define SWITCH_OFF_TOOLTIP        1449
#define SWITCH_PAUSE_TOOLTIP      1450
#define SWITCH_RESUME_TOOLTIP     1451
#define CANNOT_PERFORM_ANA        1452
#define HOBBY_NO_ANALYSIS         1453
#define MOVED_EWB_ERROR           1454
#define INCOMPAT_ANA_WITH_COMP    1455
#define INCOMPAT_ANA_WITH_ELEM    1456
#define MENU_HOBBY_ABOUT          1457
#define FULL_MENU_HOBBY_QUIT      1458
#define FULL_MENU_HOBBY_ABOUT     1459
#define FULL_MENU_HOBBY_INSTALL   1460
#define XSPICE_SINGULAR_MATRIX    1461
#define XSPICE_ANA_SETUP_ERR      1462
#define XSPICE_CANNOT_UNSETUP_PREV_ANA 1463
#define XSPICE_CANNOT_SETUP_ANA   1464
#define XSPICE_CANNOT_SETUP_EVENT_SIM 1465
#define XSPICE_ANA_INIT_FAILED    1466
#define XSPICE_CANNOT_SET_INIT_COND 1467
#define XSPICE_PREV_INIT_FAIL_NOW_RESIM 1468
#define XSPICE_NO_MEMORY          1469
#define XSPICE_INVALID_CIRCUIT    1470
#define XSPICE_DOES_NOT_CONVERGE  1471
#define XSPICE_EXCEED_MAX_TPOINTS 1472
#define XSPICE_PZ_ANA_BREAK       1473
#define XSPICE_SHORTED_OUTPUT     1474
#define XSPICE_PZ_CONV_NUM_PROB   1475
#define XSPICE_PZ_ITER_LIMIT      1476
#define XSPICE_STEP_TYPE_UNKNOWN  1477
#define XSPICE_OPEN_CIRCUIT       1478
#define XSPICE_BREAK_IN_PAST      1479
#define XSPICE_NOISE_INPUT_SRC_NIC 1480
#define XSPICE_STARTING_GMIN_STEPPING 1481
#define XSPICE_GMIN_STEP_FAILED   1482
#define XSPICE_ONE_OKAY_GMIN_STEP 1483
#define XSPICE_GMIN_STEPPING_COMPLETED 1484
#define XSPICE_GMIN_STEPPING_FAILED 1485
#define XSPICE_STARTING_SOURCE_STEPPING 1486
#define XSPICE_SOURCE_STEPPING_FAILED 1487
#define XSPICE_ONE_OKAY_SOURCE_STEP 1488
#define XSPICE_SOURCE_STEPPING_COMPLETE 1489
#define XSPICE_TF_SOURCE_NIC      1490
#define XSPICE_DCTRCURV_NIC       1491
#define XSPICE_TRANSLIN_NOT_SUPPORTED 1492
#define XSPICE_INPUT_IS_SHORTED   1493
#define XSPICE_OUTPUT_IS_SHORTED  1494
#define XSPICE_IS_UNITY           1495
#define XSPICE_TF_IS_NEG_ONE      1496
#define XSPICE_LOST_NUMERIC_STABILITY 1497
#define XSPICE_ERR_CAUSE0         1498
#define XSPICE_ERR_CAUSE1         1499
#define XSPICE_INIT_TPOINT_IS     1500
#define XSPICE_TPOINT_IS          1501
#define XSPICE_FREQ_IS            1502
#define XSPICE_NAME_IS            1503
#define XSPICE_TROUBLE_WITH_NODE  1504
#define XSPICE_TROUBLE_WITH_INSTANCE 1505
#define XSPICE_CAUSE_UNRECORDED   1506
#define XSPICE_TIMESTEP_TOO_SMALL 1507
#define XSPICE_UNKNOWN_CONTROL_SRC 1508
#define XSPICE_BJT_LIMIT_FC       1509
#define XSPICE_B1_EFFECT_LENGTH_LE_0 1510
#define XSPICE_B1_EFFECT_WIDTH_LE_0 1511
#define XSPICE_B2_EFFECT_LENGTH_LE_0 1512
#define XSPICE_B2_EFFECT_WIDTH_LE_0 1513
#define XSPICE_NO_DC_TRANS_TIME_0_USED 1514
#define XSPICE_NO_VALUE_DC_0_ASSUMED 1515
#define XSPICE_NSUB_LE_NI         1516
#define XSPICE_EFFECT_CHAN_LSS_0  1517
#define XSPICE_LTRA_SER_RES_0     1518
#define XSPICE_LTRA_USE_LIN_INTERPOL 1519
#define XSPICE_LTRA_PAR_COND_NOT_GIVEN 1520
#define XSPICE_LTRA_SER_COND_NOT_GIVEN 1521
#define XSPICE_LTRA_PAR_CAP_NOT_GIVEN 1522
#define XSPICE_LTRA_LENGTH_NOT_GIVEN 1523
#define XSPICE_LTRA_RL_LINE_NOT_SUPPORT 1524
#define XSPICE_LTRA_NONZERO_G_NOT_SUPPORT 1525
#define XSPICE_LTRA_ONE_OF_R_L_G_C_NONZERO 1526
#define XSPICE_DEP_CAP_COEF_TOO_LARGE 1527
#define XSPICE_GRADING_COEF_TOO_LARGE 1528
#define XSPICE_ACT_ENERGY_TOO_LARGE 1529
#define XSPICE_COEF_FC_TOO_LARGE  1530
#define XSPICE_BREAKDOWN_CURRENT_INC 1531
#define XSPICE_CANNOT_MATCH_FOR_AND_REV 1532
#define XSPICE_RES_IS_0_SO_INCREASED 1533
#define XSPICE_TLINE_Z0_NOT_GIVEN 1534
#define MSG_MENU_CMD              1535
#define MSG_TEMP_FORMAT           1536
#define MSG_SUBCIR_NAME           1537
#define MSG_CHOOSE_IC             1538
#define MSG_CHOOSE_SUB            1539
#define MSG_IC_TEMP               1540
#define MSG_SUB_TEMP              1541
#define MSG_UNKNOWN_ELE           1542
#define MSG_UNKNOWN_BUT           1543
#define MSG_SCALE_FACTOR          1544
#define MSG_DEL_ITEM              1545
#define MSG_DEL_WIRE              1546
#define MSG_REM_FAV               1547
#define MSG_ADD_FAV               1548
#define MSG_NODE_PROP             1549
#define MSG_ADD_S                 1550
#define ERR_CHK_GT0_LT1           1551
#define MSG_OPTGLOB_ABSTOL        1552
#define MSG_OPTGLOB_GMIN          1553
#define MSG_OPTGLOB_PIVREL        1554
#define MSG_OPTGLOB_PIVTOL        1555
#define MSG_OPTGLOB_RELTOL        1556
#define MSG_OPTGLOB_TEMP          1557
#define MSG_OPTGLOB_VNTOL         1558
#define MSG_OPTGLOB_CHGTOL        1559
#define MSG_OPTGLOB_RAMPTIME      1560
#define MSG_OPTGLOB_CONVSTEP      1561
#define MSG_OPTGLOB_CONVABSSTEP   1562
#define MSG_OPTGLOB_CONVLIMIT     1563
#define MSG_OPTGLOB_RSHUNT        1564
#define MSG_OPTDC_ITL1            1565
#define MSG_OPTDC_ITL2            1566
#define MSG_OPTDC_GMINSTEPS       1567
#define MSG_OPTDC_SRCSTEPS        1568
#define MSG_OPTMETH_GEAR          1569
#define MSG_OPTMETH_TRAPEZOIDAL   1570
#define MSG_OPTTRANS_ITL4         1571
#define MSG_OPTTRANS_MAXORD       1572
#define MSG_OPTTRANS_TRTOL        1573
#define MSG_OPTTRANS_METHOD       1574
#define MSG_OPTDEV_BYPASS         1575
#define MSG_OPTDEV_DEFAD          1576
#define MSG_OPTDEV_DEFAS          1577
#define MSG_OPTDEV_DEFL           1578
#define MSG_OPTDEV_DEFW           1579
#define MSG_OPTDEV_TNOM           1580
#define MSG_OPTDEV_TRYTOCOMPACT   1581
#define MSG_OPTOUT_ACCT           1582
#define MSG_OPTOUT_KEEPOPINFO     1583
#define MSG_OPTINST_TMAX          1584
#define MSG_OPTFLAG_ON            1585
#define MSG_OPTFLAG_OFF           1586
#define MSG_OPTFLAG_DEFAULT       1587
#define MSG_NOT_SUPPORT_FILE_ENC  1588
#define XSPICE_MATRIX_ERROR       1589
#define XSPICE_DC_OP_FAILED       1590
#define ERR_CURR_SER              1591
#define ERR_CURR_RSHUNT_SER       1592
#define ERR_CAP_SER               1593
#define MSG_DC_SWEEP              1594
#define MENU_DC_SWEEP             1595
#define MSG_CCT_NODES_SOURCES     1596
#define MSG_SOURCE1               1597
#define MSG_SOURCE2               1598
#define MSG_START_VALUE           1599
#define MSG_STOP_VALUE            1600
#define MSG_INCREMENT             1601
#define MSG_USE_SOURCE2           1602
#define MSG_SRC2_DIFF_SRC1        1603
#define FULL_MENU_DC_SWEEP        1604
#define MSG_LOW_RESOURCES         1605
#define MSG_WARN_OF_RESTRICTIONS  1606
#define CLK_RATE                  1607
#define ENG_NOTATION              1608
#define PARSE_ERRORS_TITLE        1609
#define PARSE_ERRORS_INTRO        1610
#define DEMO_NO_SIM               1611
#define DEMO_EXPIRED              1612
#define DEMO_DAYS_LEFT            1613
#define DEMO_REINSTALL            1614
#define MSG_VER_NET               1615
#define MSG_VER_LAB               1616
#define MSG_VER_EDU               1617
#define MSG_VER_EDU_LAB           1618
#define MSG_VER_EDU_NET           1619
#define MSG_VER_STUDENT           1620
#define REPLACE_SCHEME            1621
#define PASS_MATCH                1622
#define OLD_INVALID               1623
#define OLD_PASS                  1624
#define NEW_PASS                  1625
#define CONFIRM_NEW               1626
#define CHANGE_SAVE_PATH          1627
#define ENTER_NEW_PATH            1628
#define CURRENT_PATH              1629
#define SAVE_TO_GLOBAL            1630
#define CHANGE_GLOB_PASS          1631
#define SAVE_SCHEME               1632
#define SCHEME_NAME               1633
#define DELETE_SCHEME             1634
#define CHANGE_CIRC_PASS          1635
#define ENTER_PASS                1636
#define GLOB_PASS                 1637
#define CIRC_PASS                 1638
#define PASS_INVALID              1639
#define CIRC_PASS_INVALID         1640
#define GENERAL                   1641
#define SAVE_AS_GLOB              1642
#define CHANGE_PASS               1643
#define PASSWORD                  1644
#define CURR_REST_SET             1645
#define CHANGE_PATH               1646
#define RELAX_ALL                 1647
#define IGNORE_GLOBAL             1648
#define DISABLE_PRINT             1649
#define READ_ONLY                 1650
#define CIRCUIT_PATH              1651
#define CIRCUIT_ACCESS            1652
#define HIDE_SUB                  1653
#define HIDE_FAULTS               1654
#define HIDE_VALUES               1655
#define NO_MODEL_EDIT             1656
#define NO_COMP_DISP              1657
#define NO_COMP_ANAL              1658
#define NO_PARTS                  1659
#define NO_INST                   1660
#define NO_FAV                    1661
#define AVAIL_ANAL                1662
#define MSG_COMPONENTS            1663
#define MSG_GLOBAL_REST           1664
#define MSG_COMPLETE_REST         1665
#define MSG_BASIC_REST            1666
#define MSG_PROG_OPTIONS          1667
#define MSG_ADD_SCHEME            1668
#define USE_PROG_OPTION           1669
#define MSG_ANALYSES              1670
#define MENU_CIRC_RESTRICT        1671
#define MSG_LOADING_ERROR_LOG     1672
#define MSG_PARSE_EXPECT_NAME     1673
#define MSG_PARSE_EXPECT_LRAREN   1674
#define MSG_PARSE_EXPECT_FILEGETTXT 1675
#define MSG_PARSE_EXPECT_ARG      1676
#define MSG_PARSE_EXPECT_COMMALPAREN 1677
#define MSG_PARSE_EXPECT_RPAREN   1678
#define MSG_PARSE_TOO_MANY_ARGS   1679
#define MSG_PARSE_MISSING_RPAREN  1680
#define MSG_PARSE_WRONG_NUM_ARGS  1681
#define MSG_PARSE_WRONG_ARG_TYPE  1682
#define MSG_PARSE_CANNOT_OPEN     1683
#define MSG_PARSE_UNKNOWN_ROUTINE 1684
#define MSG_PARSE_NO_LINES_IN_INPUT 1685
#define MSG_PARSE_REDUNDANT_CONTROL 1686
#define MSG_PARSE_MISPLACED_ENDC  1687
#define MSG_PARSE_INCLUDE_MISSING 1688
#define MSG_PARSE_CANNOT_ALLOC    1689
#define MSG_PARSE_HIT_RETURN      1690
#define MSG_PARSE_POSSIBLE_RESP   1691
#define MSG_PARSE_CHAR_X_NO_GOOD  1692
#define MSG_PARSE_NEWLINE         1693
#define MSG_PARSE_CP_EVENT        1694
#define MSG_PARSE_WORD_TOO_LONG   1695
#define MSG_PARSE_LINE_TOO_LONG   1696
#define MSG_PARSE_NUMPARSE_ERROR  1697
#define MSG_PARSE_BAD_SET_FORM    1698
#define MSG_PARSE_EQUALS_WHAT     1699
#define MSG_PARSE_OPTIONS_UNSUP   1700
#define MSG_PARSE_OPTION_UNSUP    1701
#define MSG_PARSE_OPTION_OLD      1702
#define MSG_PARSE_IF_OPTION_ERROR 1703
#define MSG_PARSE_CANNOT_SET_SIMOPT 1704
#define MSG_PARSE_BAD_TYPE_GIVEN  1705
#define MSG_PARSE_TYPE_GIVEN      1706
#define MSG_PARSE_TYPE_EXPECTED   1707
#define MSG_PARSE_UNKNOWN_DEVTYPE 1708
#define MSG_PARSE_NO_SUCH_SUBCKT  1709
#define MSG_PARSE_TOO_FEW_BJTNODES 1710
#define MSG_PARSE_TOO_FEW_SUBCKT  1711
#define MSG_PARSE_TOO_MANY_SUBCKT 1712
#define MSG_PARSE_TOO_FEW_NODES   1713
#define MSG_PARSE_TOO_FEW_DEVS    1714
#define MSG_PARSE_MISPLACED_LINE  1715
#define MSG_PARSE_NO_LINE         1716
#define MSG_PARSE_INF_SUBCKT_RECURS 1717
#define MSG_PARSE_UNKNOWN_CUBCKT  1718
#define MSG_PARSE_CP_GETVAR_ERR   1719
#define MSG_PARSE_REALLOC_INTERR  1720
#define MSG_PARSE_GROUND_NOT_EXIST 1721
#define MSG_PARSE_NOT_SUPP_ASRC   1722
#define MSG_PARSE_CAP_NOT_SUPP    1723
#define MSG_PARSE_WRONG_MODEL     1724
#define MSG_PARSE_NO_LABELED_PARAM 1725
#define MSG_PARSE_WRONG_MODEL_TYPE 1726
#define MSG_PARSE_INVALID_BJT     1727
#define MSG_PARSE_INVALID_LINE    1728
#define MSG_PARSE_STACK_OVERFLOW  1729
#define MSG_PARSE_SYNTAX_ERROR    1730
#define MSG_PARSE_ENTERING_LEXER  1731
#define MSG_PARSE_BAD_TOKEN_TYPE  1732
#define MSG_PARSE_BAD_FUNCTION    1733
#define MSG_PARSE_BAD_NODE_TYPE   1734
#define MSG_PARSE_BAD_NODE_VOLT   1735
#define MSG_PARSE_BAD_BRANCH_CUR  1736
#define MSG_PARSE_NO_SUCH_FUNC    1737
#define MSG_PARSE_NO_SUCH_OP_NUM  1738
#define MSG_PARSE_BAD_TYPE        1739
#define MSG_PARSE_MISSING_MODEL_A 1740
#define MSG_PARSE_INVALID_MODEL_A 1741
#define MSG_PARSE_MISSING_CONN_A  1742
#define MSG_PARSE_UNEXPECT_NULLCONN 1743
#define MSG_PARSE_EXPECT_SCALCONN 1744
#define MSG_PARSE_UNEXPECT_RBRACK 1745
#define MSG_PARSE_MISSING_LBRACK  1746
#define MSG_PARSE_UNEXPECT_LBRACK 1747
#define MSG_PARSE_MISSING_RBRACK  1748
#define MSG_PARSE_EXPECT_PORT     1749
#define MSG_PARSE_TOO_MANY_CONN   1750
#define MSG_PARSE_BAD_NULL_CONN   1751
#define MSG_PARSE_TOO_FEW_CONN    1752
#define MSG_PARSE_TOO_MANY_PORT_CONN 1753
#define MSG_PARSE_MODEL_NO_DEFAULT 1754
#define MSG_PARSE_MISS_ASSOC_CONN 1755
#define MSG_PARSE_SIZE_MISMATCH   1756
#define MSG_PARSE_WRONG_DIRECTION 1757
#define MSG_PARSE_INVALID_PORT_SPEC 1758
#define MSG_PARSE_PORT_TYPE_INVALID 1759
#define MSG_PARSE_TILDE_NOT_ON_ANA 1760
#define MSG_PARSE_NOT_ENOUGH_PORTS 1761
#define MSG_PARSE_EXPECT_NODE_INST 1762
#define MSG_PARSE_BAD_CONN_TYPE   1763
#define MSG_PARSE_EXPECT_NODE     1764
#define MSG_PARSE_BAD_LINE_NETLIST 1765
#define MSG_PARSE_UNKNOWN_DEV_TYPE 1766
#define MSG_PARSE_PREMATURE_EOF   1767
#define MSG_PARSE_COULD_NOT_OPEN_INC 1768
#define MSG_PARSE_ILLEGAL_CONTINUATION 1769
#define MSG_PARSE_USE_QUIT_TO_QUIT 1770
#define MSG_PARSE_QUIT            1771
#define MSG_PARSE_SOME_STRANGE    1772
#define MSG_PARSE_SOME_STRANGE2   1773
#define MSG_PARSE_USE_AN_EQUAL    1774
#define MSG_PARSE_ERROR_ON_LINE   1775
#define MSG_PARSE_ARG_TO_POLY_NOT_INT 1776
#define MSG_PARSE_NUM_CONN_DIFF_POLY 1777
#define MSG_PARSE_BJT_NOT_AVAIL   1778
#define MSG_PARSE_DIODE_NOT_AVAIL 1779
#define MSG_PARSE_JFET_NOT_AVAIL  1780
#define MSG_PARSE_MES_NOT_AVAIL   1781
#define MSG_PARSE_URC_NOT_AVAIL   1782
#define MSG_PARSE_MOS1_NOT_AVAIL  1783
#define MSG_PARSE_MOS2_NOT_AVAIL  1784
#define MSG_PARSE_MOS3_NOT_AVAIL  1785
#define MSG_PARSE_BSIM1_NOT_AVAIL 1786
#define MSG_PARSE_BSIM2_NOT_AVAIL 1787
#define MSG_PARSE_MOS6_NOT_AVAIL  1788
#define MSG_PARSE_BSIM3_NOT_AVAIL 1789
#define MSG_PARSE_ONLY_MOS_1_TO_7 1790
#define MSG_PARSE_RESISTOR_NOT_AVAIL 1791
#define MSG_PARSE_CAP_NOT_AVAIL   1792
#define MSG_PARSE_SWITCH_NOT_AVAIL 1793
#define MSG_PARSE_CSWITCH_NOT_AVAIL 1794
#define MSG_PARSE_LTRA_NOT_AVAIL  1795
#define MSG_PARSE_UNKNOWN_MOD_TYPE 1796
#define MSG_PARSE_UNKNOWN_DEV_TYPE2 1797
#define MSG_PARSE_NO_READ_GND_NAME 1798
#define MSG_PARSE_NO_INSERT_GND   1799
#define MSG_PARSE_NO_SUB_DEFS_IN_NET 1800
#define MSG_PARSE_ILLEGAL_LEVEL_ARG 1801
#define MSG_PARSE_VCVS_NOT_SUPP   1802
#define MSG_PARSE_CCCS_NOT_SUPP   1803
#define MSG_PARSE_VCCS_NOT_SUPP   1804
#define MSG_PARSE_CCVS_NOT_SUPP   1805
#define MSG_PARSE_ISOURCE_NOT_SUPP 1806
#define MSG_PARSE_MUTUAL_NOT_SUPP 1807
#define MSG_PARSE_INDUCTOR_NOT_SUPP 1808
#define MSG_PARSE_TRANLINE_NOT_SUPP 1809
#define MSG_PARSE_VSOURCE_NOT_SUPP 1810
#define MSG_PARSE_NEW_MODEL_CREATE_ERR 1811
#define MSG_PARSE_UNREC_PARAM     1812
#define MSG_PARSE_NO_MODEL_DEF    1813
#define MSG_PARSE_ERR_DETECTED_IN 1814
#define MSG_PARSE_UNKNOWN_PAR     1815
#define MSG_PARSE_UNKNOWN_ERR     1816
#define MSG_PARSE_PAUSE_REQ       1817
#define MSG_PARSE_IMP_ERR         1818
#define MSG_PARSE_DEV_EXISTS      1819
#define MSG_PARSE_NO_SUCH_DEV     1820
#define MSG_PARSE_NO_SUCH_TERM_ON_DEV 1821
#define MSG_PARSE_NO_SUCH_MODEL   1822
#define MSG_PARSE_NO_SUCH_PAR_ON_DEV 1823
#define MSG_PARSE_OUT_OF_RAM      1824
#define MSG_PARSE_NODE_CONN       1825
#define MSG_PARSE_OP_NOT_SUPP     1826
#define MSG_PARSE_PAR_VAL_OUT_O_R 1827
#define MSG_PARSE_BAD_MATRIX      1828
#define MSG_PARSE_SING_MATRIX     1829
#define MSG_PARSE_ITT_LIMIT_REACHED 1830
#define MSG_PARSE_UNSUPP_ORDER    1831
#define MSG_PARSE_UNSUPP_INT_METHOD 1832
#define MSG_PARSE_TIMESTEP_SMALL  1833
#define MSG_PARSE_XMISSION        1834
#define MSG_PARSE_MAG_OVER        1835
#define MSG_PARSE_IO_SHORTED      1836
#define MSG_PARSE_TF_IS_1         1837
#define MSG_PARSE_NO_DISTORTION   1838
#define MSG_PARSE_NO_NOISE_ANAL   1839
#define MSG_PARSE_NO_AC_IN        1840
#define MSG_PARSE_NO_SUCH_ANAL    1841
#define MSG_PARSE_UNSUPP_ACT      1842
#define MSG_PARSE_NOT_FOUND       1843
#define MSG_PARSE_NO_F2_SRC       1844
#define MSG_PARSE_INVALID_EWB_SPICE_TYPE 1845
#define MSG_PARSE_MODEL_ERR       1846
#define MSG_PARSE_NO_MOD_DEF2     1847
#define MSG_PARSE_ARRAY_PAR_EXPECT 1848
#define MSG_PARSE_EARLY_CARD_END  1849
#define MSG_PARSE_ARRAY_PAR_NEED_VAL 1850
#define MSG_PARSE_MIFGETVAL_ERR   1851
#define MSG_PARSE_BAD_BOOL        1852
#define MSG_PARSE_BAD_INT         1853
#define MSG_PARSE_BAD_REAL        1854
#define MSG_PARSE_BAD_COMPLEX     1855
#define MSG_MAX_NODE_INIT_VOLTAGE 1856
#define MSG_PARSE_BAD_VSWITCH_CARD 1857
#define MSG_SWEEP_TYPE_MADE_LINEAR 1858
#define MSG_TEMP_OUT_OF_RANGE     1859
#define MSG_CHECK_STATEMENT_GEN_ERR 1860
#define MSG_CHECK_STATEMENT_OR    1861
#define MSG_CHECK_STATEMENT_AND   1862
#define MSG_CHECK_STATEMENT_ELEMENT 1863
#define MSG_STOP_CURRENT_ANALYSIS 1864
#define MSG_STOP_INSTRMT_SIMULATN 1865
#define MSG_SWEEP_DECADE          1866
#define MSG_SWEEP_LINEAR          1867
#define MSG_SWEEP_OCTAVE          1868
#define MSG_SCALE_LINEAR          1869
#define MSG_SCALE_LOG             1870
#define MSG_SCALE_DECIBEL         1871
#define MSG_DISTR_UNIFORM         1872
#define MSG_DISTR_GAUSSIAN        1873
#define MSG_ITL4_IS_NEG           1874
#define MSG_MAXORD_OUT_OF_RANGE   1875
#define MSG_OFF_WITH_FIXED_WIDTH  1876
#define MSG_ON_WITH_FIXED_WIDTH   1877
#define MSG_OFF_WITH_FIXED_WIDTH2 1878
#define MSG_AUTO_HIDE_PARTS_BIN   1879
#define MSG_KEEP_PARTS_BIN_POSITIONS 1880
#define MSG_DISPLAY               1881
#define MSG_PARTS_BINS            1882
#define MSG_FONT_NAME             1883
#define MSG_FONT_SIZE             1884
#define MSG_NO_SUCH_SCHEME        1885
#define MSG_WORKBENCH             1886
#define MSG_NO_NODES              1887
#define MSG_DISTORTION_OPTIONS    1888
#define MSG_AN_TYPE_AC            1889
#define MSG_AN_TYPE_DC            1890
#define MSG_AN_TYPE_TRANSIENT     1891
#define MSG_MAX_VOLTAGE           1892
#define MSG_MIN_VOLTAGE           1893
#define MSG_FREQ_AT_MAX           1894
#define MSG_FREQ_AT_MIN           1895
#define MSG_RISE_EDGE_FREQ        1896
#define MSG_FALL_EDGE_FREQ        1897
#define ERR_CHK_THIS_LT_THAT      1898
#define MSG_XSPICE_OUTPUT_IMPED   1899
#define MSG_XSPICE_TRANSFER_FUNCTION 1900
#define MSG_XSPICE_INP_IMPED      1901
#define MSG_XSPICE_OUT_IMPED      1902
#define MSG_REROUTE_WIRE          1903
#define MSG_INVALID_MODEL_LIBRARY 1904
#define XSPICE_EXCEPTION_ACCESS_VIOLATION 1905
#define XSPICE_EXCEPTION_DATATYPE_MISALIGNMENT 1906
#define XSPICE_EXCEPTION_BREAKPOINT 1907
#define XSPICE_EXCEPTION_SINGLE_STEP 1908
#define XSPICE_EXCEPTION_ARRAY_BOUNDS_EXCEEDED 1909
#define XSPICE_EXCEPTION_FLT_DENORMAL_OPERAND 1910
#define XSPICE_EXCEPTION_FLT_DIVIDE_BY_ZERO 1911
#define XSPICE_EXCEPTION_FLT_INEXACT_RESULT 1912
#define XSPICE_EXCEPTION_FLT_INVALID_OPERATION 1913
#define XSPICE_EXCEPTION_FLT_OVERFLOW 1914
#define XSPICE_EXCEPTION_FLT_STACK_CHECK 1915
#define XSPICE_EXCEPTION_FLT_UNDERFLOW 1916
#define XSPICE_EXCEPTION_INT_DIVIDE_BY_ZERO 1917
#define XSPICE_EXCEPTION_INT_OVERFLOW 1918
#define XSPICE_EXCEPTION_PRIV_INSTRUCTION 1919
#define XSPICE_EXCEPTION_IN_PAGE_ERROR 1920
#define XSPICE_STATUS_NO_MEMORY   1921
#define XSPICE_EXCEPTION_CAUGHT   1922
#define MSG_LOGIC_GRAPHER_TRACE_NUM 1923
#define MSG_LOGIC_GRAPHER_TRACE   1924
#define MSG_LOGIC_GRAPHER_SAMPLES 1925
#define MSG_LOGIC_GRAPHER_WAVEFORMS 1926
#define MSG_DELETE_ALL_SUB        1927
#define MSG_RENAME_SUB            1928
#define MSG_DEL_NO_AM             1929
#define MSG_ADVANCED              1930
#define MSG_FOURIER_SAMPLING_FREQ 1931
#define MSG_FOURIER_SAMPLING_WINDOW 1932
#define MSG_FOURIER_RAISED_COS_WINDOW 1933
#define MSG_FOURIER_RECTANGULAR_WINDOW 1934
#define ABORT_IMPORT              1935
#define MSG_OPEN_NODE_S           1936
#define MSG_SET_FONT              1937
#define MSG_COMMENT_BOX           1938
#define MSG_ADVANCED_ENABLED      1939
#define MSG_FOURIER_INTERP_PTS    1940
#define MSG_TITLE_BLOCK           1941
#define MSG_TITLE                 1942
#define MSG_DOCNUM                1943
#define MSG_REVISION              1944
#define MSG_REV                   1945
#define MSG_DATE                  1946
#define MSG_DATE_COLON            1947
#define MSG_SIZE                  1948
#define MSG_SCHEM_WIRING_CON      1949
#define MSG_PREF_AUTO_ROUTE       1950
#define MSG_PREF_MANUAL_ROUTE     1951
#define MSG_ABSOLUTE              1952
#define MSG_RELATIVE              1953
#define MSG_OUTPUT_SCALING        1954
#define MSG_SENSTVTY_NOUNIT       1955
#define MSG_PREF_WIRE_BEAUTIFY_PART 1956
#define MSG_SUBCKT                1957
#define MSG_CONTACT               1958
#define MSG_SCHEM_ROUTING_OPTIONS 1959
#define MSG_PREF_REWIRE_OPTIONS   1960
#define MSG_SCOPE_TABNAME         1961
#define MSG_SCOPE_VOLTAGE         1962
#define MSG_SCOPE_VOLTAGE_A       1963
#define MSG_SCOPE_VOLTAGE_B       1964
#define MSG_SCOPE_BOTTOM_AXIS     1965
#define MSG_SCOPE_A_TRACE         1966
#define MSG_SCOPE_B_TRACE         1967
#define MSG_SCOPE_A_VERSUS_B_TRACE 1968
#define MSG_SCOPE_B_VERSUS_A_TRACE 1969
#define MSG_PREF_WIRE_BEAUTIFY_WIRE 1970
#define P_CAP_TOL_DESCR           1971
#define P_RES_TOL_DESCR           1972
#define P_IND_TOL_DESCR           1973
#define P_VOL_TOL_DESCR           1974
#define P_CUR_TOL_DESCR           1975
#define MSG_GLOBAL_TOLERANCE      1976
#define MSG_AUTO_DELETE_CON       1977
#define MSG_WIRE_STILL            1978
#define MSG_WIRE_BEAUTIFY         1979
#define MSG_OPEN_NODE             1980
#define MSG_OPEN_NODE_AT          1981
#define MSG_CDROM_IN_DRIVE        1982
#define MSG_MC_TR_COLL_T_AT_VMAX  1983
#define MSG_MC_TR_COLL_T_AT_VMIN  1984
#define MSG_MC_TR_COLL_RISE_TIME  1985
#define MSG_MC_TR_COLL_FALL_TIME  1986
#define ERR_CHK_THIS_GT_1         1987
#define MSG_ZOOM_LEVEL            1988
#define MSG_FIT_TO_PAGE           1989
#define MSG_MC_MEAN               1990
#define MSG_MC_STD_DEV            1991
#define MSG_MC_WITHIN_N_STD       1992
#define MSG_USE_GLOBAL_TOL        1993
#define MSG_PREF_AUTO_ROUTE_UNMODED 1994
#define MSG_SUBCIRCUIT_ICON_NAME  1995
#define MSG_DRAWN_BY              1996
#define MSG_PRINT_OPT             1997
#define MSG_WS_PAGE_BRK           1998
#define MSG_MACRO_PAGE_BRK        1999
#define MSG_TYPE_MISMATCH         2000
#define MSG_ALREADY_SUBCKT_SAME_NAME 2001
#define MSG_INVALID_NAME          2002
#define MSG_INVALID_NODE          2003
#define MSG_PBREAK_CHANGED        2004
#define ERR_CHK_LE_100000         2005
#define MAX_APPMSG_NUMBER         2006
#define STOP_TRANSLATING          2007
#endif

//insert file>> #include "instance.h"
#undef  TF_OUTPOS
#undef  TF_OUTNEG
#undef  TF_OUTSRC
#undef  SENS_DC
#undef  SHIFT_LEFT
#undef  SHIFT_RIGHT

#ifdef EWB_IIT
  #define BUILD_VERSION  "(DLL version)"
  // #define USE_MEMORY_POOLS
  #define DOCHECKHEAP
  #define USE_HEAPAGENT
#else
  #define BUILD_VERSION  "(DOS32 version)"
#endif

#ifdef DEBUG_XSPICE
extern FILE* debug_file;
#endif

#define DEBUG_FILE_NAME       "debug.xsp"
#define DEBUG_FILE_OPEN()     (debug_file=fopen(DEBUG_FILE_NAME,"a"))
#define DEBUG_FILE_FLUSH()    fflush(debug_file)
#define DEBUG_FILE_CLOSE()    fclose(debug_file)

#define DEBUG_VOID(x)         ((void)(x))

#ifdef DEBUG_XSPICE
  #define DEBUG_INIT()                    DEBUG_VOID( debug_file=fopen(DEBUG_FILE_NAME,"w"), fprintf(debug_file,"THIS IS THE DEBUGING OUTPUT FOR XSPICE "  BUILD_VERSION "\n"), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT(str)                DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\n",str), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT1(str,x)             DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g\n",str,(double)x), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT2(str,x,y)           DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g\n",str,(double)x,(double)y), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT3(str,x,y,z)         DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g,\t %g\n",str,(double)x,(double)y,(double)z), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT4(str,x,y,z,a)       DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g,\t %g,\t %g\n",str,(double)x,(double)y,(double)z,(double)a), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT5(str,x,y,z,a,b)     DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= %g,\t %g,\t %g,\t %g,\t %g\n",str,(double)x,(double)y,(double)z,(double)a,(double)b), DEBUG_FILE_CLOSE() )

  #define DEBUG_PRINTs(str,s)             DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s ::= %s",str,s), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT1s(str,s,x)          DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g\n",str,s,(double)x), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT2s(str,s,x,y)        DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g\n",str,s,(double)x,(double)y), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT3s(str,s,x,y,z)      DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g,\t %g\n",str,s,(double)x,(double)y,(double)z), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT4s(str,s,x,y,z,a)    DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g,\t %g,\t %g\n",str,s,(double)x,(double)y,(double)z,(double)a), DEBUG_FILE_CLOSE() )
  #define DEBUG_PRINT5s(str,s,x,y,z,a,b)  DEBUG_VOID( DEBUG_FILE_OPEN(), fprintf(debug_file,"%s\t ::= '%s'\t %g,\t %g,\t %g,\t %g,\t %g\n",str,s,(double)x,(double)y,(double)z,(double)a,(double)b), DEBUG_FILE_CLOSE() )

  struct CKTcircuit_tag;

  #define DEBUG_MATRIX(ckt)                                   \
     DEBUG_VOID(                                              \
       DEBUG_FILE_OPEN(),                                     \
       fprintf(debug_file,"\n\n\n (%s,%d):THE FOLLOWING IS VALUE OF 'CKTmatrix'\n",__FILE__,__LINE__),   \
       SMPprintWithRHS(((struct CKTcircuit_tag*)ckt)->CKTmatrix, ((struct CKTcircuit_tag*)ckt)->CKTrhs, ((struct CKTcircuit_tag*)ckt)->CKTirhs, debug_file), \
       fprintf(debug_file,"\n\n"),                            \
       DEBUG_FILE_CLOSE()                                     \
     )

  #define DEBUG_MATRIX_ARG1(ckt,fmt,arg)                      \
     DEBUG_VOID(                                              \
       DEBUG_FILE_OPEN(),                                     \
       fprintf(debug_file,"\n\n\n(%s,%d):THE FOLLOWING IS VALUE OF '" #ckt "->CKTmatrix' :: ",__FILE__,__LINE__),   \
       fprintf(debug_file,(fmt),(arg)),   \
       fprintf(debug_file,"\n"),          \
       SMPprintWithRHS(((struct CKTcircuit_tag*)ckt)->CKTmatrix, ((struct CKTcircuit_tag*)ckt)->CKTrhs, ((struct CKTcircuit_tag*)ckt)->CKTirhs, debug_file), \
       fprintf(debug_file,"\n\n"),                            \
       DEBUG_FILE_CLOSE()                                     \
     )

  extern void dump_circuit_summary(FILE* file,struct CKTcircuit_tag* ckt);

  #define DEBUG_DUMP_CIRCUIT(ckt)                       \
     DEBUG_VOID(                                        \
       DEBUG_FILE_OPEN(),                               \
       fprintf(debug_file,"\n\n\n(%s,%d):THE FOLLOWING IS CONNECTION LIST OF '" #ckt "'\n",__FILE__,__LINE__),   \
       dump_circuit_summary(debug_file,(struct CKTcircuit_tag*) ckt),   \
       fprintf(debug_file,"\n\n"),                      \
       DEBUG_FILE_CLOSE()                               \
     )

  #define DEBUG_EXPR(x)                       DEBUG_VOID(x)
  #define DEBUG_DO_ONLY_FIRST_PASS(x)         { static int done=0; if (!done) x; done=1; }

#else
  #define DEBUG_INIT()                    DEBUG_VOID(0)
  #define DEBUG_PRINT(str)                DEBUG_VOID(0)
  #define DEBUG_PRINT1(str,x)             DEBUG_VOID(0)
  #define DEBUG_PRINT2(str,x,y)           DEBUG_VOID(0)
  #define DEBUG_PRINT3(str,x,y)           DEBUG_VOID(0)
  #define DEBUG_PRINT4(str,x,y,z)         DEBUG_VOID(0)
  #define DEBUG_PRINT5(str,x,y,z,w)       DEBUG_VOID(0)

  #define DEBUG_PRINTs(str,s)             DEBUG_VOID(0)
  #define DEBUG_PRINT1s(str,s,x)          DEBUG_VOID(0)
  #define DEBUG_PRINT2s(str,s,x,y)        DEBUG_VOID(0)
  #define DEBUG_PRINT3s(str,s,x,y,z)      DEBUG_VOID(0)
  #define DEBUG_PRINT4s(str,s,x,y,z,a)    DEBUG_VOID(0)
  #define DEBUG_PRINT5s(str,s,x,y,z,a,b)  DEBUG_VOID(0)

  #define DEBUG_MATRIX(ckt)               DEBUG_VOID(0)
  #define DEBUG_MATRIX_ARG1(ckt,fmt,arg)  DEBUG_VOID(0)

  #define DEBUG_DUMP_CIRCUIT(ckt)         DEBUG_VOID(0)

  #define DEBUG_EXPR(x)                       DEBUG_VOID(0)
  #define DEBUG_DO_ONLY_FIRST_PASS(x)         {}
#endif









#ifdef IIT
  /* KLUDGE: WE REALLY SHOULD ITERATE THROUGH THE PARAMETERS, BUT ASSUMING
   *         THAT THIS FUNCTION ONLY APPLIES TO XSPICE MODELS, EVERYTHING
   *         SHOULD BE OKAY.
   */
  #define IIT_KLUDGE_ARRAY [0]
#else
  #define IIT_KLUDGE_ARRAY
#endif


#if !defined(WIN32) && defined(EWB_IIT)
	#undef FAR
	#define FAR far
#elif defined(MSVC)
	#undef FAR
	#define FAR
#else
	#ifndef FAR
		#define FAR
	#endif
#endif


//#define DOCHECKHEAP
#ifdef DOCHECKHEAP
  extern void checkHeapSizedPtr(char const* ptr,int size);
  extern void checkHeap(char const* file,int lineno);
  extern void checkPtr(void* ptr);
  #define CHECKHEAP()           checkHeap(__FILE__,__LINE__)
  #define CHECKPTR(p)           checkHeapPtr((void*)(p))
  #define CHECKNPTR(p)          { if ((void*)(p)) checkHeapPtr((void*)(p)); }
  #define CHECKSIZEDNPTR(p,s)   { if ((void*)(p)) checkHeapSizedPtr((char*)(p),s); }
  #define CHECKSIZEDPTR(p,s)    checkHeapSizedPtr((char*)(p),s)
#else
  #define CHECKHEAP()           (void)0
  #define CHECKPTR(p)           (void)0
  #define CHECKHEAP()           (void)0
  #define CHECKSIZEDPTR(p,s)    (void)0
#endif

#ifdef MEM_ALLOC_CHECK_HEAP
  #define MEM_ALLOC_CHECKHEAP()           checkHeap(__FILE__,__LINE__)
#else
  #define MEM_ALLOC_CHECKHEAP()           (void)0
#endif


#define IPC_DEBUG_VIA_STDIO


#ifndef G_IPC_NOT_ENABLED
  #define G_IPC_NOT_ENABLED
#endif

#ifndef SPICE_BUILD
#ifndef XSPICE
  #define XSPICE
#endif
#endif

#ifndef IIT
  #define IIT
#endif

#ifdef IIT
typedef int (*qsort_cmp_t)(const void *, const void *);
#include <assert.h>
#endif

#ifdef IIT
  // Remove Microsoft's complex definition
  #ifndef _COMPLEX_DEFINED
     #define _COMPLEX_DEFINED
  #endif
  extern int NUM_SPICE3_MODELS;
#endif



/* gtri - modify - wbk - 10/8/90 - change paths */
#define BUGADDR "xspice@prism.gatech.edu"    /* Where to send bugs. */
#define HELPPATH "\\spice\\lib\\sim\\helpdir"
#define SPICEDLOG "\\tmp\\logfile"
#define NEWSFILE "\\spice\\lib\\sim\\news"    /* The message of the day. */

#if 0
#define LIBPATH "\\xspice~1\\lib\\sim\\scripts"
#define DEFAULTMFBCAP "\\xspice~1\\lib\\sim\\mfbcap"    /* The mfbcap file. */
#define SPICEHOST ""        /* Where to do rspice, "" = nowhere */
#define SPICEPATH "\\xspice~1\\bin" /* Where the binary is kept */

#else

#define LIBPATH "/usr/local/xspice-1-0/lib/sim/scripts"
#define DEFAULTMFBCAP "/usr/local/xspice-1-0/lib/sim/mfbcap"    /* The mfbcap file. */
#define SPICEHOST ""        /* Where to do rspice, "" = nowhere */
#define SPICEPATH "/usr/local/xspice-1-0/bin" /* Where the binary is kept */

#endif


/* THESE FILES NEED TO BE INCLUDED TO PROPERLY PROTOTYPE ALL FUNCTIONS
 */
//insert file>> #include "cm.h"
#ifndef CM_DEFINED
#define CM_DEFINED

/* ===========================================================================
FILE    CM.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file is includes all include data in the CM package.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

//insert file>> #include "instance.h"
//insert file>> #include "CMtypes.h"
#ifndef CMTYPES_DEFINED
#define CMTYPES_DEFINED

/* ===========================================================================
FILE    CMtypes.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Jeff Murray, Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains type definitions used by code models.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

//insert file>> #include "MIFtypes.h"
#ifndef MIFTYPES
#define MIFTYPES

/* ===========================================================================
FILE    MIFtypes.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains typedefs shared by several header files in
    the MIF package.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "basic.h"

/* ***************************************************************************** */


typedef int Mif_BOOLEAN_t;

#define  MIF_FALSE  0
#define  MIF_TRUE   1


typedef int Mif_Status_t;

#define  MIF_OK     0
#define  MIF_ERROR  1

/*
typedef enum {
    MIF_OK,
    MIF_ERROR,
} Mif_Status_t;
*/


/* ***************************************************************************** */


/*
 * The type of call to a code model - analog or event-driven
 */

typedef enum {
    MIF_ANALOG,         /* Analog call */
    MIF_EVENT_DRIVEN,   /* Event-driven call */
} Mif_Call_Type_t;



/*
 * Analysis type enumerations
 */

typedef enum {
    MIF_DC,                /* A DC or DCOP analysis */
    MIF_AC,                /* A swept AC analysis   */
    MIF_TRAN,              /* A transient analysis  */
} Mif_Analysis_t;



/*
 * Port type enumerations
 */

typedef enum {
    MIF_VOLTAGE,                /* v - Single-ended voltage */
    MIF_DIFF_VOLTAGE,           /* vd - Differential voltage */
    MIF_CURRENT,                /* i - Single-ended current */
    MIF_DIFF_CURRENT,           /* id - Differential current */
    MIF_VSOURCE_CURRENT,        /* vnam - Voltage source current */
    MIF_CONDUCTANCE,            /* g - Single-ended VCIS */
    MIF_DIFF_CONDUCTANCE,       /* gd - Differential VCIS */
    MIF_RESISTANCE,             /* h - Single-ended ICVS */
    MIF_DIFF_RESISTANCE,        /* hd - Differential ICVS */
    MIF_DIGITAL,                /* d - Digital */
    MIF_USER_DEFINED,           /* <identifier> - Any user defined type */
} Mif_Port_Type_t;



/*
 * The direction of a connector
 */

typedef enum {
    MIF_IN,                    /* Input only */
    MIF_OUT,                   /* Output only */
    MIF_INOUT,                 /* Input and output (e.g. g or h type) */
} Mif_Dir_t;



/*
 * The type of a parameter
 */

typedef enum {

    MIF_BOOLEAN,
    MIF_INTEGER,
    MIF_REAL,
    MIF_COMPLEX,
    MIF_STRING,

} Mif_Data_Type_t;



/*
 * The type of a token
 */

typedef enum {

    MIF_LARRAY_TOK,
    MIF_RARRAY_TOK,
    MIF_LCOMPLEX_TOK,
    MIF_RCOMPLEX_TOK,
    MIF_PERCENT_TOK,
    MIF_TILDE_TOK,
    MIF_STRING_TOK,
    MIF_NULL_TOK,
    MIF_NO_TOK,

} Mif_Token_Type_t;



/* 
 * Type of controlled source
 */

typedef enum {
    MIF_VCVS,
    MIF_VCIS,
    MIF_ICVS,
    MIF_ICIS,
} Mif_Cntl_Src_Type_t;


/* ***************************************************************************** */


/*
 * Complex numbers
 */

typedef struct {

    double  real;
    double  imag;

} Mif_Complex_t;



/*
 * Values of different types used by the load, ... routines
 */

typedef union {

    Mif_BOOLEAN_t  bvalue;         /* For digital node value */
    int            ivalue;         /* For integer parameters */
    double         rvalue;         /* For spice node values and real parameters */  
    Mif_Complex_t  cvalue;         /* For complex parameters */
    char           *svalue;        /* For string parameters  */
    void           *pvalue;        /* For user defined nodes */

} Mif_Value_t;




/*
 * Values of different types used by the parser.  Note that this is a structure
 * instead of a union because we need to do initializations in the ifspec.c files for
 * the models and unions cannot be initialized in any useful way in C
 *
 */

typedef struct {

    Mif_BOOLEAN_t     bvalue;         /* For BOOLEAN values */
    int               ivalue;         /* For integer values */
    double            rvalue;         /* For real values */  
    Mif_Complex_t     cvalue;         /* For complex values */
    char              *svalue;        /* For string values  */

} Mif_Parse_Value_t;

#ifdef EWB_IIT
  // Node information about a port.
  typedef struct XSPort_def {
    int             node;
    int             is_negated;
    Mif_Port_Type_t type;
    GENERIC*        node_ptr;
    IFuid           nodeUid;
  } XSPort_def_t;

  /*
  // The following 'Mif_Port_Type_t' is used by the XSPort_def
  // structure to specify that we should use the default type for
  // the port.
  */
  #define MIF_DEFAULT_PORT ((Mif_Port_Type_t)(MIF_USER_DEFINED+1))

  /* The following are the error messages that may be returned by
   * the 'MIF_init_xspice_instance' function.
   */
  typedef enum MIF_Init_Error {
     MIF_IE_okay,
     MIF_IE_Invalid_model_type_for_A_type_device,
     MIF_IE_too_many_connections,
     MIF_IE_too_few_connections,
     MIF_IE_NULL_connection_found_where_not_allowed,
     MIF_IE_Null_found_for_connection_where_not_allowed,
     MIF_IE_too_few_ports_in_connection,
     MIF_IE_too_many_ports_in_connection,
     MIF_IE_parameter_on_model_has_no_default,
     MIF_IE_defaulted_array_parameter_must_have_associated_array_connection,
     MIF_IE_Array_parameter_size_on_model_does_not_match_connection_size,
     MIF_IE_port_type_is_invalid,
     MIF_IE_ERROR__Negation_not_allowed_on_analog_nodes,
     MIF_IE_INTERNAL_ERROR__Impossible_connection_type,
     MIF_IE_ERROR__Impossible_direction_type_in_MIF_init_inst,
     MIF_IE_unable_to_insert_instance_into_event_table
  } MIF_Init_Error_Enum;

#endif

#endif /* MIFTYPES */

/***** Define Typedefs ********************************************/

typedef int BOOLEAN_t;

typedef Mif_Complex_t   Complex_t;


typedef enum {
    ZERO,                /* Normally referenced as 0 */
    ONE,                 /* Normally referenced as 1 */
    UNKNOWN,             /* Unknown */
} Digital_State_t;

typedef enum {
    STRONG,              /* strong */
    RESISTIVE,           /* resistive */
    HI_IMPEDANCE,        /* high impedance */
    UNDETERMINED,        /* unknown strength */
} Digital_Strength_t;

typedef struct {
    Digital_State_t     state;
    Digital_Strength_t  strength;
} Digital_t;



#endif /* CMTYPES_DEFINED */
//insert file>> #include "CMconst.h"
#ifndef CMCONSTANTS_DEFINED
#define CMCONSTANTS_DEFINED

/* ===========================================================================
FILE    CMconstants.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains constants used by code models.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

//insert file>> #include "MIFtypes.h"

/***** Define Constants *******************************************/

#define FALSE 0
#define TRUE  1

#define DC           MIF_DC
#define AC           MIF_AC
#define TRANSIENT    MIF_TRAN

#define ANALOG       MIF_ANALOG
#define EVENT        MIF_EVENT_DRIVEN


#endif /* CMCONSTANTS_DEFINED */
//insert file>> #include "CMproto.h"
#ifndef CMPROTO_DEFINED
#define CMPROTO_DEFINED

/* ===========================================================================
FILE    CMproto.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Jeff Murray, Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains ANSI C function prototypes for cm_xxx functions
    called by code models.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

/* Prototypes for functions used by internal code models */
/* The actual functions reside in ../ICM/CMutil.c        */
/*                                         12/17/90      */


//insert file>> #include "CMtypes.h"


void cm_climit_fcn(double in, double in_offset, double cntl_upper, 
                   double cntl_lower, double lower_delta, 
                   double upper_delta, double limit_range, 
                   double gain, int percent, double *out_final,
                   double *pout_pin_final, double *pout_pcntl_lower_final,
                   double *pout_pcntl_upper_final);



void cm_smooth_corner(double x_input, double x_center, double y_center,
                 double domain, double lower_slope, double upper_slope,
                 double *y_output, double *dy_dx);
void cm_smooth_discontinuity(double x_input, double x_lower, double y_lower,
                 double x_upper, double y_upper,
                 double *y_output, double *dy_dx);
double cm_smooth_pwl(double x_input, double *x, double *y, int size,
               double input_domain, double *dout_din);

double cm_analog_ramp_factor(InstanceHandle inst);
void cm_analog_alloc(InstanceHandle inst,int tag, int bytes);
void *cm_analog_get_ptr(InstanceHandle inst,int tag, int timepoint);
int  cm_analog_integrate(InstanceHandle inst,double integrand, double *integral, double *partial);
int  cm_analog_converge(InstanceHandle inst,double *state);
int  cm_analog_set_temp_bkpt(InstanceHandle inst,double time);
int  cm_analog_set_perm_bkpt(InstanceHandle inst,double time);
void cm_analog_not_converged(InstanceHandle inst);
void cm_analog_auto_partial(InstanceHandle inst);

void cm_event_alloc(InstanceHandle inst,int tag, int bytes);
void *cm_event_get_ptr(InstanceHandle inst,int tag, int timepoint);
int  cm_event_queue(InstanceHandle inst,double time);

char *cm_message_get_errmsg(InstanceHandle inst);
int  cm_message_send(InstanceHandle inst,char *msg);

double cm_netlist_get_c(InstanceHandle inst);
double cm_netlist_get_l(InstanceHandle inst);

Complex_t cm_complex_set(double real, double imag);
Complex_t cm_complex_add(Complex_t x, Complex_t y);
Complex_t cm_complex_subtract(Complex_t x, Complex_t y);
Complex_t cm_complex_multiply(Complex_t x, Complex_t y);
Complex_t cm_complex_divide(Complex_t x, Complex_t y);

#endif /* CMPROTO_DEFINED */

//insert file>> #include "MIFcmdat.h"
#ifndef MIFCMDAT
#define MIFCMDAT

/* ===========================================================================
FILE    MIFcmdat.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

   This file contains the data structure definitions used by
   code model and the associated MIF package.

   A special preprocessor (cmpp) is used on models written by a
   user to turn items like INPUT(<name>) into the appropriate structure
   reference.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include  "MIFtypes.h"
//insert file>> #include  "instance.h"


/* ************************************************************************** */


/*
 *  Pointers into matrix for a voltage input, voltage output partial
 */

typedef struct Mif_E_Ptr_s {

    double      *branch_poscntl;   /* Branch row, positive controlling column */
    double      *branch_negcntl;   /* Branch row, negative controlling column */

} Mif_E_Ptr_t;



/*
 *  Pointers into matrix for a current input, current output partial
 */

typedef struct Mif_F_Ptr_s {

    double      *pos_ibranchcntl;    /* Positive row, controlling branch column */
    double      *neg_ibranchcntl;    /* Negative row, controlling branch column */

} Mif_F_Ptr_t;



/*
 *  Pointers into matrix for a voltage input, current output partial
 */

typedef struct Mif_G_Ptr_s {

    double      *pos_poscntl;       /* Positive row, positive controlling column */
    double      *pos_negcntl;       /* Positive row, negative controlling column */
    double      *neg_poscntl;       /* Negative row, positive controlling column */
    double      *neg_negcntl;       /* Negative row, negative controlling column */

} Mif_G_Ptr_t;


/*
 *  Pointers into matrix for a current input, voltage output partial
 */

typedef struct Mif_H_Ptr_s {

    double      *branch_ibranchcntl;  /* Branch row, controlling branch column */

} Mif_H_Ptr_t;




/*
 * Matrix pointers associated with a particular port (of a particular type)
 */


typedef union Mif_Port_Ptr_u {

    Mif_E_Ptr_t    e;          /* Pointers for voltage input, voltage output */
    Mif_F_Ptr_t    f;          /* Pointers for current input, current output */
    Mif_G_Ptr_t    g;          /* Pointers for voltage input, current output */
    Mif_H_Ptr_t    h;          /* Pointers for current input, voltage output */

} Mif_Port_Ptr_t;



/*
 * Array of matrix data pointers for particular ports in a connection
 */

typedef struct Mif_Conn_Ptr_s {

    Mif_Port_Ptr_t      *port;    /* Data for a particular port */

} Mif_Conn_Ptr_t;



/*
 * Row numbers and matrix entry pointers for loading the matrix and RHS with
 * data appropriate for the particular output port and input ports.
 */

typedef struct Mif_Smp_Ptr_s {

    /* Data at this level is for this connection.  The Mif_Conn_Ptr_t    */
    /* subtree is used only if this connection is an output. It supplies */
    /* the matrix pointers required for loading the partials from each   */
    /* input.                                                            */

    /* node connection equation numbers */
    int             pos_node;         /* Row associated with positive node */
    int             neg_node;         /* Row associated with negative node */

    /* V source branch equation numbers */
    int             branch;           /* Row associated with V output branch */
    int             ibranch;          /* Row associated with I input branch */

    /* matrix pointers for V source output */
    double          *pos_branch;      /* Positive node row, branch column */
    double          *neg_branch;      /* Negative node row, branch column */
    double          *branch_pos;      /* Branch row, positive node column */
    double          *branch_neg;      /* Branch row, negative node column */

    /* matrix pointers for the zero-valued V source associated with an I input */
    double          *pos_ibranch;      /* Positive node row, branch column */
    double          *neg_ibranch;      /* Negative node row, branch column */
    double          *ibranch_pos;      /* Branch row, positive node column */
    double          *ibranch_neg;      /* Branch row, negative node column */

    /* array of pointer info required for putting partials into the matrix */
    Mif_Conn_Ptr_t  *input;    /* Matrix pointers associated with inputs */

} Mif_Smp_Ptr_t;




/* ******************************************************************** */



/*
 * Partial derivatives wrt ports of a particular input connection
 */

typedef struct Mif_Partial_s {

    double      *port;          /* Partial wrt this port */

} Mif_Partial_t;


/*
 * AC gains wrt ports of a particular input connection
 */

typedef struct Mif_AC_Gain_s {

    Mif_Complex_t      *port;          /* AC gain wrt this port */

} Mif_AC_Gain_t;


/*
 * Data used to access information in event struct in CKTcircuit struct ckt
 */

typedef struct {
    int         node_index;      /* Index of node in event-driven structures */
    int         output_subindex; /* Subindex of output on node */
    int         port_index;      /* Index of port in event-driven structures */
    int         output_index;    /* Index of output in event-driven structures */
} Mif_Evt_Data_t;


/*
 * Information about individual port(s) of a connection.
 */

typedef struct Mif_Port_Data_s {

    Mif_Port_Type_t type;           /* Port type - e.g. MIF_VOLTAGE, ...  */
    char            *type_str;      /* Port type in string form           */
    char            *pos_node_str;  /* Positive node identifier           */
    char            *neg_node_str;  /* Negative node identifier           */
    char            *vsource_str;   /* Voltage source identifier          */

    Mif_BOOLEAN_t   is_null;        /* Set to true if null in SPICE deck  */
    Mif_Value_t     input;          /* The input value                    */
    Mif_Value_t     output;         /* The output value                   */
    Mif_Partial_t   *partial;       /* Partials for this port wrt inputs  */
    Mif_AC_Gain_t   *ac_gain;       /* AC gains for this port wrt inputs  */
    int             old_input;      /* Index into CKTstate for old input  */

    Mif_BOOLEAN_t   invert;         /* True if state should be inverted   */
    Mif_BOOLEAN_t   changed;        /* A new output has been assigned     */
    double          load;           /* Load factor output to this port    */
    double          total_load;     /* Total load for this port           */
    double          delay;          /* Digital delay for this output port */
    char            *msg;           /* Message string output to port      */

    Mif_Smp_Ptr_t   smp_data;       /* Pointers used to load matrix/rhs   */
    Mif_Evt_Data_t  evt_data;       /* Data used to access evt struct     */

    double          nominal_output; /* Saved output when doing auto partial */

} Mif_Port_Data_t;


/* ******************************************************************** */

/*
 * Information in MIFinstance struct used by cm_.. support functions.
 */


typedef struct Mif_State_s {   /* for cm_analog_alloc() */

    int         tag;           /* Tag identifying this particular state */
    int         index_value;   /* Index into ckt->CKTstate[i] vector */
    int         doubles;       /* Number of doubles allocated for this state */
    int         bytes;         /* Actual number of bytes requested by cm_analog_alloc() */

} Mif_State_t;


typedef struct Mif_Intgr_s {   /* for cm_analog_integrate() */

    int         byte_index;    /* Byte offset into state array */

} Mif_Intgr_t;


typedef struct Mif_Conv_s {   /* for cm_analog_converge() */

    int         byte_index;   /* Byte offset into state array */
    double      last_value;   /* Value at last iteration */

} Mif_Conv_t;



/* ******************************************************************** */



/*
 * Information about the circuit in which this model is simulating.
 */

typedef struct Mif_Circ_Data_s {

    Mif_BOOLEAN_t         init;         /* True if first call to model - a setup pass */
    Mif_Analysis_t        anal_type;    /* Current analysis type                      */
    Mif_BOOLEAN_t         anal_init;    /* True if first call in this analysis type   */
    Mif_Call_Type_t       call_type;    /* Analog or event type call                  */
    double                time;         /* Current analysis time                      */
    double                frequency;    /* Current analysis frequency                 */
    double                temperature;  /* Current analysis temperature               */
    double                t[8];         /* History of last 8 analysis times t[0]=time */

} Mif_Circ_Data_t;



/*
 * The structure associated with a named "connection" on the model.
 */

typedef struct Mif_Conn_Data_s {

    char             *name;          /* Name of this connection - currently unused */
    char             *description;   /* Description of this connection - unused    */
    Mif_BOOLEAN_t    is_null;        /* Set to true if null in SPICE deck          */
    Mif_BOOLEAN_t    is_input;       /* Set to true if connection is an input */
    Mif_BOOLEAN_t    is_output;      /* Set to true if connection is an output */
    int              size;           /* The size of an array (1 if scalar)         */
    Mif_Port_Data_t  **port;         /* Pointer(s) to port(s) for this connection  */

} Mif_Conn_Data_t;



/*
 * Values for model parameters
 */

typedef struct Mif_Param_Data_s {

    Mif_BOOLEAN_t   is_null;            /* True if no value given on .model card */
    int             size;               /* Size of array (1 if scalar)           */
    Mif_Value_t     *element;           /* Value of parameter(s)                 */

} Mif_Param_Data_t;




/*
 * Values for instance variables
 */

typedef struct Mif_Inst_Var_Data_s {

    int         size;               /* Size of array (1 if scalar)           */
    Mif_Value_t *element;           /* Value of instance variables(s)        */

} Mif_Inst_Var_Data_t;




/* ************************************************************************* */



/*
 * HERE IT IS!!!
 * The top level data structure passed to code models.
 */

typedef struct Mif_Private_s {

    Mif_Circ_Data_t        circuit;       /* Information about the circuit        */
    int                    num_conn;      /* Number of connections on this model  */
    Mif_Conn_Data_t        **conn;        /* Information about each connection    */
    int                    num_param;     /* Number of parameters on this model   */
    Mif_Param_Data_t       **param;       /* Information about each parameter     */
    int                    num_inst_var;  /* Number of instance variables         */
    Mif_Inst_Var_Data_t    **inst_var;    /* Information about each inst variable */

    InstanceHandle         m_instance_handle;
} Mif_Private_t;


#define MIF_INSTANCE    (private_->m_instance_handle)


#endif /* MIFCMDAT */


#endif /* CM_DEFINED */
//insert file>> #include "enh.h"
#ifndef ENH_HEADER
#define ENH_HEADER 

/* ===========================================================================
FILE    ENH.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains typedefs used by the event-driven algorithm.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFtypes.h"
//insert file>> #include "FTEinp.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 *
 * Note that this definition must be the same as struct card in INPdefs.h...
 */

#ifndef FTEinput_h
#define FTEinput_h

//insert file>> #include "inpdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef INP
#define INP

    /* structure declarations used by either/both input package */

//insert file>> #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

#ifndef IFSIMULATOR
#define IFSIMULATOR

  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing IFSim.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

//insert file>>   #include "basic.h"
//insert file>>   #include "instance.h"

  /*
   * structure:   IFparm
   *
   *
   * The structure used to describe all values passed
   * between the front end and the simulator when there is any
   * possibility one argument of the function could have more
   * than one type.
   *
   * keyword is provided for the front end and is the token
   *    the user is expected to label the data with.
   *
   * id is an integer intended to uniquely identify the parameter
   *    to the simulator
   *
   * dataType is an integer which indicates the type of argument
   *    that must be passed for this parameter
   *
   * description is a longer description intended for help menus
   *    the description should all fit on one line, but should
   *    give a knowledgable user a good idea what the parameter is
   *    used for.
   */

  typedef struct sIFparm {
      char *keyword;
      int id;
      int dataType;
      char *description;
  } IFparm;

  /* Structure:   IFparseTree
   *
   * This structure is returned by the parser for a IF_PARSETREE valued
   * parameter and describes the information that the simulator needs
   * to know about the parse tree in order to use it.
   * It is expected that the front end will have a more extensive
   * structure which this structure will be a prefix of.
   *
   * Note that the function pointer is provided as a hook for
   * versions which may want to compile code for the parse trees
   * if they are used heavily.
   *
   */

  typedef struct sIFparseTree {
      int numVars;            /* number of variables used */
      int *varTypes;          /* array of types of variables */
      union uIFvalue * vars;  /* array of structures describing values */
      IITEXPORT(int, IFeval)(InstanceHandle,struct sIFparseTree*,double,double*,double*,double*);
  } IFparseTree;

  /*
   * Structure: IFanalysis
   *
   * This structure contains all the information available to the
   * front end about a particular analysis type.  The simulator will
   * present the front end with an array of pointers to these structures
   * which it will use to determine legal analysis types and parameters.
   *
   * Note to simulators:  As for IFdevice above, you pass an array of pointers
   * to these, so you can make this structure a prefix to a larger structure
   * which you use internally.
   *
   */

  typedef struct sIFanalysis {
      char *name;                 /* name of this analysis type */
      char *description;          /* description of this type of analysis */

      int numParms;               /* number of analysis parameter descriptors */
      struct sIFparm *analysisParms;      /* array  of analysis parameter descriptors */

  } IFanalysis;


  #ifdef XSPICE
    /* gtri - add - wbk - 10/11/90 - for structs referenced in IFdevice */
//insert file>>     #include "MIFtypes.h"
//insert file>>     #include "MIFdefs.h"
#ifndef HDR_MIFDEFS_H
#define HDR_MIFDEFS_H

/* ===========================================================================
FILE    MIFdefs.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains (augmented) SPICE 3C1 compatible typedefs for use
    with code models.  These typedefs define the data structures that are
    used internally to describe instances and models in the circuit
    description linked lists.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include  "MIFcmdat.h"
#ifdef XSPICE_BUILD
//insert file>>   #include "IFsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

#endif
//insert file>> #include "basic.h"



/* The per-instance data structure */

struct sMIFinstance {
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif


    struct sMIFmodel    *MIFmodPtr;       /* backpointer to model */
    struct sMIFinstance *MIFnextInstance; /* pointer to next instance of current model */
    IFuid               MIFname;          /* pointer to character string naming this instance */

    int                 num_conn;         /* number of connections on the code model */
    Mif_Conn_Data_t     **conn;           /* array of data structures for each connection */

    int                 num_inst_var;     /* number of instance variables on the code model */
    Mif_Inst_Var_Data_t **inst_var;       /* array of structs for each instance var */

    int                 num_param;        /* number of parameters on the code model */
    Mif_Param_Data_t    **param;          /* array of structs for each parameter */

    int                 num_state;        /* Number of state tags used for this inst */
    Mif_State_t         *state;           /* Info about states */

    int                 num_intgr;        /* Number of integrals */
    Mif_Intgr_t         *intgr;           /* Info for integrals */

    int                 num_conv;         /* Number of things to be converged */
    Mif_Conv_t          *conv;            /* Info for convergence things */

    Mif_BOOLEAN_t       initialized;      /* True if model called once already */

    Mif_BOOLEAN_t       analog;           /* true if this inst is analog or hybrid type */
    Mif_BOOLEAN_t       event_driven;     /* true if this inst is event-driven or hybrid type */

    int                 inst_index;       /* Index into inst_table in evt struct in ckt */

};



/* The per model data structure */

struct sMIFmodel {
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif


    int              MIFmodType;      /* type index of this device type */
    struct sMIFmodel *MIFnextModel;   /* pointer to next possible model in linked list */
    MIFinstance      *MIFinstances;   /* pointer to list of instances that have this model */
    IFuid            MIFmodName;      /* pointer to character string naming this model */

    int              num_param;       /* number of parameters on the code model */
    Mif_Param_Data_t **param;         /* array of structs for each parameter */

    Mif_BOOLEAN_t    analog;          /* true if this model is analog or hybrid type */
    Mif_BOOLEAN_t    event_driven;    /* true if this model is event-driven or hybrid type */

};



/* NOTE:  There are no device parameter tags, since the ask, mAsk, ...    */
/* functions for code models work out of the generic code model structure */



#endif /* MIFDEFS */
    #ifdef XSPICE_BUILD
//insert file>>       #include "xspice.h"
    #endif
//insert file>>     #include "MIFparse.h"
#ifndef MIFPARSE
#define MIFPARSE

/* ===========================================================================
FILE    MIFparse.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the information structure definitions used by the
    code model parser to check for valid connections and parameters.

    Structures of these types are created by the code model preprocessor
    (cmpp) from the user created ifspec.ifs file.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include  "MIFtypes.h"


/*
 * Information about a connection used by the parser to error check input
 */


typedef struct Mif_Conn_Info_s {

    char            *name;             /* Name of this connection */
    char            *description;      /* Description of this connection */
    Mif_Dir_t       direction;         /* Is this connection an input, output, or both? */
    Mif_Port_Type_t default_port_type; /* The default port type */
    char            *default_type;     /* The default type in string form */
    int             num_allowed_types; /* The size of the allowed type arrays */
    Mif_Port_Type_t *allowed_type;     /* The allowed types */
    char            **allowed_type_str; /* The allowed types in string form */
    Mif_BOOLEAN_t   is_array;          /* True if connection is an array       */
    Mif_BOOLEAN_t   has_lower_bound;   /* True if there is an array size lower bound */
    int             lower_bound;       /* Array size lower bound */
    Mif_BOOLEAN_t   has_upper_bound;   /* True if there is an array size upper bound */
    int             upper_bound;       /* Array size upper bound */
    Mif_BOOLEAN_t   null_allowed;      /* True if null is allowed for this connection */

} Mif_Conn_Info_t;




/*
 * Information about a parameter used by the parser to error check input
 */

typedef struct Mif_Param_Info_s {

    char                *name;            /* Name of this parameter */
    char                *description;     /* Description of this parameter */
    Mif_Data_Type_t     type;             /* Is this a real, BOOLEAN, string, ... */
    Mif_BOOLEAN_t       has_default;      /* True if there is a default value */
    Mif_Parse_Value_t   default_value;    /* The default value */
    Mif_BOOLEAN_t       has_lower_limit;  /* True if there is a lower limit */
    Mif_Parse_Value_t   lower_limit;      /* The lower limit for this parameter */
    Mif_BOOLEAN_t       has_upper_limit;  /* True if there is a upper limit */
    Mif_Parse_Value_t   upper_limit;      /* The upper limit for this parameter */
    Mif_BOOLEAN_t       is_array;         /* True if parameter is an array       */
    Mif_BOOLEAN_t       has_conn_ref;     /* True if parameter is associated with a connector */
    int                 conn_ref;         /* The subscript of the associated connector */
    Mif_BOOLEAN_t       has_lower_bound;  /* True if there is an array size lower bound */
    int                 lower_bound;      /* Array size lower bound */
    Mif_BOOLEAN_t       has_upper_bound;  /* True if there is an array size upper bound */
    int                 upper_bound;      /* Array size upper bound */
    Mif_BOOLEAN_t       null_allowed;     /* True if null is allowed for this parameter */

} Mif_Param_Info_t;




/*
 * Information about an instance parameter used by the parser to error check input
 */

typedef struct Mif_Inst_Var_Info_s {

    char                *name;            /* Name of this instance var */
    char                *description;     /* Description of this instance var */
    Mif_Data_Type_t     type;             /* Is this a real, BOOLEAN, string, ... */
    Mif_BOOLEAN_t       is_array;         /* True if instance var is an array       */

} Mif_Inst_Var_Info_t;


#endif /* MIFPARSE */
//insert file>>     #include "MIFcmdat.h"
    /* gtri - end - wbk - 10/11/90 */
  #endif

//insert file>>   #include "ftedata.h"

/* RCS Info: $Revision: 1.5 $ on $Date: 88/11/17 02:35:21 $
 *         $Source: /ic3/quarles/shared/include/RCS/FTEdata.h,v $
 * Copyright (c) 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
 *
 * Structures used for representing spice data in nutmeg.
 */

#ifndef FTEdata_h
#define FTEdata_h

//insert file>> #include "cpstd.h"      /* for struct SPICE_complex */
//insert file>> #include "xspice.h"

//#ifdef IIT
//#define _complex _rename_complex_to_avoid_redefinition_problems_with_microsoft_compiler
//#define complex rename_complex_to_avoid_redefinition_problems_with_microsoft_compiler
//#endif

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 * Standard definitions. This file serves as the header file for std.c and
 * wlist.c
 */

#ifndef _STD_H_
#define _STD_H_

typedef int BOOL;

//insert file>> #include "misc.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

#ifndef MISC_H
#define MISC_H

#ifdef IIT
//insert file>> #include "spice.h"
//insert file>> #include "os_msdos.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

/*
 *	MS-DOS using MSC-C 5.1
 */

#define     DIR_CWD		"."
#define     DIR_PATHSEP		"\\"
#define     DIR_TERM		'\\'
#define	    TEMPFORMAT		"%s%d.tmp"

#define HAS_ASCII
#define HAS_CHDIR		/* for tree filesystems, chdir( )	*/
#define HAS_CLEARERR		/* clearerr( ), should be in stdio	*/
#define HAS_CTYPE		/* <ctype.h>, iswhite( ), etc.		*/
#define HAS_DOSDIRS		/* Emulate opendir, etc.		*/

#ifndef BIT32
#define HAS_MEMAVL		/* Use _memavl( ) 			*/
#endif

#define HAS_ENVIRON
#define HAS_FTIME
#define HAS_GETCWD		/* getcwd(buf, size)			*/
#define HAS_LOCALTIME
#define HAS_LONGJUMP		/* setjmp( ), longjmp( )		*/
//#define HAS_MINDATA
#define HAS_NOINLINE
#define HAS_NOVM
#define HAS_PCTERM
#define HAS_QSORT		/* qsort( )				*/
#define HAS_SHORTMACRO
#define HAS_STAT
#define HAS_STDLIB
#define HAS_STRCHR		/* strchr( ) instead of index( )	*/
#define HAS_SYSTEM
#define HAS_UNIX_SIGS
#define HAS_UNLINK
#define HAS_LIMITS_H
#define HAS_FLOAT_H
#define HAS_NO_IEEE_LOGB
#define HAS_NO_ERFC
#define HAS_BATCHSIM

#define WANT_PCHARDCOPY

#ifndef IIT
#define WANT_MFB
#endif

#endif

#define BSIZE_SP      512

#ifdef HAS_EXIT1
#  define EXIT_NORMAL 1
#  define EXIT_BAD    0
#else
#  define EXIT_NORMAL 0
#  define EXIT_BAD    1
#endif

#ifdef HAS_CTYPE
#  ifndef isalpha
#    include <ctype.h>
#  endif
#endif

#define eq(a,b)  (!strcmp((a), (b)))
#define eqc(inst, a,b)  (cieq((a), (b)))
#define isalphanum(c)   (isalpha(c) || isdigit(c))
#define hexnum(c) ((((c) >= '0') && ((c) <= '9')) ? ((c) - '0') : ((((c) >= \
        'a') && ((c) <= 'f')) ? ((c) - 'a' + 10) : ((((c) >= 'A') && \
        ((c) <= 'F')) ? ((c) - 'A' + 10) : 0)))

//insert file>> #include "strext.h"
#ifdef HAS_STRINGS
#  include <strings.h>
#else
#  include <string.h>
#endif

extern char* tmalloc(InstanceHandle inst, int num);
extern char* trealloc(InstanceHandle inst, char* str,int num);
extern void txfree(InstanceHandle inst, char* ptr);

#define tfree(inst, x)    (txfree(inst, (char*)x), x = 0)

#define alloc(inst, TYPE) ((TYPE *) tmalloc(inst, sizeof(TYPE)))

int prefix(InstanceHandle inst, char *p,char *s);
char* copy(InstanceHandle inst, char *str);
extern int substring(InstanceHandle inst, char* str,char *sub);
extern void appendc(InstanceHandle inst, char* s,char  c);
extern int scannum(InstanceHandle inst, char* str);
extern int cieq(char* p, char* s);
extern int ciprefix(InstanceHandle inst, char *p,char  *s);
extern void strtolower(InstanceHandle inst, char* str);
extern char* gettok(InstanceHandle inst, char **s);

extern char *tilde_expand(InstanceHandle inst, char *string);
extern void cp_printword(InstanceHandle inst, char *string,FILE *fp);

extern char *datestring(void);
extern double EXPORT seconds(InstanceHandle inst);

extern char *smktemp(InstanceHandle inst, char* id);

/* Externs from libc */

#ifdef HAS_STDLIB
#  ifndef _STDLIB_INCLUDED
#    define _STDLIB_INCLUDED
#    include <stdlib.h>
#  endif
#endif

#ifndef IIT
#ifndef HAS_BSDRAND
#  define random	rand
#  define srandom	srand
#endif
#endif

#ifdef HAS_DOSDIRS
   char *getcwd( );
#endif

#ifdef HAS_BSDRAND
   #ifdef IIT
   #include <stdlib.h>
   #else
   extern long random();
   #endif
   extern void srandom();
#else
#ifndef IIT
#  define random	rand
#endif
#  define srandom	srand
#endif
#ifdef IIT
   #include <stdio.h>
   #include <stdlib.h>
#else
     extern char *calloc();
     extern char *malloc();
     extern char *realloc();
     extern char *getenv();
     extern int errno;
     extern char *sys_errlist[];
     extern char *getenv();
     extern char *getwd();
     extern int rand();
     extern int srand();
     extern int atoi();
     extern int kill();
     extern int getpid();
     extern int qsort();
#endif
#ifdef notdef
     extern void exit();
#endif

#ifdef HAS_GETCWD
     extern char *getcwd( );
#endif

#ifdef HAS_CLEARERR
#  ifndef clearerr
//      extern void clearerr();
#include <stdio.h>
#  endif /* clearerr */
#endif /* HAS_CLEARERR */

#ifndef bzero
      extern int bzero(char *ptr,int num);
#endif
#ifndef bcopy
      extern void bcopy(char* from,char* to,int num);
#endif

#ifndef index
#  ifdef HAS_INDEX
      extern char* index(char *s, char c);
      extern char* rindex(char *s, char c);
#  else
#include <string.h>

#  endif
#endif

#ifndef HAS_INDEX
#  ifndef index
#    ifdef HAS_STRCHR
#      define	index	strchr
#      define	rindex	strrchr
#    endif
#  endif
#endif

#ifdef HAS_VPERROR
extern void perror();
#endif

#ifdef HAS_TIME_
#  ifdef HAS_BSDTIME
extern char *timezone();
#  endif
extern char *asctime();
extern struct tm *localtime();
#endif

#ifndef HAS_MEMAVL
#  ifdef HAS_RLIMIT_
extern char *sbrk();
#  endif
#endif

#define false 0
#define true 1

#ifdef HAS_DOSDIRS
#ifdef IIT
typedef int     DIR;
#else
typedef	int	*DIR;
#endif
struct direct {
	int	d_reclen;
	short	d_ino;
	short	d_namelen;
	char	d_name[20];
	};

#  ifdef IIT
extern DIR *opendir(char *);
extern struct direct *readdir(DIR *);
#  else
extern DIR *opendir( );
extern struct direct *readdir( );
#  endif
#endif

#endif /* MISC_H */
//insert file>> #include "util.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef UTIL
#define UTIL

//insert file>> #include "instance.h"

/* #define MALLOC(x) calloc(1,(unsigned)(x)) */
#define MALLOC(inst, x) tmalloc(inst, (unsigned)(x))

#define ALLOC(inst, type,number)  ((type *)tmalloc(inst, (unsigned)(sizeof(type)*(number))))
#define FREE(inst, x) {if ((x)!=NULL) {txfree(inst, (char *)(x));(x) = 0;}}

#define REALLOC_SET(inst, ptr,type,number)  \
           ptr = (type*)REALLOC(inst, ptr,(unsigned)(sizeof(type)*(number)) )

/* Calloc that properly handles allocating a cleared vector. */
#define CALLOC_VEC(inst, ptr,type,number)                     \
{   int i; ptr = ALLOC(inst, type, number);                   \
    if (ptr != (type *)NULL)                            \
        for(i=(number)-1;i>=0; i--) ptr[i] = (type) 0;  \
}



#define REALLOC(inst, x,y) trealloc(inst, (char*)(x),(unsigned)(y))
#define ZERO(PTR,TYPE)  (bzero((char*)(PTR),sizeof(TYPE)))


#include <stdlib.h>
extern char *trealloc(InstanceHandle, char*,int);
extern char *tmalloc(InstanceHandle, int);

#define TRUE 1
#define FALSE 0

#ifdef DEBUG
#define DEBUGMSG(textargs) printf(textargs)
#else
#define DEBUGMSG(testargs) 
#endif

#include <math.h>

/* XXX Move these into the above ifdef someday */
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define SIGN(a,b) ( b >= 0 ? (a >= 0 ? a : - a) : (a >= 0 ? - a : a))

#define ABORT() fflush(stderr);fflush(stdout);abort();

#define ERRORMESSAGE(CODE,MESSAGE)	{					      \
    errMsg = MALLOC(inst, strlen(MESSAGE) + 1);                     \
	strcpy(errMsg, (MESSAGE));					      \
	return (CODE);							      \
	}

#define NEW(inst, TYPE)   ((TYPE *) MALLOC(inst, sizeof(TYPE)))
#define NEWN(inst, TYPE,COUNT) ((TYPE *) MALLOC(inst, sizeof(TYPE) * (COUNT)))

#define	R_NORM(A,B) {							      \
	if ((A) == 0.0) {						      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS(A) > 1.0) {					      \
		(B) += 1;						      \
		(A) /= 2.0;						      \
	    }								      \
	    while (FABS(A) < 0.5) {					      \
		(B) -= 1;						      \
		(A) *= 2.0;						      \
	    }								      \
	}								      \
    }

#endif /*UTIL*/


#ifndef FILE
/* XXX Bogus */
#  include <stdio.h>
#endif

/* Doubly linked lists of words. */

struct wordlist {
    char *wl_word;
    struct wordlist *wl_next;
    struct wordlist *wl_prev;
} ;

typedef struct wordlist wordlist;

/* Complex numbers. */

struct SPICE_complex {   /* IBM portability... */
    double cx_real;
    double cx_imag;
} ;

typedef struct SPICE_complex SPICE_complex;

#define realpart(cval)  ((struct SPICE_complex *) (cval))->cx_real
#define imagpart(cval)  ((struct SPICE_complex *) (cval))->cx_imag

/* Externs defined in std.c */
extern int cp_numdgt;

#ifndef IIT
extern void setenv(InstanceHandle inst);
extern char *gethome(InstanceHandle inst);
extern char *getusername(InstanceHandle inst);
#endif

extern void quit(InstanceHandle inst);
extern void fatal(InstanceHandle inst);
extern char *tildexpand(InstanceHandle inst, char *string);
extern char *printnum(InstanceHandle inst, double num);
extern void cp_printword(InstanceHandle inst, char *string,FILE *fp);

/* Externs from wlist.c */

extern char **wl_mkvec(InstanceHandle inst, wordlist *wlist);
extern char *wl_flatten(InstanceHandle inst, wordlist *wlist);
extern int wl_length(InstanceHandle inst, wordlist *wlist);
extern void wl_free(InstanceHandle inst, wordlist *wlist);
extern void wl_print(InstanceHandle inst, wordlist *wlist,FILE *fp);
extern void wl_sort(InstanceHandle inst, wordlist *wlist);
extern wordlist *wl_append(InstanceHandle inst, wordlist *wlist,wordlist *nwl);
extern wordlist *wl_build(InstanceHandle inst, char *v[]);
extern wordlist *wl_copy(InstanceHandle inst, wordlist *wlist);
extern wordlist *wl_nthelem(InstanceHandle inst, int i,wordlist *wl);
extern wordlist * wl_range(InstanceHandle inst, wordlist* wl, int low, int up);
extern wordlist *wl_reverse(InstanceHandle inst, wordlist *wlist);
extern wordlist *wl_splice(InstanceHandle inst, wordlist *elt,wordlist *list);

#endif /* _STD_H_*/
//insert file>> #include "fteconst.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/* Vector types. */

#ifndef _CONSTANTS_
#define _CONSTANTS_

#ifdef _DEBUG
#ifdef _MSC_VER
#pragma message( "  parsing FTEconst.H" )
#endif /*_MSC_VER*/
#endif /*_DEBUG*/

#define SV_NOTYPE   0
#define SV_TIME  1
#define SV_FREQUENCY    2
#define SV_VOLTAGE  3
#define SV_CURRENT  4
#define SV_OUTPUT_N_DENS 5
#define SV_OUTPUT_NOISE  6
#define SV_INPUT_N_DENS 7
#define SV_INPUT_NOISE  8
#define SV_POLE     9
#define SV_ZERO     10
#define SV_SPARAM   11

#ifdef notdef
#define SV_OUTPUT_NOISE 5
#define SV_INPUT_NOISE  6
#define SV_HD2    7
#define SV_HD3    8
#define SV_DIM2  9
#define SV_SIM2  10
#define SV_DIM3  11
#define SV_POLE     12
#define SV_ZERO     13
#define SV_SPARAM   14
#endif

/* Dvec flags. */

#define VF_REAL     (1 << 0) /* The data is real. */
#define VF_COMPLEX  (1 << 1) /* The data is complex. */
#define VF_ACCUM    (1 << 2) /* writedata should save this vector. */
#define VF_PLOT     (1 << 3) /* writedata should incrementally plot it. */
#define VF_PRINT    (1 << 4) /* writedata should print this vector. */
#define VF_MINGIVEN (1 << 5) /* The v_minsignal value is valid. */
#define VF_MAXGIVEN (1 << 6) /* The v_maxsignal value is valid. */
#define VF_PERMANENT    (1 << 7) /* Don't garbage collect this vector. */

/* Grid types. */

/*
#define GRID_NONE   0
#define GRID_LIN    1
#define GRID_LOGLOG 2
#define GRID_XLOG   3
#define GRID_YLOG   4
#define GRID_POLAR  5
#define GRID_SMITH  6
*/

/* SMITHGRID is only a smith grid, SMITH transforms the data */
typedef enum {
    GRID_NONE = 0,
    GRID_LIN = 1,
    GRID_LOGLOG = 2, GRID_XLOG = 3, GRID_YLOG = 4,
    GRID_POLAR = 5,
    GRID_SMITH = 6,
    GRID_SMITHGRID = 7,

    GRID_DECLIN, GRID_DECLOG, GRID_DECOCT, GRID_DECDEC,
    GRID_LOGDEC, GRID_LOGOCT, GRID_LINDEC, GRID_LINOCT,
    GRID_OCTLIN, GRID_OCTLOG, GRID_OCTDEC, GRID_OCTOCT

} GRIDTYPE;

/* Plot types. */

/*
#define PLOT_LIN    0
#define PLOT_COMB   1
#define PLOT_POINT  2
*/

typedef enum {
    PLOT_LIN = 0, PLOT_COMB = 1, PLOT_POINT = 2
} PLOTTYPE;

/* The types for command completion keywords. Note that these constants
 * are built into cmdtab.c, so DON'T change them unless you want to
 * change all of the bitmasks in cp_coms.
 * Note that this is spice- and nutmeg- dependent.
 */

#define CT_FILENAME     0
#define CT_CKTNAMES     2
#define CT_COMMANDS     3
#define CT_DBNUMS       4
#define CT_DEVNAMES     5
#define CT_LISTINGARGS  6
#define CT_NODENAMES    7
#define CT_PLOT         8
#define CT_PLOTKEYWORDS 9
#define CT_RUSEARGS     10
#define CT_STOPARGS     11
#define CT_UDFUNCS      12
#define CT_VARIABLES    13
#define CT_VECTOR       14
#define CT_TYPENAMES    16

#endif


/* A (possibly multi-dimensional) data vector.  The data is represented
 * internally by a 1-d array.  The number of dimensions and the size
 * of each dimension is recorded, along with v_length, the total size of
 * the array.  If the dimensionality is 0 or 1, v_length is significant
 * instead of v_numdims and v_dims, and the vector is handled in the old
 * manner.
 */

#define MAXDIMS 8

typedef struct dvec {
    char *v_name;      /* Same as so_vname. */
    int v_type;  /* Same as so_vtype. */
    short v_flags;    /* Flags (a combination of VF_*). */
    double *v_realdata; /* Real data. */
    SPICE_complex *v_compdata;    /* Complex data. */
    double v_minsignal; /* Minimum value to plot. */
    double v_maxsignal; /* Maximum value to plot. */
    GRIDTYPE v_gridtype;     /* One of GRID_*. */
    PLOTTYPE v_plottype;     /* One of PLOT_*. */
    int v_length;      /* Length of the vector. */
    int v_rlength;    /* How much space we really have. */
    int v_outindex;  /* Index if writedata is building the vector. */
    int v_linestyle;    /* What line style we are using. */
    int v_color;        /* What color we are using. */
    char *v_defcolor;   /* The name of a color to use. */
    int v_numdims;      /* How many dims -- 0 = scalar (len = 1). */
    int v_dims[MAXDIMS];    /* The actual size in each dimension. */
    struct plot *v_plot;    /* The plot structure (if it has one). */
    struct dvec *v_next;    /* Link for list of plot vectors. */
    struct dvec *v_link2;   /* Extra link for things like print. */
    struct dvec *v_scale;   /* If this has a non-standard scale... */
} DataVector ;

#define isreal(v)   ((v)->v_flags & VF_REAL)
#define iscomplex(v)    ((v)->v_flags & VF_COMPLEX)

/* The information for a particular set of vectors that come from one
 * plot.
 */

typedef struct plot {
    char *pl_title;     /* The title card. */
    char *pl_date;      /* Date. */
    char *pl_name;      /* The plot name. */
    char *pl_typename;  /* Tran1, op2, etc. */
    struct dvec *pl_dvecs;  /* The data vectors in this plot. */
    struct dvec *pl_scale;  /* The "scale" for the rest of the vectors. */
    struct plot *pl_next;   /* List of plots. */
    wordlist *pl_commands;  /* Commands to execute for this plot. */
    struct variable *pl_env;/* The 'environment' for this plot. */
    char *pl_ccom;      /* The ccom struct for this plot. */
    BOOL pl_written;    /* Some or all of the vecs have been saved. */
    int pl_ndims;    /* Number of dimensions */
} PlotInfo ;

#endif /* FTEdata_h */

  /*
   *
   * types for IFnewUid
   *
   */

  #define UID_ANALYSIS 0x1
  #define UID_TASK 0x2
  #define UID_INSTANCE 0x4
  #define UID_MODEL 0x8
  #define UID_SIGNAL 0x10
  #define UID_OTHER 0x20


  /*
   * dataType values:
   *
   * Note:  These structures are put together by ORing together the
   *    appropriate bits from the fields below as is shown for the vector
   *    types.
   * IF_REQUIRED indicates that the parameter must be specified.
   *    The front end does not NEED to check for this, but can to save time,
   *    since failure to do so will cause the simulator to fail.
   * IF_SET indicates that the specified item is an input parameter.
   * IF_ASK indicates that the specified item is something the simulator
   *    can provide information about.
   * IF_SET and IF_ASK are NOT mutually exclusive.
   * if IF_SET and IF_ASK are both zero, it indicates a parameter that
   *    the simulator recoginizes are being a reasonable paremeter, but
   *    which this simulator does not implement.
   */

  #define IF_FLAG 0x1
  #define IF_INTEGER 0x2
  #define IF_REAL 0x4
  #define IF_COMPLEX 0x8
  #define IF_NODE 0x10
  #define IF_STRING 0x20
  #define IF_INSTANCE 0x40
  #define IF_PARSETREE 0x80

  /* indicates that for a query the integer field will have a selector
   * in it to pick a sub-field */
  #define IF_SELECT 0x800
  #define IF_VSELECT 0x400

  /* indicates a vector of the specified type */
  #define IF_DIAGRAM_GRAPH_NORETX  0x1000
  #define IF_DIAGRAM_CHART         0x2000
  #define IF_DIAGRAM_GRAPH         0x4000
  #define IF_DIAGRAM_ALL         ( IF_DIAGRAM_CHART | IF_DIAGRAM_GRAPH | IF_DIAGRAM_GRAPH_NORETX )
  #define RemoveDiagramType(x)   ( (x) & ~IF_DIAGRAM_ALL )
  #define IF_VECTOR 0x8000

  #define IF_FLAGVEC     (IF_FLAG|IF_VECTOR)
  #define IF_INTVEC      (IF_INTEGER|IF_VECTOR)
  #define IF_REALVEC     (IF_REAL|IF_VECTOR)
  #define IF_CPLXVEC     (IF_COMPLEX|IF_VECTOR)
  #define IF_NODEVEC     (IF_NODE|IF_VECTOR)
  #define IF_STRINGVEC   (IF_STRING|IF_VECTOR)
  #define IF_INSTVEC     (IF_INSTANCE|IF_VECTOR)

  #define IF_REQUIRED 0x4000

  #define IF_VARTYPES 0x80ff

  #define IF_SET 0x2000
  #define IF_ASK 0x1000

  /* If you AND with IF_UNIMP_MASK and get 0, it is recognized, but not
   * implemented
   */
  #define IF_UNIMP_MASK (~0xfff)

  /* Used by sensetivity to check if a parameter is or is not useful */
  #define IF_REDUNDANT	0x0010000
  #define IF_PRINCIPAL	0x0020000
  #define IF_AC		0x0040000
  #define IF_AC_ONLY	0x0080000
  #define IF_NOISE	0x0100000
  #define IF_NONSENSE	0x0200000

  #define IF_SETQUERY	0x0400000
  #define IF_ORQUERY	0x0800000
  #define IF_CHKQUERY	0x1000000

  /* For "show" command: do not print value in a table by default */
  #define IF_UNINTERESTING 0x2000000


  /*
   * Structure:    IFvalue
   *
   * structure used to pass the values corresponding to the above
   * dataType.  All types are passed in one of these structures, with
   * relatively simple rules concerning the handling of the structure.
   *
   * whoever makes the subroutine call allocates a single instance of the
   * structure.  The basic data structure belongs to you, and you
   * should arrange to free it when appropriate.
   *
   * The responsibilities of the data supplier are:
   * Any vectors referenced by the structure are to be malloc()'d
   * and are assumed to have been turned over to the recipient and
   * thus should not be re-used or free()'d.
   *
   * The responsibilities of the data recipient are:
   * scalar valued data is to be copied by the recipient
   * vector valued data is now the property of the recipient,
   * and must be free()'d when no longer needed.
   *
   * Character strings are a special case:  Since it is assumed
   * that all character strings are directly descended from input
   * tokens, it is assumed that they are static, thus nobody
   * frees them until the circuit is deleted, when the front end
   * may do so.
   *
   * EVERYBODY's responsibility is to be SURE that the right data
   * is filled in and read out of the structure as per the IFparm
   * structure describing the parameter being passed.  Programs
   * neglecting this rule are fated to die of data corruption
   *
   */

  /*
   * and of course, the standard complex data type
   */
  typedef struct sIFcomplex {
      double real;
      double imag;
  } IFcomplex;


  typedef union uIFvalue {
      int iValue;             /* integer or flag valued data */
      double rValue;          /* real valued data */
      IFcomplex cValue;       /* complex valued data */
      char *sValue;           /* string valued data */
      IFuid uValue;           /* UID valued data */
      IFnode nValue;          /* node valued data */
      IFparseTree *tValue;    /* parse tree */
      struct {
          int numValue;       /* length of vector */
          union {
              int *iVec;      /* pointer to integer vector */
              double *rVec;   /* pointer to real vector */
              IFcomplex *cVec;/* pointer to complex vector */
              char **sVec;    /* pointer to string vector */
              IFuid *uVec;    /* pointer to UID vector */
              IFnode *nVec;   /* pointer to node vector */
          }vec;
      }v;
  } IFvalue;

  #ifdef IIT
  extern char * EXPORT spice_malloc(InstanceHandle inst, int num);
  #endif

  /*
   * structure:  IFdevice
   *
   * This structure contains all the information available to the
   * front end about a particular device.  The simulator will
   * present the front end with an array of pointers to these structures
   * which it will use to determine legal device types and parameters.
   *
   * Note to simulators:  you are passing an array of pointers to
   * these structures, so you may in fact make this the first component
   * in a larger, more complex structure which includes other data
   * which you need, but which is not needed in the common
   * front end interface.
   *
   */

  /* gtri - modify - wbk - 10/11/90 - add entries to hold data required */
  /*                                  by new parser                     */

  typedef struct sIFdevice {
      char *name;                 /* name of this type of device */
      char *description;          /* description of this type of device */

      #if defined(IIT) || !defined(XSPICE)
          int *terms;                 /* number of terminals on this device */
          int *numNames;              /* number of names in termNames */
      #else
          int terms;                  /* number of terminals on this device */
          int numNames;               /* number of names in termNames */
      #endif
      char **termNames;           /* pointer to array of pointers to names */
				  /* array contains 'terms' pointers */


      #if defined(IIT) || !defined(XSPICE)
          int *numInstanceParms;      /* number of instance parameter descriptors */
      #else
          int numInstanceParms;       /* number of instance parameter descriptors */
      #endif
      IFparm *instanceParms;      /* array  of instance parameter descriptors */

      #if defined(IIT) || !defined(XSPICE)
          int *numModelParms;         /* number of model parameter descriptors */
      #else
          int numModelParms;          /* number of model parameter descriptors */
      #endif
      IFparm *modelParms;         /* array  of model parameter descriptors */

      #if defined(IIT) || !defined(XSPICE)
          int flags;			/* DEV_ */
      #endif

      #ifdef XSPICE
          void (*cm_func)(Mif_Private_t *);  /* pointer to code model function */

          int num_conn;               /* number of code model connections */
          Mif_Conn_Info_t  *conn;     /* array of connection info for mif parser */

          int num_param;              /* number of parameters = numModelParms */
          Mif_Param_Info_t *param;    /* array of parameter info for mif parser */

          int num_inst_var;              /* number of instance vars = numInstanceParms */
          Mif_Inst_Var_Info_t *inst_var; /* array of instance var info for mif parser */
      #endif

  } IFdevice;
  /* gtri - end - wbk - 10/11/90 */

  #ifdef XSPICE
     #define IFdevice_Berkeley_default_for_XSPICE_params \
             NULL, 0, NULL, 0, NULL, 0, NULL
  #else
     #define IFdevice_Berkeley_default_for_XSPICE_params 
  #endif

  /*
   * Structure: IFsimulator
   *
   * This is what we have been leading up to all along.
   * This structure describes a simulator to the front end, and is
   * returned from the SIMinit command to the front end.
   * This is where all those neat structures we described in the first
   * few hundred lines of this file come from.
   *
   */
  typedef enum FileMode    {EXT_NONE, EXT_OUT, EXT_ERR} FileMode;
  typedef enum ExecuteMode {EXE_NONE, EXE_CLI, EXE_DOT_OPTION} ExecuteMode;
  typedef enum ExecuteResult {EXER_IGNORED, EXE_FAIL, EXER_SUCCEED} ExecuteResult;

  int EXPORT GetNodeAndCompList(CKTcircuit*             ckt,
                                ANALYSIS_TYPE           analysis_type,
                                AnalysisNode**          node_array,
                                int*                    num_nodes,
                                AnalysisComponents**    component_array,
                                int*                    num_components
                               );

  struct circ* EXPORT GetCircuitList(InstanceHandle handle);
  struct circ* EXPORT GetCurrentCircuit(InstanceHandle handle);

  typedef struct sIFsimulator {
      char *simulator;                /* the simulator's name */
      char *description;              /* description of this simulator */
      char *version;                  /* version or revision level of simulator*/

      int numDevices;                 /* number of device types supported */
      IFdevice **devices;             /* array of device type descriptors */

      int numAnalyses;                /* number of analysis types supported */
      IFanalysis **analyses;          /* array of analysis type descriptors */

      int numNodeParms;               /* number of node parameters supported */
      IFparm *nodeParms;              /* array of node parameter descriptors */

      int numSpecSigs;        /* number of special signals legal in parse trees */
      char **specSigs;        /* names of special signals legal in parse trees */

      /* create new circuit */
      IITEXPORT(int, newCircuit)(InstanceHandle handle,
                                 GENERIC ** ckt
                                );

      /* destroy old circuit's data structures*/
      IITEXPORT(int, deleteCircuit)(GENERIC * ckt);

      /* create new node */
      IITEXPORT(int, newNode)(GENERIC*  ckt,
                              GENERIC** node,
                              IFuid name
                             );

      /* create ground node */
      IITEXPORT(int, groundNode)(GENERIC*  ckt,
                                 GENERIC** node,
                                 IFuid     name
                                );

      /* bind a node to a terminal */
      IITEXPORT(int, bindNode)(GENERIC* ckt,
                               GENERIC* instance,
                               int      terminal,
                               GENERIC* node
                              );

      /* find a node by name */
      IITEXPORT(int, findNode)(GENERIC*  ckt,
                               GENERIC** node,
                               IFuid     name
                              );

      /* find the node attached to a terminal */
      IITEXPORT(int, instToNode)(GENERIC*  ckt,
                                 GENERIC*  instance,
                                 int       terminal,
                                 GENERIC** node,
                                 IFuid*    nodeName
                                );

      /* set a parameter on a node */
      IITEXPORT(int, setNodeParm)(GENERIC* ckt,
                                  GENERIC* node,
                                  int      param_number,
                                  IFvalue* value,
                                  IFvalue* selector
                                 );

      /* ask a question about a node */
      IITEXPORT(int, askNodeQuest)(GENERIC* ckt,
                                   GENERIC* node,
                                   int      param_number,
                                   IFvalue* value,
                                   IFvalue* selector
                                  );

      /* delete a node from the circuit */
      IITEXPORT(int, deleteNode)(GENERIC* ckt,
                                 GENERIC* node
                                );

      /* create new instance */
      IITEXPORT(int, newInstance)(GENERIC*   ckt,
                                  GENERIC*   model,
                                  GENERIC**  instance,
                                  IFuid      name
                                 );

      /* set a parameter on an instance */
      IITEXPORT(int, setInstanceParm)(GENERIC* ckt,
                                      GENERIC* instance,
                                      int      param_number,
                                      IFvalue* value,
                                      IFvalue* selector
                                     );

      /* ask a question about an instance */
      IITEXPORT(int, askInstanceQuest)(GENERIC*  ckt,
                                       GENERIC*  instance,
                                       int       which,
                                       IFvalue*  value,
                                       IFvalue*  selector
                                      );

      /* find a specific instance */
      IITEXPORT(int, findInstance)(GENERIC*   ckt,
                                   int*       type,
                                   GENERIC**  instance,
                                   IFuid      name,
                                   GENERIC*   model,
                                   IFuid      model_name
                                  );

      /* delete an instance from the circuit */
      IITEXPORT(int, deleteInstance)(GENERIC* ckt,
                                     GENERIC* instance
                                    );

      /* create new model */
      IITEXPORT(int, newModel)(GENERIC*  ckt,
                               int       type,
                               GENERIC** model,
                               IFuid     name
                              );

      /* set a parameter on a model */
      IITEXPORT(int, setModelParm)(GENERIC*  ckt,
                                   GENERIC*  model,
                                   int       param_number,
                                   IFvalue*  value,
                                   IFvalue*  selector
                                  );

      /* ask a questions about a model */
      IITEXPORT(int, askModelQuest)(GENERIC*  ckt,
                                    GENERIC*  model,
                                    int       which,
                                    IFvalue*  value,
                                    IFvalue*  selector
                                   );

      /* find a specific model */
      IITEXPORT(int, findModel)(GENERIC*  ckt,
                                int*      type,
                                GENERIC** model,
                                IFuid     name
                               );

      /* delete a model from the circuit*/
      IITEXPORT(int, deleteModel)(GENERIC* ckt,
                                  GENERIC* model
                                 );

      /* create a new task */
      IITEXPORT(int, newTask)(GENERIC*  ckt,
                              GENERIC** task,
                              IFuid     name
                             );

      /* create new analysis within a task */
      IITEXPORT(int, newAnalysis)(GENERIC*  ,
                                  int       ,
                                  IFuid,
                                  GENERIC** ,
                                  GENERIC*
                                 );

      /* set a parameter on an analysis  */
      IITEXPORT(int, setAnalysisParm)(GENERIC* ,
                                      GENERIC* ,
                                      int      ,
                                      IFvalue* ,
                                      IFvalue*
                                     );

      /* ask a question about an analysis */
      IITEXPORT(int, askAnalysisQuest)(GENERIC* ,
                                       GENERIC* ,
                                       int      ,
                                       IFvalue* ,
                                       IFvalue*
                                      );

      /* find a specific analysis */
      IITEXPORT(int, findAnalysis)(GENERIC*   ,
                                   int*       ,
                                   GENERIC**  ,
                                   IFuid      ,
                                   GENERIC*   ,
                                   IFuid
                                  );

      /* find a specific task */
      IITEXPORT(int, findTask)(GENERIC*   ,
                               GENERIC**  ,
                               IFuid
                              );

      /* delete a task */
      IITEXPORT(int, deleteTask)(GENERIC* ,
                                 GENERIC*
                                );


      IITEXPORT(int, doAnalyses)(GENERIC*  ,
                                 int       ,
                                 GENERIC*
                                );

  #if defined(IIT) || !defined(XSPICE)
      IITEXPORT(char *, nonconvErr)(GENERIC*,char *); /* return nonconvergence error */
  #endif

  #ifdef EWB_IIT
	  IITEXPORT(int, getMatrixElement)(GENERIC*, GENERIC*, GENERIC*, double**);
	  IITEXPORT(int, getVoltage)(GENERIC*, GENERIC*, GENERIC*, double*);
	  IITEXPORT(int, addVoltage)(GENERIC*, GENERIC*, double);
	  IITEXPORT(int, getCurrent)(GENERIC*, GENERIC*, double*);
	  IITEXPORT(int, addCurrent)(GENERIC*, GENERIC*, GENERIC*, double);
	  IITEXPORT(int, setBreakPoint)(GENERIC*, double);
	  IITEXPORT(int, setRelativeBreakPoint)(GENERIC*, double);
	  IITEXPORT(int, changeCapacitorValue)(GENERIC*, GENERIC*, double);
	  IITEXPORT(int, changeInductorValue)(GENERIC*, GENERIC*, double);
	  IITEXPORT(int, isFirstIteration)(GENERIC*, int*);
	  IITEXPORT(int, setMaxStep)(GENERIC*, double);
  #endif

#ifdef IIT
      IITEXPORT(int, executeShellCmd)(InstanceHandle handle,
                                      FileMode       mode,
                                      char*          command
                                     );

      IITEXPORT(int, GetNodeAndCompList)(
                               CKTcircuit*             ckt,
                               ANALYSIS_TYPE           analysis_type,
                               AnalysisNode**          node_array,
                               int*                    num_nodes,
                               AnalysisComponents**    component_array,
                               int*                    num_components
                             );

      IITEXPORT(struct circ*, GetCircuitList)(InstanceHandle handle);
      IITEXPORT(struct circ*, GetCurrentCircuit)(InstanceHandle handle);
#endif
  } IFsimulator;


typedef struct PlotterInfo
{
        double *xlims, *ylims;          /* The size of the screen. */
        char *xname, *plotname;         /* What to label things. */
    	char *hcopy;                    /* The raster file. */
        int nplots;                     /* How many plots there will be. */
        double xdelta, ydelta;          /* Line increments for the scale. */
        int gridtype;                   /* The grid type */
        int plottype;                   /*  and the plot type. */
        char *xlabel, *ylabel;          /* Labels for axes. */
        int xtype, ytype;               /* The types of the data graphed. */
        char *pname;
        char *commandline;              /* For xi_zoomdata() */
} PlotterInfo;


  /*
   * Structure: IFfrontEnd
   *
   * This structure provides the simulator with all the information
   * it needs about the front end.  This is the entire set of
   * front end and back end related routines the simulator
   * should know about.
   *
   */

  typedef struct sIFfrontEnd {
      /* create a new UID in the circuit */
      IITEXPORT(int, IFnewUid)(GENERIC*,IFuid*,IFuid,char*,int,GENERIC**);

      /* create a new UID in the circuit */
      IITEXPORT(int, IFdelUid)(GENERIC*,IFuid,int);

      /* should we stop now? */
      IITEXPORT(int, IFpauseTest)(InstanceHandle inst);

      /* what time is it? */
      IITEXPORT(double, IFseconds)(InstanceHandle inst);

      /* output an error or warning message */
      IITEXPORT(int, IFerror)(InstanceHandle inst, int,char*,IFuid*);

      /* start pointwise output plot */
      IITEXPORT(int, OUTpBeginPlot)(GENERIC*,GENERIC*,IFuid,IFuid,int,
                                    int,IFuid*,int,GENERIC**);
                              
      /* data for pointwise plot */
      IITEXPORT(int, OUTpData)(InstanceHandle inst,GENERIC*,IFvalue*,IFvalue*);
                              
      /* start windowed output plot */
      IITEXPORT(int, OUTwBeginPlot)(InstanceHandle inst, GENERIC*,GENERIC*,IFuid,IFuid,int,
                                   int,IFuid*,int,GENERIC**);
                              
      /* independent vector for windowed plot */
      IITEXPORT(int, OUTwReference)(InstanceHandle inst, GENERIC*,IFvalue*,GENERIC**);
                              
      /* data for windowed plot */
      IITEXPORT(int, OUTwData)(InstanceHandle inst, GENERIC*,int,IFvalue*,GENERIC*);
                              
      /* signal end of windows */
      IITEXPORT(int, OUTwEnd)(InstanceHandle inst, GENERIC*);

      /* end of plot */
      IITEXPORT(int, OUTendPlot)(InstanceHandle inst, GENERIC*);
                              
      /* start nested domain */
      IITEXPORT(int, OUTbeginDomain)(InstanceHandle inst, GENERIC*,char *,int,IFvalue*);
                              
      /* end nested domain */
      IITEXPORT(int, OUTendDomain)(InstanceHandle inst, GENERIC*);
                              
      IITEXPORT(int, OUTattributes)(InstanceHandle inst, GENERIC *,char*,int,IFvalue*);

      #ifdef EWB_IIT
      /* setup devices */
	  IITEXPORT(int, EWBsetup)(void);

      /* load devices */
	  IITEXPORT(int, EWBload)(double timeStep, double time);

      /* load devices (ac) */
	  IITEXPORT(int, EWBacload)(double freq);

      /* accept timepoint */
	  IITEXPORT(int, EWBaccept)(double time, double *bp);

      /* convergence test */
	  IITEXPORT(int, EWBconvTest)(int *noncon);

      /* convert the name of a SPICE  to a EWB node */
      IITEXPORT(char*, EWBconvNode)(char* nodename);
      #endif

     #ifdef IIT
      /* Access EWB's message table */
      IITEXPORT(char*, EWBMsg)(InstanceHandle handle, unsigned long);
     #endif

     #ifdef IIT
      IITEXPORT(int, shellCmdOutput)(InstanceHandle handle, FileMode mode, char* command);
     #endif

      IITEXPORT(ExecuteResult, cmdExecute)(InstanceHandle handle, ExecuteMode mode, char* command);

      /* Initialize the grap*/
      IITEXPORT(int, graphInit)(InstanceHandle handle, void** context, PlotterInfo* pi);

      /* Graph a datavector */
      IITEXPORT(int, graphPoints)(InstanceHandle handle, void* context, DataVector* v, DataVector* xs, int nostart);

      /* Uninitialize the graph */
      IITEXPORT(int, graphCleanup)(InstanceHandle handle, void** context);

      /* Register a new UID in the circuit */
      IITEXPORT(int, RegisterUid)(InstanceHandle handle, IFuid* uid, int type);

      /* Unregister a new UID in the circuit */
      IITEXPORT(int, UnRegisterUid)(InstanceHandle handle, IFuid* uid);

      /* Allocate memory */
      IITEXPORT(void*, Malloc)(InstanceHandle handle, int size);

      /* Reallocate memory */
      IITEXPORT(void*, ReAlloc)(InstanceHandle handle, void* mem, int newsize);

      /* Free memory */
      IITEXPORT(void, Free)(InstanceHandle handle, void* uid);

  } IFfrontEnd;

  char* XSpiceMsg(InstanceHandle handle, unsigned long msgid);

  /* flags for the first argument to IFerror */
  #define ERR_WARN  0x1
  #define ERR_FATAL 0x2
  #define ERR_PANIC 0x4
  #define ERR_INFO  0x8

      /* valid values for the second argument to doAnalyses */

      /* continue the analysis from where we left off */
  #define RESUME 0
      /* start everything over from the beginning of this task*/
  #define RESTART 1
      /* abandon the current analysis and go on the the next in the task*/
  #define SKIPTONEXT 2

  #define OUT_SCALE_LIN   1
  #define OUT_SCALE_LOG   2

#endif /*IFSIMULATOR*/
//insert file>> #include "gendefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef GEN
#define GEN

//insert file>> #include "instance.h"
//insert file>> #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/


        /* definitions used to describe generic devices */

/* information used to describe a single instance */

typedef struct sGENinstance {
    #ifdef IIT
    InstanceHandle m_instance_handle;
    #endif

    struct sGENmodel *GENmodPtr;    /* backpointer to model */
    struct sGENinstance *GENnextInstance;   /* pointer to next instance of 
                                             * current model*/
    IFuid GENname;  /* pointer to character string naming this instance */
    int GENstate;   /* state index number */
    int GENnode1;   /* appropriate node numbers */
    int GENnode2;   /* appropriate node numbers */
    int GENnode3;   /* appropriate node numbers */
    int GENnode4;   /* appropriate node numbers */
    int GENnode5;   /* appropriate node numbers */
} GENinstance ;


/* Generic circuit data */

typedef void GENcircuit;

/* per model data */

typedef struct sGENmodel {       /* model structure for a resistor */
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif

    int GENmodType; /* type index of this device type */
    struct sGENmodel *GENnextModel; /* pointer to next possible model in 
                                     * linked list */
    GENinstance * GENinstances; /* pointer to list of instances that have this
                                 * model */
    IFuid GENmodName;       /* pointer to character string naming this model */
} GENmodel;

#endif /*GEN*/
//insert file>> #include "inpptree.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Wayne A. Christopher, U. C. Berkeley CAD Group 
**********/

/*
 *   faustus@cad.berkeley.edu, ucbvax!faustus
 *
 * These definitions specify the format of the parse tree parameter type.
 * The first four are the elements of IFparseTree, defined in IFsim.h.
 */


#ifndef INP_PARSE
#define INP_PARSE

//insert file>> #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/


/* This is the parameter value passed to the device routines.  To get the
 * value of the function, where tree is a pointer to the INPparseTree,
 * result is a pointer to where you want the result, derivs is a pointer to
 * an vector of numVars doubles, and vals is a pointer to the selected
 * elements from the RHS, do
 *  tree->p.IFeval(inst,&tree, result, vals, derivs)
 * This routine will return either OK, E_PARMVAL, or E_PANIC.  If an error
 * is reported the eval function will have printed something to standard
 * out before returning.
 */

typedef struct INPparseTree {
    IFparseTree p;
    struct INPparseNode *tree;  /* The real stuff. */
    struct INPparseNode **derivs;   /* The derivative parse trees. */
} INPparseTree;

/* This is what is passed as the actual parameter value.  The fields will all
 * be filled in as needed.
 *
 * Values with names like v(something) and i(something) are treated specially.
 * They are considered voltages at nodes and branch currents through
 * voltage sources, respectively.  The corresponding parameters will be of
 * type IF_NODE and IF_INSTANCE, respectively.
 */

typedef double (*INPparseNode_function_t)(InstanceHandle,double,...);

typedef struct INPparseNode {
    int type;           /* One of PT_*, below. */
    struct INPparseNode *left;  /* Left operand, or single operand. */
    struct INPparseNode *right; /* Right operand, if there is one. */
    double constant;        /* If INP_CONSTANT. */
    int valueIndex;         /* If INP_VAR, index into vars array. */
    char *funcname;         /* If INP_FUNCTION, name of function, */
    int funcnum;            /* ... one of PTF_*, */
    INPparseNode_function_t function;       /* ... and pointer to the function. */
} INPparseNode;

/* These are the possible types of nodes we can have in the parse tree.  The
 * numbers for the ops 1 - 5 have to be the same as the token numbers,
 * below.
 */

#define PT_PLACEHOLDER  0       /* For i(something) ... */
#define PT_PLUS     1
#define PT_MINUS    2
#define PT_TIMES    3
#define PT_DIVIDE   4
#define PT_POWER    5
#define PT_FUNCTION 6
#define PT_CONSTANT 7
#define PT_VAR      8
#define PT_COMMA    10

/* These are the functions that we support. */

#define PTF_ACOS    0
#define PTF_ACOSH   1
#define PTF_ASIN    2
#define PTF_ASINH   3
#define PTF_ATAN    4
#define PTF_ATANH   5
#define PTF_COS     6
#define PTF_COSH    7
#define PTF_EXP     8
#define PTF_LN      9
#define PTF_LOG     10
#define PTF_SIN     11
#define PTF_SINH    12
#define PTF_SQRT    13
#define PTF_TAN     14
#define PTF_TANH    15
#define PTF_UMINUS  16
#define PTF_ABS		17
#define PTF_SGN		18
#define PTF_USTEP	19
#define PTF_URAMP	20

/* The following things are used by the parser -- these are the token types the
 * lexer returns.
 */

#define TOK_END         0
#define TOK_PLUS        1
#define TOK_MINUS       2
#define TOK_TIMES       3
#define TOK_DIVIDE      4
#define TOK_POWER       5
#define TOK_UMINUS      6
#define TOK_LPAREN      7
#define TOK_RPAREN      8
#define TOK_VALUE       9
#define TOK_COMMA       10

/* And the types for value tokens... */

#define TYP_NUM         0
#define TYP_STRING      1
#define TYP_PNODE       2

/* A parser stack element. */

typedef struct PTelement {
    int token;
    int type;
    union {
        char *string;
        double real;
        INPparseNode *pnode;
    } value;
} PTelement ;

#define PT_STACKSIZE 200

/* These are things defined in PTfunctions.c */

extern double PTplus(InstanceHandle inst,double,double);
extern double PTminus(InstanceHandle inst,double,double);
extern double PTtimes(InstanceHandle inst,double,double);
extern double PTdivide(InstanceHandle inst,double,double);
extern double PTpower(InstanceHandle inst,double,double);
extern double PTacos(InstanceHandle inst,double);
extern double PTabs(InstanceHandle inst,double);
extern double PTacosh(InstanceHandle inst,double);
extern double PTasin(InstanceHandle inst,double);
extern double PTasinh(InstanceHandle inst,double);
extern double PTatan(InstanceHandle inst,double);
extern double PTatanh(InstanceHandle inst,double);
extern double PTcos(InstanceHandle inst,double);
extern double PTcosh(InstanceHandle inst,double);
extern double PTexp(InstanceHandle inst,double);
extern double PTln(InstanceHandle inst,double);
extern double PTlog(InstanceHandle inst,double);
extern double PTsgn(InstanceHandle inst,double);
extern double PTsin(InstanceHandle inst,double);
extern double PTsinh(InstanceHandle inst,double);
extern double PTsqrt(InstanceHandle inst,double);
extern double PTtan(InstanceHandle inst,double);
extern double PTtanh(InstanceHandle inst,double);
extern double PTustep(InstanceHandle inst,double);
extern double PTuramp(InstanceHandle inst,double);
extern double PTuminus(InstanceHandle inst,double);

/* And in IFeval.c */

#ifdef MSVC
extern int EXPORT IFeval(InstanceHandle inst, struct sIFparseTree* tree,
	double gmin, double *result, double *vals, double *derivs);
#else
extern int EXPORT IFeval(InstanceHandle inst, struct sIFparseTree*, double, double*,
	double*, double*);
#endif

#endif


struct INPtab {
    char *t_ent;
    struct INPtab *t_next;
};

struct INPnTab {
    char *t_ent;
    GENERIC* t_node;
    struct INPnTab *t_next;
};

typedef struct sINPtables{
    struct INPtab **INPsymtab;
    struct INPnTab **INPtermsymtab;
    int INPsize;
    int INPtermsize;
    GENERIC *defAmod;
    GENERIC *defBmod;
    GENERIC *defCmod;
    GENERIC *defDmod;
    GENERIC *defEmod;
    GENERIC *defFmod;
    GENERIC *defGmod;
    GENERIC *defHmod;
    GENERIC *defImod;
    GENERIC *defJmod;
    GENERIC *defKmod;
    GENERIC *defLmod;
    GENERIC *defMmod;
    GENERIC *defNmod;
    GENERIC *defOmod;
    GENERIC *defPmod;
    GENERIC *defQmod;
    GENERIC *defRmod;
    GENERIC *defSmod;
    GENERIC *defTmod;
    GENERIC *defUmod;
    GENERIC *defVmod;
    GENERIC *defWmod;
    GENERIC *defYmod;
    GENERIC *defZmod;
} INPtables;

typedef struct card{
    int linenum;
    char *line;
    char *error;
    struct card *nextcard;
    struct card *actualLine;
} card;

/* structure used to save models in after they are read during pass 1 */
typedef struct sINPmodel{
    IFuid INPmodName;   /* uid of model */
    int INPmodType;     /* type index of device type */
    struct sINPmodel *INPnextModel;  /* link to next model */
    int INPmodUsed;     /* flag to indicate it has already been used */
    card *INPmodLine;   /* pointer to line describing model */
    GENERIC *INPmodfast;   /* high speed pointer to model for access */
} INPmodel;

/* listing types - used for debug listings */
#define LOGICAL 1
#define PHYSICAL 2

int EXPORT IFnewUid(GENERIC*,IFuid*,IFuid,char*,int,GENERIC**);
int EXPORT IFdelUid(GENERIC*,IFuid,int);
int INPaName(InstanceHandle inst, char*,union uIFvalue*,GENERIC*,int*,char*,GENERIC**,struct sIFsimulator*,int*,
        union uIFvalue*);
int INPapName(GENERIC*,int,GENERIC*,char*,union uIFvalue*);
void INPcaseFix(InstanceHandle inst, char*);
char * INPdevParse(InstanceHandle inst, char**,GENERIC*,int,GENERIC*,double*,int*,INPtables*);
char *INPdomodel(InstanceHandle inst, GENERIC *,card*, INPtables*);
void INPdoOpts(InstanceHandle inst, GENERIC*,GENERIC*,card*,INPtables*);
#ifdef XSPICE_BUILD
char *INPerrCat(InstanceHandle inst, char *, char *);
#endif
char *INPerror(InstanceHandle inst, int type);
double INPevaluate(InstanceHandle inst, char**,int*,int);
char * INPfindLev(InstanceHandle inst, char*,int*);
char * INPgetMod(InstanceHandle inst, GENERIC*,char*,INPmodel**,INPtables*);
int INPgetTok(InstanceHandle inst, char**,char**,int);
void INPgetTree(InstanceHandle inst, char**,INPparseTree**,GENERIC*,INPtables*);
union uIFvalue * INPgetValue(InstanceHandle inst, GENERIC*,char**,int,INPtables*);
int INPgndInsert(InstanceHandle inst, GENERIC*,char**,INPtables*,GENERIC**);
int INPinsert(InstanceHandle inst, char**,INPtables*);
int INPremove(InstanceHandle inst, char*,INPtables*);
int INPlookMod(InstanceHandle inst, char*);
int INPmakeMod(InstanceHandle inst, char*,int,card*);
#ifdef XSPICE_BUILD
char *INPmkTemp(InstanceHandle inst, char*);
#endif
void INPpas1(InstanceHandle inst, GENERIC*,card*,INPtables*);
void INPpas2(InstanceHandle inst, GENERIC*,card*,INPtables*,GENERIC *);
int INPpName(InstanceHandle inst, char*,union uIFvalue*,GENERIC*,int,GENERIC*);
int INPtermInsert(InstanceHandle inst, GENERIC*,char**,INPtables*,GENERIC**);
int INPmkTerm(InstanceHandle inst, GENERIC*,char**,INPtables*,GENERIC**);
int INPtypelook(InstanceHandle,char*);
void INP2B(GENERIC*,INPtables*,card*);
void INP2C(GENERIC*,INPtables*,card*);
void INP2D(GENERIC*,INPtables*,card*);
void INP2E(GENERIC*,INPtables*,card*);
void INP2F(GENERIC*,INPtables*,card*);
void INP2G(GENERIC*,INPtables*,card*);
void INP2H(GENERIC*,INPtables*,card*);
void INP2I(GENERIC*,INPtables*,card*);
void INP2J(GENERIC*,INPtables*,card*);
void INP2K(GENERIC*,INPtables*,card*);
void INP2L(GENERIC*,INPtables*,card*);
void INP2M(GENERIC*,INPtables*,card*);
void INP2O(GENERIC*,INPtables*,card*);
void INP2Q(GENERIC*,INPtables*,card*,GENERIC*);
void INP2R(GENERIC*,INPtables*,card*);
void INP2S(GENERIC*,INPtables*,card*);
void INP2T(GENERIC*,INPtables*,card*);
void INP2U(GENERIC*,INPtables*,card*);
void INP2V(GENERIC*,INPtables*,card*);
void INP2W(GENERIC*,INPtables*,card*);
void INP2Z(GENERIC*,INPtables*,card*);
int INP2dot(GENERIC*,INPtables*,card*,GENERIC*,GENERIC*);
INPtables *INPtabInit(InstanceHandle inst, int);
void INPkillMods(InstanceHandle inst);
void INPtabEnd(InstanceHandle inst, INPtables *);
int INPremTerm(InstanceHandle inst,char *token,INPtables *tab);
int INPgetUTok(InstanceHandle inst, char** line, char** token, int gobble);
int INPgetStr(InstanceHandle inst,char **line, char **token, int gobble);

#endif /*INP*/

struct line {
    int li_linenum;
    char *li_line;
    char *li_error;
    struct line *li_next;
    struct line *li_actual;
} ;

/* Listing types. */

#define LS_LOGICAL  1
#define LS_PHYSICAL 2
#define LS_DECK  3

#endif /* FTEinput_h */


/*
The following data is used in implementing various enhancements made to the
simulator.  The main struct is dynamically allocated in ckt so that incremental additions
can be made more easily without the need to recompile multiple modules.
Allocation and initialization is done in CKTinit.c which should be the only
module needed to recompile after additions are made here.
*/


typedef enum Enh_Conv_Source_t {
    ENH_ANALOG_NODE,            /* An analog node */
    ENH_EVENT_NODE,             /* An event-driven node */
    ENH_ANALOG_BRANCH,          /* A branch current */
    ENH_ANALOG_INSTANCE,        /* An analog instance */
    ENH_EVENT_INSTANCE,         /* An event-driven instance */
    ENH_HYBRID_INSTANCE,        /* A hybrid (analog/event-driven) instance */
} Enh_Conv_Source_t;


typedef struct Enh_Bkpt_t {
   double           current;    /* The current dynamic breakpoint time */
   double           last;       /* The last used dynamic breakpoint time */
} Enh_Bkpt_t;

typedef struct Enh_Ramp_t {
    double           ramptime;    /* supply ramping time specified on .options */
} Enh_Ramp_t;

typedef struct Enh_Conv_Debug_t {
    Mif_BOOLEAN_t    last_NIiter_call;  /* True if this is the last call to NIiter() */
    Mif_BOOLEAN_t    report_conv_probs; /* True if conv test functions should send debug info */
} Enh_Conv_Debug_t;


typedef struct Enh_Conv_Limit_t {
    Mif_BOOLEAN_t    enabled;           /* True if convergence limiting enabled on code models */
    double           abs_step;          /* Minimum limiting step size */
    double           step;              /* Fractional step amount */
} Enh_Conv_Limit_t;


typedef struct Enh_Rshunt_t {
    Mif_BOOLEAN_t    enabled;      /* True if rshunt option used */
    double           gshunt;       /* 1.0 / rshunt */
    int              num_nodes;    /* Number of nodes in matrix */
    double           **diag;       /* Pointers to matrix diagonals */
} Enh_Rshunt_t;


typedef struct Enh_Ckt_Data_t {
    Enh_Bkpt_t       breakpoint;   /* Data used by dynamic breakpoints */
    Enh_Ramp_t       ramp;         /* New options added to simulator */
    Enh_Conv_Debug_t conv_debug;   /* Convergence debug info dumping data */
    Enh_Conv_Limit_t conv_limit;   /* Convergence limiting info */
    Enh_Rshunt_t     rshunt_data;  /* Shunt conductance from nodes to ground */
} Enh_Ckt_Data_t;



void ENHreport_conv_prob(Enh_Conv_Source_t type, char *name, char *msg);
struct line *ENHtranslate_poly(InstanceHandle inst, struct line *deck);


#endif /* ENH_HEADER */
//insert file>> #include "ipc.h"
/* $Id: IPC.h,v 1.1 91/12/19 16:22:43 bill Exp $
 *
 */
/*============================================================================
FILE    IPC.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Steve Tynor

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    Provides compatibility for the new SPICE simulator to both the MSPICE user
    interface and BCP (via ATESSE v.1 style AEGIS mailboxes) and the new ATESSE
    v.2 Simulator Interface and BCP (via Bsd Sockets).

INTERFACES


REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

============================================================================*/

#ifndef IPC_DEFINED 
#define IPC_DEFINED 


#define  IPC_MAX_LINE_LEN       80
#define  IPC_MAX_PATH_LEN      256

/* Known socket port for server and client to communicate: */
#define SOCKET_PORT   1064

/* Recognition character for Beginning Of Line of message: */
#define BOL_CHAR  '\\'

/* Length (in bytes) of a socket message header:                             */
#define SOCK_MSG_HDR_LEN 5


typedef int Ipc_BOOLEAN_t;

#define IPC_FALSE 0
#define IPC_TRUE  1
   
typedef struct {   /* Don't change this type!  It is cast elsewhere */
   double real;
   double imag;
} Ipc_Complex_t;

/*---------------------------------------------------------------------------*/
typedef enum {
   IPC_STATUS_OK,
   IPC_STATUS_NO_DATA,
   IPC_STATUS_END_OF_DECK,
   IPC_STATUS_EOF,
   IPC_STATUS_ERROR,
} Ipc_Status_t;

#if 0
/*---------------------------------------------------------------------------*/
typedef void* Ipc_Connection_t;
/*
 * A connection is an `opaque' type - the user has no access to the details of
 * the implementation. Indeed the details are different depending on whether
 * underlying transport mechanism is AEGIS Mailboxes or Bsd Sockets (or
 * something else...)
 */
#endif

/*---------------------------------------------------------------------------*/
typedef enum {
   IPC_WAIT,
   IPC_NO_WAIT,
} Ipc_Wait_t;

/*---------------------------------------------------------------------------*/
typedef enum {
   IPC_PROTOCOL_V1,     /* >DATAB records in ATESSE v.1 format
                         * Handles v.1 style logfile name passing protocol
                         */
   IPC_PROTOCOL_V2,     /* >DATAB records in ATESSE v.2 format
                         */
} Ipc_Protocol_t;

/*---------------------------------------------------------------------------*/
typedef enum {
   IPC_MODE_BATCH,
   IPC_MODE_INTERACTIVE,
} Ipc_Mode_t;


/*---------------------------------------------------------------------------*/
typedef enum {
   IPC_ANAL_DCOP,
   IPC_ANAL_DCTRCURVE,
   IPC_ANAL_AC,
   IPC_ANAL_TRAN,
} Ipc_Anal_t;

#endif  /* IPC_DEFINED */
//insert file>> #include "mif.h"
#ifndef MIF
#define MIF

/* ===========================================================================
FILE    MIF.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file structure definitions global data used with the MIF package.
    The global data structure is used to circumvent the need to modify
    argument lists in existing SPICE 3C1 functions.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

//insert file>> #include  "MIFtypes.h"
//insert file>> #include  "MIFdefs.h"
//insert file>> #include  "CKTdefs.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CKT
#define CKT "CKTdefs.h $Revision: 1.13 $  on $Date: 89/04/05 13:09:39 $ "
  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing CKTdefs.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

//insert file>>   #include "basic.h"
//insert file>>   #include "xspice.h"

  #ifdef XSPICE
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
//insert file>>     #include "EVT.h"
#ifndef EVT_HEADER
#define EVT_HEADER 

/* ===========================================================================
FILE    EVT.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of the evt data structure and all
    its substructures.  The single evt structure is housed inside of
    the main 3C1 circuit structure 'ckt' and contains virtually all
    information about the event-driven simulation.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFdefs.h"
//insert file>> #include "MIFcmdat.h"
//insert file>> #include "MIFtypes.h"


/* ************** */
/* Info structure */
/* ************** */


typedef struct Evt_Output_Info_s {
    struct Evt_Output_Info_s  *next;  /* the next in the linked list */
    int  node_index;                  /* index into node info struct for this output */
    int  output_subindex;             /* index into output data in node data struct  */
    int  inst_index;                  /* Index of instance the port is on */
    int  port_index;                  /* Index of port the output corresponds to */
} Evt_Output_Info_t;

typedef struct Evt_Port_Info_s {
    struct Evt_Port_Info_s  *next;        /* the next in the linked list of node info */
    int                     inst_index;   /* Index of instance the port is on */
    int                     node_index;   /* index of node the port is connected to */
    char                    *node_name;   /* name of node port is connected to */
    char                    *inst_name;   /* instance name */
    char                    *conn_name;   /* connection name on instance */
    int                     port_num;     /* port number of instance connector */
} Evt_Port_Info_t;

typedef struct Evt_Inst_Index_s {
    struct Evt_Inst_Index_s  *next;           /* the next in the linked list */
    int                      index_value;     /* the value of the index */
} Evt_Inst_Index_t;

typedef struct Evt_Node_Info_s {
    struct Evt_Node_Info_s  *next;     /* the next in the linked list */
    char              *name;           /* Name of node in deck */
    int               udn_index;       /* Index of the node type */
    Mif_BOOLEAN_t     invert;          /* True if need to make inverted copy */
    int               num_ports;       /* Number of ports connected to this node */
    int               num_outputs;     /* Number of outputs connected to this node */
    int               num_insts;       /* The number of insts receiving node as input */
    Evt_Inst_Index_t  *inst_list;      /* Linked list of indexes of these instances */
} Evt_Node_Info_t;

typedef struct Evt_Inst_Info_s {
    struct Evt_Inst_Info_s  *next;      /* the next in the linked list of node info */
    struct sMIFinstance     *inst_ptr;  /* Pointer to MIFinstance struct for this instance */
} Evt_Inst_Info_t;

typedef struct Evt_Info_ {
    Evt_Inst_Info_t    *inst_list;         /* static info about event/hybrid instances */
    Evt_Node_Info_t    *node_list;         /* static info about event nodes */
    Evt_Port_Info_t    *port_list;         /* static info about event ports */
    Evt_Output_Info_t  *output_list;       /* static info about event outputs */
    int                *hybrid_index;      /* vector of inst indexs for hybrids */
    Evt_Inst_Info_t    **inst_table;       /* vector of pointers to elements in inst_list */
    Evt_Node_Info_t    **node_table;       /* vector of pointers to elements in node_list */
    Evt_Port_Info_t    **port_table;       /* vector of pointers to elements in port_list */
    Evt_Output_Info_t  **output_table;     /* vector of pointers to elements in output_list */
} Evt_Info_t;








/* *************** */
/* Queue structure */
/* *************** */



typedef struct Evt_Inst_Event_s {
    struct Evt_Inst_Event_s  *next; /* the next in the linked list */
    double            event_time;   /* Time for this event to happen */
    double            posted_time;  /* Time at which event was entered in queue */
} Evt_Inst_Event_t; 

typedef struct Evt_Inst_Queue_s {
    Evt_Inst_Event_t  **head;          /* Beginning of linked lists */
    Evt_Inst_Event_t  ***current;      /* Beginning of pending events */
    Evt_Inst_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Inst_Event_t  **free;          /* Linked lists of items freed by backups */
    double            last_time;       /* Time at which last_step was set */
    double            next_time;       /* Earliest next event time in queue */
    int               num_modified;    /* Number modified since last accepted timepoint */
    int               *modified_index; /* Indexes of modified instances */
    Mif_BOOLEAN_t     *modified;       /* Flags used to prevent multiple entries */
    int               num_pending;     /* Count of number of pending events in lists */
    int               *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t     *pending;        /* Flags used to prevent multiple entries */
    int               num_to_call;     /* Count of number of instances that need to be called */
    int               *to_call_index;  /* Indexes of instances to be called */
    Mif_BOOLEAN_t     *to_call;        /* Flags used to prevent multiple entries */
} Evt_Inst_Queue_t;




typedef struct Evt_Node_Queue_s {
    int               num_to_eval;    /* Count of number of nodes that need to be evaluated */
    int               *to_eval_index; /* Indexes of nodes to be evaluated */
    Mif_BOOLEAN_t     *to_eval;       /* Flags used to prevent multiple entries */
    int               num_changed;    /* Count of number of nodes that changed */
    int               *changed_index; /* Indexes of nodes that changed */
    Mif_BOOLEAN_t     *changed;       /* Flags used to prevent multiple entries */
} Evt_Node_Queue_t;




typedef struct Evt_Output_Event_s {
    struct Evt_Output_Event_s  *next; /* the next in the linked list */
    double            event_time;     /* Time for this event to happen */
    double            posted_time;    /* Time at which event was entered in queue */
    Mif_BOOLEAN_t     removed;        /* True if event has been deactivated */
    double            removed_time;   /* Time at which event was deactivated */
    void              *value;         /* The delayed value sent to this output */
} Evt_Output_Event_t; 

typedef struct Evt_Output_Queue_s {
    Evt_Output_Event_t  **head;          /* Beginning of linked lists */
    Evt_Output_Event_t  ***current;      /* Beginning of pending events */
    Evt_Output_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Output_Event_t  **free;          /* Linked lists of items freed by backups */
    double              last_time;       /* Time at which last_step was set */
    double              next_time;       /* Earliest next event time in queue */
    int                 num_modified;    /* Number modified since last accepted timepoint */
    int                 *modified_index; /* Indexes of modified outputs */
    Mif_BOOLEAN_t       *modified;       /* Flags used to prevent multiple entries */
    int                 num_pending;     /* Count of number of pending events in lists */
    int                 *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t       *pending;        /* Flags used to prevent multiple entries */
    int                 num_changed;     /* Count of number of outputs that changed */
    int                 *changed_index;  /* Indexes of outputs that changed */
    Mif_BOOLEAN_t       *changed;        /* Flags used to prevent multiple entries */
} Evt_Output_Queue_t;




typedef struct Evt_Queue_s {
    Evt_Inst_Queue_t   inst;               /* dynamic queue for instances */
    Evt_Node_Queue_t   node;               /* dynamic queue of changing nodes */
    Evt_Output_Queue_t output;             /* dynamic queue of delayed outputs */
} Evt_Queue_t;




/* ************** */
/* Data structure */
/* ************** */




typedef struct Evt_Node_s {
    struct Evt_Node_s *next;          /* pointer to next in linked list */
    Mif_BOOLEAN_t    op;              /* true if computed from op analysis */
    double           step;            /* DC step or time at which data was computed */
    void             **output_value;  /* Array of outputs posted to this node */
    void             *node_value;     /* Resultant computed from output values */
    void             *inverted_value; /* Inverted copy of node_value */
} Evt_Node_t;

typedef struct {
    Evt_Node_t     **head;          /* Beginning of linked lists */
    Evt_Node_t     ***tail;         /* Location of last item added to list */
    Evt_Node_t     ***last_step;    /* 'tail' at last accepted timepoint */
    Evt_Node_t     **free;          /* Linked lists of items freed by backups */
    int            num_modified;    /* Number modified since last accepted timepoint */
    int            *modified_index; /* Indexes of modified nodes */
    Mif_BOOLEAN_t  *modified;       /* Flags used to prevent multiple entries */
    Evt_Node_t     *rhs;            /* Location where model outputs are placed */
    Evt_Node_t     *rhsold;         /* Location where model inputs are retrieved */
    double         *total_load;     /* Location where total load inputs are retrieved */
} Evt_Node_Data_t;




typedef struct Evt_State_s {
    struct Evt_State_s   *next;        /* Pointer to next state */
    struct Evt_State_s   *prev;        /* Pointer to previous state */
    double               step;         /* Time at which state was assigned (0 for DC) */
    void                 *block;       /* Block of memory holding all states on inst */
} Evt_State_t;


typedef struct Evt_State_Desc_s {
    struct Evt_State_Desc_s *next;   /* Pointer to next description */
    int                     tag;     /* Tag for this state */
    int                     size;    /* Size of this state */
    int                     offset;  /* Offset of this state into the state block */
} Evt_State_Desc_t;


typedef struct Evt_State_Data_s {
    Evt_State_t    **head;              /* Beginning of linked lists */
    Evt_State_t    ***tail;             /* Location of last item added to list */
    Evt_State_t    ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_State_t    **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
    int            *total_size;         /* Total bytes for all states allocated */
    Evt_State_Desc_t **desc;            /* Lists of description structures */
} Evt_State_Data_t;




typedef struct Evt_Msg_s {
    struct Evt_Msg_s     *next;      /* Pointer to next state */
    Mif_BOOLEAN_t        op;         /* true if output from op analysis */
    double               step;       /* DC step or time at which message was output */
    char                 *text;      /* The value of the message text */
    int                  port_index; /* The index of the port from which the message came */
} Evt_Msg_t;


typedef struct Evt_Msg_Data_s {
    Evt_Msg_t      **head;              /* Beginning of linked lists */
    Evt_Msg_t      ***tail;             /* Location of last item added to list */
    Evt_Msg_t      ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_Msg_t      **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
} Evt_Msg_Data_t;


typedef struct Evt_Statistic_s {
    int                op_alternations;    /* Total alternations between event and analog */
    int                op_load_calls;      /* Total load calls in DCOP analysis */
    int                op_event_passes;    /* Total passes through event iteration loop */
    int                tran_load_calls;    /* Total inst calls in transient analysis */
    int                tran_time_backups;  /* Number of transient timestep cuts */
} Evt_Statistic_t;




typedef struct Evt_Data_s {
    Evt_Node_Data_t    *node;               /* dynamic event solution vector */
    Evt_State_Data_t   *state;              /* dynamic event instance state data */
    Evt_Msg_Data_t     *msg;                /* dynamic event message data */
    Evt_Statistic_t    *statistics;         /* Statistics for events, etc. */
} Evt_Data_t;



/* **************** */
/* Counts structure */
/* **************** */


typedef struct Evt_Count_s {
    int          num_insts;             /* number of event/hybrid instances parsed */
    int          num_hybrids;           /* number of hybrids parsed */
    int          num_hybrid_outputs;    /* number of outputs on all hybrids parsed */
    int          num_nodes;             /* number of event nodes parsed */
    int          num_ports;             /* number of event ports parsed */
    int          num_outputs;           /* number of event outputs parsed */
} Evt_Count_t;



/* **************** */
/* Limits structure */
/* **************** */


typedef struct Evt_Limit_s {
    int         max_event_passes;    /* maximum loops in attempting convergence of event nodes */
    int         max_op_alternations; /* maximum loops through event/analog alternation */
} Evt_Limit_t;


/* ************** */
/* Jobs structure */
/* ************** */


typedef struct Evt_Job_s {
    int                num_jobs;           /* Number of jobs run */
    char               **job_name;         /* Names of different jobs */
    Evt_Node_Data_t    **node_data;        /* node_data for different jobs */
    Evt_State_Data_t   **state_data;       /* state_data for different jobs */
    Evt_Msg_Data_t     **msg_data;         /* messages for different jobs */
    Evt_Statistic_t    **statistics;       /* Statistics for different jobs */
} Evt_Job_t;



/* ***************** */
/* Options structure */
/* ***************** */


typedef struct Evt_Option_s {
    Mif_BOOLEAN_t   op_alternate;        /* Alternate analog/event solutions in OP analysis */
} Evt_Option_t;


/* ****************** */
/* Main evt structure */
/* ****************** */

typedef struct Evt_Ckt_Data_s {
    Evt_Count_t     counts;         /* Number of insts, nodes, etc. */
    Evt_Info_t      info;           /* Static info about insts, etc. */
    Evt_Queue_t     queue;          /* Dynamic queued events */
    Evt_Data_t      data;           /* Results and state data */
    Evt_Limit_t     limits;         /* Iteration limits, etc. */
    Evt_Job_t       jobs;           /* Data held from multiple job runs */
    Evt_Option_t    options;        /* Data input on .options cards */
} Evt_Ckt_Data_t;



#endif /* EVT_HEADER */
//insert file>>     #include "ENH.h"
#ifndef ENH_HEADER
#define ENH_HEADER 

/* ===========================================================================
FILE    ENH.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains typedefs used by the event-driven algorithm.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFtypes.h"
//insert file>> #include "FTEinp.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 *
 * Note that this definition must be the same as struct card in INPdefs.h...
 */


/*
The following data is used in implementing various enhancements made to the
simulator.  The main struct is dynamically allocated in ckt so that incremental additions
can be made more easily without the need to recompile multiple modules.
Allocation and initialization is done in CKTinit.c which should be the only
module needed to recompile after additions are made here.
*/


typedef enum Enh_Conv_Source_t {
    ENH_ANALOG_NODE,            /* An analog node */
    ENH_EVENT_NODE,             /* An event-driven node */
    ENH_ANALOG_BRANCH,          /* A branch current */
    ENH_ANALOG_INSTANCE,        /* An analog instance */
    ENH_EVENT_INSTANCE,         /* An event-driven instance */
    ENH_HYBRID_INSTANCE,        /* A hybrid (analog/event-driven) instance */
} Enh_Conv_Source_t;


typedef struct Enh_Bkpt_t {
   double           current;    /* The current dynamic breakpoint time */
   double           last;       /* The last used dynamic breakpoint time */
} Enh_Bkpt_t;

typedef struct Enh_Ramp_t {
    double           ramptime;    /* supply ramping time specified on .options */
} Enh_Ramp_t;

typedef struct Enh_Conv_Debug_t {
    Mif_BOOLEAN_t    last_NIiter_call;  /* True if this is the last call to NIiter() */
    Mif_BOOLEAN_t    report_conv_probs; /* True if conv test functions should send debug info */
} Enh_Conv_Debug_t;


typedef struct Enh_Conv_Limit_t {
    Mif_BOOLEAN_t    enabled;           /* True if convergence limiting enabled on code models */
    double           abs_step;          /* Minimum limiting step size */
    double           step;              /* Fractional step amount */
} Enh_Conv_Limit_t;


typedef struct Enh_Rshunt_t {
    Mif_BOOLEAN_t    enabled;      /* True if rshunt option used */
    double           gshunt;       /* 1.0 / rshunt */
    int              num_nodes;    /* Number of nodes in matrix */
    double           **diag;       /* Pointers to matrix diagonals */
} Enh_Rshunt_t;


typedef struct Enh_Ckt_Data_t {
    Enh_Bkpt_t       breakpoint;   /* Data used by dynamic breakpoints */
    Enh_Ramp_t       ramp;         /* New options added to simulator */
    Enh_Conv_Debug_t conv_debug;   /* Convergence debug info dumping data */
    Enh_Conv_Limit_t conv_limit;   /* Convergence limiting info */
    Enh_Rshunt_t     rshunt_data;  /* Shunt conductance from nodes to ground */
} Enh_Ckt_Data_t;



void ENHreport_conv_prob(Enh_Conv_Source_t type, char *name, char *msg);
struct line *ENHtranslate_poly(InstanceHandle inst, struct line *deck);


#endif /* ENH_HEADER */
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
  #endif


  #define MAXNUMDEVS 32
  extern int DEVmaxnum;
  #define MAXNUMDEVNODES 4

//insert file>>   #include "smpdefs.h"
#ifndef SMP
#define SMP

#ifdef IIT
typedef  struct MatrixFrame SMPmatrix;
#else
typedef  char SMPmatrix;
#endif

typedef  struct MatrixElement  *SMPelement;

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "complex.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CMPLX
#define CMPLX "complex.h $Revision: 1.5 $  on $Date: 88/11/22 02:51:07 $ "

/*  header file containing definitions for complex functions
 *
 *  Each expects two arguments for each complex number - a real and an
 *  imaginary part.
 */
typedef struct {
    double real;
    double imag;
} SPcomplex;


#define DC_ABS(a,b) (FABS(a) + FABS(b))

#ifdef notdef
#define DC_DIV(a,b,c,d,x,y) { \
    double r,s;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((a)+(b)*r)/s;\
        y=((b)-(a)*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((a)*r+(b))/s;\
        y=((b)*r-(a))/s;\
    }\
}
#endif /*notdef */

#ifndef HAS_SHORTMACRO
#define DC_DIVEQ(a,b,c,d) { \
    double r,s,x,y;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((*(a))+(*(b))*r)/s;\
        y=((*(b))-(*(a))*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((*(a))*r+(*(b)))/s;\
        y=((*(b))*r-(*(a)))/s;\
    }\
    (*(a)) = x; \
    (*(b)) = y; \
}
#else /*HAS_SHORTMACRO*/
#define DC_DIVEQ DCdiveq
#ifdef IIT
extern void DCdiveq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCdiveq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifndef HAS_SHORTMACRO
#define DC_MULT(a,b,c,d,x,y) { \
    *(x) = (a) * (c) - (b) * (d) ;\
    *(y) = (a) * (d) + (b) * (c) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MULT DCmult
#ifdef IIT
extern void DCmult(InstanceHandle inst, double,double,double,double,double*,double*);
#else /* stdc */
extern void DCmult(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifdef notdef 
#define DC_MINUS(a,b,c,d,x,y) { \
    (x) = (a) - (c) ;\
    (y) = (b) - (d) ;\
}
#endif /*notdef*/

#ifndef HAS_SHORTMACRO
#define DC_MINUSEQ(a,b,c,d) { \
    *(a) -= (c) ;\
    *(b) -= (d) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MINUSEQ DCminusEq
#ifdef IIT
extern void DCminusEq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCminusEq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#define	C_SQRT(A) {							      \
	double	_mag, _a;						      \
	if ((A).imag == 0.0) {						      \
	    if ((A).real < 0.0) {					      \
		(A).imag = sqrt(-(A).real);				      \
		(A).real = 0.0;						      \
	    } else {							      \
		(A).real = sqrt((A).real);				      \
		(A).imag = 0.0;						      \
	    }								      \
	} else {							      \
	    _mag = sqrt((A).real * (A).real + (A).imag * (A).imag);	      \
	    _a = (_mag - (A).real) / 2.0;				      \
	    if (_a <= 0.0) {						      \
		(A).real = sqrt(_mag);					      \
		(A).imag /= (2.0 * (A).real); /*XXX*/			      \
	    } else {							      \
		_a = sqrt(_a);						      \
		(A).real = (A).imag / (2.0 * _a);			      \
		(A).imag = _a;						      \
	    }								      \
	}								      \
    }

#define	C_MAG2(A) (((A).real = (A).real * (A).real + (A).imag * (A).imag),    \
	(A).imag = 0.0)

#define	C_CONJ(A) ((A).imag *= -1.0)

#define	C_CONJEQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = - (B.imag);						      \
    }

#define	C_EQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = (B.imag);						      \
    }

#define	C_NORM(A,B) {							      \
	if ((A).real == 0.0 && (A).imag == 0.0) {			      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS((A).real) > 1.0 || FABS((A).imag) > 1.0) {	      \
		(B) += 1;						      \
		(A).real /= 2.0;					      \
		(A).imag /= 2.0;					      \
	    }								      \
	    while (FABS((A).real) <= 0.5 && FABS((A).imag) <= 0.5) {	      \
		(B) -= 1;						      \
		(A).real *= 2.0;					      \
		(A).imag *= 2.0;					      \
	    }								      \
	}								      \
    }

#define	C_ABS(A) (sqrt((A).real * (A.real) + (A.imag * A.imag)))

#define	C_MUL(A,B) {							      \
	double	TMP1, TMP2;						      \
	TMP1 = (A.real);						      \
	TMP2 = (B.real);						      \
	(A).real = TMP1 * TMP2 - (A.imag) * (B.imag);			      \
	(A).imag = TMP1 * (B.imag) + (A.imag) * TMP2;			      \
    }

#define	C_MULEQ(A,B,C) {						      \
	(A).real = (B.real) * (C.real) - (B.imag) * (C.imag);		      \
	(A).imag = (B.real) * (C.imag) + (B.imag) * (C.real);		      \
    }

#define	C_DIV(A,B) {							      \
	double	_tmp, _mag;						      \
	_tmp = (A.real);						      \
	(A).real = _tmp * (B.real) + (A).imag * (B.imag);		      \
	(A).imag = - _tmp * (B.imag) + (A.imag) * (B.real);		      \
	_mag = (B.real) * (B.real) + (B.imag) * (B.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_DIVEQ(A,B,C) {						      \
	double	_mag;							      \
	(A).real = (B.real) * (C.real) + (B.imag) * (C.imag);		      \
	(A).imag = (B.imag) * (C.real) - (B.real) * (C.imag) ;		      \
	_mag = (C.real) * (C.real) + (C.imag) * (C.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_ADD(A,B) {							      \
	(A).real += (B.real);						      \
	(A).imag += (B.imag);						      \
    }

#define	C_ADDEQ(A,B,C) {						      \
	(A).real = (B.real) + (C.real);					      \
	(A).imag = (B.imag) + (C.imag);					      \
    }

#define	C_SUB(A,B) {							      \
	(A).real -= (B.real);						      \
	(A).imag -= (B.imag);						      \
    }

#define	C_SUBEQ(A,B,C) {						      \
	(A).real = (B.real) - (C.real);					      \
	(A).imag = (B.imag) - (C.imag);					      \
    }



#endif /*CMPLX*/
#include <stdio.h>

#ifdef IIT

#ifndef MatrixFrame_defined
#define MatrixFrame_defined
typedef  struct MatrixFrame* MatrixPtr;
#endif

//insert file>> #include "sensgen.h"
#ifndef HDR_sensgen_h
#define HDR_sensgen_h

typedef struct CKTcircuit_tag* CKTcircuit_ptr;

struct s_sgen {
	CKTcircuit_ptr	ckt;
	struct sGENmodel	**devlist;
	struct sGENmodel	*model, *next_model, *first_model;
	struct sGENinstance	*instance, *next_instance, *first_instance;
	struct sIFparm		*ptable;
	double		value;
	int		dev;
	int		istate;
	int		param, max_param;
	int		is_dc;
	int		is_instparam;
	int		is_q;
	int		is_principle;
	int		is_zerook;
};

typedef struct s_sgen sgen;

extern sgen* sgen_init(CKTcircuit_ptr ckt, int is_dc);
extern int sgen_next(InstanceHandle inst, sgen** xsg);


#endif

int SMPcAddCol(InstanceHandle inst,  MatrixPtr Matrix, int Accum_Col, int Addend_Col );
int SMPcZeroCol(InstanceHandle inst, MatrixPtr Matrix, int Col);
int SMPcDProd(InstanceHandle inst, SMPmatrix *Matrix,SPcomplex *pMantissa,int *pExponent);
#endif

int SMPaddElt(InstanceHandle inst,  SMPmatrix *, int , int , double );
void SMPcClear(InstanceHandle inst,  SMPmatrix *);
int SMPcLUfac(InstanceHandle inst,  SMPmatrix *, double );
int SMPcProdDiag(InstanceHandle inst,  SMPmatrix *, SPcomplex *, int *);
int SMPcReorder(InstanceHandle inst,  SMPmatrix * , double , double , int *);
void SMPcSolve(InstanceHandle inst,  SMPmatrix *, double [], double [], double [], double []);
void SMPclear(InstanceHandle inst,  SMPmatrix *);
void SMPcolSwap(InstanceHandle inst,  SMPmatrix * , int , int );
void SMPdestroy(InstanceHandle inst,  SMPmatrix *);
int SMPfillup(InstanceHandle inst,  SMPmatrix * );
SMPelement * SMPfindElt(InstanceHandle inst,  SMPmatrix *, int , int , int );
void SMPgetError(InstanceHandle inst,  SMPmatrix *, int *, int *);
int SMPluFac(InstanceHandle inst,  SMPmatrix *, double , double );
double * SMPmakeElt(InstanceHandle inst,  SMPmatrix * , int , int );
int SMPmatSize(InstanceHandle inst,  SMPmatrix *);
int SMPnewMatrix(InstanceHandle inst,  SMPmatrix ** );
int SMPnewNode(InstanceHandle inst,  int , SMPmatrix *);
int SMPpreOrder(InstanceHandle inst,  SMPmatrix *);
void SMPprintWithRHS(InstanceHandle inst,  SMPmatrix * , double const* rhs, double const* irhs, FILE *);
void SMPprint(InstanceHandle inst,  SMPmatrix * , FILE *);
int SMPreorder(InstanceHandle inst,  SMPmatrix * , double , double , double );
void SMProwSwap(InstanceHandle inst,  SMPmatrix * , int , int );
void SMPsolve(InstanceHandle inst,  SMPmatrix *, double [], double []);

#endif /*SMP*/
//insert file>>   #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

//insert file>>   #include "acdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef ACDEFS
#define ACDEFS

//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef JOBdef
#define JOBdef


//insert file>> #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/


typedef struct sJOB{
    int JOBtype;                /* type of job */
    struct sJOB *JOBnextJob;    /* next job in list */
    IFuid JOBname;              /* name of this job */

} JOB;

#define NODOMAIN	0
#define TIMEDOMAIN	1
#define FREQUENCYDOMAIN 2
#define SWEEPDOMAIN	3

#endif /*JOBdef*/



#ifdef CKTcircuit_has_been_defined
#ifndef JOBdef_part2
#define JOBdef_part2

#ifdef IIT
typedef int (*SPICEanalysis_setParm_t)(struct CKTcircuit_tag* ckt, GENERIC *anal, int which, union uIFvalue *value);
typedef int (*SPICEanalysis_askQuest_t)(struct CKTcircuit_tag*, GENERIC *anal, int which, union uIFvalue *value);
typedef int (*SPICEanalysis_an_init_t)(struct CKTcircuit_tag*, JOB *job);
typedef int (*SPICEanalysis_an_func_t)(struct CKTcircuit_tag*, int restart);
#endif


typedef struct {
    IFanalysis public_;
    int size;
    int domain;
    int do_ic;
#ifdef IIT
    SPICEanalysis_setParm_t  setParm;
    SPICEanalysis_askQuest_t askQuest;
    SPICEanalysis_an_init_t  an_init;
    SPICEanalysis_an_func_t  an_func;
#else
    int (*(setParm))( );
    int (*(askQuest))( );
    int (*an_init)( );
    int (*an_func)( );
#endif

} SPICEanalysis;
#endif
#endif

    /* structure used to describe an AC analysis to be performed */

typedef struct {
    int JOBtype;
    JOB *JOBnextJob;    /* pointer to next thing to do */
    char *JOBname;      /* name of this job */
    double ACstartFreq;
    double ACstopFreq;
    double ACfreqDelta; /* multiplier for decade/octave stepping, */
                        /* step for linear steps. */
    double ACsaveFreq;  /* frequency at which we left off last time*/
    int ACstepType;     /* values described below */
    int ACnumberSteps;
} ACAN;

/* available step types: XXX should be somewhere else */

#define DECADE 1
#define OCTAVE 2
#define LINEAR 3

#define AC_DEC 1
#define AC_OCT 2
#define AC_LIN 3
#define AC_START 4
#define AC_STOP 5
#define AC_STEPS 6

#endif /*ACDEFS*/
//insert file>>   #include "gendefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "trcvdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */
#ifndef DCTR
#define DCTR


//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "tskdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */
#ifndef TSK
#define TSK


//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/


typedef struct {
    JOB taskOptions;    /* job structure at the front to hold options */
    JOB *jobs;
    char *TSKname;
    double TSKtemp;
    double TSKnomTemp;
    int TSKmaxOrder;        /* maximum integration method order */
    int TSKintegrateMethod; /* the integration method to be used */
    int TSKcurrentAnalysis; /* the analysis in progress (if any) */

/* defines for the value of  TSKcurrentAnalysis */
#define DOING_DCOP 1
#define DOING_TRCV 2
#define DOING_AC   4
#define DOING_TRAN 8

    int TSKbypass;
    int TSKdcMaxIter;       /* iteration limit for dc op.  (itl1) */
    int TSKdcTrcvMaxIter;   /* iteration limit for dc tran. curv (itl2) */
    int TSKtranMaxIter;     /* iteration limit for each timepoint for tran*/
                            /* (itl4) */
    int TSKnumSrcSteps;     /* number of steps for source stepping */
    int TSKnumGminSteps;    /* number of steps for Gmin stepping */
    double TSKminBreak;
    double TSKabstol;
    double TSKpivotAbsTol;
    double TSKpivotRelTol;
    double TSKreltol;
    double TSKchgtol;
    double TSKvoltTol;
#ifdef NEWTRUNC
    double TSKlteReltol;
    double TSKlteAbstol;
#endif /* NEWTRUNC */
    double TSKgmin;
    double TSKdelmin;
    double TSKtrtol;
    double TSKdefaultMosL;
    double TSKdefaultMosW;
    double TSKdefaultMosAD;
    double TSKdefaultMosAS;
    unsigned int TSKfixLimit:1;
    unsigned int TSKnoOpIter:1; /* no OP iterating, go straight to gmin step */
    unsigned int TSKtryToCompact:1; /* flag for LTRA lines */
    unsigned int TSKbadMos3:1; /* flag for MOS3 models */
    unsigned int TSKkeepOpInfo:1; /* flag for small signal analyses */
}TSKtask;

#endif /*TSK*/
//insert file>> #include "gendefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

    /*
     * structures used to describe D.C. transfer curve analyses to
     * be performed.
     */

#define TRCVNESTLEVEL 2 /* depth of nesting of curves - 2 for spice2 */

typedef struct {
    int JOBtype;
    JOB *JOBnextJob;
    char *JOBname;
    double TRCVvStart[TRCVNESTLEVEL];   /* starting voltage/current */
    double TRCVvStop[TRCVNESTLEVEL];    /* ending voltage/current */
    double TRCVvStep[TRCVNESTLEVEL];    /* voltage/current step */
    double TRCVvSave[TRCVNESTLEVEL];    /* voltage of this source BEFORE 
                                         * analysis-to restore when done */
    int TRCVgSave[TRCVNESTLEVEL];    /* dcGiven flag; as with vSave */
    IFuid TRCVvName[TRCVNESTLEVEL];     /* source being varied */
    struct sGENinstance *TRCVvElt[TRCVNESTLEVEL];   /* pointer to source */
    int TRCVvType[TRCVNESTLEVEL];   /* type of element being varied */
    int TRCVset[TRCVNESTLEVEL];     /* flag to indicate this nest level used */
    int TRCVnestLevel;      /* number of levels of nesting called for */
    int TRCVnestState;      /* iteration state during pause */
} TRCV;

#define DCT_START1 1
#define DCT_STOP1 2
#define DCT_STEP1 3
#define DCT_NAME1 4
#define DCT_TYPE1 5
#define DCT_START2 6
#define DCT_STOP2 7
#define DCT_STEP2 8
#define DCT_NAME2 9
#define DCT_TYPE2 10

#endif /*DCTR*/
//insert file>>   #include "optdefs.h"
//insert file>> #include "xspice.h"

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#ifndef OPT
#define OPT

    /* structure used to describe the statistics to be collected */

typedef struct {

    int STATnumIter;    /* number of total iterations performed */
    int STATtranIter;   /* number of iterations for transient analysis */
    int STAToldIter;    /* number of iterations at the end of the last point */
                        /* used to compute iterations per point */

    int STATtimePts;    /* total number of timepoints */
    int STATaccepted;   /* number of timepoints accepted */
    int STATrejected;   /* number of timepoints rejected */

    double STATtotAnalTime;     /* total time for analysis */
    double STATtranTime;    /* transient analysis time */
    double STATloadTime;    /* time spent in device loading */
    double STATdecompTime;  /* total time spent in LU decomposition */
    double STATsolveTime;   /* total time spent in F-B subst. */
    double STATreorderTime; /* total time spent reordering */
    double STATtranDecompTime;  /* time spent in transient LU decomposition */
    double STATtranSolveTime;   /* time spent in transient F-B Subst. */

    double STATtstep;   /* tstep for the simulation. */
    double STATtmax;    /* tmax for the simulation. */

} STATistics;

#define OPT_GMIN 1
#define OPT_RELTOL 2
#define OPT_ABSTOL 3
#define OPT_VNTOL 4
#define OPT_TRTOL 5
#define OPT_CHGTOL 6
#define OPT_PIVTOL 7
#define OPT_PIVREL 8
#define OPT_TNOM 9
#define OPT_ITL1 10
#define OPT_ITL2 11
#define OPT_ITL3 12
#define OPT_ITL4 13
#define OPT_ITL5 14
#define OPT_DEFL 15
#define OPT_DEFW 16
#define OPT_DEFAD 17
#define OPT_DEFAS 18
#define OPT_BYPASS 19
#define OPT_MAXORD 20

#define OPT_ITERS 21
#define OPT_TRANIT 22
#define OPT_TRANPTS 23
#define OPT_TRANACCPT 24
#define OPT_TRANRJCT 25
#define OPT_TOTANALTIME 26
#define OPT_TRANTIME 27
#define OPT_LOADTIME 28
#define OPT_DECOMP 29
#define OPT_SOLVE 30
#define OPT_TRANDECOMP 31
#define OPT_TRANSOLVE 32
#define OPT_TEMP 33
#define OPT_OLDLIMIT 34
#define OPT_TRANCURITER 35
#define OPT_SRCSTEPS 36
#define OPT_GMINSTEPS 37
#define OPT_MINBREAK 38
#define OPT_NOOPITER 39
#define OPT_EQNS 40
#define OPT_REORDTIME 41
#define OPT_INTEGRATIONMETHOD 42
#define OPT_TRYTOCOMPACT 43
#define OPT_BADMOS3 44
#define OPT_KEEPOPINFO 45

#ifdef XSPICE
/* gtri - begin - wbk - add new options */
#define OPT_ENH_NOOPALTER           100
#define OPT_ENH_RAMPTIME            101
#define OPT_EVT_MAX_EVT_PASSES      102
#define OPT_EVT_MAX_OP_ALTER        103
#define OPT_ENH_CONV_LIMIT          104
#define OPT_ENH_CONV_ABS_STEP       105
#define OPT_ENH_CONV_STEP           106
#define OPT_MIF_AUTO_PARTIAL        107
#define OPT_ENH_RSHUNT              108
/* gtri - end   - wbk - add new options */

#ifdef EWB_IIT
#define OPT_ENH_NOOPALTER_ENABLE       109
#define OPT_ENH_CONV_LIMIT_ENABLE      110
#define OPT_MIF_AUTO_PARTIAL_ENABLE    111
#define OPT_ENH_CONV_STEP_DEFAULT      112
#define OPT_ENH_CONV_ABS_STEP_DEFAULT  113
#define OPT_ENH_RSHUNT_DEFAULT         114
#endif

#ifdef EWB_IIT
#define OPT_DUMP_CIRCUIT               115
#define OPT_DUMP_RAWFILE               116
#endif

#endif

#ifdef IIT
#define OPT_RESET_ALL_ANA_OPT          117
#endif

#endif /*OPT*/
//insert file>>   #include "sen2defs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/
/*
 * SENdefs.h - structures for sensitivity package
 */

#ifndef SENSTRUCTS
#define SENSTRUCTS


//insert file>> #include "smpdefs.h"
//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/


typedef struct {
    int JOBtype;
    JOB *JOBnextJob;    /* pointer to next thing to do */
    char *JOBname;      /* name of this job */

    int SENnumVal;         /* length of the next two arrays */
    char **SENdevices;  /* names of the devices to do sensetivity analysis of */
    char **SENparmNames;/* parameters of the above devices to do analysis wrt */

    unsigned int SENinitflag :1 ;   /* indicates whether sensitivity structure*/
                                    /* is to be initialized */ 
    unsigned int SENicflag :1 ; /* indicates whether initial conditions
                                   are specified for transient analysis */

    unsigned int SENstatus :1;     /* indicates whether perturbation
                          is in progress*/ 
    unsigned int SENacpertflag :1; /* indictes whether the perturbation
                          is to be carried out in ac analysis
                          (is done only for first frequency )*/
    int SENmode;     /* indicates the type of sensitivity analysis
                        reqired: DC, Transient, or AC */
    int SENparms;    /* # of  design parameters  */
    double SENpertfac;    /* perturbation factor (for active
                             devices )*/ 
    double  **SEN_Sap;  /* sensitivity matrix (DC and transient )*/
    double  **SEN_RHS;  /* RHS matrix (real part)
                           contains the sensitivity values after SMPsolve*/
    double  **SEN_iRHS; /* RHS matrix (imag part )
                           contains the sensitivity values after SMPsolve*/
    int SENsize;      /* stores the number of rows of each of the above
            three matrices */
    SMPmatrix  *SEN_Jacmat; /* sensitivity Jacobian matrix, */
    double  *SEN_parmVal;   /* table containing values of design parameters */
    char    **SEN_parmName; /* table containing names of design parameters */

} SENstruct;

/* SENmode */
#define DCSEN  0x1
#define TRANSEN  0x2
#define ACSEN  0x4

#define NORMAL 0
#define PERTURBATION  1
#define OFF 0
#define ON 1


#define SEN_AC 1
#define SEN_DC 2
#define SEN_TRAN 3
#define SEN_DEV 4
#define SEN_PARM 5

#endif /* SENSTRUCTS */
//insert file>>   #include "pzdefs.h"
#ifndef PZDEFS
#define PZDEFS "PZdefs.h $Revision: 1.3 $  on $Date: 88/11/16 21:55:29 $ "

    /* structure used to describe an PZ analysis to be performed */

//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "complex.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CMPLX
#define CMPLX "complex.h $Revision: 1.5 $  on $Date: 88/11/22 02:51:07 $ "

/*  header file containing definitions for complex functions
 *
 *  Each expects two arguments for each complex number - a real and an
 *  imaginary part.
 */
typedef struct {
    double real;
    double imag;
} SPcomplex;


#define DC_ABS(a,b) (FABS(a) + FABS(b))

#ifdef notdef
#define DC_DIV(a,b,c,d,x,y) { \
    double r,s;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((a)+(b)*r)/s;\
        y=((b)-(a)*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((a)*r+(b))/s;\
        y=((b)*r-(a))/s;\
    }\
}
#endif /*notdef */

#ifndef HAS_SHORTMACRO
#define DC_DIVEQ(a,b,c,d) { \
    double r,s,x,y;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((*(a))+(*(b))*r)/s;\
        y=((*(b))-(*(a))*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((*(a))*r+(*(b)))/s;\
        y=((*(b))*r-(*(a)))/s;\
    }\
    (*(a)) = x; \
    (*(b)) = y; \
}
#else /*HAS_SHORTMACRO*/
#define DC_DIVEQ DCdiveq
#ifdef IIT
extern void DCdiveq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCdiveq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifndef HAS_SHORTMACRO
#define DC_MULT(a,b,c,d,x,y) { \
    *(x) = (a) * (c) - (b) * (d) ;\
    *(y) = (a) * (d) + (b) * (c) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MULT DCmult
#ifdef IIT
extern void DCmult(InstanceHandle inst, double,double,double,double,double*,double*);
#else /* stdc */
extern void DCmult(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifdef notdef 
#define DC_MINUS(a,b,c,d,x,y) { \
    (x) = (a) - (c) ;\
    (y) = (b) - (d) ;\
}
#endif /*notdef*/

#ifndef HAS_SHORTMACRO
#define DC_MINUSEQ(a,b,c,d) { \
    *(a) -= (c) ;\
    *(b) -= (d) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MINUSEQ DCminusEq
#ifdef IIT
extern void DCminusEq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCminusEq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#define	C_SQRT(A) {							      \
	double	_mag, _a;						      \
	if ((A).imag == 0.0) {						      \
	    if ((A).real < 0.0) {					      \
		(A).imag = sqrt(-(A).real);				      \
		(A).real = 0.0;						      \
	    } else {							      \
		(A).real = sqrt((A).real);				      \
		(A).imag = 0.0;						      \
	    }								      \
	} else {							      \
	    _mag = sqrt((A).real * (A).real + (A).imag * (A).imag);	      \
	    _a = (_mag - (A).real) / 2.0;				      \
	    if (_a <= 0.0) {						      \
		(A).real = sqrt(_mag);					      \
		(A).imag /= (2.0 * (A).real); /*XXX*/			      \
	    } else {							      \
		_a = sqrt(_a);						      \
		(A).real = (A).imag / (2.0 * _a);			      \
		(A).imag = _a;						      \
	    }								      \
	}								      \
    }

#define	C_MAG2(A) (((A).real = (A).real * (A).real + (A).imag * (A).imag),    \
	(A).imag = 0.0)

#define	C_CONJ(A) ((A).imag *= -1.0)

#define	C_CONJEQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = - (B.imag);						      \
    }

#define	C_EQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = (B.imag);						      \
    }

#define	C_NORM(A,B) {							      \
	if ((A).real == 0.0 && (A).imag == 0.0) {			      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS((A).real) > 1.0 || FABS((A).imag) > 1.0) {	      \
		(B) += 1;						      \
		(A).real /= 2.0;					      \
		(A).imag /= 2.0;					      \
	    }								      \
	    while (FABS((A).real) <= 0.5 && FABS((A).imag) <= 0.5) {	      \
		(B) -= 1;						      \
		(A).real *= 2.0;					      \
		(A).imag *= 2.0;					      \
	    }								      \
	}								      \
    }

#define	C_ABS(A) (sqrt((A).real * (A.real) + (A.imag * A.imag)))

#define	C_MUL(A,B) {							      \
	double	TMP1, TMP2;						      \
	TMP1 = (A.real);						      \
	TMP2 = (B.real);						      \
	(A).real = TMP1 * TMP2 - (A.imag) * (B.imag);			      \
	(A).imag = TMP1 * (B.imag) + (A.imag) * TMP2;			      \
    }

#define	C_MULEQ(A,B,C) {						      \
	(A).real = (B.real) * (C.real) - (B.imag) * (C.imag);		      \
	(A).imag = (B.real) * (C.imag) + (B.imag) * (C.real);		      \
    }

#define	C_DIV(A,B) {							      \
	double	_tmp, _mag;						      \
	_tmp = (A.real);						      \
	(A).real = _tmp * (B.real) + (A).imag * (B.imag);		      \
	(A).imag = - _tmp * (B.imag) + (A.imag) * (B.real);		      \
	_mag = (B.real) * (B.real) + (B.imag) * (B.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_DIVEQ(A,B,C) {						      \
	double	_mag;							      \
	(A).real = (B.real) * (C.real) + (B.imag) * (C.imag);		      \
	(A).imag = (B.imag) * (C.real) - (B.real) * (C.imag) ;		      \
	_mag = (C.real) * (C.real) + (C.imag) * (C.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_ADD(A,B) {							      \
	(A).real += (B.real);						      \
	(A).imag += (B.imag);						      \
    }

#define	C_ADDEQ(A,B,C) {						      \
	(A).real = (B.real) + (C.real);					      \
	(A).imag = (B.imag) + (C.imag);					      \
    }

#define	C_SUB(A,B) {							      \
	(A).real -= (B.real);						      \
	(A).imag -= (B.imag);						      \
    }

#define	C_SUBEQ(A,B,C) {						      \
	(A).real = (B.real) - (C.real);					      \
	(A).imag = (B.imag) - (C.imag);					      \
    }



#endif /*CMPLX*/

typedef struct strial {
    SPcomplex	s, f_raw, f_def;
    struct strial *next, *prev;
    int		mag_raw, mag_def;
    int		multiplicity;
    int		flags;
    int		seq_num;
    int		count;
} PZtrial;

typedef struct {
    int JOBtype;
    JOB *JOBnextJob;
    IFuid JOBname;
    int PZin_pos;
    int PZin_neg;
    int PZout_pos;
    int PZout_neg;
    int PZinput_type;
    int PZwhich;
    int PZnumswaps;
    int PZbalance_col;
    int PZsolution_col;
    PZtrial *PZpoleList;
    PZtrial *PZzeroList;
    int PZnPoles;
    int PZnZeros;
    double *PZdrive_pptr;
    double *PZdrive_nptr;
} PZAN;

#define PZ_DO_POLES	0x1
#define PZ_DO_ZEROS	0x2
#define PZ_IN_VOL	1
#define PZ_IN_CUR	2

#define PZ_NODEI 1
#define PZ_NODEG 2
#define PZ_NODEJ 3
#define PZ_NODEK 4
#define PZ_V 5
#define PZ_I 6
#define PZ_POL 7
#define PZ_ZER 8
#define PZ_PZ 9

#endif /*PZDEFS*/



  typedef struct sCKTnode {
      IFuid name;
      int type;

      #define SP_VOLTAGE 3
      #define SP_CURRENT 4
      #define NODE_VOLTAGE SP_VOLTAGE
      #define NODE_CURRENT SP_CURRENT

      int number;
      double ic;
      double nodeset;
      double *ptr;
      struct sCKTnode *next;
      unsigned int icGiven:1;
      unsigned int nsGiven:1;
  } CKTnode;

  /* defines for node parameters */
  #define PARM_NS 1
  #define PARM_IC 2
  #define PARM_NODETYPE 3


  struct CKTcircuit_tag {
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif

     #ifdef XSPICE
     /* gtri - begin - wbk - change declaration to allow dynamic sizing */

     /* An associated change is made in CKTinit.c to alloc the space */
     /* required for the pointers.  No changes are needed to the source */
     /* code at the 3C1 level, although the compiler will generate */
     /* slightly different code for references to this data. */

     /*  GENmodel *CKThead[MAXNUMDEVS];  */
         struct sGENmodel **CKThead;

     /* gtri - end   - wbk - change declaration to allow dynamic sizing */
     #else
         struct sGENmodel *CKThead[MAXNUMDEVS];
     #endif
         STATistics *CKTstat;
         double *(CKTstates[8]);
     #define CKTstate0 CKTstates[0]
     #define CKTstate1 CKTstates[1]
     #define CKTstate2 CKTstates[2]
     #define CKTstate3 CKTstates[3]
     #define CKTstate4 CKTstates[4]
     #define CKTstate5 CKTstates[5]
     #define CKTstate6 CKTstates[6]
     #define CKTstate7 CKTstates[7]
         double CKTtime;
         double CKTdelta;
         double CKTdeltaOld[7];
         double CKTtemp;
         double CKTnomTemp;
         double CKTvt;
         double CKTag[7];        /* the gear variable coefficient matrix */
     #ifdef PREDICTOR
         double CKTagp[7];       /* the gear predictor variable coefficient matrix */
     #endif /*PREDICTOR*/
         int CKTorder;           /* the integration method order */
         int CKTmaxOrder;        /* maximum integration method order */
         int CKTintegrateMethod; /* the integration method to be used */

     /* known integration methods */
     #define TRAPEZOIDAL 1
     #define GEAR 2

         SMPmatrix *CKTmatrix;   /* pointer to sparse matrix */
         int CKTniState;         /* internal state */
         double *CKTrhs;         /* current rhs value - being loaded */
         double *CKTrhsOld;      /* previous rhs value for convergence testing */
         double *CKTrhsSpare;    /* spare rhs value for reordering */
         double *CKTirhs;        /* current rhs value - being loaded (imag) */
         double *CKTirhsOld;     /* previous rhs value (imaginary)*/
         double *CKTirhsSpare;   /* spare rhs value (imaginary)*/
     #ifdef PREDICTOR
         double *CKTpred;        /* predicted solution vector */
         double *CKTsols[8];     /* previous 8 solutions */
     #endif /* PREDICTOR */

         double *CKTrhsOp;      /* operating point values */
         double *CKTsenRhs;      /* current sensitivity rhs  values */
         double *CKTseniRhs;      /* current sensitivity rhs  values (imag)*/


     /*
      *  symbolic constants for CKTniState
      *      Note that they are bitwise disjoint
      */

     #define NISHOULDREORDER 0x1
     #define NIREORDERED 0x2
     #define NIUNINITIALIZED 0x4
     #define NIACSHOULDREORDER 0x10
     #define NIACREORDERED 0x20
     #define NIACUNINITIALIZED 0x40
     #define NIDIDPREORDER 0x100
     #define NIPZSHOULDREORDER 0x200

         int CKTmaxEqNum;
         int CKTcurrentAnalysis; /* the analysis in progress (if any) */

     /* defines for the value of  CKTcurrentAnalysis */
     /* are in TSKdefs.h */

         CKTnode *CKTnodes;
         CKTnode *CKTlastNode;
     #define NODENAME(ckt,nodenum) CKTnodName(ckt,nodenum)
         int CKTnumStates;
         long CKTmode;

     /* defines for CKTmode */

     /* old 'mode' parameters */
     #define MODE 0x3
     #define MODETRAN 0x1
     #define MODEAC 0x2

     /* old 'modedc' parameters */
     #define MODEDC 0x70
     #define MODEDCOP 0x10
     #define MODETRANOP 0x20
     #define MODEDCTRANCURVE 0x40

     /* old 'initf' parameters */
     #define INITF 0x3f00
     #define MODEINITFLOAT 0x100
     #define MODEINITJCT 0x200
     #define MODEINITFIX 0x400
     #define MODEINITSMSIG 0x800
     #define MODEINITTRAN 0x1000
     #define MODEINITPRED 0x2000

     /* old 'nosolv' paramater */
     #define MODEUIC 0x10000l

         int CKTbypass;
         int CKTdcMaxIter;       /* iteration limit for dc op.  (itl1) */
         int CKTdcTrcvMaxIter;   /* iteration limit for dc tran. curv (itl2) */
         int CKTtranMaxIter;     /* iteration limit for each timepoint for tran*/
                                 /* (itl4) */
         int CKTbreakSize;
         int CKTbreak;
         double CKTsaveDelta;
         double CKTminBreak;
         double *CKTbreaks;
         double CKTabstol;
         double CKTpivotAbsTol;
         double CKTpivotRelTol;
         double CKTreltol;
         double CKTchgtol;
         double CKTvoltTol;
     #ifdef NEWTRUNC
         double CKTlteReltol;
         double CKTlteAbstol;
     #endif /* NEWTRUNC */
         double CKTgmin;
         double CKTdelmin;
         double CKTtrtol;
         double CKTfinalTime;
         double CKTstep;
         double CKTmaxStep;
         double CKTinitTime;
         double CKTomega;
         double CKTsrcFact;
         double CKTdiagGmin;
         int CKTnumSrcSteps;
         int CKTnumGminSteps;
         int CKTnoncon;
         double CKTdefaultMosL;
         double CKTdefaultMosW;
         double CKTdefaultMosAD;
         double CKTdefaultMosAS;
         unsigned int CKThadNodeset:1;
         unsigned int CKTfixLimit:1; /* flag to indicate that the limiting of
                                      * MOSFETs should be done as in SPICE2 */
         unsigned int CKTnoOpIter:1; /* flag to indicate not to try the operating
                                      * point brute force, but to use gmin stepping
                                      * first */
         unsigned int CKTisSetup:1;  /* flag to indicate if CKTsetup done */
         JOB *CKTcurJob;

         SENstruct *CKTsenInfo;	/* the sensitivity information */
         double *CKTtimePoints;	/* list of all accepted timepoints in the
				        current transient simulation */
         double *CKTdeltaList;	/* list of all timesteps in the current
				        transient simulation */
         int CKTtimeListSize;	/* size of above lists */
         int CKTtimeIndex;		/* current position in above lists */
         int CKTsizeIncr;		/* amount to increment size of above arrays
				        when you run out of space */
         unsigned int CKTtryToCompact:1; /* try to compact past history for LTRA
				        lines */
         unsigned int CKTbadMos3:1; /* Use old, unfixed MOS3 equations */
         unsigned int CKTkeepOpInfo:1; /* flag for small signal analyses */
         int CKTtroubleNode;		/* Non-convergent node number */
         struct sGENinstance *CKTtroubleElt;	/* Non-convergent device instance */
     #ifdef EWB_IIT
	     double CKTiitBreakPoint;
	     double CKTiitSaveDelta;
     #endif
     #ifdef XSPICE
     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */

         struct Evt_Ckt_Data_s *evt;  /* all data about event driven stuff */
         struct Enh_Ckt_Data_t *enh;  /* data used by general enhancements */

     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
     #endif
     #ifdef IIT
         int oldCKTmaxEqNum;
     #endif

#ifdef IIT
     //* Transient analysis options
     #define EXT_MODE_ZERO_IC    0x00000l
     #define EXT_MODE_AUTO_IC    0x000002
     #define EXT_MODE_AUTO_TMAX  0x000004
     #define EXT_MODE_AUTO_TSTEP 0x000008
     long CKText_mode;
#endif
  };

  #ifdef IIT
    #define CKTcircuit_has_been_defined
//insert file>>     #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/


    struct s_sgen* sgen_init(CKTcircuit* ckt,int is_dc);
    int sgen_next(InstanceHandle INST, struct s_sgen **xsg);
    int sens_getp(InstanceHandle INST, struct s_sgen *sg, CKTcircuit *ckt,union uIFvalue* val);
  #endif

  #ifdef EWB_IIT
    int EXPORT getMatrixElement( GENERIC*, GENERIC*, GENERIC*, double**);
    int EXPORT getVoltage(GENERIC*, GENERIC*, GENERIC*, double*);
    int EXPORT addVoltage(GENERIC*, GENERIC*, double);
    int EXPORT getCurrent(GENERIC*, GENERIC*, double*);
    int EXPORT addCurrent(GENERIC*, GENERIC*, GENERIC*, double);
    int EXPORT setBreakPoint(GENERIC*, double);
    int EXPORT setRelativeBreakPoint(GENERIC*, double);
    int EXPORT changeCapacitorValue(GENERIC*, GENERIC*, double);
    int EXPORT changeInductorValue(GENERIC*, GENERIC*, double);
    int EXPORT isFirstIteration(GENERIC*, int*);
    int EXPORT setMaxStep(GENERIC*, double);
  #endif

  #ifdef DLL
    #if defined(MSVC) || !defined(WIN32)
      #undef FAR
    #endif

    #include <windows.h>

    #if defined(MSVC)
      #undef FAR
      #define FAR
	#elif !defined(WIN32)
      #undef FAR
      #define FAR far
    #endif

    #ifdef MSVC
      int EXPORT  SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #else
      int CALLBACK _export SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #endif
  #else
    int SPIinit(InstanceHandle inst);
  #endif

  int ACan(CKTcircuit *, int );
  int ACaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int ACsetParm( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int CKTacDump( CKTcircuit *, double , GENERIC *);
  int CKTacLoad( CKTcircuit *);
  int CKTaccept( CKTcircuit *);
  int CKTacct( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int EXPORT CKTask( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskAnalQ( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskNodQst( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTbindNode( GENERIC *, GENERIC *, int , GENERIC *);
  void CKTbreakDump( CKTcircuit *);
  int CKTclrBreak( CKTcircuit *);
  int CKTconvTest( CKTcircuit *);
  int EXPORT CKTcrtElt( GENERIC *, GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTdelTask( GENERIC *, GENERIC *);
  int EXPORT CKTdestroy( GENERIC *);
  int CKTdltAnal( GENERIC *, GENERIC *, GENERIC *);
  int EXPORT CKTdltInst( GENERIC *, GENERIC *);
  int EXPORT CKTdltMod( GENERIC *, GENERIC *);
  int EXPORT CKTdltNod( GENERIC *, GENERIC *);
  int EXPORT CKTdoJob( GENERIC *, int , GENERIC *);
  void CKTdump( CKTcircuit *, double, GENERIC *);
  int EXPORT CKTfndAnal( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int CKTfndBranch( CKTcircuit *, IFuid);
  int EXPORT CKTfndDev( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int EXPORT CKTfndMod( GENERIC *, int *, GENERIC **, IFuid );
  int EXPORT CKTfndNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTfndTask( GENERIC *, GENERIC **, IFuid  );
  int EXPORT CKTground( GENERIC *, GENERIC **, IFuid );
  int CKTic( CKTcircuit *);
  int EXPORT CKTinit(InstanceHandle handle, GENERIC **);
  int EXPORT CKTinst2Node( GENERIC *, GENERIC *, int , GENERIC **, IFuid *);
  int CKTlinkEq(CKTcircuit*,CKTnode*);
  int CKTload( CKTcircuit *);
  int CKTmapNode( GENERIC *, GENERIC **, IFuid );
  int CKTmkCur( CKTcircuit  *, CKTnode **, IFuid , char *);
  int CKTmkNode(CKTcircuit*,CKTnode**);
  int CKTmkVolt( CKTcircuit  *, CKTnode **, IFuid , char *);
  int EXPORT CKTmodAsk( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTmodCrt( GENERIC *, int , GENERIC **, IFuid );
  int EXPORT CKTmodParam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTnames(CKTcircuit *, int *, IFuid **);
  int EXPORT CKTnewAnal( GENERIC *, int , IFuid , GENERIC **, GENERIC *);
  int CKTnewEq( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewTask( GENERIC *, GENERIC **, IFuid );
  IFuid CKTnodName( CKTcircuit *, int );
  void CKTnodOut( CKTcircuit *);
  CKTnode * CKTnum2nod( CKTcircuit *, int );
  int CKTop(CKTcircuit *, long, long, int );
  int CKTpModName( char *, union uIFvalue *, CKTcircuit *, int , IFuid , struct sGENmodel **);
  int CKTpName( char *, union uIFvalue *, CKTcircuit *, int , char *, struct sGENinstance **);
  int EXPORT CKTparam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTpzFindZeros( CKTcircuit *, PZtrial **, int * );
  int CKTpzLoad( CKTcircuit *, SPcomplex * );
  int CKTpzSetup( CKTcircuit *, int);
  int CKTsenAC( CKTcircuit *);
  int CKTsenComp( CKTcircuit *);
  int CKTsenDCtran( CKTcircuit *);
  int CKTsenLoad( CKTcircuit *);
  void CKTsenPrint( CKTcircuit *);
  int CKTsenSetup( CKTcircuit *);
  int CKTsenUpdate( CKTcircuit *);
  int EXPORT CKTsetAnalPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetBreak( CKTcircuit *, double );
  int EXPORT CKTsetNodPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetOpt( GENERIC *, GENERIC *, int , union uIFvalue *);
  int CKTsetup( CKTcircuit *);
  int CKTunsetup(CKTcircuit *ckt);
  int CKTtemp( CKTcircuit *);
  char * EXPORT CKTtrouble(GENERIC *, char *);
  void CKTterr( int , CKTcircuit *, double *);
  int CKTtrunc( CKTcircuit *, double *);
  int CKTtypelook( char *);
  int DCOaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCOsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCTaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCTsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCop(CKTcircuit *);
  int DCtrCurv(CKTcircuit *, int );
  int DCtran(CKTcircuit *, int );
  int DISTOan(CKTcircuit *, int);
  int NOISEan(CKTcircuit *, int);
  int PZan(CKTcircuit *, int );
  int PZinit(CKTcircuit * );
  int PZpost(CKTcircuit * );
  int PZaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int PZsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  void SENdestroy(InstanceHandle, SENstruct *);
  int SENsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENstartup(CKTcircuit *);
  char* SPerror(InstanceHandle INST, int type);
  int TFanal(CKTcircuit *, int );
  int TFaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TFsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANinit(CKTcircuit *, JOB *);
  int NIacIter(CKTcircuit * );
  int NIcomCof(CKTcircuit * );
  int NIconvTest(CKTcircuit * );
  void NIdestroy(CKTcircuit * );
  int NIinit(CKTcircuit  * );
  int NIintegrate(CKTcircuit *, double *, double *, double , int );
  int NIiter(CKTcircuit * , int );
  int NIpzMuller(InstanceHandle, PZtrial **, PZtrial *);
  int NIpzComplex(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym2(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIreinit(CKTcircuit *);
  int NIsenReinit(CKTcircuit *);
  int EXPORT isFirstIteration (GENERIC *inCkt, int *first_iteration);

  #ifdef EWB_IIT
    int EXPORT modelInitialize(InstanceHandle INST, int modelType,GENERIC* model, IFuid modelUid);
  #endif

//insert file>>   #include "noisedef.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Gary W. Ng
**********/

#ifndef NOISEDEFS
#define NOISEDEFS

//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/


    /* structure used to describe an noise analysis */

typedef struct {
    int JOBtype;
    JOB *JOBnextJob;          /* pointer to next thing to do */
    char *JOBname;            /* name of this job */
    IFnode output;        /* noise output summation node */
    IFnode outputRef;     /* noise output reference node */
    IFuid input;      /* name of the AC source used as input reference */
    double NstartFreq;
    double NstopFreq;
    double NfreqDelta;    /* multiplier for decade/octave stepping, */
                              /* step for linear steps. */
    double NsavFstp; /* frequency step at which we stopped last time */
    double NsavOnoise;   /* integrated output noise when we left off last time */
    double NsavInoise;   /* integrated input noise when we left off last time */
    int NstpType;        /* values described below */
    int NnumSteps;
    int NStpsSm; /* number of steps before we output a noise summary report */
} NOISEAN;



    /* structure used to carry information between subparts of the noise analysis code */

typedef struct {
    double freq;
    double lstFreq;
    double delFreq;
    double outNoiz;       /* integrated output noise as of the last frequency point */
    double inNoise;        /* integrated input noise as of the last frequency point */
    double GainSqInv;
    double lnGainInv;
    double lnFreq;
    double lnLastFreq;
    double delLnFreq;
    int outNumber;      /* keeps track of the current output variable */
    int numPlots;        /* keeps track of the number of active plots so we can close them in */
			   /* a do loop. */
    unsigned int prtSummary;
    double *outpVector;  /* pointer to our array of noise outputs */
    GENERIC *NplotPtr; /* the plot pointer */
    IFuid *namelist;       /* list of plot names */
} Ndata;


/* codes for saving and retrieving integrated noise data */

#define LNLSTDENS 0     /* array location that the log of the last noise density is stored */
#define OUTNOIZ       1     /* array location that integrated output noise is stored */
#define INNOIZ        2     /* array location that integrated input noise is stored */

#define NSTATVARS 3    /* number of "state" variables that must be stored for each noise */
			      /* generator.  in this case it is three: LNLSTDENS, OUTNOIZ */
			      /* and INNOIZ */


/* available step types: */

#define DECADE 1
#define OCTAVE 2
#define LINEAR 3


/* noise analysis parameters */

#define N_OUTPUT     1
#define N_OUTREF 2
#define N_INPUT      3
#define N_START      4
#define N_STOP       5
#define N_STEPS      6
#define N_PTSPERSUM  7
#define N_DEC        8
#define N_OCT        9
#define N_LIN        10


/* noise routine operations/modes */

#define N_DENS    1
#define INT_NOIZ 2
#define N_OPEN       1
#define N_CALC       2
#define N_CLOSE      3
#define SHOTNOISE       1
#define THERMNOISE    2
#define N_GAIN       3


/* tolerances and limits to make numerical analysis more robust */

#define N_MINLOG          1E-38       /* the smallest number we can take the log of */
#define N_MINGAIN         1E-20       /* the smallest input-output gain we can tolerate */
					   /*    (to calculate input-referred noise we divide */
					   /*     the output noise by the gain) */
#define N_INTFTHRESH   1E-10       /* the largest slope (of a log-log noise spectral */
					   /*    density vs. freq plot) at which the noise */
					   /*    spectum is still considered flat. (no need for */
					   /*    log curve fitting) */
#define N_INTUSELOG      1E-10       /* decides which expression to use for the integral of */
					   /*    x**k.  If k is -1, then we must use a 'ln' form. */
					   /*    Otherwise, we use a 'power' form.  This */
					   /*    parameter is the region around (k=) -1 for which */
					   /*    use the 'ln' form. */


/* misc constants */

#define N_MXVLNTH  64   /* maximum length for noise output variables we will generate */
                               /* (see MAXVLENGTH in FTE/writedata.c) */



extern int NsetParm(CKTcircuit *ckt, GENERIC *anal, int which,
	union uIFvalue *value);
extern int NaskQuest(CKTcircuit *ckt, GENERIC *anal, int which,
	union uIFvalue *value);
#endif /*NOISEDEFS*/

  int CKTnoise (CKTcircuit *ckt,int mode, int operation, Ndata *data);
  int CKTdisto(CKTcircuit *ckt,int mode);
  int NIdIter(CKTcircuit *ckt);
  void NInzIter(CKTcircuit *ckt, int posDrive, int negDrive);
#ifndef IIT
  extern struct sIFfrontEnd *SPfrontEnd;
#endif

#ifndef IIT
#ifdef DO_RAWFILE_ALSO
  extern struct sIFfrontEnd *EWB_frontEnd;
  extern struct sIFfrontEnd nutmeginfo;
#endif /* DO_RAWFILE_ALSO */
#endif

#endif /*CKT*/


typedef struct Mif_Circuit_Info_s {
   Mif_BOOLEAN_t   init;        /* TRUE if first call to model */
   Mif_BOOLEAN_t   anal_init;   /* TRUE if first call for this analysis type */
   Mif_Analysis_t  anal_type;   /* The type of analysis being performed */
   Mif_Call_Type_t call_type;   /* Type of call to code model - analog or event-driven */
   double          evt_step;    /* The current DC step or time in event analysis */
} Mif_Circuit_Info_t;


typedef struct Mif_Bkpt_Info_s {
   double           current;    /* The current dynamic breakpoint time */
   double           last;       /* The last used dynamic breakpoint time */
} Mif_Bkpt_Info_t;


typedef struct Mif_Auto_Partial_s {
    Mif_BOOLEAN_t   global;     /* Set by .option to force all models to use auto */
    Mif_BOOLEAN_t   local;      /* Set by individual model to request auto partials */
} Mif_Auto_Partial_t;


typedef struct Mif_Info_s {
   Mif_Circuit_Info_t circuit;    /* Circuit data that will be needed by MIFload */
   struct sMIFinstance *instance;  /* Current instance struct */
   CKTcircuit         *ckt;       /* The ckt struct for the circuit */
   char               *errmsg;    /* An error msg from a cm_... function */
   Mif_Bkpt_Info_t    breakpoint; /* Data used by dynamic breakpoints */
   Mif_Auto_Partial_t auto_partial; /* Flags to enable auto partial computations */
} Mif_Info_t;



extern Mif_Info_t  g_mif_info;


#endif  /* MIF */
//insert file>> #include "mifproto.h"
#ifndef MIFPROTO
#define MIFPROTO

/* ===========================================================================
FILE    MIFproto.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains ANSI C function prototypes for functions in the
    MIF package.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */



//insert file>> #include "MIFtypes.h"
//insert file>> #include "MIFdefs.h"
//insert file>> #include "IFsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

//insert file>> #include "INPdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "SMPdefs.h"
//insert file>> #include "CKTdefs.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CKT
#define CKT "CKTdefs.h $Revision: 1.13 $  on $Date: 89/04/05 13:09:39 $ "
  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing CKTdefs.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

//insert file>>   #include "basic.h"
//insert file>>   #include "xspice.h"

  #ifdef XSPICE
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
//insert file>>     #include "EVT.h"
#ifndef EVT_HEADER
#define EVT_HEADER 

/* ===========================================================================
FILE    EVT.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of the evt data structure and all
    its substructures.  The single evt structure is housed inside of
    the main 3C1 circuit structure 'ckt' and contains virtually all
    information about the event-driven simulation.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFdefs.h"
//insert file>> #include "MIFcmdat.h"
//insert file>> #include "MIFtypes.h"


/* ************** */
/* Info structure */
/* ************** */


typedef struct Evt_Output_Info_s {
    struct Evt_Output_Info_s  *next;  /* the next in the linked list */
    int  node_index;                  /* index into node info struct for this output */
    int  output_subindex;             /* index into output data in node data struct  */
    int  inst_index;                  /* Index of instance the port is on */
    int  port_index;                  /* Index of port the output corresponds to */
} Evt_Output_Info_t;

typedef struct Evt_Port_Info_s {
    struct Evt_Port_Info_s  *next;        /* the next in the linked list of node info */
    int                     inst_index;   /* Index of instance the port is on */
    int                     node_index;   /* index of node the port is connected to */
    char                    *node_name;   /* name of node port is connected to */
    char                    *inst_name;   /* instance name */
    char                    *conn_name;   /* connection name on instance */
    int                     port_num;     /* port number of instance connector */
} Evt_Port_Info_t;

typedef struct Evt_Inst_Index_s {
    struct Evt_Inst_Index_s  *next;           /* the next in the linked list */
    int                      index_value;     /* the value of the index */
} Evt_Inst_Index_t;

typedef struct Evt_Node_Info_s {
    struct Evt_Node_Info_s  *next;     /* the next in the linked list */
    char              *name;           /* Name of node in deck */
    int               udn_index;       /* Index of the node type */
    Mif_BOOLEAN_t     invert;          /* True if need to make inverted copy */
    int               num_ports;       /* Number of ports connected to this node */
    int               num_outputs;     /* Number of outputs connected to this node */
    int               num_insts;       /* The number of insts receiving node as input */
    Evt_Inst_Index_t  *inst_list;      /* Linked list of indexes of these instances */
} Evt_Node_Info_t;

typedef struct Evt_Inst_Info_s {
    struct Evt_Inst_Info_s  *next;      /* the next in the linked list of node info */
    struct sMIFinstance     *inst_ptr;  /* Pointer to MIFinstance struct for this instance */
} Evt_Inst_Info_t;

typedef struct Evt_Info_ {
    Evt_Inst_Info_t    *inst_list;         /* static info about event/hybrid instances */
    Evt_Node_Info_t    *node_list;         /* static info about event nodes */
    Evt_Port_Info_t    *port_list;         /* static info about event ports */
    Evt_Output_Info_t  *output_list;       /* static info about event outputs */
    int                *hybrid_index;      /* vector of inst indexs for hybrids */
    Evt_Inst_Info_t    **inst_table;       /* vector of pointers to elements in inst_list */
    Evt_Node_Info_t    **node_table;       /* vector of pointers to elements in node_list */
    Evt_Port_Info_t    **port_table;       /* vector of pointers to elements in port_list */
    Evt_Output_Info_t  **output_table;     /* vector of pointers to elements in output_list */
} Evt_Info_t;








/* *************** */
/* Queue structure */
/* *************** */



typedef struct Evt_Inst_Event_s {
    struct Evt_Inst_Event_s  *next; /* the next in the linked list */
    double            event_time;   /* Time for this event to happen */
    double            posted_time;  /* Time at which event was entered in queue */
} Evt_Inst_Event_t; 

typedef struct Evt_Inst_Queue_s {
    Evt_Inst_Event_t  **head;          /* Beginning of linked lists */
    Evt_Inst_Event_t  ***current;      /* Beginning of pending events */
    Evt_Inst_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Inst_Event_t  **free;          /* Linked lists of items freed by backups */
    double            last_time;       /* Time at which last_step was set */
    double            next_time;       /* Earliest next event time in queue */
    int               num_modified;    /* Number modified since last accepted timepoint */
    int               *modified_index; /* Indexes of modified instances */
    Mif_BOOLEAN_t     *modified;       /* Flags used to prevent multiple entries */
    int               num_pending;     /* Count of number of pending events in lists */
    int               *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t     *pending;        /* Flags used to prevent multiple entries */
    int               num_to_call;     /* Count of number of instances that need to be called */
    int               *to_call_index;  /* Indexes of instances to be called */
    Mif_BOOLEAN_t     *to_call;        /* Flags used to prevent multiple entries */
} Evt_Inst_Queue_t;




typedef struct Evt_Node_Queue_s {
    int               num_to_eval;    /* Count of number of nodes that need to be evaluated */
    int               *to_eval_index; /* Indexes of nodes to be evaluated */
    Mif_BOOLEAN_t     *to_eval;       /* Flags used to prevent multiple entries */
    int               num_changed;    /* Count of number of nodes that changed */
    int               *changed_index; /* Indexes of nodes that changed */
    Mif_BOOLEAN_t     *changed;       /* Flags used to prevent multiple entries */
} Evt_Node_Queue_t;




typedef struct Evt_Output_Event_s {
    struct Evt_Output_Event_s  *next; /* the next in the linked list */
    double            event_time;     /* Time for this event to happen */
    double            posted_time;    /* Time at which event was entered in queue */
    Mif_BOOLEAN_t     removed;        /* True if event has been deactivated */
    double            removed_time;   /* Time at which event was deactivated */
    void              *value;         /* The delayed value sent to this output */
} Evt_Output_Event_t; 

typedef struct Evt_Output_Queue_s {
    Evt_Output_Event_t  **head;          /* Beginning of linked lists */
    Evt_Output_Event_t  ***current;      /* Beginning of pending events */
    Evt_Output_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Output_Event_t  **free;          /* Linked lists of items freed by backups */
    double              last_time;       /* Time at which last_step was set */
    double              next_time;       /* Earliest next event time in queue */
    int                 num_modified;    /* Number modified since last accepted timepoint */
    int                 *modified_index; /* Indexes of modified outputs */
    Mif_BOOLEAN_t       *modified;       /* Flags used to prevent multiple entries */
    int                 num_pending;     /* Count of number of pending events in lists */
    int                 *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t       *pending;        /* Flags used to prevent multiple entries */
    int                 num_changed;     /* Count of number of outputs that changed */
    int                 *changed_index;  /* Indexes of outputs that changed */
    Mif_BOOLEAN_t       *changed;        /* Flags used to prevent multiple entries */
} Evt_Output_Queue_t;




typedef struct Evt_Queue_s {
    Evt_Inst_Queue_t   inst;               /* dynamic queue for instances */
    Evt_Node_Queue_t   node;               /* dynamic queue of changing nodes */
    Evt_Output_Queue_t output;             /* dynamic queue of delayed outputs */
} Evt_Queue_t;




/* ************** */
/* Data structure */
/* ************** */




typedef struct Evt_Node_s {
    struct Evt_Node_s *next;          /* pointer to next in linked list */
    Mif_BOOLEAN_t    op;              /* true if computed from op analysis */
    double           step;            /* DC step or time at which data was computed */
    void             **output_value;  /* Array of outputs posted to this node */
    void             *node_value;     /* Resultant computed from output values */
    void             *inverted_value; /* Inverted copy of node_value */
} Evt_Node_t;

typedef struct {
    Evt_Node_t     **head;          /* Beginning of linked lists */
    Evt_Node_t     ***tail;         /* Location of last item added to list */
    Evt_Node_t     ***last_step;    /* 'tail' at last accepted timepoint */
    Evt_Node_t     **free;          /* Linked lists of items freed by backups */
    int            num_modified;    /* Number modified since last accepted timepoint */
    int            *modified_index; /* Indexes of modified nodes */
    Mif_BOOLEAN_t  *modified;       /* Flags used to prevent multiple entries */
    Evt_Node_t     *rhs;            /* Location where model outputs are placed */
    Evt_Node_t     *rhsold;         /* Location where model inputs are retrieved */
    double         *total_load;     /* Location where total load inputs are retrieved */
} Evt_Node_Data_t;




typedef struct Evt_State_s {
    struct Evt_State_s   *next;        /* Pointer to next state */
    struct Evt_State_s   *prev;        /* Pointer to previous state */
    double               step;         /* Time at which state was assigned (0 for DC) */
    void                 *block;       /* Block of memory holding all states on inst */
} Evt_State_t;


typedef struct Evt_State_Desc_s {
    struct Evt_State_Desc_s *next;   /* Pointer to next description */
    int                     tag;     /* Tag for this state */
    int                     size;    /* Size of this state */
    int                     offset;  /* Offset of this state into the state block */
} Evt_State_Desc_t;


typedef struct Evt_State_Data_s {
    Evt_State_t    **head;              /* Beginning of linked lists */
    Evt_State_t    ***tail;             /* Location of last item added to list */
    Evt_State_t    ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_State_t    **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
    int            *total_size;         /* Total bytes for all states allocated */
    Evt_State_Desc_t **desc;            /* Lists of description structures */
} Evt_State_Data_t;




typedef struct Evt_Msg_s {
    struct Evt_Msg_s     *next;      /* Pointer to next state */
    Mif_BOOLEAN_t        op;         /* true if output from op analysis */
    double               step;       /* DC step or time at which message was output */
    char                 *text;      /* The value of the message text */
    int                  port_index; /* The index of the port from which the message came */
} Evt_Msg_t;


typedef struct Evt_Msg_Data_s {
    Evt_Msg_t      **head;              /* Beginning of linked lists */
    Evt_Msg_t      ***tail;             /* Location of last item added to list */
    Evt_Msg_t      ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_Msg_t      **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
} Evt_Msg_Data_t;


typedef struct Evt_Statistic_s {
    int                op_alternations;    /* Total alternations between event and analog */
    int                op_load_calls;      /* Total load calls in DCOP analysis */
    int                op_event_passes;    /* Total passes through event iteration loop */
    int                tran_load_calls;    /* Total inst calls in transient analysis */
    int                tran_time_backups;  /* Number of transient timestep cuts */
} Evt_Statistic_t;




typedef struct Evt_Data_s {
    Evt_Node_Data_t    *node;               /* dynamic event solution vector */
    Evt_State_Data_t   *state;              /* dynamic event instance state data */
    Evt_Msg_Data_t     *msg;                /* dynamic event message data */
    Evt_Statistic_t    *statistics;         /* Statistics for events, etc. */
} Evt_Data_t;



/* **************** */
/* Counts structure */
/* **************** */


typedef struct Evt_Count_s {
    int          num_insts;             /* number of event/hybrid instances parsed */
    int          num_hybrids;           /* number of hybrids parsed */
    int          num_hybrid_outputs;    /* number of outputs on all hybrids parsed */
    int          num_nodes;             /* number of event nodes parsed */
    int          num_ports;             /* number of event ports parsed */
    int          num_outputs;           /* number of event outputs parsed */
} Evt_Count_t;



/* **************** */
/* Limits structure */
/* **************** */


typedef struct Evt_Limit_s {
    int         max_event_passes;    /* maximum loops in attempting convergence of event nodes */
    int         max_op_alternations; /* maximum loops through event/analog alternation */
} Evt_Limit_t;


/* ************** */
/* Jobs structure */
/* ************** */


typedef struct Evt_Job_s {
    int                num_jobs;           /* Number of jobs run */
    char               **job_name;         /* Names of different jobs */
    Evt_Node_Data_t    **node_data;        /* node_data for different jobs */
    Evt_State_Data_t   **state_data;       /* state_data for different jobs */
    Evt_Msg_Data_t     **msg_data;         /* messages for different jobs */
    Evt_Statistic_t    **statistics;       /* Statistics for different jobs */
} Evt_Job_t;



/* ***************** */
/* Options structure */
/* ***************** */


typedef struct Evt_Option_s {
    Mif_BOOLEAN_t   op_alternate;        /* Alternate analog/event solutions in OP analysis */
} Evt_Option_t;


/* ****************** */
/* Main evt structure */
/* ****************** */

typedef struct Evt_Ckt_Data_s {
    Evt_Count_t     counts;         /* Number of insts, nodes, etc. */
    Evt_Info_t      info;           /* Static info about insts, etc. */
    Evt_Queue_t     queue;          /* Dynamic queued events */
    Evt_Data_t      data;           /* Results and state data */
    Evt_Limit_t     limits;         /* Iteration limits, etc. */
    Evt_Job_t       jobs;           /* Data held from multiple job runs */
    Evt_Option_t    options;        /* Data input on .options cards */
} Evt_Ckt_Data_t;



#endif /* EVT_HEADER */
//insert file>>     #include "ENH.h"
#ifndef ENH_HEADER
#define ENH_HEADER 

/* ===========================================================================
FILE    ENH.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains typedefs used by the event-driven algorithm.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFtypes.h"
//insert file>> #include "FTEinp.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 *
 * Note that this definition must be the same as struct card in INPdefs.h...
 */


/*
The following data is used in implementing various enhancements made to the
simulator.  The main struct is dynamically allocated in ckt so that incremental additions
can be made more easily without the need to recompile multiple modules.
Allocation and initialization is done in CKTinit.c which should be the only
module needed to recompile after additions are made here.
*/


typedef enum Enh_Conv_Source_t {
    ENH_ANALOG_NODE,            /* An analog node */
    ENH_EVENT_NODE,             /* An event-driven node */
    ENH_ANALOG_BRANCH,          /* A branch current */
    ENH_ANALOG_INSTANCE,        /* An analog instance */
    ENH_EVENT_INSTANCE,         /* An event-driven instance */
    ENH_HYBRID_INSTANCE,        /* A hybrid (analog/event-driven) instance */
} Enh_Conv_Source_t;


typedef struct Enh_Bkpt_t {
   double           current;    /* The current dynamic breakpoint time */
   double           last;       /* The last used dynamic breakpoint time */
} Enh_Bkpt_t;

typedef struct Enh_Ramp_t {
    double           ramptime;    /* supply ramping time specified on .options */
} Enh_Ramp_t;

typedef struct Enh_Conv_Debug_t {
    Mif_BOOLEAN_t    last_NIiter_call;  /* True if this is the last call to NIiter() */
    Mif_BOOLEAN_t    report_conv_probs; /* True if conv test functions should send debug info */
} Enh_Conv_Debug_t;


typedef struct Enh_Conv_Limit_t {
    Mif_BOOLEAN_t    enabled;           /* True if convergence limiting enabled on code models */
    double           abs_step;          /* Minimum limiting step size */
    double           step;              /* Fractional step amount */
} Enh_Conv_Limit_t;


typedef struct Enh_Rshunt_t {
    Mif_BOOLEAN_t    enabled;      /* True if rshunt option used */
    double           gshunt;       /* 1.0 / rshunt */
    int              num_nodes;    /* Number of nodes in matrix */
    double           **diag;       /* Pointers to matrix diagonals */
} Enh_Rshunt_t;


typedef struct Enh_Ckt_Data_t {
    Enh_Bkpt_t       breakpoint;   /* Data used by dynamic breakpoints */
    Enh_Ramp_t       ramp;         /* New options added to simulator */
    Enh_Conv_Debug_t conv_debug;   /* Convergence debug info dumping data */
    Enh_Conv_Limit_t conv_limit;   /* Convergence limiting info */
    Enh_Rshunt_t     rshunt_data;  /* Shunt conductance from nodes to ground */
} Enh_Ckt_Data_t;



void ENHreport_conv_prob(Enh_Conv_Source_t type, char *name, char *msg);
struct line *ENHtranslate_poly(InstanceHandle inst, struct line *deck);


#endif /* ENH_HEADER */
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
  #endif


  #define MAXNUMDEVS 32
  extern int DEVmaxnum;
  #define MAXNUMDEVNODES 4

//insert file>>   #include "smpdefs.h"
//insert file>>   #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

//insert file>>   #include "acdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "gendefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "trcvdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */
//insert file>>   #include "optdefs.h"
//insert file>> #include "xspice.h"

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "sen2defs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/
/*
 * SENdefs.h - structures for sensitivity package
 */

//insert file>>   #include "pzdefs.h"
#ifndef PZDEFS
#define PZDEFS "PZdefs.h $Revision: 1.3 $  on $Date: 88/11/16 21:55:29 $ "

    /* structure used to describe an PZ analysis to be performed */

//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "complex.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CMPLX
#define CMPLX "complex.h $Revision: 1.5 $  on $Date: 88/11/22 02:51:07 $ "

/*  header file containing definitions for complex functions
 *
 *  Each expects two arguments for each complex number - a real and an
 *  imaginary part.
 */
typedef struct {
    double real;
    double imag;
} SPcomplex;


#define DC_ABS(a,b) (FABS(a) + FABS(b))

#ifdef notdef
#define DC_DIV(a,b,c,d,x,y) { \
    double r,s;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((a)+(b)*r)/s;\
        y=((b)-(a)*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((a)*r+(b))/s;\
        y=((b)*r-(a))/s;\
    }\
}
#endif /*notdef */

#ifndef HAS_SHORTMACRO
#define DC_DIVEQ(a,b,c,d) { \
    double r,s,x,y;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((*(a))+(*(b))*r)/s;\
        y=((*(b))-(*(a))*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((*(a))*r+(*(b)))/s;\
        y=((*(b))*r-(*(a)))/s;\
    }\
    (*(a)) = x; \
    (*(b)) = y; \
}
#else /*HAS_SHORTMACRO*/
#define DC_DIVEQ DCdiveq
#ifdef IIT
extern void DCdiveq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCdiveq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifndef HAS_SHORTMACRO
#define DC_MULT(a,b,c,d,x,y) { \
    *(x) = (a) * (c) - (b) * (d) ;\
    *(y) = (a) * (d) + (b) * (c) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MULT DCmult
#ifdef IIT
extern void DCmult(InstanceHandle inst, double,double,double,double,double*,double*);
#else /* stdc */
extern void DCmult(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifdef notdef 
#define DC_MINUS(a,b,c,d,x,y) { \
    (x) = (a) - (c) ;\
    (y) = (b) - (d) ;\
}
#endif /*notdef*/

#ifndef HAS_SHORTMACRO
#define DC_MINUSEQ(a,b,c,d) { \
    *(a) -= (c) ;\
    *(b) -= (d) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MINUSEQ DCminusEq
#ifdef IIT
extern void DCminusEq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCminusEq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#define	C_SQRT(A) {							      \
	double	_mag, _a;						      \
	if ((A).imag == 0.0) {						      \
	    if ((A).real < 0.0) {					      \
		(A).imag = sqrt(-(A).real);				      \
		(A).real = 0.0;						      \
	    } else {							      \
		(A).real = sqrt((A).real);				      \
		(A).imag = 0.0;						      \
	    }								      \
	} else {							      \
	    _mag = sqrt((A).real * (A).real + (A).imag * (A).imag);	      \
	    _a = (_mag - (A).real) / 2.0;				      \
	    if (_a <= 0.0) {						      \
		(A).real = sqrt(_mag);					      \
		(A).imag /= (2.0 * (A).real); /*XXX*/			      \
	    } else {							      \
		_a = sqrt(_a);						      \
		(A).real = (A).imag / (2.0 * _a);			      \
		(A).imag = _a;						      \
	    }								      \
	}								      \
    }

#define	C_MAG2(A) (((A).real = (A).real * (A).real + (A).imag * (A).imag),    \
	(A).imag = 0.0)

#define	C_CONJ(A) ((A).imag *= -1.0)

#define	C_CONJEQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = - (B.imag);						      \
    }

#define	C_EQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = (B.imag);						      \
    }

#define	C_NORM(A,B) {							      \
	if ((A).real == 0.0 && (A).imag == 0.0) {			      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS((A).real) > 1.0 || FABS((A).imag) > 1.0) {	      \
		(B) += 1;						      \
		(A).real /= 2.0;					      \
		(A).imag /= 2.0;					      \
	    }								      \
	    while (FABS((A).real) <= 0.5 && FABS((A).imag) <= 0.5) {	      \
		(B) -= 1;						      \
		(A).real *= 2.0;					      \
		(A).imag *= 2.0;					      \
	    }								      \
	}								      \
    }

#define	C_ABS(A) (sqrt((A).real * (A.real) + (A.imag * A.imag)))

#define	C_MUL(A,B) {							      \
	double	TMP1, TMP2;						      \
	TMP1 = (A.real);						      \
	TMP2 = (B.real);						      \
	(A).real = TMP1 * TMP2 - (A.imag) * (B.imag);			      \
	(A).imag = TMP1 * (B.imag) + (A.imag) * TMP2;			      \
    }

#define	C_MULEQ(A,B,C) {						      \
	(A).real = (B.real) * (C.real) - (B.imag) * (C.imag);		      \
	(A).imag = (B.real) * (C.imag) + (B.imag) * (C.real);		      \
    }

#define	C_DIV(A,B) {							      \
	double	_tmp, _mag;						      \
	_tmp = (A.real);						      \
	(A).real = _tmp * (B.real) + (A).imag * (B.imag);		      \
	(A).imag = - _tmp * (B.imag) + (A.imag) * (B.real);		      \
	_mag = (B.real) * (B.real) + (B.imag) * (B.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_DIVEQ(A,B,C) {						      \
	double	_mag;							      \
	(A).real = (B.real) * (C.real) + (B.imag) * (C.imag);		      \
	(A).imag = (B.imag) * (C.real) - (B.real) * (C.imag) ;		      \
	_mag = (C.real) * (C.real) + (C.imag) * (C.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_ADD(A,B) {							      \
	(A).real += (B.real);						      \
	(A).imag += (B.imag);						      \
    }

#define	C_ADDEQ(A,B,C) {						      \
	(A).real = (B.real) + (C.real);					      \
	(A).imag = (B.imag) + (C.imag);					      \
    }

#define	C_SUB(A,B) {							      \
	(A).real -= (B.real);						      \
	(A).imag -= (B.imag);						      \
    }

#define	C_SUBEQ(A,B,C) {						      \
	(A).real = (B.real) - (C.real);					      \
	(A).imag = (B.imag) - (C.imag);					      \
    }



#endif /*CMPLX*/

typedef struct strial {
    SPcomplex	s, f_raw, f_def;
    struct strial *next, *prev;
    int		mag_raw, mag_def;
    int		multiplicity;
    int		flags;
    int		seq_num;
    int		count;
} PZtrial;

typedef struct {
    int JOBtype;
    JOB *JOBnextJob;
    IFuid JOBname;
    int PZin_pos;
    int PZin_neg;
    int PZout_pos;
    int PZout_neg;
    int PZinput_type;
    int PZwhich;
    int PZnumswaps;
    int PZbalance_col;
    int PZsolution_col;
    PZtrial *PZpoleList;
    PZtrial *PZzeroList;
    int PZnPoles;
    int PZnZeros;
    double *PZdrive_pptr;
    double *PZdrive_nptr;
} PZAN;

#define PZ_DO_POLES	0x1
#define PZ_DO_ZEROS	0x2
#define PZ_IN_VOL	1
#define PZ_IN_CUR	2

#define PZ_NODEI 1
#define PZ_NODEG 2
#define PZ_NODEJ 3
#define PZ_NODEK 4
#define PZ_V 5
#define PZ_I 6
#define PZ_POL 7
#define PZ_ZER 8
#define PZ_PZ 9

#endif /*PZDEFS*/



  typedef struct sCKTnode {
      IFuid name;
      int type;

      #define SP_VOLTAGE 3
      #define SP_CURRENT 4
      #define NODE_VOLTAGE SP_VOLTAGE
      #define NODE_CURRENT SP_CURRENT

      int number;
      double ic;
      double nodeset;
      double *ptr;
      struct sCKTnode *next;
      unsigned int icGiven:1;
      unsigned int nsGiven:1;
  } CKTnode;

  /* defines for node parameters */
  #define PARM_NS 1
  #define PARM_IC 2
  #define PARM_NODETYPE 3


  struct CKTcircuit_tag {
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif

     #ifdef XSPICE
     /* gtri - begin - wbk - change declaration to allow dynamic sizing */

     /* An associated change is made in CKTinit.c to alloc the space */
     /* required for the pointers.  No changes are needed to the source */
     /* code at the 3C1 level, although the compiler will generate */
     /* slightly different code for references to this data. */

     /*  GENmodel *CKThead[MAXNUMDEVS];  */
         struct sGENmodel **CKThead;

     /* gtri - end   - wbk - change declaration to allow dynamic sizing */
     #else
         struct sGENmodel *CKThead[MAXNUMDEVS];
     #endif
         STATistics *CKTstat;
         double *(CKTstates[8]);
     #define CKTstate0 CKTstates[0]
     #define CKTstate1 CKTstates[1]
     #define CKTstate2 CKTstates[2]
     #define CKTstate3 CKTstates[3]
     #define CKTstate4 CKTstates[4]
     #define CKTstate5 CKTstates[5]
     #define CKTstate6 CKTstates[6]
     #define CKTstate7 CKTstates[7]
         double CKTtime;
         double CKTdelta;
         double CKTdeltaOld[7];
         double CKTtemp;
         double CKTnomTemp;
         double CKTvt;
         double CKTag[7];        /* the gear variable coefficient matrix */
     #ifdef PREDICTOR
         double CKTagp[7];       /* the gear predictor variable coefficient matrix */
     #endif /*PREDICTOR*/
         int CKTorder;           /* the integration method order */
         int CKTmaxOrder;        /* maximum integration method order */
         int CKTintegrateMethod; /* the integration method to be used */

     /* known integration methods */
     #define TRAPEZOIDAL 1
     #define GEAR 2

         SMPmatrix *CKTmatrix;   /* pointer to sparse matrix */
         int CKTniState;         /* internal state */
         double *CKTrhs;         /* current rhs value - being loaded */
         double *CKTrhsOld;      /* previous rhs value for convergence testing */
         double *CKTrhsSpare;    /* spare rhs value for reordering */
         double *CKTirhs;        /* current rhs value - being loaded (imag) */
         double *CKTirhsOld;     /* previous rhs value (imaginary)*/
         double *CKTirhsSpare;   /* spare rhs value (imaginary)*/
     #ifdef PREDICTOR
         double *CKTpred;        /* predicted solution vector */
         double *CKTsols[8];     /* previous 8 solutions */
     #endif /* PREDICTOR */

         double *CKTrhsOp;      /* operating point values */
         double *CKTsenRhs;      /* current sensitivity rhs  values */
         double *CKTseniRhs;      /* current sensitivity rhs  values (imag)*/


     /*
      *  symbolic constants for CKTniState
      *      Note that they are bitwise disjoint
      */

     #define NISHOULDREORDER 0x1
     #define NIREORDERED 0x2
     #define NIUNINITIALIZED 0x4
     #define NIACSHOULDREORDER 0x10
     #define NIACREORDERED 0x20
     #define NIACUNINITIALIZED 0x40
     #define NIDIDPREORDER 0x100
     #define NIPZSHOULDREORDER 0x200

         int CKTmaxEqNum;
         int CKTcurrentAnalysis; /* the analysis in progress (if any) */

     /* defines for the value of  CKTcurrentAnalysis */
     /* are in TSKdefs.h */

         CKTnode *CKTnodes;
         CKTnode *CKTlastNode;
     #define NODENAME(ckt,nodenum) CKTnodName(ckt,nodenum)
         int CKTnumStates;
         long CKTmode;

     /* defines for CKTmode */

     /* old 'mode' parameters */
     #define MODE 0x3
     #define MODETRAN 0x1
     #define MODEAC 0x2

     /* old 'modedc' parameters */
     #define MODEDC 0x70
     #define MODEDCOP 0x10
     #define MODETRANOP 0x20
     #define MODEDCTRANCURVE 0x40

     /* old 'initf' parameters */
     #define INITF 0x3f00
     #define MODEINITFLOAT 0x100
     #define MODEINITJCT 0x200
     #define MODEINITFIX 0x400
     #define MODEINITSMSIG 0x800
     #define MODEINITTRAN 0x1000
     #define MODEINITPRED 0x2000

     /* old 'nosolv' paramater */
     #define MODEUIC 0x10000l

         int CKTbypass;
         int CKTdcMaxIter;       /* iteration limit for dc op.  (itl1) */
         int CKTdcTrcvMaxIter;   /* iteration limit for dc tran. curv (itl2) */
         int CKTtranMaxIter;     /* iteration limit for each timepoint for tran*/
                                 /* (itl4) */
         int CKTbreakSize;
         int CKTbreak;
         double CKTsaveDelta;
         double CKTminBreak;
         double *CKTbreaks;
         double CKTabstol;
         double CKTpivotAbsTol;
         double CKTpivotRelTol;
         double CKTreltol;
         double CKTchgtol;
         double CKTvoltTol;
     #ifdef NEWTRUNC
         double CKTlteReltol;
         double CKTlteAbstol;
     #endif /* NEWTRUNC */
         double CKTgmin;
         double CKTdelmin;
         double CKTtrtol;
         double CKTfinalTime;
         double CKTstep;
         double CKTmaxStep;
         double CKTinitTime;
         double CKTomega;
         double CKTsrcFact;
         double CKTdiagGmin;
         int CKTnumSrcSteps;
         int CKTnumGminSteps;
         int CKTnoncon;
         double CKTdefaultMosL;
         double CKTdefaultMosW;
         double CKTdefaultMosAD;
         double CKTdefaultMosAS;
         unsigned int CKThadNodeset:1;
         unsigned int CKTfixLimit:1; /* flag to indicate that the limiting of
                                      * MOSFETs should be done as in SPICE2 */
         unsigned int CKTnoOpIter:1; /* flag to indicate not to try the operating
                                      * point brute force, but to use gmin stepping
                                      * first */
         unsigned int CKTisSetup:1;  /* flag to indicate if CKTsetup done */
         JOB *CKTcurJob;

         SENstruct *CKTsenInfo;	/* the sensitivity information */
         double *CKTtimePoints;	/* list of all accepted timepoints in the
				        current transient simulation */
         double *CKTdeltaList;	/* list of all timesteps in the current
				        transient simulation */
         int CKTtimeListSize;	/* size of above lists */
         int CKTtimeIndex;		/* current position in above lists */
         int CKTsizeIncr;		/* amount to increment size of above arrays
				        when you run out of space */
         unsigned int CKTtryToCompact:1; /* try to compact past history for LTRA
				        lines */
         unsigned int CKTbadMos3:1; /* Use old, unfixed MOS3 equations */
         unsigned int CKTkeepOpInfo:1; /* flag for small signal analyses */
         int CKTtroubleNode;		/* Non-convergent node number */
         struct sGENinstance *CKTtroubleElt;	/* Non-convergent device instance */
     #ifdef EWB_IIT
	     double CKTiitBreakPoint;
	     double CKTiitSaveDelta;
     #endif
     #ifdef XSPICE
     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */

         struct Evt_Ckt_Data_s *evt;  /* all data about event driven stuff */
         struct Enh_Ckt_Data_t *enh;  /* data used by general enhancements */

     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
     #endif
     #ifdef IIT
         int oldCKTmaxEqNum;
     #endif

#ifdef IIT
     //* Transient analysis options
     #define EXT_MODE_ZERO_IC    0x00000l
     #define EXT_MODE_AUTO_IC    0x000002
     #define EXT_MODE_AUTO_TMAX  0x000004
     #define EXT_MODE_AUTO_TSTEP 0x000008
     long CKText_mode;
#endif
  };

  #ifdef IIT
    #define CKTcircuit_has_been_defined
//insert file>>     #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/


    struct s_sgen* sgen_init(CKTcircuit* ckt,int is_dc);
    int sgen_next(InstanceHandle INST, struct s_sgen **xsg);
    int sens_getp(InstanceHandle INST, struct s_sgen *sg, CKTcircuit *ckt,union uIFvalue* val);
  #endif

  #ifdef EWB_IIT
    int EXPORT getMatrixElement( GENERIC*, GENERIC*, GENERIC*, double**);
    int EXPORT getVoltage(GENERIC*, GENERIC*, GENERIC*, double*);
    int EXPORT addVoltage(GENERIC*, GENERIC*, double);
    int EXPORT getCurrent(GENERIC*, GENERIC*, double*);
    int EXPORT addCurrent(GENERIC*, GENERIC*, GENERIC*, double);
    int EXPORT setBreakPoint(GENERIC*, double);
    int EXPORT setRelativeBreakPoint(GENERIC*, double);
    int EXPORT changeCapacitorValue(GENERIC*, GENERIC*, double);
    int EXPORT changeInductorValue(GENERIC*, GENERIC*, double);
    int EXPORT isFirstIteration(GENERIC*, int*);
    int EXPORT setMaxStep(GENERIC*, double);
  #endif

  #ifdef DLL
    #if defined(MSVC) || !defined(WIN32)
      #undef FAR
    #endif

    #include <windows.h>

    #if defined(MSVC)
      #undef FAR
      #define FAR
	#elif !defined(WIN32)
      #undef FAR
      #define FAR far
    #endif

    #ifdef MSVC
      int EXPORT  SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #else
      int CALLBACK _export SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #endif
  #else
    int SPIinit(InstanceHandle inst);
  #endif

  int ACan(CKTcircuit *, int );
  int ACaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int ACsetParm( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int CKTacDump( CKTcircuit *, double , GENERIC *);
  int CKTacLoad( CKTcircuit *);
  int CKTaccept( CKTcircuit *);
  int CKTacct( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int EXPORT CKTask( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskAnalQ( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskNodQst( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTbindNode( GENERIC *, GENERIC *, int , GENERIC *);
  void CKTbreakDump( CKTcircuit *);
  int CKTclrBreak( CKTcircuit *);
  int CKTconvTest( CKTcircuit *);
  int EXPORT CKTcrtElt( GENERIC *, GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTdelTask( GENERIC *, GENERIC *);
  int EXPORT CKTdestroy( GENERIC *);
  int CKTdltAnal( GENERIC *, GENERIC *, GENERIC *);
  int EXPORT CKTdltInst( GENERIC *, GENERIC *);
  int EXPORT CKTdltMod( GENERIC *, GENERIC *);
  int EXPORT CKTdltNod( GENERIC *, GENERIC *);
  int EXPORT CKTdoJob( GENERIC *, int , GENERIC *);
  void CKTdump( CKTcircuit *, double, GENERIC *);
  int EXPORT CKTfndAnal( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int CKTfndBranch( CKTcircuit *, IFuid);
  int EXPORT CKTfndDev( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int EXPORT CKTfndMod( GENERIC *, int *, GENERIC **, IFuid );
  int EXPORT CKTfndNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTfndTask( GENERIC *, GENERIC **, IFuid  );
  int EXPORT CKTground( GENERIC *, GENERIC **, IFuid );
  int CKTic( CKTcircuit *);
  int EXPORT CKTinit(InstanceHandle handle, GENERIC **);
  int EXPORT CKTinst2Node( GENERIC *, GENERIC *, int , GENERIC **, IFuid *);
  int CKTlinkEq(CKTcircuit*,CKTnode*);
  int CKTload( CKTcircuit *);
  int CKTmapNode( GENERIC *, GENERIC **, IFuid );
  int CKTmkCur( CKTcircuit  *, CKTnode **, IFuid , char *);
  int CKTmkNode(CKTcircuit*,CKTnode**);
  int CKTmkVolt( CKTcircuit  *, CKTnode **, IFuid , char *);
  int EXPORT CKTmodAsk( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTmodCrt( GENERIC *, int , GENERIC **, IFuid );
  int EXPORT CKTmodParam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTnames(CKTcircuit *, int *, IFuid **);
  int EXPORT CKTnewAnal( GENERIC *, int , IFuid , GENERIC **, GENERIC *);
  int CKTnewEq( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewTask( GENERIC *, GENERIC **, IFuid );
  IFuid CKTnodName( CKTcircuit *, int );
  void CKTnodOut( CKTcircuit *);
  CKTnode * CKTnum2nod( CKTcircuit *, int );
  int CKTop(CKTcircuit *, long, long, int );
  int CKTpModName( char *, union uIFvalue *, CKTcircuit *, int , IFuid , struct sGENmodel **);
  int CKTpName( char *, union uIFvalue *, CKTcircuit *, int , char *, struct sGENinstance **);
  int EXPORT CKTparam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTpzFindZeros( CKTcircuit *, PZtrial **, int * );
  int CKTpzLoad( CKTcircuit *, SPcomplex * );
  int CKTpzSetup( CKTcircuit *, int);
  int CKTsenAC( CKTcircuit *);
  int CKTsenComp( CKTcircuit *);
  int CKTsenDCtran( CKTcircuit *);
  int CKTsenLoad( CKTcircuit *);
  void CKTsenPrint( CKTcircuit *);
  int CKTsenSetup( CKTcircuit *);
  int CKTsenUpdate( CKTcircuit *);
  int EXPORT CKTsetAnalPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetBreak( CKTcircuit *, double );
  int EXPORT CKTsetNodPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetOpt( GENERIC *, GENERIC *, int , union uIFvalue *);
  int CKTsetup( CKTcircuit *);
  int CKTunsetup(CKTcircuit *ckt);
  int CKTtemp( CKTcircuit *);
  char * EXPORT CKTtrouble(GENERIC *, char *);
  void CKTterr( int , CKTcircuit *, double *);
  int CKTtrunc( CKTcircuit *, double *);
  int CKTtypelook( char *);
  int DCOaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCOsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCTaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCTsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCop(CKTcircuit *);
  int DCtrCurv(CKTcircuit *, int );
  int DCtran(CKTcircuit *, int );
  int DISTOan(CKTcircuit *, int);
  int NOISEan(CKTcircuit *, int);
  int PZan(CKTcircuit *, int );
  int PZinit(CKTcircuit * );
  int PZpost(CKTcircuit * );
  int PZaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int PZsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  void SENdestroy(InstanceHandle, SENstruct *);
  int SENsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENstartup(CKTcircuit *);
  char* SPerror(InstanceHandle INST, int type);
  int TFanal(CKTcircuit *, int );
  int TFaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TFsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANinit(CKTcircuit *, JOB *);
  int NIacIter(CKTcircuit * );
  int NIcomCof(CKTcircuit * );
  int NIconvTest(CKTcircuit * );
  void NIdestroy(CKTcircuit * );
  int NIinit(CKTcircuit  * );
  int NIintegrate(CKTcircuit *, double *, double *, double , int );
  int NIiter(CKTcircuit * , int );
  int NIpzMuller(InstanceHandle, PZtrial **, PZtrial *);
  int NIpzComplex(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym2(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIreinit(CKTcircuit *);
  int NIsenReinit(CKTcircuit *);
  int EXPORT isFirstIteration (GENERIC *inCkt, int *first_iteration);

  #ifdef EWB_IIT
    int EXPORT modelInitialize(InstanceHandle INST, int modelType,GENERIC* model, IFuid modelUid);
  #endif

//insert file>>   #include "noisedef.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Gary W. Ng
**********/


  int CKTnoise (CKTcircuit *ckt,int mode, int operation, Ndata *data);
  int CKTdisto(CKTcircuit *ckt,int mode);
  int NIdIter(CKTcircuit *ckt);
  void NInzIter(CKTcircuit *ckt, int posDrive, int negDrive);
#ifndef IIT
  extern struct sIFfrontEnd *SPfrontEnd;
#endif

#ifndef IIT
#ifdef DO_RAWFILE_ALSO
  extern struct sIFfrontEnd *EWB_frontEnd;
  extern struct sIFfrontEnd nutmeginfo;
#endif /* DO_RAWFILE_ALSO */
#endif

#endif /*CKT*/



extern void MIF_INP2A(
    GENERIC      *ckt,      /* circuit structure to put mod/inst structs in */
    struct sINPtables    *tab,      /* symbol table for node names, etc.            */
    struct card         *current   /* the card we are to parse                     */
);


extern char * MIFgetMod(
    GENERIC   *ckt,
    char      *name,
    struct sINPmodel  **model,
    struct sINPtables *tab
);


extern union uIFvalue * MIFgetValue(
    GENERIC   *ckt,
    char      **line,
    int       type,
    struct sINPtables *tab,
    char      **err
);


extern int MIFsetup(
    SMPmatrix             *matrix,
    struct sGENmodel      *inModel,
    CKTcircuit            *ckt,
    int                   *state
);

extern int MIFunsetup(
    struct sGENmodel      *inModel,
    CKTcircuit            *ckt
);

extern int MIFload(
    struct sGENmodel      *inModel,
    CKTcircuit    *ckt
);


extern int MIFmParam(
    int param_index,
    union uIFvalue *value,
    struct sGENmodel *inModel
);

extern int MIFask(
    CKTcircuit *ckt,
    struct sGENinstance *inst,
    int param_index,
    union uIFvalue *value,
    union uIFvalue *select
);

extern int MIFmAsk(
    CKTcircuit *ckt,
    struct sGENmodel *inModel,
    int param_index,
    union uIFvalue *value
);

extern int MIFtrunc(
    struct sGENmodel   *inModel,
    CKTcircuit *ckt,
    double     *timeStep
);

extern int MIFconvTest(
    struct sGENmodel   *inModel,
    CKTcircuit *ckt
);

extern int MIFdelete(
    struct sGENmodel *inModel,
    IFuid    name,
    struct sGENinstance  **inst
);

extern int MIFmDelete(
    struct sGENmodel **inModel,
    IFuid    modname,
    struct sGENmodel *model
);

extern void MIFdestroy(
    struct sGENmodel **inModel
);

extern char  *MIFgettok(
    InstanceHandle inst,
    char **s
);


extern char  *MIFget_token(InstanceHandle inst,
    char **s,
    Mif_Token_Type_t *type
);


extern Mif_Cntl_Src_Type_t MIFget_cntl_src_type(
    Mif_Port_Type_t in_port_type,
    Mif_Port_Type_t out_port_type
);

extern char *MIFcopy(InstanceHandle,char *);

#ifdef EWB_IIT
MIF_Init_Error_Enum EXPORT
MIF_init_xspice_instance(GENERIC* ckt,       /* circuit structure to put mod/inst structs in */
                         char const* name,   /* the name of the instance */
                         MIFmodel*   mdfast, /* the name of the model */
                         MIFinstance* fast, /* pointer to instance struct */
                         int         type,   /* the type of the model for this instance */
                                             /* the integer index into the DEVices data
                                                array for this  model */
                         struct XSPort_def*  nodes,   /* list of nodes */
                         int*           nnodes,  /* number of nodes per port */
                         int            nvnodes  /* number of ports */
                        );
#endif

#endif  /* MIFPROTO */
//insert file>> #include "cmconst.h"
//insert file>> #include "evt.h"
#ifndef EVT_HEADER
#define EVT_HEADER 

/* ===========================================================================
FILE    EVT.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of the evt data structure and all
    its substructures.  The single evt structure is housed inside of
    the main 3C1 circuit structure 'ckt' and contains virtually all
    information about the event-driven simulation.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFdefs.h"
//insert file>> #include "MIFcmdat.h"
//insert file>> #include "MIFtypes.h"


/* ************** */
/* Info structure */
/* ************** */


typedef struct Evt_Output_Info_s {
    struct Evt_Output_Info_s  *next;  /* the next in the linked list */
    int  node_index;                  /* index into node info struct for this output */
    int  output_subindex;             /* index into output data in node data struct  */
    int  inst_index;                  /* Index of instance the port is on */
    int  port_index;                  /* Index of port the output corresponds to */
} Evt_Output_Info_t;

typedef struct Evt_Port_Info_s {
    struct Evt_Port_Info_s  *next;        /* the next in the linked list of node info */
    int                     inst_index;   /* Index of instance the port is on */
    int                     node_index;   /* index of node the port is connected to */
    char                    *node_name;   /* name of node port is connected to */
    char                    *inst_name;   /* instance name */
    char                    *conn_name;   /* connection name on instance */
    int                     port_num;     /* port number of instance connector */
} Evt_Port_Info_t;

typedef struct Evt_Inst_Index_s {
    struct Evt_Inst_Index_s  *next;           /* the next in the linked list */
    int                      index_value;     /* the value of the index */
} Evt_Inst_Index_t;

typedef struct Evt_Node_Info_s {
    struct Evt_Node_Info_s  *next;     /* the next in the linked list */
    char              *name;           /* Name of node in deck */
    int               udn_index;       /* Index of the node type */
    Mif_BOOLEAN_t     invert;          /* True if need to make inverted copy */
    int               num_ports;       /* Number of ports connected to this node */
    int               num_outputs;     /* Number of outputs connected to this node */
    int               num_insts;       /* The number of insts receiving node as input */
    Evt_Inst_Index_t  *inst_list;      /* Linked list of indexes of these instances */
} Evt_Node_Info_t;

typedef struct Evt_Inst_Info_s {
    struct Evt_Inst_Info_s  *next;      /* the next in the linked list of node info */
    struct sMIFinstance     *inst_ptr;  /* Pointer to MIFinstance struct for this instance */
} Evt_Inst_Info_t;

typedef struct Evt_Info_ {
    Evt_Inst_Info_t    *inst_list;         /* static info about event/hybrid instances */
    Evt_Node_Info_t    *node_list;         /* static info about event nodes */
    Evt_Port_Info_t    *port_list;         /* static info about event ports */
    Evt_Output_Info_t  *output_list;       /* static info about event outputs */
    int                *hybrid_index;      /* vector of inst indexs for hybrids */
    Evt_Inst_Info_t    **inst_table;       /* vector of pointers to elements in inst_list */
    Evt_Node_Info_t    **node_table;       /* vector of pointers to elements in node_list */
    Evt_Port_Info_t    **port_table;       /* vector of pointers to elements in port_list */
    Evt_Output_Info_t  **output_table;     /* vector of pointers to elements in output_list */
} Evt_Info_t;








/* *************** */
/* Queue structure */
/* *************** */



typedef struct Evt_Inst_Event_s {
    struct Evt_Inst_Event_s  *next; /* the next in the linked list */
    double            event_time;   /* Time for this event to happen */
    double            posted_time;  /* Time at which event was entered in queue */
} Evt_Inst_Event_t; 

typedef struct Evt_Inst_Queue_s {
    Evt_Inst_Event_t  **head;          /* Beginning of linked lists */
    Evt_Inst_Event_t  ***current;      /* Beginning of pending events */
    Evt_Inst_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Inst_Event_t  **free;          /* Linked lists of items freed by backups */
    double            last_time;       /* Time at which last_step was set */
    double            next_time;       /* Earliest next event time in queue */
    int               num_modified;    /* Number modified since last accepted timepoint */
    int               *modified_index; /* Indexes of modified instances */
    Mif_BOOLEAN_t     *modified;       /* Flags used to prevent multiple entries */
    int               num_pending;     /* Count of number of pending events in lists */
    int               *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t     *pending;        /* Flags used to prevent multiple entries */
    int               num_to_call;     /* Count of number of instances that need to be called */
    int               *to_call_index;  /* Indexes of instances to be called */
    Mif_BOOLEAN_t     *to_call;        /* Flags used to prevent multiple entries */
} Evt_Inst_Queue_t;




typedef struct Evt_Node_Queue_s {
    int               num_to_eval;    /* Count of number of nodes that need to be evaluated */
    int               *to_eval_index; /* Indexes of nodes to be evaluated */
    Mif_BOOLEAN_t     *to_eval;       /* Flags used to prevent multiple entries */
    int               num_changed;    /* Count of number of nodes that changed */
    int               *changed_index; /* Indexes of nodes that changed */
    Mif_BOOLEAN_t     *changed;       /* Flags used to prevent multiple entries */
} Evt_Node_Queue_t;




typedef struct Evt_Output_Event_s {
    struct Evt_Output_Event_s  *next; /* the next in the linked list */
    double            event_time;     /* Time for this event to happen */
    double            posted_time;    /* Time at which event was entered in queue */
    Mif_BOOLEAN_t     removed;        /* True if event has been deactivated */
    double            removed_time;   /* Time at which event was deactivated */
    void              *value;         /* The delayed value sent to this output */
} Evt_Output_Event_t; 

typedef struct Evt_Output_Queue_s {
    Evt_Output_Event_t  **head;          /* Beginning of linked lists */
    Evt_Output_Event_t  ***current;      /* Beginning of pending events */
    Evt_Output_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Output_Event_t  **free;          /* Linked lists of items freed by backups */
    double              last_time;       /* Time at which last_step was set */
    double              next_time;       /* Earliest next event time in queue */
    int                 num_modified;    /* Number modified since last accepted timepoint */
    int                 *modified_index; /* Indexes of modified outputs */
    Mif_BOOLEAN_t       *modified;       /* Flags used to prevent multiple entries */
    int                 num_pending;     /* Count of number of pending events in lists */
    int                 *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t       *pending;        /* Flags used to prevent multiple entries */
    int                 num_changed;     /* Count of number of outputs that changed */
    int                 *changed_index;  /* Indexes of outputs that changed */
    Mif_BOOLEAN_t       *changed;        /* Flags used to prevent multiple entries */
} Evt_Output_Queue_t;




typedef struct Evt_Queue_s {
    Evt_Inst_Queue_t   inst;               /* dynamic queue for instances */
    Evt_Node_Queue_t   node;               /* dynamic queue of changing nodes */
    Evt_Output_Queue_t output;             /* dynamic queue of delayed outputs */
} Evt_Queue_t;




/* ************** */
/* Data structure */
/* ************** */




typedef struct Evt_Node_s {
    struct Evt_Node_s *next;          /* pointer to next in linked list */
    Mif_BOOLEAN_t    op;              /* true if computed from op analysis */
    double           step;            /* DC step or time at which data was computed */
    void             **output_value;  /* Array of outputs posted to this node */
    void             *node_value;     /* Resultant computed from output values */
    void             *inverted_value; /* Inverted copy of node_value */
} Evt_Node_t;

typedef struct {
    Evt_Node_t     **head;          /* Beginning of linked lists */
    Evt_Node_t     ***tail;         /* Location of last item added to list */
    Evt_Node_t     ***last_step;    /* 'tail' at last accepted timepoint */
    Evt_Node_t     **free;          /* Linked lists of items freed by backups */
    int            num_modified;    /* Number modified since last accepted timepoint */
    int            *modified_index; /* Indexes of modified nodes */
    Mif_BOOLEAN_t  *modified;       /* Flags used to prevent multiple entries */
    Evt_Node_t     *rhs;            /* Location where model outputs are placed */
    Evt_Node_t     *rhsold;         /* Location where model inputs are retrieved */
    double         *total_load;     /* Location where total load inputs are retrieved */
} Evt_Node_Data_t;




typedef struct Evt_State_s {
    struct Evt_State_s   *next;        /* Pointer to next state */
    struct Evt_State_s   *prev;        /* Pointer to previous state */
    double               step;         /* Time at which state was assigned (0 for DC) */
    void                 *block;       /* Block of memory holding all states on inst */
} Evt_State_t;


typedef struct Evt_State_Desc_s {
    struct Evt_State_Desc_s *next;   /* Pointer to next description */
    int                     tag;     /* Tag for this state */
    int                     size;    /* Size of this state */
    int                     offset;  /* Offset of this state into the state block */
} Evt_State_Desc_t;


typedef struct Evt_State_Data_s {
    Evt_State_t    **head;              /* Beginning of linked lists */
    Evt_State_t    ***tail;             /* Location of last item added to list */
    Evt_State_t    ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_State_t    **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
    int            *total_size;         /* Total bytes for all states allocated */
    Evt_State_Desc_t **desc;            /* Lists of description structures */
} Evt_State_Data_t;




typedef struct Evt_Msg_s {
    struct Evt_Msg_s     *next;      /* Pointer to next state */
    Mif_BOOLEAN_t        op;         /* true if output from op analysis */
    double               step;       /* DC step or time at which message was output */
    char                 *text;      /* The value of the message text */
    int                  port_index; /* The index of the port from which the message came */
} Evt_Msg_t;


typedef struct Evt_Msg_Data_s {
    Evt_Msg_t      **head;              /* Beginning of linked lists */
    Evt_Msg_t      ***tail;             /* Location of last item added to list */
    Evt_Msg_t      ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_Msg_t      **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
} Evt_Msg_Data_t;


typedef struct Evt_Statistic_s {
    int                op_alternations;    /* Total alternations between event and analog */
    int                op_load_calls;      /* Total load calls in DCOP analysis */
    int                op_event_passes;    /* Total passes through event iteration loop */
    int                tran_load_calls;    /* Total inst calls in transient analysis */
    int                tran_time_backups;  /* Number of transient timestep cuts */
} Evt_Statistic_t;




typedef struct Evt_Data_s {
    Evt_Node_Data_t    *node;               /* dynamic event solution vector */
    Evt_State_Data_t   *state;              /* dynamic event instance state data */
    Evt_Msg_Data_t     *msg;                /* dynamic event message data */
    Evt_Statistic_t    *statistics;         /* Statistics for events, etc. */
} Evt_Data_t;



/* **************** */
/* Counts structure */
/* **************** */


typedef struct Evt_Count_s {
    int          num_insts;             /* number of event/hybrid instances parsed */
    int          num_hybrids;           /* number of hybrids parsed */
    int          num_hybrid_outputs;    /* number of outputs on all hybrids parsed */
    int          num_nodes;             /* number of event nodes parsed */
    int          num_ports;             /* number of event ports parsed */
    int          num_outputs;           /* number of event outputs parsed */
} Evt_Count_t;



/* **************** */
/* Limits structure */
/* **************** */


typedef struct Evt_Limit_s {
    int         max_event_passes;    /* maximum loops in attempting convergence of event nodes */
    int         max_op_alternations; /* maximum loops through event/analog alternation */
} Evt_Limit_t;


/* ************** */
/* Jobs structure */
/* ************** */


typedef struct Evt_Job_s {
    int                num_jobs;           /* Number of jobs run */
    char               **job_name;         /* Names of different jobs */
    Evt_Node_Data_t    **node_data;        /* node_data for different jobs */
    Evt_State_Data_t   **state_data;       /* state_data for different jobs */
    Evt_Msg_Data_t     **msg_data;         /* messages for different jobs */
    Evt_Statistic_t    **statistics;       /* Statistics for different jobs */
} Evt_Job_t;



/* ***************** */
/* Options structure */
/* ***************** */


typedef struct Evt_Option_s {
    Mif_BOOLEAN_t   op_alternate;        /* Alternate analog/event solutions in OP analysis */
} Evt_Option_t;


/* ****************** */
/* Main evt structure */
/* ****************** */

typedef struct Evt_Ckt_Data_s {
    Evt_Count_t     counts;         /* Number of insts, nodes, etc. */
    Evt_Info_t      info;           /* Static info about insts, etc. */
    Evt_Queue_t     queue;          /* Dynamic queued events */
    Evt_Data_t      data;           /* Results and state data */
    Evt_Limit_t     limits;         /* Iteration limits, etc. */
    Evt_Job_t       jobs;           /* Data held from multiple job runs */
    Evt_Option_t    options;        /* Data input on .options cards */
} Evt_Ckt_Data_t;



#endif /* EVT_HEADER */
//insert file>> #include "ipcproto.h"
#ifdef HDR_ipc_proto_h
#define HDR_ipc_proto_h


/* IPC.c */
#ifdef IIT
Ipc_Status_t ipc_send_evtdict_prefix (void);
Ipc_Status_t ipc_send_evtdict_suffix (void);
Ipc_Status_t ipc_send_evtdata_prefix (void);
Ipc_Status_t ipc_send_evtdata_suffix (void);
Ipc_Status_t ipc_send_event(int ipc_index, double step, double plot_val, char* print_val, void* ipc_val, int len);
#endif

static Ipc_BOOLEAN_t kw_match (char *keyword , char *str );
Ipc_Status_t ipc_initialize_server (char *server_name , Ipc_Mode_t m , Ipc_Protocol_t p );
Ipc_Status_t ipc_terminate_server (void );
Ipc_Status_t ipc_get_line (char *str , int *len , Ipc_Wait_t wait );
Ipc_Status_t ipc_flush (void );
static Ipc_Status_t ipc_send_line_binary (char *str , int len );
Ipc_Status_t ipc_send_line (char *str );
Ipc_Status_t ipc_send_data_prefix (double time );
Ipc_Status_t ipc_send_dcop_prefix (void );
Ipc_Status_t ipc_send_data_suffix (void );
Ipc_Status_t ipc_send_dcop_suffix (void );
Ipc_Status_t ipc_send_errchk (void );
Ipc_Status_t ipc_send_end (void );
static int stuff_binary_v1 (double d1 , double d2 , int n , char *buf , int pos );
Ipc_Status_t ipc_send_double (char *tag , double value );
Ipc_Status_t ipc_send_complex (char *tag , Ipc_Complex_t value );
Ipc_Status_t ipc_send_int (char *tag , int value );
Ipc_Status_t ipc_send_BOOLEAN (char *tag , Ipc_BOOLEAN_t value );
Ipc_Status_t ipc_send_string (char *tag , char *value );
Ipc_Status_t ipc_send_int_array (char *tag , int array_len , int *value );
Ipc_Status_t ipc_send_double_array (char *tag , int array_len , double *value );
Ipc_Status_t ipc_send_complex_array (char *tag , int array_len , Ipc_Complex_t *value );
Ipc_Status_t ipc_send_BOOLEAN_array (char *tag , int array_len , Ipc_BOOLEAN_t *value );
Ipc_Status_t ipc_send_string_array (char *tag , int array_len , char **value );

/* IPCtiein.c */
void ipc_handle_stop (void );
void ipc_handle_returni (void );
void ipc_handle_mintime (double time );
void ipc_handle_vtrans (char *vsrc , char *dev );
static void ipc_send_stdout (void );
static void ipc_send_stderr (void );
Ipc_Status_t ipc_send_std_files (void );
Ipc_BOOLEAN_t ipc_screen_name (char *name , char *mapped_name );
int ipc_get_devices (void *circuit , char *device , char ***names , double **modtypes );
void ipc_free_devices (int num_items , char **names , double *modtypes );
void ipc_check_pause_stop (void );

/* IPCaegis.c */
Ipc_Status_t ipc_transport_initialize_server (char *server_name , Ipc_Mode_t m , Ipc_Protocol_t p , char *batch_filename );
static Ipc_Status_t extract_msg (char *str , int *len );
Ipc_Status_t ipc_transport_get_line (char *str , int *len , Ipc_Wait_t wait );
Ipc_Status_t ipc_transport_terminate_server (void );
Ipc_Status_t ipc_transport_send_line (char *str , int len );

#endif

//insert file>> #include "mifcmdat.h"
//insert file>> #include "miftypes.h"
//insert file>> #include "cmproto.h"
//insert file>> #include "evtproto.h"
#ifndef EVTPROTO_HEADER
#define EVTPROTO_HEADER 

/* ===========================================================================
FILE    EVTproto.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains ANSI C function prototypes for functions
    in the event-driven simulation algorithm package.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */

//insert file>> #include "CKTdefs.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CKT
#define CKT "CKTdefs.h $Revision: 1.13 $  on $Date: 89/04/05 13:09:39 $ "
  #ifdef _DEBUG
  #ifdef _MSC_VER
  #pragma message( "  parsing CKTdefs.H" )
  #endif /*_MSC_VER*/
  #endif /*_DEBUG*/

//insert file>>   #include "basic.h"
//insert file>>   #include "xspice.h"

  #ifdef XSPICE
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
//insert file>>     #include "EVT.h"
#ifndef EVT_HEADER
#define EVT_HEADER 

/* ===========================================================================
FILE    EVT.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of the evt data structure and all
    its substructures.  The single evt structure is housed inside of
    the main 3C1 circuit structure 'ckt' and contains virtually all
    information about the event-driven simulation.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFdefs.h"
//insert file>> #include "MIFcmdat.h"
//insert file>> #include "MIFtypes.h"


/* ************** */
/* Info structure */
/* ************** */


typedef struct Evt_Output_Info_s {
    struct Evt_Output_Info_s  *next;  /* the next in the linked list */
    int  node_index;                  /* index into node info struct for this output */
    int  output_subindex;             /* index into output data in node data struct  */
    int  inst_index;                  /* Index of instance the port is on */
    int  port_index;                  /* Index of port the output corresponds to */
} Evt_Output_Info_t;

typedef struct Evt_Port_Info_s {
    struct Evt_Port_Info_s  *next;        /* the next in the linked list of node info */
    int                     inst_index;   /* Index of instance the port is on */
    int                     node_index;   /* index of node the port is connected to */
    char                    *node_name;   /* name of node port is connected to */
    char                    *inst_name;   /* instance name */
    char                    *conn_name;   /* connection name on instance */
    int                     port_num;     /* port number of instance connector */
} Evt_Port_Info_t;

typedef struct Evt_Inst_Index_s {
    struct Evt_Inst_Index_s  *next;           /* the next in the linked list */
    int                      index_value;     /* the value of the index */
} Evt_Inst_Index_t;

typedef struct Evt_Node_Info_s {
    struct Evt_Node_Info_s  *next;     /* the next in the linked list */
    char              *name;           /* Name of node in deck */
    int               udn_index;       /* Index of the node type */
    Mif_BOOLEAN_t     invert;          /* True if need to make inverted copy */
    int               num_ports;       /* Number of ports connected to this node */
    int               num_outputs;     /* Number of outputs connected to this node */
    int               num_insts;       /* The number of insts receiving node as input */
    Evt_Inst_Index_t  *inst_list;      /* Linked list of indexes of these instances */
} Evt_Node_Info_t;

typedef struct Evt_Inst_Info_s {
    struct Evt_Inst_Info_s  *next;      /* the next in the linked list of node info */
    struct sMIFinstance     *inst_ptr;  /* Pointer to MIFinstance struct for this instance */
} Evt_Inst_Info_t;

typedef struct Evt_Info_ {
    Evt_Inst_Info_t    *inst_list;         /* static info about event/hybrid instances */
    Evt_Node_Info_t    *node_list;         /* static info about event nodes */
    Evt_Port_Info_t    *port_list;         /* static info about event ports */
    Evt_Output_Info_t  *output_list;       /* static info about event outputs */
    int                *hybrid_index;      /* vector of inst indexs for hybrids */
    Evt_Inst_Info_t    **inst_table;       /* vector of pointers to elements in inst_list */
    Evt_Node_Info_t    **node_table;       /* vector of pointers to elements in node_list */
    Evt_Port_Info_t    **port_table;       /* vector of pointers to elements in port_list */
    Evt_Output_Info_t  **output_table;     /* vector of pointers to elements in output_list */
} Evt_Info_t;








/* *************** */
/* Queue structure */
/* *************** */



typedef struct Evt_Inst_Event_s {
    struct Evt_Inst_Event_s  *next; /* the next in the linked list */
    double            event_time;   /* Time for this event to happen */
    double            posted_time;  /* Time at which event was entered in queue */
} Evt_Inst_Event_t; 

typedef struct Evt_Inst_Queue_s {
    Evt_Inst_Event_t  **head;          /* Beginning of linked lists */
    Evt_Inst_Event_t  ***current;      /* Beginning of pending events */
    Evt_Inst_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Inst_Event_t  **free;          /* Linked lists of items freed by backups */
    double            last_time;       /* Time at which last_step was set */
    double            next_time;       /* Earliest next event time in queue */
    int               num_modified;    /* Number modified since last accepted timepoint */
    int               *modified_index; /* Indexes of modified instances */
    Mif_BOOLEAN_t     *modified;       /* Flags used to prevent multiple entries */
    int               num_pending;     /* Count of number of pending events in lists */
    int               *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t     *pending;        /* Flags used to prevent multiple entries */
    int               num_to_call;     /* Count of number of instances that need to be called */
    int               *to_call_index;  /* Indexes of instances to be called */
    Mif_BOOLEAN_t     *to_call;        /* Flags used to prevent multiple entries */
} Evt_Inst_Queue_t;




typedef struct Evt_Node_Queue_s {
    int               num_to_eval;    /* Count of number of nodes that need to be evaluated */
    int               *to_eval_index; /* Indexes of nodes to be evaluated */
    Mif_BOOLEAN_t     *to_eval;       /* Flags used to prevent multiple entries */
    int               num_changed;    /* Count of number of nodes that changed */
    int               *changed_index; /* Indexes of nodes that changed */
    Mif_BOOLEAN_t     *changed;       /* Flags used to prevent multiple entries */
} Evt_Node_Queue_t;




typedef struct Evt_Output_Event_s {
    struct Evt_Output_Event_s  *next; /* the next in the linked list */
    double            event_time;     /* Time for this event to happen */
    double            posted_time;    /* Time at which event was entered in queue */
    Mif_BOOLEAN_t     removed;        /* True if event has been deactivated */
    double            removed_time;   /* Time at which event was deactivated */
    void              *value;         /* The delayed value sent to this output */
} Evt_Output_Event_t; 

typedef struct Evt_Output_Queue_s {
    Evt_Output_Event_t  **head;          /* Beginning of linked lists */
    Evt_Output_Event_t  ***current;      /* Beginning of pending events */
    Evt_Output_Event_t  ***last_step;    /* Values of 'current' at last accepted timepoint */
    Evt_Output_Event_t  **free;          /* Linked lists of items freed by backups */
    double              last_time;       /* Time at which last_step was set */
    double              next_time;       /* Earliest next event time in queue */
    int                 num_modified;    /* Number modified since last accepted timepoint */
    int                 *modified_index; /* Indexes of modified outputs */
    Mif_BOOLEAN_t       *modified;       /* Flags used to prevent multiple entries */
    int                 num_pending;     /* Count of number of pending events in lists */
    int                 *pending_index;  /* Indexes of pending events */
    Mif_BOOLEAN_t       *pending;        /* Flags used to prevent multiple entries */
    int                 num_changed;     /* Count of number of outputs that changed */
    int                 *changed_index;  /* Indexes of outputs that changed */
    Mif_BOOLEAN_t       *changed;        /* Flags used to prevent multiple entries */
} Evt_Output_Queue_t;




typedef struct Evt_Queue_s {
    Evt_Inst_Queue_t   inst;               /* dynamic queue for instances */
    Evt_Node_Queue_t   node;               /* dynamic queue of changing nodes */
    Evt_Output_Queue_t output;             /* dynamic queue of delayed outputs */
} Evt_Queue_t;




/* ************** */
/* Data structure */
/* ************** */




typedef struct Evt_Node_s {
    struct Evt_Node_s *next;          /* pointer to next in linked list */
    Mif_BOOLEAN_t    op;              /* true if computed from op analysis */
    double           step;            /* DC step or time at which data was computed */
    void             **output_value;  /* Array of outputs posted to this node */
    void             *node_value;     /* Resultant computed from output values */
    void             *inverted_value; /* Inverted copy of node_value */
} Evt_Node_t;

typedef struct {
    Evt_Node_t     **head;          /* Beginning of linked lists */
    Evt_Node_t     ***tail;         /* Location of last item added to list */
    Evt_Node_t     ***last_step;    /* 'tail' at last accepted timepoint */
    Evt_Node_t     **free;          /* Linked lists of items freed by backups */
    int            num_modified;    /* Number modified since last accepted timepoint */
    int            *modified_index; /* Indexes of modified nodes */
    Mif_BOOLEAN_t  *modified;       /* Flags used to prevent multiple entries */
    Evt_Node_t     *rhs;            /* Location where model outputs are placed */
    Evt_Node_t     *rhsold;         /* Location where model inputs are retrieved */
    double         *total_load;     /* Location where total load inputs are retrieved */
} Evt_Node_Data_t;




typedef struct Evt_State_s {
    struct Evt_State_s   *next;        /* Pointer to next state */
    struct Evt_State_s   *prev;        /* Pointer to previous state */
    double               step;         /* Time at which state was assigned (0 for DC) */
    void                 *block;       /* Block of memory holding all states on inst */
} Evt_State_t;


typedef struct Evt_State_Desc_s {
    struct Evt_State_Desc_s *next;   /* Pointer to next description */
    int                     tag;     /* Tag for this state */
    int                     size;    /* Size of this state */
    int                     offset;  /* Offset of this state into the state block */
} Evt_State_Desc_t;


typedef struct Evt_State_Data_s {
    Evt_State_t    **head;              /* Beginning of linked lists */
    Evt_State_t    ***tail;             /* Location of last item added to list */
    Evt_State_t    ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_State_t    **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
    int            *total_size;         /* Total bytes for all states allocated */
    Evt_State_Desc_t **desc;            /* Lists of description structures */
} Evt_State_Data_t;




typedef struct Evt_Msg_s {
    struct Evt_Msg_s     *next;      /* Pointer to next state */
    Mif_BOOLEAN_t        op;         /* true if output from op analysis */
    double               step;       /* DC step or time at which message was output */
    char                 *text;      /* The value of the message text */
    int                  port_index; /* The index of the port from which the message came */
} Evt_Msg_t;


typedef struct Evt_Msg_Data_s {
    Evt_Msg_t      **head;              /* Beginning of linked lists */
    Evt_Msg_t      ***tail;             /* Location of last item added to list */
    Evt_Msg_t      ***last_step;        /* 'tail' at last accepted timepoint */
    Evt_Msg_t      **free;              /* Linked lists of items freed by backups */
    int            num_modified;        /* Number modified since last accepted timepoint */
    int            *modified_index;     /* List of indexes modified */
    Mif_BOOLEAN_t  *modified;           /* Flags used to prevent multiple entries */
} Evt_Msg_Data_t;


typedef struct Evt_Statistic_s {
    int                op_alternations;    /* Total alternations between event and analog */
    int                op_load_calls;      /* Total load calls in DCOP analysis */
    int                op_event_passes;    /* Total passes through event iteration loop */
    int                tran_load_calls;    /* Total inst calls in transient analysis */
    int                tran_time_backups;  /* Number of transient timestep cuts */
} Evt_Statistic_t;




typedef struct Evt_Data_s {
    Evt_Node_Data_t    *node;               /* dynamic event solution vector */
    Evt_State_Data_t   *state;              /* dynamic event instance state data */
    Evt_Msg_Data_t     *msg;                /* dynamic event message data */
    Evt_Statistic_t    *statistics;         /* Statistics for events, etc. */
} Evt_Data_t;



/* **************** */
/* Counts structure */
/* **************** */


typedef struct Evt_Count_s {
    int          num_insts;             /* number of event/hybrid instances parsed */
    int          num_hybrids;           /* number of hybrids parsed */
    int          num_hybrid_outputs;    /* number of outputs on all hybrids parsed */
    int          num_nodes;             /* number of event nodes parsed */
    int          num_ports;             /* number of event ports parsed */
    int          num_outputs;           /* number of event outputs parsed */
} Evt_Count_t;



/* **************** */
/* Limits structure */
/* **************** */


typedef struct Evt_Limit_s {
    int         max_event_passes;    /* maximum loops in attempting convergence of event nodes */
    int         max_op_alternations; /* maximum loops through event/analog alternation */
} Evt_Limit_t;


/* ************** */
/* Jobs structure */
/* ************** */


typedef struct Evt_Job_s {
    int                num_jobs;           /* Number of jobs run */
    char               **job_name;         /* Names of different jobs */
    Evt_Node_Data_t    **node_data;        /* node_data for different jobs */
    Evt_State_Data_t   **state_data;       /* state_data for different jobs */
    Evt_Msg_Data_t     **msg_data;         /* messages for different jobs */
    Evt_Statistic_t    **statistics;       /* Statistics for different jobs */
} Evt_Job_t;



/* ***************** */
/* Options structure */
/* ***************** */


typedef struct Evt_Option_s {
    Mif_BOOLEAN_t   op_alternate;        /* Alternate analog/event solutions in OP analysis */
} Evt_Option_t;


/* ****************** */
/* Main evt structure */
/* ****************** */

typedef struct Evt_Ckt_Data_s {
    Evt_Count_t     counts;         /* Number of insts, nodes, etc. */
    Evt_Info_t      info;           /* Static info about insts, etc. */
    Evt_Queue_t     queue;          /* Dynamic queued events */
    Evt_Data_t      data;           /* Results and state data */
    Evt_Limit_t     limits;         /* Iteration limits, etc. */
    Evt_Job_t       jobs;           /* Data held from multiple job runs */
    Evt_Option_t    options;        /* Data input on .options cards */
} Evt_Ckt_Data_t;



#endif /* EVT_HEADER */
//insert file>>     #include "ENH.h"
#ifndef ENH_HEADER
#define ENH_HEADER 

/* ===========================================================================
FILE    ENH.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains typedefs used by the event-driven algorithm.

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFtypes.h"
//insert file>> #include "FTEinp.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 *
 * Note that this definition must be the same as struct card in INPdefs.h...
 */


/*
The following data is used in implementing various enhancements made to the
simulator.  The main struct is dynamically allocated in ckt so that incremental additions
can be made more easily without the need to recompile multiple modules.
Allocation and initialization is done in CKTinit.c which should be the only
module needed to recompile after additions are made here.
*/


typedef enum Enh_Conv_Source_t {
    ENH_ANALOG_NODE,            /* An analog node */
    ENH_EVENT_NODE,             /* An event-driven node */
    ENH_ANALOG_BRANCH,          /* A branch current */
    ENH_ANALOG_INSTANCE,        /* An analog instance */
    ENH_EVENT_INSTANCE,         /* An event-driven instance */
    ENH_HYBRID_INSTANCE,        /* A hybrid (analog/event-driven) instance */
} Enh_Conv_Source_t;


typedef struct Enh_Bkpt_t {
   double           current;    /* The current dynamic breakpoint time */
   double           last;       /* The last used dynamic breakpoint time */
} Enh_Bkpt_t;

typedef struct Enh_Ramp_t {
    double           ramptime;    /* supply ramping time specified on .options */
} Enh_Ramp_t;

typedef struct Enh_Conv_Debug_t {
    Mif_BOOLEAN_t    last_NIiter_call;  /* True if this is the last call to NIiter() */
    Mif_BOOLEAN_t    report_conv_probs; /* True if conv test functions should send debug info */
} Enh_Conv_Debug_t;


typedef struct Enh_Conv_Limit_t {
    Mif_BOOLEAN_t    enabled;           /* True if convergence limiting enabled on code models */
    double           abs_step;          /* Minimum limiting step size */
    double           step;              /* Fractional step amount */
} Enh_Conv_Limit_t;


typedef struct Enh_Rshunt_t {
    Mif_BOOLEAN_t    enabled;      /* True if rshunt option used */
    double           gshunt;       /* 1.0 / rshunt */
    int              num_nodes;    /* Number of nodes in matrix */
    double           **diag;       /* Pointers to matrix diagonals */
} Enh_Rshunt_t;


typedef struct Enh_Ckt_Data_t {
    Enh_Bkpt_t       breakpoint;   /* Data used by dynamic breakpoints */
    Enh_Ramp_t       ramp;         /* New options added to simulator */
    Enh_Conv_Debug_t conv_debug;   /* Convergence debug info dumping data */
    Enh_Conv_Limit_t conv_limit;   /* Convergence limiting info */
    Enh_Rshunt_t     rshunt_data;  /* Shunt conductance from nodes to ground */
} Enh_Ckt_Data_t;



void ENHreport_conv_prob(Enh_Conv_Source_t type, char *name, char *msg);
struct line *ENHtranslate_poly(InstanceHandle inst, struct line *deck);


#endif /* ENH_HEADER */
    /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
  #endif


  #define MAXNUMDEVS 32
  extern int DEVmaxnum;
  #define MAXNUMDEVNODES 4

//insert file>>   #include "smpdefs.h"
//insert file>>   #include "ifsim.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Thomas L. Quarles
**********/

//insert file>>   #include "acdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "gendefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "trcvdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */
//insert file>>   #include "optdefs.h"
//insert file>> #include "xspice.h"

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>>   #include "sen2defs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/
/*
 * SENdefs.h - structures for sensitivity package
 */

//insert file>>   #include "pzdefs.h"
#ifndef PZDEFS
#define PZDEFS "PZdefs.h $Revision: 1.3 $  on $Date: 88/11/16 21:55:29 $ "

    /* structure used to describe an PZ analysis to be performed */

//insert file>> #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

//insert file>> #include "complex.h"
/*
 * Copyright (c) 1985 Thomas L. Quarles
 */
#ifndef CMPLX
#define CMPLX "complex.h $Revision: 1.5 $  on $Date: 88/11/22 02:51:07 $ "

/*  header file containing definitions for complex functions
 *
 *  Each expects two arguments for each complex number - a real and an
 *  imaginary part.
 */
typedef struct {
    double real;
    double imag;
} SPcomplex;


#define DC_ABS(a,b) (FABS(a) + FABS(b))

#ifdef notdef
#define DC_DIV(a,b,c,d,x,y) { \
    double r,s;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((a)+(b)*r)/s;\
        y=((b)-(a)*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((a)*r+(b))/s;\
        y=((b)*r-(a))/s;\
    }\
}
#endif /*notdef */

#ifndef HAS_SHORTMACRO
#define DC_DIVEQ(a,b,c,d) { \
    double r,s,x,y;\
    if(FABS(c)>FABS(d)) { \
        r=(d)/(c);\
        s=(c)+r*(d);\
        x=((*(a))+(*(b))*r)/s;\
        y=((*(b))-(*(a))*r)/s;\
    } else { \
        r=(c)/(d);\
        s=(d)+r*(c);\
        x=((*(a))*r+(*(b)))/s;\
        y=((*(b))*r-(*(a)))/s;\
    }\
    (*(a)) = x; \
    (*(b)) = y; \
}
#else /*HAS_SHORTMACRO*/
#define DC_DIVEQ DCdiveq
#ifdef IIT
extern void DCdiveq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCdiveq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifndef HAS_SHORTMACRO
#define DC_MULT(a,b,c,d,x,y) { \
    *(x) = (a) * (c) - (b) * (d) ;\
    *(y) = (a) * (d) + (b) * (c) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MULT DCmult
#ifdef IIT
extern void DCmult(InstanceHandle inst, double,double,double,double,double*,double*);
#else /* stdc */
extern void DCmult(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#ifdef notdef 
#define DC_MINUS(a,b,c,d,x,y) { \
    (x) = (a) - (c) ;\
    (y) = (b) - (d) ;\
}
#endif /*notdef*/

#ifndef HAS_SHORTMACRO
#define DC_MINUSEQ(a,b,c,d) { \
    *(a) -= (c) ;\
    *(b) -= (d) ;\
}
#else /*HAS_SHORTMACRO*/
#define DC_MINUSEQ DCminusEq
#ifdef IIT
extern void DCminusEq(InstanceHandle inst, double*,double*,double,double);
#else /* stdc */
extern void DCminusEq(InstanceHandle inst);
#endif /* stdc */
#endif /*HAS_SHORTMACRO*/

#define	C_SQRT(A) {							      \
	double	_mag, _a;						      \
	if ((A).imag == 0.0) {						      \
	    if ((A).real < 0.0) {					      \
		(A).imag = sqrt(-(A).real);				      \
		(A).real = 0.0;						      \
	    } else {							      \
		(A).real = sqrt((A).real);				      \
		(A).imag = 0.0;						      \
	    }								      \
	} else {							      \
	    _mag = sqrt((A).real * (A).real + (A).imag * (A).imag);	      \
	    _a = (_mag - (A).real) / 2.0;				      \
	    if (_a <= 0.0) {						      \
		(A).real = sqrt(_mag);					      \
		(A).imag /= (2.0 * (A).real); /*XXX*/			      \
	    } else {							      \
		_a = sqrt(_a);						      \
		(A).real = (A).imag / (2.0 * _a);			      \
		(A).imag = _a;						      \
	    }								      \
	}								      \
    }

#define	C_MAG2(A) (((A).real = (A).real * (A).real + (A).imag * (A).imag),    \
	(A).imag = 0.0)

#define	C_CONJ(A) ((A).imag *= -1.0)

#define	C_CONJEQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = - (B.imag);						      \
    }

#define	C_EQ(A,B) {							      \
	(A).real = (B.real);						      \
	(A).imag = (B.imag);						      \
    }

#define	C_NORM(A,B) {							      \
	if ((A).real == 0.0 && (A).imag == 0.0) {			      \
	    (B) = 0;							      \
	} else {							      \
	    while (FABS((A).real) > 1.0 || FABS((A).imag) > 1.0) {	      \
		(B) += 1;						      \
		(A).real /= 2.0;					      \
		(A).imag /= 2.0;					      \
	    }								      \
	    while (FABS((A).real) <= 0.5 && FABS((A).imag) <= 0.5) {	      \
		(B) -= 1;						      \
		(A).real *= 2.0;					      \
		(A).imag *= 2.0;					      \
	    }								      \
	}								      \
    }

#define	C_ABS(A) (sqrt((A).real * (A.real) + (A.imag * A.imag)))

#define	C_MUL(A,B) {							      \
	double	TMP1, TMP2;						      \
	TMP1 = (A.real);						      \
	TMP2 = (B.real);						      \
	(A).real = TMP1 * TMP2 - (A.imag) * (B.imag);			      \
	(A).imag = TMP1 * (B.imag) + (A.imag) * TMP2;			      \
    }

#define	C_MULEQ(A,B,C) {						      \
	(A).real = (B.real) * (C.real) - (B.imag) * (C.imag);		      \
	(A).imag = (B.real) * (C.imag) + (B.imag) * (C.real);		      \
    }

#define	C_DIV(A,B) {							      \
	double	_tmp, _mag;						      \
	_tmp = (A.real);						      \
	(A).real = _tmp * (B.real) + (A).imag * (B.imag);		      \
	(A).imag = - _tmp * (B.imag) + (A.imag) * (B.real);		      \
	_mag = (B.real) * (B.real) + (B.imag) * (B.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_DIVEQ(A,B,C) {						      \
	double	_mag;							      \
	(A).real = (B.real) * (C.real) + (B.imag) * (C.imag);		      \
	(A).imag = (B.imag) * (C.real) - (B.real) * (C.imag) ;		      \
	_mag = (C.real) * (C.real) + (C.imag) * (C.imag);		      \
	(A).real /= _mag;						      \
	(A).imag /= _mag;						      \
    }

#define	C_ADD(A,B) {							      \
	(A).real += (B.real);						      \
	(A).imag += (B.imag);						      \
    }

#define	C_ADDEQ(A,B,C) {						      \
	(A).real = (B.real) + (C.real);					      \
	(A).imag = (B.imag) + (C.imag);					      \
    }

#define	C_SUB(A,B) {							      \
	(A).real -= (B.real);						      \
	(A).imag -= (B.imag);						      \
    }

#define	C_SUBEQ(A,B,C) {						      \
	(A).real = (B.real) - (C.real);					      \
	(A).imag = (B.imag) - (C.imag);					      \
    }



#endif /*CMPLX*/

typedef struct strial {
    SPcomplex	s, f_raw, f_def;
    struct strial *next, *prev;
    int		mag_raw, mag_def;
    int		multiplicity;
    int		flags;
    int		seq_num;
    int		count;
} PZtrial;

typedef struct {
    int JOBtype;
    JOB *JOBnextJob;
    IFuid JOBname;
    int PZin_pos;
    int PZin_neg;
    int PZout_pos;
    int PZout_neg;
    int PZinput_type;
    int PZwhich;
    int PZnumswaps;
    int PZbalance_col;
    int PZsolution_col;
    PZtrial *PZpoleList;
    PZtrial *PZzeroList;
    int PZnPoles;
    int PZnZeros;
    double *PZdrive_pptr;
    double *PZdrive_nptr;
} PZAN;

#define PZ_DO_POLES	0x1
#define PZ_DO_ZEROS	0x2
#define PZ_IN_VOL	1
#define PZ_IN_CUR	2

#define PZ_NODEI 1
#define PZ_NODEG 2
#define PZ_NODEJ 3
#define PZ_NODEK 4
#define PZ_V 5
#define PZ_I 6
#define PZ_POL 7
#define PZ_ZER 8
#define PZ_PZ 9

#endif /*PZDEFS*/



  typedef struct sCKTnode {
      IFuid name;
      int type;

      #define SP_VOLTAGE 3
      #define SP_CURRENT 4
      #define NODE_VOLTAGE SP_VOLTAGE
      #define NODE_CURRENT SP_CURRENT

      int number;
      double ic;
      double nodeset;
      double *ptr;
      struct sCKTnode *next;
      unsigned int icGiven:1;
      unsigned int nsGiven:1;
  } CKTnode;

  /* defines for node parameters */
  #define PARM_NS 1
  #define PARM_IC 2
  #define PARM_NODETYPE 3


  struct CKTcircuit_tag {
     #ifdef IIT
         InstanceHandle m_instance_handle;
     #endif

     #ifdef XSPICE
     /* gtri - begin - wbk - change declaration to allow dynamic sizing */

     /* An associated change is made in CKTinit.c to alloc the space */
     /* required for the pointers.  No changes are needed to the source */
     /* code at the 3C1 level, although the compiler will generate */
     /* slightly different code for references to this data. */

     /*  GENmodel *CKThead[MAXNUMDEVS];  */
         struct sGENmodel **CKThead;

     /* gtri - end   - wbk - change declaration to allow dynamic sizing */
     #else
         struct sGENmodel *CKThead[MAXNUMDEVS];
     #endif
         STATistics *CKTstat;
         double *(CKTstates[8]);
     #define CKTstate0 CKTstates[0]
     #define CKTstate1 CKTstates[1]
     #define CKTstate2 CKTstates[2]
     #define CKTstate3 CKTstates[3]
     #define CKTstate4 CKTstates[4]
     #define CKTstate5 CKTstates[5]
     #define CKTstate6 CKTstates[6]
     #define CKTstate7 CKTstates[7]
         double CKTtime;
         double CKTdelta;
         double CKTdeltaOld[7];
         double CKTtemp;
         double CKTnomTemp;
         double CKTvt;
         double CKTag[7];        /* the gear variable coefficient matrix */
     #ifdef PREDICTOR
         double CKTagp[7];       /* the gear predictor variable coefficient matrix */
     #endif /*PREDICTOR*/
         int CKTorder;           /* the integration method order */
         int CKTmaxOrder;        /* maximum integration method order */
         int CKTintegrateMethod; /* the integration method to be used */

     /* known integration methods */
     #define TRAPEZOIDAL 1
     #define GEAR 2

         SMPmatrix *CKTmatrix;   /* pointer to sparse matrix */
         int CKTniState;         /* internal state */
         double *CKTrhs;         /* current rhs value - being loaded */
         double *CKTrhsOld;      /* previous rhs value for convergence testing */
         double *CKTrhsSpare;    /* spare rhs value for reordering */
         double *CKTirhs;        /* current rhs value - being loaded (imag) */
         double *CKTirhsOld;     /* previous rhs value (imaginary)*/
         double *CKTirhsSpare;   /* spare rhs value (imaginary)*/
     #ifdef PREDICTOR
         double *CKTpred;        /* predicted solution vector */
         double *CKTsols[8];     /* previous 8 solutions */
     #endif /* PREDICTOR */

         double *CKTrhsOp;      /* operating point values */
         double *CKTsenRhs;      /* current sensitivity rhs  values */
         double *CKTseniRhs;      /* current sensitivity rhs  values (imag)*/


     /*
      *  symbolic constants for CKTniState
      *      Note that they are bitwise disjoint
      */

     #define NISHOULDREORDER 0x1
     #define NIREORDERED 0x2
     #define NIUNINITIALIZED 0x4
     #define NIACSHOULDREORDER 0x10
     #define NIACREORDERED 0x20
     #define NIACUNINITIALIZED 0x40
     #define NIDIDPREORDER 0x100
     #define NIPZSHOULDREORDER 0x200

         int CKTmaxEqNum;
         int CKTcurrentAnalysis; /* the analysis in progress (if any) */

     /* defines for the value of  CKTcurrentAnalysis */
     /* are in TSKdefs.h */

         CKTnode *CKTnodes;
         CKTnode *CKTlastNode;
     #define NODENAME(ckt,nodenum) CKTnodName(ckt,nodenum)
         int CKTnumStates;
         long CKTmode;

     /* defines for CKTmode */

     /* old 'mode' parameters */
     #define MODE 0x3
     #define MODETRAN 0x1
     #define MODEAC 0x2

     /* old 'modedc' parameters */
     #define MODEDC 0x70
     #define MODEDCOP 0x10
     #define MODETRANOP 0x20
     #define MODEDCTRANCURVE 0x40

     /* old 'initf' parameters */
     #define INITF 0x3f00
     #define MODEINITFLOAT 0x100
     #define MODEINITJCT 0x200
     #define MODEINITFIX 0x400
     #define MODEINITSMSIG 0x800
     #define MODEINITTRAN 0x1000
     #define MODEINITPRED 0x2000

     /* old 'nosolv' paramater */
     #define MODEUIC 0x10000l

         int CKTbypass;
         int CKTdcMaxIter;       /* iteration limit for dc op.  (itl1) */
         int CKTdcTrcvMaxIter;   /* iteration limit for dc tran. curv (itl2) */
         int CKTtranMaxIter;     /* iteration limit for each timepoint for tran*/
                                 /* (itl4) */
         int CKTbreakSize;
         int CKTbreak;
         double CKTsaveDelta;
         double CKTminBreak;
         double *CKTbreaks;
         double CKTabstol;
         double CKTpivotAbsTol;
         double CKTpivotRelTol;
         double CKTreltol;
         double CKTchgtol;
         double CKTvoltTol;
     #ifdef NEWTRUNC
         double CKTlteReltol;
         double CKTlteAbstol;
     #endif /* NEWTRUNC */
         double CKTgmin;
         double CKTdelmin;
         double CKTtrtol;
         double CKTfinalTime;
         double CKTstep;
         double CKTmaxStep;
         double CKTinitTime;
         double CKTomega;
         double CKTsrcFact;
         double CKTdiagGmin;
         int CKTnumSrcSteps;
         int CKTnumGminSteps;
         int CKTnoncon;
         double CKTdefaultMosL;
         double CKTdefaultMosW;
         double CKTdefaultMosAD;
         double CKTdefaultMosAS;
         unsigned int CKThadNodeset:1;
         unsigned int CKTfixLimit:1; /* flag to indicate that the limiting of
                                      * MOSFETs should be done as in SPICE2 */
         unsigned int CKTnoOpIter:1; /* flag to indicate not to try the operating
                                      * point brute force, but to use gmin stepping
                                      * first */
         unsigned int CKTisSetup:1;  /* flag to indicate if CKTsetup done */
         JOB *CKTcurJob;

         SENstruct *CKTsenInfo;	/* the sensitivity information */
         double *CKTtimePoints;	/* list of all accepted timepoints in the
				        current transient simulation */
         double *CKTdeltaList;	/* list of all timesteps in the current
				        transient simulation */
         int CKTtimeListSize;	/* size of above lists */
         int CKTtimeIndex;		/* current position in above lists */
         int CKTsizeIncr;		/* amount to increment size of above arrays
				        when you run out of space */
         unsigned int CKTtryToCompact:1; /* try to compact past history for LTRA
				        lines */
         unsigned int CKTbadMos3:1; /* Use old, unfixed MOS3 equations */
         unsigned int CKTkeepOpInfo:1; /* flag for small signal analyses */
         int CKTtroubleNode;		/* Non-convergent node number */
         struct sGENinstance *CKTtroubleElt;	/* Non-convergent device instance */
     #ifdef EWB_IIT
	     double CKTiitBreakPoint;
	     double CKTiitSaveDelta;
     #endif
     #ifdef XSPICE
     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */

         struct Evt_Ckt_Data_s *evt;  /* all data about event driven stuff */
         struct Enh_Ckt_Data_t *enh;  /* data used by general enhancements */

     /* gtri - evt - wbk - 5/20/91 - add event-driven and enhancements data */
     #endif
     #ifdef IIT
         int oldCKTmaxEqNum;
     #endif

#ifdef IIT
     //* Transient analysis options
     #define EXT_MODE_ZERO_IC    0x00000l
     #define EXT_MODE_AUTO_IC    0x000002
     #define EXT_MODE_AUTO_TMAX  0x000004
     #define EXT_MODE_AUTO_TSTEP 0x000008
     long CKText_mode;
#endif
  };

  #ifdef IIT
    #define CKTcircuit_has_been_defined
//insert file>>     #include "jobdefs.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/


    struct s_sgen* sgen_init(CKTcircuit* ckt,int is_dc);
    int sgen_next(InstanceHandle INST, struct s_sgen **xsg);
    int sens_getp(InstanceHandle INST, struct s_sgen *sg, CKTcircuit *ckt,union uIFvalue* val);
  #endif

  #ifdef EWB_IIT
    int EXPORT getMatrixElement( GENERIC*, GENERIC*, GENERIC*, double**);
    int EXPORT getVoltage(GENERIC*, GENERIC*, GENERIC*, double*);
    int EXPORT addVoltage(GENERIC*, GENERIC*, double);
    int EXPORT getCurrent(GENERIC*, GENERIC*, double*);
    int EXPORT addCurrent(GENERIC*, GENERIC*, GENERIC*, double);
    int EXPORT setBreakPoint(GENERIC*, double);
    int EXPORT setRelativeBreakPoint(GENERIC*, double);
    int EXPORT changeCapacitorValue(GENERIC*, GENERIC*, double);
    int EXPORT changeInductorValue(GENERIC*, GENERIC*, double);
    int EXPORT isFirstIteration(GENERIC*, int*);
    int EXPORT setMaxStep(GENERIC*, double);
  #endif

  #ifdef DLL
    #if defined(MSVC) || !defined(WIN32)
      #undef FAR
    #endif

    #include <windows.h>

    #if defined(MSVC)
      #undef FAR
      #define FAR
	#elif !defined(WIN32)
      #undef FAR
      #define FAR far
    #endif

    #ifdef MSVC
      int EXPORT  SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #else
      int CALLBACK _export SPIinit(InstanceHandle inst);
      int consoleSPIinit(InstanceHandle inst);
    #endif
  #else
    int SPIinit(InstanceHandle inst);
  #endif

  int ACan(CKTcircuit *, int );
  int ACaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int ACsetParm( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int CKTacDump( CKTcircuit *, double , GENERIC *);
  int CKTacLoad( CKTcircuit *);
  int CKTaccept( CKTcircuit *);
  int CKTacct( CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int EXPORT CKTask( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskAnalQ( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTaskNodQst( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTbindNode( GENERIC *, GENERIC *, int , GENERIC *);
  void CKTbreakDump( CKTcircuit *);
  int CKTclrBreak( CKTcircuit *);
  int CKTconvTest( CKTcircuit *);
  int EXPORT CKTcrtElt( GENERIC *, GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTdelTask( GENERIC *, GENERIC *);
  int EXPORT CKTdestroy( GENERIC *);
  int CKTdltAnal( GENERIC *, GENERIC *, GENERIC *);
  int EXPORT CKTdltInst( GENERIC *, GENERIC *);
  int EXPORT CKTdltMod( GENERIC *, GENERIC *);
  int EXPORT CKTdltNod( GENERIC *, GENERIC *);
  int EXPORT CKTdoJob( GENERIC *, int , GENERIC *);
  void CKTdump( CKTcircuit *, double, GENERIC *);
  int EXPORT CKTfndAnal( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int CKTfndBranch( CKTcircuit *, IFuid);
  int EXPORT CKTfndDev( GENERIC *, int *, GENERIC **, IFuid , GENERIC *, IFuid );
  int EXPORT CKTfndMod( GENERIC *, int *, GENERIC **, IFuid );
  int EXPORT CKTfndNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTfndTask( GENERIC *, GENERIC **, IFuid  );
  int EXPORT CKTground( GENERIC *, GENERIC **, IFuid );
  int CKTic( CKTcircuit *);
  int EXPORT CKTinit(InstanceHandle handle, GENERIC **);
  int EXPORT CKTinst2Node( GENERIC *, GENERIC *, int , GENERIC **, IFuid *);
  int CKTlinkEq(CKTcircuit*,CKTnode*);
  int CKTload( CKTcircuit *);
  int CKTmapNode( GENERIC *, GENERIC **, IFuid );
  int CKTmkCur( CKTcircuit  *, CKTnode **, IFuid , char *);
  int CKTmkNode(CKTcircuit*,CKTnode**);
  int CKTmkVolt( CKTcircuit  *, CKTnode **, IFuid , char *);
  int EXPORT CKTmodAsk( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int EXPORT CKTmodCrt( GENERIC *, int , GENERIC **, IFuid );
  int EXPORT CKTmodParam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTnames(CKTcircuit *, int *, IFuid **);
  int EXPORT CKTnewAnal( GENERIC *, int , IFuid , GENERIC **, GENERIC *);
  int CKTnewEq( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewNode( GENERIC *, GENERIC **, IFuid );
  int EXPORT CKTnewTask( GENERIC *, GENERIC **, IFuid );
  IFuid CKTnodName( CKTcircuit *, int );
  void CKTnodOut( CKTcircuit *);
  CKTnode * CKTnum2nod( CKTcircuit *, int );
  int CKTop(CKTcircuit *, long, long, int );
  int CKTpModName( char *, union uIFvalue *, CKTcircuit *, int , IFuid , struct sGENmodel **);
  int CKTpName( char *, union uIFvalue *, CKTcircuit *, int , char *, struct sGENinstance **);
  int EXPORT CKTparam( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTpzFindZeros( CKTcircuit *, PZtrial **, int * );
  int CKTpzLoad( CKTcircuit *, SPcomplex * );
  int CKTpzSetup( CKTcircuit *, int);
  int CKTsenAC( CKTcircuit *);
  int CKTsenComp( CKTcircuit *);
  int CKTsenDCtran( CKTcircuit *);
  int CKTsenLoad( CKTcircuit *);
  void CKTsenPrint( CKTcircuit *);
  int CKTsenSetup( CKTcircuit *);
  int CKTsenUpdate( CKTcircuit *);
  int EXPORT CKTsetAnalPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetBreak( CKTcircuit *, double );
  int EXPORT CKTsetNodPm( GENERIC *, GENERIC *, int , union uIFvalue *, union uIFvalue *);
  int CKTsetOpt( GENERIC *, GENERIC *, int , union uIFvalue *);
  int CKTsetup( CKTcircuit *);
  int CKTunsetup(CKTcircuit *ckt);
  int CKTtemp( CKTcircuit *);
  char * EXPORT CKTtrouble(GENERIC *, char *);
  void CKTterr( int , CKTcircuit *, double *);
  int CKTtrunc( CKTcircuit *, double *);
  int CKTtypelook( char *);
  int DCOaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCOsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCTaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int DCTsetParm(CKTcircuit  *, GENERIC *, int , union uIFvalue *);
  int DCop(CKTcircuit *);
  int DCtrCurv(CKTcircuit *, int );
  int DCtran(CKTcircuit *, int );
  int DISTOan(CKTcircuit *, int);
  int NOISEan(CKTcircuit *, int);
  int PZan(CKTcircuit *, int );
  int PZinit(CKTcircuit * );
  int PZpost(CKTcircuit * );
  int PZaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int PZsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  void SENdestroy(InstanceHandle, SENstruct *);
  int SENsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int SENstartup(CKTcircuit *);
  char* SPerror(InstanceHandle INST, int type);
  int TFanal(CKTcircuit *, int );
  int TFaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TFsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANaskQuest(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANsetParm(CKTcircuit *, GENERIC *, int , union uIFvalue *);
  int TRANinit(CKTcircuit *, JOB *);
  int NIacIter(CKTcircuit * );
  int NIcomCof(CKTcircuit * );
  int NIconvTest(CKTcircuit * );
  void NIdestroy(CKTcircuit * );
  int NIinit(CKTcircuit  * );
  int NIintegrate(CKTcircuit *, double *, double *, double , int );
  int NIiter(CKTcircuit * , int );
  int NIpzMuller(InstanceHandle, PZtrial **, PZtrial *);
  int NIpzComplex(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIpzSym2(InstanceHandle INST, PZtrial **, PZtrial *);
  int NIreinit(CKTcircuit *);
  int NIsenReinit(CKTcircuit *);
  int EXPORT isFirstIteration (GENERIC *inCkt, int *first_iteration);

  #ifdef EWB_IIT
    int EXPORT modelInitialize(InstanceHandle INST, int modelType,GENERIC* model, IFuid modelUid);
  #endif

//insert file>>   #include "noisedef.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1987 Gary W. Ng
**********/


  int CKTnoise (CKTcircuit *ckt,int mode, int operation, Ndata *data);
  int CKTdisto(CKTcircuit *ckt,int mode);
  int NIdIter(CKTcircuit *ckt);
  void NInzIter(CKTcircuit *ckt, int posDrive, int negDrive);
#ifndef IIT
  extern struct sIFfrontEnd *SPfrontEnd;
#endif

#ifndef IIT
#ifdef DO_RAWFILE_ALSO
  extern struct sIFfrontEnd *EWB_frontEnd;
  extern struct sIFfrontEnd nutmeginfo;
#endif /* DO_RAWFILE_ALSO */
#endif

#endif /*CKT*/
//insert file>> #include "CPstd.h"
//insert file>> #include "xspice.h"

//#ifdef IIT
//#define _complex _rename_complex_to_avoid_redefinition_problems_with_microsoft_compiler
//#define complex rename_complex_to_avoid_redefinition_problems_with_microsoft_compiler
//#endif

/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1986 Wayne A. Christopher, U. C. Berkeley CAD Group
**********/

/*
 * Standard definitions. This file serves as the header file for std.c and
 * wlist.c
 */

//insert file>> #include "MIFdefs.h"
//insert file>> #include "IPC.h"
/* $Id: IPC.h,v 1.1 91/12/19 16:22:43 bill Exp $
 *
 */
/*============================================================================
FILE    IPC.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Steve Tynor

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    Provides compatibility for the new SPICE simulator to both the MSPICE user
    interface and BCP (via ATESSE v.1 style AEGIS mailboxes) and the new ATESSE
    v.2 Simulator Interface and BCP (via Bsd Sockets).

INTERFACES


REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

============================================================================*/



/* ******************* */
/* Function Prototypes */
/* ******************* */


int EVTinit1(CKTcircuit *ckt);
int EVTinit2(CKTcircuit *ckt);

void EVTtermInsert(
    struct CKTcircuit_tag      *ckt,
    struct sMIFinstance  *fast,
    char            *node_name,
    char            *type_name,
    int             conn_num,
    int             port_num,
    char            **err_msg);

int EVTsetup(struct CKTcircuit_tag *ckt);

int EVTiter(struct CKTcircuit_tag *ckt);

void EVTbackup(struct CKTcircuit_tag *ckt, double new_time);

double EVTnext_time(struct CKTcircuit_tag *ckt);

void EVTqueue_output(
    struct CKTcircuit_tag *ckt,
    int        output_index,
    int        udn_index,
    struct Evt_Output_Event_s  *new_event,
    double     posted_time,
    double     event_time);


void EVTqueue_inst(
    struct CKTcircuit_tag *ckt,
    int        inst_index,
    double     posted_time,
    double     event_time);

void EVTdequeue(struct CKTcircuit_tag *ckt, double time);

int EVTload(struct CKTcircuit_tag *ckt, int inst_index);

void EVTprint(InstanceHandle inst,wordlist *wl);

int EVTop(
    struct CKTcircuit_tag *ckt,
    long       firstmode,
    long       continuemode,
    int        max_iter,
    Mif_BOOLEAN_t  first_call);

void EVTop_save(
    struct CKTcircuit_tag    *ckt,
    Mif_BOOLEAN_t op,
    double        step);

void EVTnode_copy(
    struct CKTcircuit_tag    *ckt,
    int           node_index,
    struct Evt_Node_s    *from,
    struct Evt_Node_s    **to);

void EVTcall_hybrids(struct CKTcircuit_tag *ckt);

void EVTdump(
    struct CKTcircuit_tag    *ckt,
    Ipc_Anal_t    mode,
    double        step);

void EVTaccept(
    struct CKTcircuit_tag *ckt,    /* main circuit struct */
    double     time);    /* time at which analog soln was accepted */


#endif /* EVTPROTO_HEADER */
//insert file>> #include "ipctiein.h"
/*============================================================================
FILE    IPCtiein.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    Provides a protocol independent interface between the simulator
    and the IPC method used to interface to CAE packages.

INTERFACES


REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

============================================================================*/


#ifndef IPC_TIEIN_DEFINED
#define IPC_TIEIN_DEFINED


//insert file>> #include "IPC.h"
/* $Id: IPC.h,v 1.1 91/12/19 16:22:43 bill Exp $
 *
 */
/*============================================================================
FILE    IPC.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Steve Tynor

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    Provides compatibility for the new SPICE simulator to both the MSPICE user
    interface and BCP (via ATESSE v.1 style AEGIS mailboxes) and the new ATESSE
    v.2 Simulator Interface and BCP (via Bsd Sockets).

INTERFACES


REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

============================================================================*/

//insert file>> #include "IPCproto.h"
#ifdef HDR_ipc_proto_h
#define HDR_ipc_proto_h


/* IPC.c */
#ifdef IIT
Ipc_Status_t ipc_send_evtdict_prefix (void);
Ipc_Status_t ipc_send_evtdict_suffix (void);
Ipc_Status_t ipc_send_evtdata_prefix (void);
Ipc_Status_t ipc_send_evtdata_suffix (void);
Ipc_Status_t ipc_send_event(int ipc_index, double step, double plot_val, char* print_val, void* ipc_val, int len);
#endif

static Ipc_BOOLEAN_t kw_match (char *keyword , char *str );
Ipc_Status_t ipc_initialize_server (char *server_name , Ipc_Mode_t m , Ipc_Protocol_t p );
Ipc_Status_t ipc_terminate_server (void );
Ipc_Status_t ipc_get_line (char *str , int *len , Ipc_Wait_t wait );
Ipc_Status_t ipc_flush (void );
static Ipc_Status_t ipc_send_line_binary (char *str , int len );
Ipc_Status_t ipc_send_line (char *str );
Ipc_Status_t ipc_send_data_prefix (double time );
Ipc_Status_t ipc_send_dcop_prefix (void );
Ipc_Status_t ipc_send_data_suffix (void );
Ipc_Status_t ipc_send_dcop_suffix (void );
Ipc_Status_t ipc_send_errchk (void );
Ipc_Status_t ipc_send_end (void );
static int stuff_binary_v1 (double d1 , double d2 , int n , char *buf , int pos );
Ipc_Status_t ipc_send_double (char *tag , double value );
Ipc_Status_t ipc_send_complex (char *tag , Ipc_Complex_t value );
Ipc_Status_t ipc_send_int (char *tag , int value );
Ipc_Status_t ipc_send_BOOLEAN (char *tag , Ipc_BOOLEAN_t value );
Ipc_Status_t ipc_send_string (char *tag , char *value );
Ipc_Status_t ipc_send_int_array (char *tag , int array_len , int *value );
Ipc_Status_t ipc_send_double_array (char *tag , int array_len , double *value );
Ipc_Status_t ipc_send_complex_array (char *tag , int array_len , Ipc_Complex_t *value );
Ipc_Status_t ipc_send_BOOLEAN_array (char *tag , int array_len , Ipc_BOOLEAN_t *value );
Ipc_Status_t ipc_send_string_array (char *tag , int array_len , char **value );

/* IPCtiein.c */
void ipc_handle_stop (void );
void ipc_handle_returni (void );
void ipc_handle_mintime (double time );
void ipc_handle_vtrans (char *vsrc , char *dev );
static void ipc_send_stdout (void );
static void ipc_send_stderr (void );
Ipc_Status_t ipc_send_std_files (void );
Ipc_BOOLEAN_t ipc_screen_name (char *name , char *mapped_name );
int ipc_get_devices (void *circuit , char *device , char ***names , double **modtypes );
void ipc_free_devices (int num_items , char **names , double *modtypes );
void ipc_check_pause_stop (void );

/* IPCaegis.c */
Ipc_Status_t ipc_transport_initialize_server (char *server_name , Ipc_Mode_t m , Ipc_Protocol_t p , char *batch_filename );
static Ipc_Status_t extract_msg (char *str , int *len );
Ipc_Status_t ipc_transport_get_line (char *str , int *len , Ipc_Wait_t wait );
Ipc_Status_t ipc_transport_terminate_server (void );
Ipc_Status_t ipc_transport_send_line (char *str , int len );

#endif



#define  IPC_STDOUT_FILE_NAME  "/usr/tmp/atesse_xspice.out"
#define  IPC_STDERR_FILE_NAME  "/usr/tmp/atesse_xspice.err"


/*
Ipc_Vtrans_t is used by functions that return results to translate
voltage source names to the names of the devices they monitor.
This table is built from #VTRANS cards in the incoming deck and
is provided for ATESSE 1.0 compatibility.
*/

typedef struct {
    int     size;               /* Size of arrays */
    char    **vsrc_name;        /* Array of voltage source name prefixes */
    char    **device_name;      /* Array of device names the vsources map to */
} Ipc_Vtrans_t;


/*
Ipc_Tiein_t is used by the SPICE mods that take care of interprocess communications
activities.
*/

typedef struct {

    Ipc_BOOLEAN_t   enabled;      /* True if we are using IPC */
    Ipc_Mode_t      mode;         /* INTERACTIVE or BATCH mode */
    Ipc_Anal_t      anal_type;    /* DCOP, AC, ... mode */
    Ipc_BOOLEAN_t   syntax_error; /* True if error occurred during parsing */
    Ipc_BOOLEAN_t   run_error;    /* True if error occurred during simulation */
    Ipc_BOOLEAN_t   errchk_sent;  /* True if #ERRCHK has been sent */
    Ipc_BOOLEAN_t   returni;      /* True if simulator should return currents */
    double          mintime;      /* Minimum time between timepoints returned */
    double          last_time;    /* Last timepoint returned */
    double          cpu_time;     /* CPU time used during simulation */
    Ipc_BOOLEAN_t   *send;        /* Used by OUTinterface to determine what to send */
    char            *log_file;    /* Path to write log file */
    Ipc_Vtrans_t    vtrans;       /* Used by OUTinterface to translate v sources */
    Ipc_BOOLEAN_t   stop_analysis; /* True if analysis should be terminated */

} Ipc_Tiein_t;



extern  Ipc_Tiein_t  g_ipc;


#endif  /* IPC_TIEIN_DEFINED */

//insert file>> #include "mifdefs.h"
//insert file>> #include "cmtypes.h"
//insert file>> #include "evtudn.h"
#ifndef EVTUDN_HEADER
#define EVTUDN_HEADER 

/* ===========================================================================
FILE    EVTudn.h

MEMBER OF process XSPICE

Copyright 1991
Georgia Tech Research Corporation
Atlanta, Georgia 30332
All Rights Reserved

PROJECT A-8503

AUTHORS

    9/12/91  Bill Kuhn

MODIFICATIONS

    <date> <person name> <nature of modifications>

SUMMARY

    This file contains the definition of "User-Defined Nodes".
    These nodes are integrated into the simulator similar to the
    way models are tied into SPICE 3C1, so that new node types
    can be relatively easily added.  The functions (required and
    optional) are listed below.  For optional functions, the
    function can be left undefined and the pointer placed into the
    Evt_Udn_Info_t structure can be specified as NULL.

    Required functions:
        create  -  allocate data structure used as inputs and outputs to code models
        initialize  -  set structure to appropriate initial value for first use as model input
        copy  -  make a copy of the contents into created but possibly uninitialized structure
        compare  -  determine if two structures are equal in value

    Optional functions:
        dismantle  -  free allocations _inside_ structure (but not structure itself)
        invert  -  invert logical value of structure
        resolve  -  determine the resultant when multiple outputs are connected to a node
        plot_val  -  output a real value for specified structure component for plotting purposes
        print_val  -  output a string value for specified structure component for printing
        ipc_val  -  output a binary data structure and size of the structure for IPC

INTERFACES

    None.

REFERENCED FILES

    None.

NON-STANDARD FEATURES

    None.

=========================================================================== */


//insert file>> #include "MIFtypes.h"  /* for Mif_BOOLEAN_t used in udn_..._compare */

#define MALLOCED_PTR                 (*evt_struct_ptr)
#define STRUCT_PTR                   evt_struct_ptr
#define STRUCT_PTR_1                 evt_struct_ptr_1
#define STRUCT_PTR_2                 evt_struct_ptr_2
#define EQUAL                        (*evt_equal)
#define INPUT_STRUCT_PTR             evt_input_struct_ptr
#define OUTPUT_STRUCT_PTR            evt_output_struct_ptr
#define INPUT_STRUCT_PTR_ARRAY       evt_input_struct_ptr_array
#define INPUT_STRUCT_PTR_ARRAY_SIZE  evt_input_struct_ptr_array_size
#define STRUCT_MEMBER_ID             evt_struct_member_id
#define PLOT_VAL                     (*evt_plot_val)
#define PRINT_VAL                    (*evt_print_val)
#define IPC_VAL                      (*evt_ipc_val)
#define IPC_VAL_SIZE                 (*evt_ipc_val_size)
#define EVT_INSTANCE                 evt_instance

#define CREATE_ARGS      InstanceHandle evt_instance,\
                         void **evt_struct_ptr
#define INITIALIZE_ARGS  InstanceHandle evt_instance,\
                         void *evt_struct_ptr
#define COMPARE_ARGS     InstanceHandle evt_instance,\
                         void *evt_struct_ptr_1, \
                         void *evt_struct_ptr_2, \
                         Mif_BOOLEAN_t *evt_equal
#define COPY_ARGS        InstanceHandle evt_instance,\
                         void *evt_input_struct_ptr, \
                         void *evt_output_struct_ptr
#define DISMANTLE_ARGS   InstanceHandle evt_instance,\
                         void *evt_struct_ptr
#define INVERT_ARGS      InstanceHandle evt_instance,\
                         void *evt_struct_ptr
#define RESOLVE_ARGS     InstanceHandle evt_instance,\
                         int evt_input_struct_ptr_array_size, \
                         void **evt_input_struct_ptr_array, \
                         void *evt_output_struct_ptr
#define PLOT_VAL_ARGS    InstanceHandle evt_instance,\
                         void *evt_struct_ptr, \
                         char *evt_struct_member_id, \
                         double *evt_plot_val
#define PRINT_VAL_ARGS   InstanceHandle evt_instance,\
                         void *evt_struct_ptr, \
                         char *evt_struct_member_id, \
                         char **evt_print_val
#define IPC_VAL_ARGS     InstanceHandle evt_instance,\
                         void *evt_struct_ptr, \
                         void **evt_ipc_val, \
                         int  *evt_ipc_val_size


typedef struct {
    char          *name;
    char          *description;
    void          ((*create)(CREATE_ARGS));
    void          ((*dismantle)(DISMANTLE_ARGS));
    void          ((*initialize)(INITIALIZE_ARGS));
    void          ((*invert)(INVERT_ARGS));
    void          ((*copy)(COPY_ARGS));
    void          ((*resolve)(RESOLVE_ARGS));
    void          ((*compare)(COMPARE_ARGS));
    void          ((*plot_val)(PLOT_VAL_ARGS));
    void          ((*print_val)(PRINT_VAL_ARGS));
    void          ((*ipc_val)(IPC_VAL_ARGS));
} Evt_Udn_Info_t;


extern int             g_evt_num_udn_types;
extern Evt_Udn_Info_t  *g_evt_udn_info[];


#endif /* EVTUDN_HEADER */
//insert file>> #include "mifparse.h"

//insert file>> #include "misc.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/



#if defined(IIT) && defined(EWB_IIT) && defined(XSPICE)
extern void free_Mif_Info(InstanceHandle inst, struct Mif_Info_s* g_mif_info);
extern void free_Enh_Ckt_Data(InstanceHandle inst, struct Enh_Ckt_Data_t* enh,CKTcircuit *ckt);
extern void free_Evt_Ckt_Data(InstanceHandle inst, struct Evt_Ckt_Data_s* evt,CKTcircuit *ckt);
#endif

#define XSPICE_PI   3.14159265358979323846

#endif

#define QUIT_CURRENT_ANALYSIS -1942
#define NON_RECOVERABLE_ERROR -1969

#define serious_error(error) ( (error)==NON_RECOVERABLE_ERROR || (error==QUIT_CURRENT_ANALYSIS) )

#define MIN_DIV_CONST 1e-12

extern double checked_divide_variable;

#define MIN_DENOMINATOR_OF(x) ( checked_divide_variable=(x),                                                            \
                                checked_divide_variable=   (0<=checked_divide_variable && checked_divide_variable<MIN_DIV_CONST)  ? MIN_DIV_CONST   \
                                                        :  (0>checked_divide_variable  && checked_divide_variable>-MIN_DIV_CONST) ? -MIN_DIV_CONST  \
                                                        :  checked_divide_variable                                      \
                              )

#define CHECKED_DIVIDE(x,y)  (MIN_DENOMINATOR_OF(y),         \
                              (x)/checked_divide_variable    \
                             )
#ifdef EWB_IIT
   #define IIT_NL       "   "
#else
   #define IIT_NL       "\n"
#endif





/*
 *	Portability, global externs, kitchen sink (yuk).
 *	In future releases this will include things from misc.h and util.h,
 *	   which duplicate each other in places
 */
//insert file>> #include "instance.h"
//insert file>> #include "basic.h"

#include <math.h>

#define FABS(a)      fabs(a)

#ifndef	M_PI
#  define M_PI		3.14159265358979323846
#endif
#ifndef	M_E
#  define M_E  	   2.7182818284590452354
#endif
#ifndef	M_LOG2E
#  define M_LOG2E		1.4426950408889634074
#endif
#ifndef	M_LOG10E
#  define M_LOG10E        0.43429448190325182765
#endif

//insert file>> #include "port.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

/*
 *  Operating System
 */

#ifdef aix
#  include "os_aix.h"
#  define CONFIGURED
#endif

#ifdef bsd
#  include "os_bsd.h"
#  define CONFIGURED
#endif

#ifdef ultrix
#  include "os_ultrx.h"
#  define CONFIGURED
#endif

#ifdef sun
#  include "os_sun.h"
#  define CONFIGURED
#endif

#ifdef hpux
#  include "os_hpux.h"
#  define CONFIGURED
#endif

#ifdef sequent
#  include "os_dynix.h"
#  define CONFIGURED
#endif

#ifdef sgi
#  include "os_sysv.h"
#  define CONFIGURED
#endif

#ifdef ipsc
#  include "os_ipsc.h"
#  define CONFIGURED
#endif

#ifdef __MSDOS__
#  include "os_msdos.h"
#  define CONFIGURED
#endif

#ifdef MSDOS
#  include "os_msdos.h"
#  define CONFIGURED
#endif

#ifdef NeXT
#  include "os_bsd.h"
#  define CONFIGURED
#endif

#ifdef THINK_C
#  include "os_mac.h"
#  define CONFIGURED
#endif

#ifdef alpha_osf
#  include "os_osf.h"
#  define CONFIGURED
#endif


// DEFAULT CONFIGURATION
//insert file>> #include "os_msdos.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

/*
 *	MS-DOS using MSC-C 5.1
 */

#define     DIR_CWD		"."
#define     DIR_PATHSEP		"\\"
#define     DIR_TERM		'\\'
#define	    TEMPFORMAT		"%s%d.tmp"

#define HAS_ASCII
#define HAS_CHDIR		/* for tree filesystems, chdir( )	*/
#define HAS_CLEARERR		/* clearerr( ), should be in stdio	*/
#define HAS_CTYPE		/* <ctype.h>, iswhite( ), etc.		*/
#define HAS_DOSDIRS		/* Emulate opendir, etc.		*/

#ifndef BIT32
#define HAS_MEMAVL		/* Use _memavl( ) 			*/
#endif

#define HAS_ENVIRON
#define HAS_FTIME
#define HAS_GETCWD		/* getcwd(buf, size)			*/
#define HAS_LOCALTIME
#define HAS_LONGJUMP		/* setjmp( ), longjmp( )		*/
//#define HAS_MINDATA
#define HAS_NOINLINE
#define HAS_NOVM
#define HAS_PCTERM
#define HAS_QSORT		/* qsort( )				*/
#define HAS_SHORTMACRO
#define HAS_STAT
#define HAS_STDLIB
#define HAS_STRCHR		/* strchr( ) instead of index( )	*/
#define HAS_SYSTEM
#define HAS_UNIX_SIGS
#define HAS_UNLINK
#define HAS_LIMITS_H
#define HAS_FLOAT_H
#define HAS_NO_IEEE_LOGB
#define HAS_NO_ERFC
#define HAS_BATCHSIM

#define WANT_PCHARDCOPY

#ifndef IIT
#define WANT_MFB
#endif

#define CONFIGURED

#ifndef CONFIGURED

error error error error

Operating system type unknown

error error error error

#endif
//insert file>> #include "hw.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

/*
 *  Hardware specific machine limits
 */

#ifdef HAS_LIMITS_H
# include <limits.h>
#endif

#ifdef HAS_FLOAT_H
# include <float.h>
#endif

#ifdef vax

#  include "hw_vax.h"
#  ifndef	HUGE_VAL
#    define HUGE_VAL	1.701411834604692293e+38 
#  endif

#else
//insert file>> #include "hw_ieee.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

/*
 *  IEEE Floating point
 */

#define MAX_EXP_ARG	709.0

#ifndef DBL_EPSILON
# define DBL_EPSILON	8.9e-15
#endif
#ifndef DBL_MAX
# define DBL_MAX	1.79769313486231e+308
#endif
#ifndef DBL_MIN
# define DBL_MIN	2.22507385850721e-308
#endif
#ifndef SHRT_MAX
# define SHRT_MAX	32766
#endif
#ifndef INT_MAX
# define INT_MAX	2147483646
#endif
#ifndef LONG_MAX
# define LONG_MAX	2147483646
#endif

#define MAXPOSINT	INT_MAX

#define HAS_IEEE_FLOAT
#  ifndef	HUGE_VAL
#    define	HUGE_VAL	1.8e+308
#  endif

#endif

#ifndef	HUGE
#  define HUGE	HUGE_VAL
#endif

//insert file>> #include "config.h"
#ifdef HAS_NOVM
/* For the PC */
#define NOBYPASS
#endif
//insert file>> #include "capabil.h"
/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
**********/

/*
 *  #define-s that are always on
 */

#define CAPZEROBYPASS
#define NEWCONV
/* #define CAPBYPASS	Internal use only */

/*
 *  #define-s to identify common capabilities
 */

#ifdef WANT_X11
#  define HAS_X11
#else
#  ifdef WANT_X10
#    define HAS_X10
#    ifdef WANT_XT
#      define HAS_XT
#    endif
#  endif	/* X10 */
#endif	/* !X11 */

#ifdef WANT_MFB
#  define HAS_MFB
#endif

#ifdef HAS_BSDDIRS
#  define HAS_DIRS_
#endif
#ifdef HAS_SYSVDIRS
#  define HAS_DIRS_
#endif
#ifdef HAS_DOSDIRS
#  define HAS_DIRS_
#endif

#ifdef HAS_BSDTTY
#  define HAS_TTY_
#endif
#ifdef HAS_SYSVTTY
#  define HAS_TTY_
#endif

#ifdef HAS_BSDTIME
#  define HAS_TIME_
#  define HAS_LOCALTIME
#endif
#ifdef HAS_SYSVTIME
#  define HAS_TIME_
#  define HAS_LOCALTIME
#endif

#ifdef HAS_BSDRLIMIT
#  define HAS_RLIMIT_
#endif
#ifdef HAS_SYSVRLIMIT
#  define HAS_RLIMIT_
#endif
#ifdef HAS_MEMAVL
#  define HAS_RLIMIT_
#endif

#ifdef HAS_BSDRUSAGE
#  define HAS_RUSAGE_
#endif
#ifdef HAS_SYSVRUSAGE
#  define HAS_RUSAGE_
#endif

#ifdef HAS_X10
#  define HAS_X_
#endif
#ifdef HAS_X11
#  define HAS_X_
#endif

#ifndef DIR_TERM
#  define DIR_TERM	0
#endif

#ifndef DIR_PATHSEP
#  define DIR_PATHSEP	0
#endif

#ifndef DIR_CWD
#  define DIR_CWD		0
#endif

#ifdef HAS_NO_ERFC
#  ifndef HAS_NO_ERFC_DECL
#    define HAS_NO_ERFC_DECL
#  endif
#endif

#ifdef HAS_NO_IEEE_LOGB
#  ifndef HAS_NO_IEEE_LOGB_DECL
#    define HAS_NO_IEEE_LOGB_DECL
#  endif
#endif

#ifdef HAS_IEEE_SCALBN
#  define scalb scalbn
#endif

#ifdef HAS_NO_IEEE_LOGB_DECL
#  ifdef IIT
extern double logb(double), scalb(double, int);
#  else
extern double logb(), scalb();
#  endif
#endif

#ifdef HAS_NO_ERFC_DECL
#  ifdef IIT
extern double erfc(double);
#  else
extern double erfc();
#  endif
#endif

#ifndef SIGNAL_TYPE
#  define SIGNAL_TYPE void
#endif

#ifndef IIT
/* SORRY, NO CHEATING IS ALLOWED. */
#ifndef SIGNAL_FUNCTION
#  define SIGNAL_FUNCTION SIGNAL_TYPE (*)( )
#endif
#endif

#define	NUMELEMS(ARRAY)	(sizeof(ARRAY)/sizeof(*ARRAY))

extern char *Spice_Exec_Dir;
extern char *Spice_Lib_Dir;
extern char Spice_OptChar;
extern char *Def_Editor;
extern char *Bug_Addr;
extern int AsciiRawFile;
extern char *Spice_Host;
extern char *Spiced_Log;

extern char Spice_Notice[ ];
extern char Spice_Version[ ];
extern char Spice_Build_Date[ ];

extern char *News_File;
extern char *Default_MFB_Cap;
extern char *Spice_Path;
extern char *Help_Path;
extern char *Lib_Path;
extern int  Patch_Level;

#endif

