for { set xdx_i 1 } { $xdx_i <= $xdx_opt_anz } { incr xdx_i } {
   set xdx_opt_$xdx_i 0
}
set xdx_acfilename ""
set xdx_name ""
set xdx_x_name ""
set xdx_ac_name ""
set xdx_text_xname ""
set xdx_text_opt_1 ""
set xdx_busy 0
set xdx_num_mainframe -1
set xdx_num_frame     -1
set xdx_num_column     0
set xdx_num_row        0
set xdx_xname_col      #FFFFA0
set xdx_xname_col_none #C0C0FF
set xdx_act_bt_col     #FF9090
set xdx_cancel 0
proc xdx_export_dialog { opt xdx_ver } {
   global xdx_opt_anz
   global xdx_animation
   for { set i 1 } { $i <= $xdx_opt_anz } { incr i } {
      global xdx_opt_$i
   }
   global xdx_acfilename
   global xdx_name
   global xdx_x_name
   global xdx_ac_name
   global xdx_text_xname
   global xdx_text_opt_1
   global acfilename
   global tcl_platform
   global xdx_xname_col
   global xdx_xname_col_none
   global xdx_act_bt_col
   global xdx_busy
   global xdx_num_mainframe
   global xdx_num_frame
   global xdx_num_column
   global xdx_num_row
   global xdx_version
   global tcl_version
   for { set i 1 } { $i <= $xdx_opt_anz } { incr i } {
      set xdx_opt_$i [string index $opt [expr "$i-1"] ]
   }
   change_fname acfilename "" w
   set xdx_version $xdx_ver
   if { ![ winfo exists .directx ] } {
      toplevel .directx
      wm title .directx "Export X File"
      wm transient .directx [winfo toplevel [winfo parent .directx]]
      frame .directx.name -border 1 -relief solid -bg $xdx_xname_col
      if { $tcl_version >= 8.4 } {
         pack .directx.name -fill both -expand 1 -padx 5 -pady {5 10}
      } else {
         pack .directx.name -fill both -expand 1 -padx 5 -pady 5
      }
      label .directx.name.xname -textvariable xdx_text_xname -bg $xdx_xname_col
      pack .directx.name.xname -fill x -expand 1 -padx 20 -pady 1
      frame .directx.opt
      pack .directx.opt -fill both -expand 1
      xdx_opt_mainframe
      xdx_opt_frame "AC3D File"
      xdx_opt_init   1  "xdx_text_opt_1" \
                        " The AC3D file is also saved. \n Same as 'File -> Save xxx.ac'. "
      xdx_opt_frame "Model Information"
      xdx_opt_init   2  "Model Information to X File"  \
                        " Information of the model \n are stored in the X file. "
      xdx_opt_init   3  "Object Data to X File"  \
                        " Object data ( text ) are stored \n in the X file as comments. "
      xdx_opt_init  22  "Lines/Polylines to X File"  \
                        " Lines and Polylines are stored \n in the X file as comments. "
      xdx_opt_frame "Naming"
      xdx_opt_init  15  "Object Names for Frames/Meshes"  \
                        " The AC3D object names are \n used for 'Frame' and 'Mesh'. "
      xdx_opt_init  16  "Indices for Frames/Meshes"  \
                        " Each 'Frame' and 'Mesh' get an unique index. "
      xdx_opt_init  30  "No digit as first character"  \
                        " Some programs do not accept mesh/frame names \n starting with a digit. With this option enabled an underbar \n is added to the name if the first character is a digit. "
      xdx_opt_frame "Coordinate System"
      xdx_opt_init   4  "Right Handed Coordinate System"  \
                        " Mesh data is created for a right handed coordinate system. \n ( The z axis shows to the front ( out of the screen, as in AC3D ). \n Direct X normally use the left handed coordinate system. \n OpenGL normally use the right handed coordinate system. "
      xdx_opt_init  12  "Invert Face Orientation"  \
                        " Inverts all objects by \n inverting all their faces. "
      xdx_opt_frame "Materials"
      xdx_opt_init   7  "Save Materials"  \
                        " If enabled, then any material attributes \n used by mesh object are output to the .X file \n using the MeshMaterialList structure. "
      xdx_opt_init  19  "No Specular Reflection"  \
                        " Specular color and power (shininess) \n is set to zero in the x file. "
      if { $xdx_animation == 0 } {
         xdx_opt_mainframe
      }
      xdx_opt_frame "Textures"
      xdx_opt_init   6  "Texture Coordinates"  \
                        " If enabled, then any (u,v) texture coordinates \n that are assigned to face vertices are \n output to the .X file using the \n MeshTextureCoords structure. "
      xdx_opt_init   5  "Strip Texture File Names"  \
                        " Texture file names are stored without path. "
      xdx_opt_init  20  "Use Material Properties"  \
                        " The material properties of the surfaces \n are used for textured objects, too. "
      if { $xdx_animation == 1 } {
         xdx_opt_mainframe
      }
      xdx_opt_frame "Frames"
      xdx_opt_init  11  "No Frames"  \
                        " If enabled, then only mesh objects \n are written to file. "
      xdx_opt_init  21  "Frames only for Groups"  \
                        " If enabled, then frames are created only for groups. "
      xdx_opt_frame "Meshes"
      xdx_opt_init  10  "Triangles Only"  \
                        " If enabled, then all polygons which have four or \n more sides are converted to triangles prior to output. "
      xdx_opt_init  29  "Commit Subdivision"  \
                        " Same as the AC3D function \n ( 'Object' -> 'Commit subdivision' ). \n This only affects the exported X file. \n The AC3D model will not be changed. "
      xdx_opt_init  23  "Consider 1S/2S"  \
                        " If enabled, a second surface with opposite \n direction is created for each two-sided surface. \n This only affects the exported X file. \n The AC3D model will not be changed. "
      xdx_opt_init  24  "Optimize Vertex List" \
                        " Eliminates duplicate vertices of the mesh structure. \n Only vertices with the same coordinates, the same normals \n and the same texture coordinates are eliminated. This \n means, that the model will not be changed with this option. \n The only advantage of not using this option is faster saving. "
      xdx_opt_init  14  "Vertex Duplication Indices"  \
                        " If enabled, then the VertexDuplicationIndices structure is used. \n This template is instantiated on a per-mesh basis, holding \n information about which vertices in the mesh are duplicates of \n each other. "
      xdx_opt_frame "Normals"
      xdx_opt_init   8  "Save Normals"  \
                        " If enabled, then any normals that are assigned \n to face vertices are output to the X file \n using the MeshNormals structure. "
      xdx_opt_init  13  "Normals corresponding to Smooth/Flat" \
                        " Normals are calculated in regard of the \n AC3D 'smooth'/'flat' characteristic. \n The software which use the x file may \n calculate the normals itself. In this case you \n will not get smooth/flat surfaces as in AC3D. "
      xdx_opt_init   9  "Flip Normals"  \
                        " If enabled, then the direction of each \n vertex normal is flipped so that \n it points to the opposite direction. "
      if { $xdx_animation == 1 } {
         xdx_opt_frame "Animation"
         xdx_opt_init  25  "No Animation" \
                           " Independent of any other option, no animation is created. "
         xdx_opt_init  26  "Add Animation Info" \
                           " Information about the created animation \n are stored in the X file as comments. "
         xdx_opt_init  27  "Use Object Data as Animation Script" \
                           " Select the 'Animation' button for help. "
      }
      if { $tcl_version >= 8.4 } {
         labelframe .directx.std_bt
         pack .directx.std_bt -fill x -padx 5 -pady {10 5}
      } else {
         frame .directx.std_bt -border 2 -relief groove
         pack .directx.std_bt -fill x -padx 5 -pady 5
      }
      set std_bt_col #90FF90
      set inf_bt_col #FFFF90
      set ani_bt_col #9090FF
      button .directx.std_bt.def -text "Default Settings" -bg $std_bt_col -padx 5 -pady 1 -command {
         set j 1
         foreach i { 0 0 0 0 1 1 1 1 0 0 0 0 1 0 1 0 0 1 0 1 0 0 1 1 1 1 1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 } {
            set xdx_opt_$j $i
            incr j
         }
      }
      pack .directx.std_bt.def -side left -fill x -padx 5 -pady 5
      button .directx.std_bt.inf -text "Information" -bg $inf_bt_col -padx 5 -pady 1 -command {
         global xdx_ver
         xdx_info_dialog .directx - "Direct X Export  -  Version $xdx_version" \
          "\n Export plugin for Microsoft(R) DirectX(R) (.x) files - ('DirectX.p')\n\
              by Frank Meinert\n\
              \n\
              If you have suggestions or bug reports you can contact me via e-mail :\n\
              'Frank_Meinert@t-online.de'  ( Natrlich auch in Deutsch. )\n\n\
              There is a balloon help for each option. ( Possible switched off\n\
              at 'File -> Settings... -> General -> Balloon help' )\n "
      }
      pack .directx.std_bt.inf -side left -padx 5
      if { $xdx_animation == 1 } {
         button .directx.std_bt.ani -text "Animation" -bg $ani_bt_col -padx 5 -pady 1 -command {
            global xdx_ver
            if { $tcl_platform(platform) == "windows" } {
               set f systemfixed
            } elseif { $tcl_platform(platform) == "unix" } {
               set f fixed
            } else {
               set f -
            }
            xdx_info_dialog .directx $f "Direct X Export  -  Animation" \
                "\nAnimation Script ( included anywhere in Object Data Text ) :\
                 \n\
                 \n   _ANIMATION_ {\
                 \n      # Comment ( until line end )\
                 \n      command { ... } { ... } ...\
                 \n      ...\
                 \n   }\
                 \n\
                 \n\
                 \nCommands :\
                 \n\
                 \n   rotate { <start time>, <end time>, <num time> }\
                 \n      { <start angle> - <end angle> }\
                 \n      { <point 1 start axis x>, <y>, <z> ,  <point 2 start axis x>, <y>, <z>\
                 \n         \[ - <point 1 end axis x>, <y>, <z> ,  <point 2 end axis x>, <y>, <z> ] }\
                 \n "
         }
         pack .directx.std_bt.ani -side left -padx 5
      }
      if { $tcl_version >= 8.4 } {
         labelframe .directx.act_bt
      } else {
         frame .directx.act_bt -border 2 -relief groove
      }
      pack .directx.act_bt -fill x -padx 5 -pady 5
      button .directx.act_bt.save -text "Save" -bg $xdx_act_bt_col -pady 3 -command {
         if { $xdx_busy == 0 } {
            set xdx_busy 1
            wm withdraw .directx
            update
            xdx_save_ac3d
            if { $xdx_acfilename != $acfilename } {
               set answer [tk_messageBox -message "File name not valid !\nPlease select a new file name." -title "Warning !" -type ok -icon warning -parent .]
               set xdx_name ""
            }
            set xdx_opt_save ""
            for { set i 1 } { $i <= $xdx_opt_anz } { incr i } {
               append xdx_opt_save [ eval set xdx_opt_$i ]
            }
            xdx_do_save "save" $xdx_name $xdx_opt_save
            set xdx_busy 0
         }
      }
      pack .directx.act_bt.save -side left -fill x -expand 1 -padx 5 -pady 5
      button .directx.act_bt.save_as -text "Save as ..." -bg $xdx_act_bt_col -pady 3 -command {
         if { $xdx_busy == 0 } {
            set xdx_busy 1
            wm withdraw .directx
            update
            xdx_save_ac3d
            set xdx_opt_save_as ""
            for { set i 1 } { $i <= $xdx_opt_anz } { incr i } {
               append xdx_opt_save_as [ eval set xdx_opt_$i ]
            }
            xdx_do_save "save_as" $xdx_name $xdx_opt_save_as
            set xdx_busy 0
         }
      }
      pack .directx.act_bt.save_as -side left -fill x -expand 1 -padx 5 -pady 5
      button .directx.act_bt.cancel -text "Cancel" -bg $xdx_act_bt_col -pady 3 -command {
         if { $xdx_busy == 0 } {
            wm withdraw .directx
         }
      }
      pack .directx.act_bt.cancel -side left -fill x -expand 1 -padx 5 -pady 5
      trace variable acfilename w change_fname
      if { $xdx_name == "" } {
         .directx.name.xname configure -bg $xdx_xname_col_none
         .directx.name configure -bg $xdx_xname_col_none
      } else {
         .directx.name.xname configure -bg $xdx_xname_col
         .directx.name configure -bg $xdx_xname_col
   	}
   }
   wm deiconify .directx
   centre_window_on_screen .directx
}
proc xdx_info_dialog { parent font title info_txt } {
   global xdx_act_bt_col
   toplevel .x_info
   wm title .x_info $title
   wm transient .x_info [winfo toplevel [winfo parent .x_info]]
   if { $font == "-" } {
      label .x_info.msg -justify left -text $info_txt
   } else {
      label .x_info.msg -justify left -font $font -text $info_txt
   }
   pack .x_info.msg -padx 5
   button .x_info.ok -text "OK" -bg $xdx_act_bt_col -padx 40 -pady 2 -command {
      destroy .x_info
   }
   pack .x_info.ok -padx 10 -pady 15
   centre_window_on_screen .x_info
   focus .x_info.ok
   grab .x_info
   tkwait window .x_info
}
proc xdx_do_save { cmd name opt } {
   global xdx_act_bt_col
   toplevel .directx_save
   wm title .directx_save "Export X"
   wm transient .directx_save [winfo toplevel [winfo parent .directx_save]]
   button .directx_save.cancel -text "Abort" -bg $xdx_act_bt_col -padx 20 -pady 5 -command {
      set xdx_cancel 1
   }
   pack .directx_save.cancel -padx 5 -pady 5
   centre_window_on_screen .directx_save
   wm withdraw .directx_save
   update
   ac3d xdx_save $cmd $name $opt
   destroy .directx_save
}
proc change_fname { var elem op } {
   global xdx_acfilename
   global xdx_name
   global xdx_x_name
   global xdx_ac_name
   global xdx_text_xname
   global xdx_text_opt_1
   global tcl_platform
   global .directx.name.xname
   global .directx.name
   global xdx_xname_col
   global xdx_xname_col_none
   upvar $var acf
   set xdx_acfilename $acf
	set xdx_name [file rootname $xdx_acfilename]
	set xdx_x_name [file rootname $xdx_acfilename].x
	set xdx_ac_name [file tail $xdx_acfilename]
   if { $tcl_platform(platform) == "windows" } {
	   regsub -all / $xdx_name {\\} xdx_name
	   regsub -all / $xdx_x_name {\\} xdx_x_name
   }
   if { $xdx_name == "" } {
	   set xdx_text_xname "X File :   *** UNTITLED ***"
      set xdx_text_opt_1 "Save AC3D File"
   } else {
	   set xdx_text_xname "X File : '$xdx_x_name'"
      set xdx_text_opt_1 "Save AC3D File ( '$xdx_ac_name' )"
	}
   if [ winfo exists .directx ] {
      if { $xdx_name == "" } {
         .directx.name.xname configure -bg $xdx_xname_col_none
         .directx.name configure -bg $xdx_xname_col_none
      } else {
         .directx.name.xname configure -bg $xdx_xname_col
         .directx.name configure -bg $xdx_xname_col
   	}
   }
}
proc xdx_save_ac3d { } {
   global xdx_opt_1
   if { $xdx_opt_1 == 1 } {
      menu_save_last
   }
}
proc xdx_opt_init { opt_num { text "" } { balloon "" } } {
   global xdx_num_mainframe
   global xdx_num_frame
   global xdx_num_column
   global xdx_num_row
   if { [ string range $text 0 12 ] == "xdx_text_opt_" } {
      checkbutton .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.$xdx_num_row -textvariable $text -variable xdx_opt_$opt_num
   } else {
      checkbutton .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.$xdx_num_row -text $text -variable xdx_opt_$opt_num
   }
   if { $balloon != "" } {
      add_balloon .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.$xdx_num_row $balloon
   }
   pack .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.$xdx_num_row -anchor w -padx 10
   incr xdx_num_row
}
proc xdx_opt_frame { txt } {
   global xdx_num_mainframe
   global xdx_num_frame
   global xdx_num_column
   global xdx_num_row
   global tcl_version
   incr xdx_num_frame
   if { $tcl_version >= 8.4 } {
      labelframe .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame -text $txt
      pack .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame -fill both -expand 1 -padx 5 -pady 5
   } else {
      frame .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame -border 2 -relief groove
      pack .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame -fill both -expand 1 -padx 5 -pady 5
      label .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.txt_label -text $txt -bd 1 -relief raised
      pack .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.txt_label -anchor w -fill x -padx 5
   }
   set xdx_num_column 0
   set xdx_num_row 0
   frame .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.space_top -height 5
   pack .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.space_top
   frame .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.space_bot -height 5
   pack .directx.opt.mf$xdx_num_mainframe.opt$xdx_num_frame.space_bot -side bottom
}
proc xdx_opt_mainframe { } {
   global xdx_num_mainframe
   global xdx_num_frame
   global xdx_num_column
   global xdx_num_row
   incr xdx_num_mainframe
   frame .directx.opt.mf$xdx_num_mainframe
   pack .directx.opt.mf$xdx_num_mainframe -fill both -expand 1 -side left
}
