set ldr_path_col       #FFFFA0

set ldr_act_bt_col     #FF9090

if { $tcl_platform(platform) == "macintosh" } {

   set ldr_bt_padx    15

   set ldr_bt_pady     3

} else {

   set ldr_bt_padx     5

   set ldr_bt_pady     1

}

puts ""

puts [ expr " $ldr_bt_padx + 3 " ]

puts ""

set ldr_num_mainframe -1

set ldr_num_frame     -1

set ldr_num_column     0

set ldr_num_row        0

set ldr_cancel 0

set ldr_set 0

set ldraw_settings_default "011000000000000000000000000000"

if { $prefs_ldraw_base_path == "" } {

   set prefs_ldraw_base_path "---"

}

if { $prefs_ldraw_settings == "" } {

   set prefs_ldraw_settings $ldraw_settings_default

}

set ldr_opt_anz 30

for { set ldr_i 1 } { $ldr_i <= $ldr_opt_anz } { incr ldr_i } {

   set ldr_opt_$ldr_i 0

}

proc ldr_get_vertex { v } {

   global ldr_vert_arr

   if { [ info exist ldr_vert_arr($v) ] } {

      return $ldr_vert_arr($v)

   } else {

      return ""

   }

}

proc ldr_set_vertex { v n } {

   global ldr_vert_arr

   set ldr_vert_arr($v) $n

}

proc ldr_del_vertex { } {

   global ldr_vert_arr

   array unset ldr_vert_arr

}

proc ldr_settings { } {

   global ldr_path_col

   global ldr_act_bt_col

   global ldr_bt_padx

   global ldr_bt_pady

   global ldr_set

   global prefs_ldraw_base_path

   global ldr_path_text

   global prefs_ldraw_settings

   global ldraw_settings_default

   global ldr_version

   global ldr_opt_anz

   for { set i 1 } { $i <= $ldr_opt_anz } { incr i } {

      global ldr_opt_$i

   }

   if { $prefs_ldraw_base_path == "" } {

      set prefs_ldraw_base_path "---"

   }

   if { $prefs_ldraw_settings == "" } {

      set prefs_ldraw_settings $ldraw_settings_default

   }

   for { set ldr_i 1 } { $ldr_i <= $ldr_opt_anz } { incr ldr_i } {

      set ldr_opt_$ldr_i [ string index $prefs_ldraw_settings $ldr_i ]

   }

   toplevel .ldr_import

   wm title .ldr_import "LDraw Settings"

   wm transient .ldr_import [winfo toplevel [winfo parent .ldr_import]]

   wm protocol .ldr_import WM_DELETE_WINDOW {

      set ldr_set 0

      destroy .ldr_import

   }

   set ldr_path_text  "LDraw base path : '$prefs_ldraw_base_path'"

   frame .ldr_import.path -border 1 -relief solid -bg $ldr_path_col

   pack .ldr_import.path -fill both -expand 1 -padx 5 -pady {5 10}

   label .ldr_import.path.name -textvariable ldr_path_text -bg $ldr_path_col

   pack .ldr_import.path.name -side left -expand 1 -fill x -padx 20 -pady 1

   button .ldr_import.path.set -text "Set" -bg #9090FF -padx $ldr_bt_padx -pady $ldr_bt_pady -command {

      set base_path [ tk_chooseDirectory -parent .ldr_import ]

      if { $base_path == "" } {

      } else {

         set prefs_ldraw_base_path [ file nativename $base_path ]

         if { ![file exists "$prefs_ldraw_base_path/PARTS/3001.DAT" ] } {

            tk_messageBox -parent .ldr_import -title "LDraw base path" -message "This is NOT the LDraw base path !"

            set prefs_ldraw_base_path "---"

         }

      }

      set ldr_path_text "LDraw base path : '$prefs_ldraw_base_path'"

   }

   pack .ldr_import.path.set -side left -fill x -padx 2 -pady 2

   frame .ldr_import.opt

   pack .ldr_import.opt -fill both -expand 1

   ldr_opt_mainframe

   ldr_opt_frame "Objects/Groups"

   ldr_opt_init   1  "Create Main Group"  " If enabled, then an additional group \n is created for the whole model. "

   ldr_opt_init   2  "Individual Objects for Parts"  " If enabled, then an individual object \n is created for every part/subfile. "

   ldr_opt_frame "Studs"

   ldr_opt_init  10  "No Studs"  " If enabled, then Stud Parts \n ('studxxx.dat') are not loaded. "

   ldr_opt_init  11  "Low Res Studs"  " If enabled, then low resolution \n studs ('stu2xxx.dat') are used. "

   ldr_opt_mainframe

   ldr_opt_frame "Lines"

   ldr_opt_init   5  "No Edge Lines"  " If enabled, the edges lines are not loaded. "

   ldr_opt_frame "Polygons"

   ldr_opt_init  15  "No Polygons"  " If enabled, the polygons are not loaded. "

   ldr_opt_init  16  "Single-Sided Surfaces"  " If enabled, each polygon is \n created as two single-sided \n surfaces with opposite directions. \n This is useful for exporters which \n do not consider double-sided surfaces. "

   ldr_opt_frame "Extras"

   ldr_opt_init  20  "Keep MPD Directory"  " If a MPD file is loaded, a temporary directory \n is created in the AC3D plugin directory named \n 'LDRAW_MPD'. This directory contains all single \n LDraw files contained in the MPD file. If this \n option is enabled, the directory with the LDraw \n files included will not be deleted after loading. "

   ldr_opt_init  21  "Create Complete MPD"  " If enabled, an additional MPD file is created \n which contains the main file and all needed subfiles. \n This setting is valid only for this time and is not saved. "

   labelframe .ldr_import.std_bt

   pack .ldr_import.std_bt -fill x -padx 5 -pady {10 5}

   set std_bt_col #90FF90

   set inf_bt_col #FFFF90

   set ani_bt_col #9090FF

   button .ldr_import.std_bt.def -text "Default Settings" -bg $std_bt_col -padx $ldr_bt_padx -pady $ldr_bt_pady -command {

      for { set ldr_i 1 } { $ldr_i <= $ldr_opt_anz } { incr ldr_i } {

         set ldr_opt_$ldr_i [ string index $ldraw_settings_default $ldr_i ]

      }

   }

   pack .ldr_import.std_bt.def -side left -fill x -padx 5 -pady 5

   button .ldr_import.std_bt.inf -text "Information" -bg $inf_bt_col -padx $ldr_bt_padx -pady $ldr_bt_pady -command {

      global ldr_version

      ldr_info_dialog .ldr_import - "LDraw Import  -  Version $ldr_version" \

       "\n Import plugin for LDraw ( Lego ) files - ('ldraw.p')\n\

           by Frank Meinert\n\

           \n\

           If you have suggestions or bug reports you can contact me via e-mail :\n\

           'Frank_Meinert@t-online.de'  ( Natrlich auch in Deutsch. )\n\n\

           There is a balloon help for each option. ( Possible switched off\n\

           at 'File -> Settings... -> General -> Balloon help' )\n\

           \n\

           Because most LDraw files contain references to part files (subfiles),\n\

           the LDraw part libraries must be installed and the LDraw base path\n\

           must be set.\n\

           ( If all data is contained in the LDraw file, there is no need to\n\

           install the libraries and to set the base path. )\n\

           \n\

           For more information, please have a look at 'www.ldraw.org'\n\

           \n\

           This settings are only saved, if the AC3D settings are saved, too.\n\

           For this, the AC3D setting ('File'->'Settings...'->'Advanced'\n\

           ->'Save settings on exit') must be switched on.\n"

      grab set .ldr_import

   }

   pack .ldr_import.std_bt.inf -side left -padx 5

   labelframe .ldr_import.act_bt

   pack .ldr_import.act_bt -fill x -padx 5 -pady 5

   button .ldr_import.act_bt.ok -text "Load" -bg $ldr_act_bt_col -pady [ expr " $ldr_bt_pady + 2 " ] -command {

      set prefs_ldraw_settings "0"

      for { set i 1 } { $i <= $ldr_opt_anz } { incr i } {

         append prefs_ldraw_settings [ eval set ldr_opt_$i ]

      }

      set ldr_set 1

      destroy .ldr_import

   }

   pack .ldr_import.act_bt.ok -side left -fill x -expand 1 -padx 5 -pady 5

   button .ldr_import.act_bt.cancel -text "Cancel" -bg $ldr_act_bt_col -pady [ expr " $ldr_bt_pady + 2 " ] -command {

      set ldr_set 0

      destroy .ldr_import

   }

   pack .ldr_import.act_bt.cancel -side left -fill x -expand 1 -padx 5 -pady 5

   centre_window_on_screen .ldr_import

   focus .ldr_import.act_bt.ok

   grab set .ldr_import

   tkwait window .ldr_import

   return $ldr_set

}

proc ldr_opt_init { opt_num { text "" } { balloon "" } } {

   global ldr_num_mainframe

   global ldr_num_frame

   global ldr_num_column

   global ldr_num_row

   if { [ string range $text 0 12 ] == "ldr_text_opt_" } {

      checkbutton .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.$ldr_num_row -textvariable $text -variable ldr_opt_$opt_num

   } else {

      checkbutton .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.$ldr_num_row -text $text -variable ldr_opt_$opt_num

   }

   if { $balloon != "" } {

      add_balloon .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.$ldr_num_row $balloon

   }

   pack .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.$ldr_num_row -anchor w -padx 10

   incr ldr_num_row

}

proc ldr_opt_frame { txt } {

   global ldr_num_mainframe

   global ldr_num_frame

   global ldr_num_column

   global ldr_num_row

   incr ldr_num_frame

   labelframe .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame -text $txt

   pack .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame -fill both -expand 1 -padx 5 -pady 5

   set ldr_num_column 0

   set ldr_num_row 0

   frame .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.space_top -height 5

   pack .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.space_top

   frame .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.space_bot -height 5

   pack .ldr_import.opt.mf$ldr_num_mainframe.opt$ldr_num_frame.space_bot -side bottom

}

proc ldr_opt_mainframe { } {

   global ldr_num_mainframe

   global ldr_num_frame

   global ldr_num_column

   global ldr_num_row

   incr ldr_num_mainframe

   frame .ldr_import.opt.mf$ldr_num_mainframe

   pack .ldr_import.opt.mf$ldr_num_mainframe -fill both -expand 1 -side left

}

proc ldr_abort_start { } {

   global ldr_act_bt_col

   global ldr_cancel

   set ldr_cancel 0

   toplevel .ldraw_abort

   wm title .ldraw_abort "LDraw"

   wm transient .ldraw_abort [winfo toplevel [winfo parent .ldraw_abort]]

   label .ldraw_abort.status -font systemfixed -anchor w -text "Loading ... "

   pack .ldraw_abort.status -padx 20 -pady 10

   button .ldraw_abort.cancel -text "Abort" -bg $ldr_act_bt_col -padx 20 -pady 5 -command {

      set ldr_cancel 1

   }

   pack .ldraw_abort.cancel -padx 5 -pady 5

   centre_window_on_screen .ldraw_abort

   grab set .ldraw_abort

   update

}

proc ldr_abort_test { } {

   global ldr_cancel

   update

   if { $ldr_cancel == 1 } {

      return 1

   }

   return 0

}

proc ldr_abort_end { } {

   destroy .ldraw_abort

   update

}

proc ldr_info_dialog { parent font title info_txt } {

   global ldr_act_bt_col

   toplevel .ldr_info

   wm title .ldr_info $title

   wm transient .ldr_info [winfo toplevel [winfo parent .ldr_info]]

   if { $font == "-" } {

      label .ldr_info.msg -justify left -text $info_txt

   } else {

      label .ldr_info.msg -justify left -font $font -text $info_txt

   }

   pack .ldr_info.msg -padx 5

   button .ldr_info.ok -text "OK" -bg $ldr_act_bt_col -padx 40 -pady 2 -command {

      destroy .ldr_info

   }

   pack .ldr_info.ok -padx 10 -pady 15

   centre_window_on_screen .ldr_info

   focus .ldr_info.ok

   grab .ldr_info

   tkwait window .ldr_info

}

