proc ddhbasrelief_makeframe {} {

   # CUSTOM CONFIGURATION: Change these values to set the number of characters
   #                       wide * high to show the texture list box
   set lwidth 48
   set lheight 12

   # Object size vars
   set objsizmin 0.1
   set objsizmax 100.0
   set objsizinc 0.1

   # Height vars
   set heightmin 0.01
   set heightmax 100.0
   set heightinc 0.1

   toplevel .ddhbasrelief
   wm title .ddhbasrelief "Bas relief from texture"
   wm transient .ddhbasrelief [winfo toplevel [winfo parent .ddhbasrelief]]

   set width 6
   set ypad 3

   # List of textures
   frame .ddhbasrelief.frmlist
   pack .ddhbasrelief.frmlist -side top -fill both -expand 1
   label .ddhbasrelief.frmlist.ttl -text "Texture for bas relief"
   pack .ddhbasrelief.frmlist.ttl -side top -fill x
   listbox .ddhbasrelief.frmlist.listtex -height $lheight -width $lwidth -yscrollcommand ".ddhbasrelief.frmlist.listtexscroll set"
   scrollbar .ddhbasrelief.frmlist.listtexscroll -orient vertical -command { .ddhbasrelief.frmlist.listtex yview }
   pack .ddhbasrelief.frmlist.listtex -side left -fill both -expand 1
   pack .ddhbasrelief.frmlist.listtexscroll -side right -fill y

   # Space
   frame .ddhbasrelief.frmspace1
   pack .ddhbasrelief.frmspace1 -side top -fill x -pady $ypad

   # Size of the resulting object
   set frm [frame .ddhbasrelief.frmobjsiz]
   pack $frm -side top -fill x
   label $frm.lbl -text "Maximum width/depth"
   pack $frm.lbl -side left -fill x
   spinbox $frm.sbx -from $objsizmin -increment $objsizinc -to $objsizmax -textvariable ddhbasrelief_objsiz -width $width
   pack $frm.sbx -side right -fill x
   add_balloon $frm.lbl "Maximum size of the resulting object along the X/Z axes."

   # Maximum height
   set frm [frame .ddhbasrelief.frmheight]
   pack $frm -side top -fill x
   label $frm.lbl -text "Maximum height"
   pack $frm.lbl -side left -fill x
   spinbox $frm.sbx -from $heightmin -increment $heightinc -to $heightmax -textvariable ddhbasrelief_height -width $width
   pack $frm.sbx -side right -fill x
   add_balloon $frm.lbl "Maximum size of the resulting object along the Y axis."

   # Space
   frame .ddhbasrelief.frmspace2
   pack .ddhbasrelief.frmspace2 -side top -fill x -pady $ypad

   # Go
   frame .ddhbasrelief.frmbtn
   pack .ddhbasrelief.frmbtn -side top -fill x

   button .ddhbasrelief.frmbtn.btnapply -text "Create grid" -command {
      if { [ .ddhbasrelief.frmlist.listtex curselection ] == "" } {
         tk_messageBox -message "Please select a texture" -type ok -icon warning
         return
      }
      set idx [.ddhbasrelief.frmlist.listtex curselection]
      eval ac3d ddhbasrelief_go $idx $ddhbasrelief_objsiz $ddhbasrelief_height $ddhbasrelief_maxsiz
      destroy .ddhbasrelief
   }
   pack .ddhbasrelief.frmbtn.btnapply -side left -fill x -expand 1

   button .ddhbasrelief.frmbtn.btncancel -text "Cancel" -command {
      destroy .ddhbasrelief
   }
   pack .ddhbasrelief.frmbtn.btncancel -side right -fill x -expand 1

}

proc ddhbasrelief_dialog {} {

   global ac_platform

   global ddhbasrelief_objsiz
   global ddhbasrelief_height
   global ddhbasrelief_maxsiz

   set ddhbasrelief_objsiz 1.0
   set ddhbasrelief_height 0.1
   # MAXIMUM SIZE OF AN IMAGE (width * height)
   # This is the maximum number of vertices that will be created from a texture.
   # Change at your own risk.
   set ddhbasrelief_maxsiz 65536

   if ![winfo exists .ddhbasrelief] {
      ddhbasrelief_makeframe
   }

   wm deiconify .ddhbasrelief
   centre_window_on_screen .ddhbasrelief
   if { $ac_platform == "Mac" } {
	   update idletasks
	   exposeUI .ddhbasrelief
   }

   grab .ddhbasrelief

}

