set xanchor centre
set yanchor centre
set zanchor centre

proc selection_recentre_dialog {} {
  global xanchor yanchor zanchor

  if ![winfo exists .centre] {
    new_toplevel .centre "Centre"

    label .centre.title -text "Set object centres"
    pack .centre.title -side top -fill x

    frame .centre.f1 -border 2 -relief raised
    pack .centre.f1 -fill both -expand 1

# ROW 0

    label .centre.f1.xmin -text MIN
    grid .centre.f1.xmin -row 0 -column 1

    label .centre.f1.x -text Cent
    grid .centre.f1.x -row 0 -column 2

    label .centre.f1.xmax -text MAX
    grid .centre.f1.xmax -row 0 -column 3

# ROW 1

    label .centre.f1.ymax -text "X"
    grid .centre.f1.ymax -row 1 -column 0

    radiobutton .centre.f1.11 -value min -variable xanchor 
    grid .centre.f1.11 -row 1 -column 1

    radiobutton .centre.f1.12 -value centre -variable xanchor 
    grid .centre.f1.12 -row 1 -column 2

    radiobutton .centre.f1.13 -value max -variable xanchor 

    grid .centre.f1.13 -row 1 -column 3

# ROW 2

    label .centre.f1.y -text "Y"
    grid .centre.f1.y -row 2 -column 0

    radiobutton .centre.f1.21 -value min -variable yanchor
    grid .centre.f1.21 -row 2 -column 1

    radiobutton .centre.f1.22 -value centre -variable yanchor
    grid .centre.f1.22 -row 2 -column 2

    radiobutton .centre.f1.23 -value max -variable yanchor
    grid .centre.f1.23 -row 2 -column 3

# ROW 3

    label .centre.f1.ymin -text "Z"
    grid .centre.f1.ymin -row 3 -column 0

    radiobutton .centre.f1.31 -value min -variable zanchor
    grid .centre.f1.31 -row 3 -column 1

    radiobutton .centre.f1.32 -value centre -variable zanchor
    grid .centre.f1.32 -row 3 -column 2

    radiobutton .centre.f1.33 -value max -variable zanchor
    grid .centre.f1.33 -row 3 -column 3


    frame .centre.f3
    pack .centre.f3 -side bottom -fill x

    button .centre.f3.ok -text "Apply" -command {
      eval ac3d selection_recentre $xanchor $yanchor $zanchor
      ac3d redraw_orth
    }
    pack .centre.f3.ok -side left -fill x -expand 1

    button .centre.f3.cancel -text "Close" -command {
      wm withdraw .centre
    }
    pack .centre.f3.cancel -side left -fill x -expand 1
  }

  wm deiconify .centre
    centre_window_on_screen .centre
}








