# FONT3D TCL code for a dialog that gets lets the user select a true type font
# and enter some text.  Font3d is then run and the dxf output is loaded into AC3D
# Note - the standard dialog doesn't work under WINDOWS because the TCL file dialog is unable
# to select a font!




proc font3d_get_fontname {} {
global fsBox
global env
global tcl_platform
global fontname

set filetypes  {
{{ TrueType fonts} {.ttf}}
{{ All files} {*.*}}
}


# YOU WILL PROBABLY NEED TO EDIT fontdir TO POINT TO YOUR
# DIR WHERE YOUR TRUE_TYPE FONTS RESIDE

	if { $tcl_platform(platform) == "windows" } {
		set s $env(SystemRoot)
		set fontdir $s/fonts

		set list [glob "$fontdir/*.ttf"]

		toplevel .f3dfonts
		wm transient .f3dfonts [winfo toplevel [winfo parent .f3dfonts]]
		wm title .f3dfonts "Double click on a font"
		listbox .f3dfonts.list -yscrollcommand ".f3dfonts.yscroll set" 
		scrollbar .f3dfonts.yscroll -orient vertical \
			-command { .f3dfonts.list yview }

		pack .f3dfonts.yscroll  -side left -fill y
		pack .f3dfonts.list  -side left -fill both -expand 1

		foreach f $list {
			.f3dfonts.list insert 0 $f
		}
		pack .f3dfonts.list -fill both
		centre_window_on_screen .f3dfonts

		bind .f3dfonts.list <Double-1> {
			set fontname [selection get]
			destroy .f3dfonts
		}

	} else {

		if { $tcl_platform(platform) == "unix" } {
			# for SGI and other UNIX set this to point to a dir of ttf fonts
			set fontdir /dosc/winnt/fonts
		}


	 set filename [tk_getOpenFile -title "Select a font" -initialdir $fontdir ]

	#    set fsBox(path) $fontdir
	#    get_openfilename "select a font" $filetypes ""
	}


}

proc font3d_go {} {
global fontname
global fonttext
global fontdepth
global env
global prefs_plugin_dir
global tcl_platform

    if { $fontname == "" } { tk_messageBox -message "Select a font file" -type ok -title Error; return false}
    if { $fonttext == "" } { tk_messageBox -message "Enter some text" -type ok -title Error; return false}

	set path [get_ac3d_path plugins]

    if { $tcl_platform(platform) == "windows" } {
       set f3dname "$path\\font3d.exe" 
       set tmpnam "$env(TEMP)\\font3d.dxf"

    } else {
       set f3dname "$path/font3d" 
       set tmpnam /tmp/font3d.dxf
    }
   

    exec "$f3dname"  string=$fonttext \
        format=dxf output=$tmpnam depth=$fontdepth font=$fontname


    ac3d load_file $tmpnam

	catch {
	    file delete $tmpnam
	} 
    wm withdraw .f3d
    return true
}

proc font3d_dialog {} {
global fontdepth

  if ![winfo exists .f3d] {

    set fontdepth 0.2

    toplevel .f3d
    wm title .f3d "Add Font3D text"
    wm transient .f3d [winfo toplevel [winfo parent .f3d]]

    frame .f3d.f1
    label .f3d.f1.l -text "Font"
    entry .f3d.f1.fontname -textvariable fontname -width 50
    button .f3d.f1.browse -text "Browse..." -command { set fontname [font3d_get_fontname] }
    pack .f3d.f1.l -side left
    pack .f3d.f1.browse -side right
    pack .f3d.f1.fontname -fill x -expand true

    frame .f3d.f2
    label .f3d.f2.l -text "Text"
    entry .f3d.f2.text -textvariable fonttext
    bind .f3d.f2.text <Return> { .f3d.f4.go flash ; .f3d.f4.go invoke }

    pack .f3d.f2.l -side left 
    pack .f3d.f2.text -side left -fill x -expand true

    pack .f3d.f1 -side top
    pack .f3d.f2 -side top
    
    frame .f3d.f3
    checkbutton .f3d.f3.depth -text "3d" -variable fontdepth -onvalue 0.2 -offvalue 0.0 
    pack  .f3d.f3.depth

    frame .f3d.f4
    button .f3d.f4.go -text OK -command font3d_go
    button .f3d.f4.stop -text Cancel -command { wm withdraw .f3d }
    pack .f3d.f4.go .f3d.f4.stop -side left

    pack .f3d.f1 -side top -fill x -expand true
    pack .f3d.f2 -side top -fill x -expand true
    pack .f3d.f3 -side top
    pack .f3d.f4 -side top
  }

  wm deiconify .f3d
  centre_window_on_screen .f3d

}

























