proc ddhgreeble_spinbox { framename labeltext bmin bmax binc var sbwidth balloon } {

   frame $framename
   pack $framename -side top -fill x

   label $framename.lbl -text $labeltext
   pack $framename.lbl -side left -fill x

   spinbox $framename.sbx -from $bmin -increment $binc -to $bmax -textvariable $var -width $sbwidth -command {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   pack $framename.sbx -side right -fill x

   add_balloon $framename.lbl $balloon

   bind $framename.sbx <Return> {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }

}


ac3d add_pref window_geom_greeble ""

proc ddhgreeble_makeframe {} {
global prefs_window_geom_greeble

	new_toplevel_tracked .ddhgreeble "Greeble" prefs_window_geom_greeble
#   toplevel .ddhgreeble
#   wm title .ddhgreeble "Greeble"
#   wm transient .ddhgreeble [winfo toplevel [winfo parent .ddhgreeble]]

   set width 6
   set ypad 3

   ###########################################################################
   # Beveling

   set frmbev [frame .ddhgreeble.frmbevel]
   pack $frmbev -side top -fill x

   label $frmbev.ttl -text "=== BEVEL ==="
   pack $frmbev.ttl -side top -fill x

   checkbutton $frmbev.cbbevel -text "Beveling" -variable ddhgreeble_bev_on -command {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   pack $frmbev.cbbevel -anchor w

   ddhgreeble_spinbox $frmbev.randpct "Bevel frequency % " 0 100 1 ddhgreeble_bev_rand_pct $width "Percentage of surfaces that will receive beveling"
   ddhgreeble_spinbox $frmbev.minht "Bevel minimum height % " 0 100000 1 ddhgreeble_bev_minht $width "Minimum height of the bevel"
   ddhgreeble_spinbox $frmbev.maxht "Bevel maximum height % " 0 100000 1 ddhgreeble_bev_maxht $width "Maximum height of the bevel"
   ddhgreeble_spinbox $frmbev.minind "Bevel minimum indent % " 0 99 1 ddhgreeble_bev_minind $width "Minimum distance to indent the bevel from the surface's edge"
   ddhgreeble_spinbox $frmbev.maxind "Bevel maximum indent % " 0 99 1 ddhgreeble_bev_maxind $width "Maximum distance to indent the bevel from the surface's edge"
   ddhgreeble_spinbox $frmbev.divpct "Bevel division frequency % " 0 100 1 ddhgreeble_bev_gridpct $width "Percentage of bevels that will be split randomly into 2, 3, or 4 bevels. "

   ###########################################################################
   # Greebling

   set frmgre [frame .ddhgreeble.frmgreeble]
   pack $frmgre -side top -fill x

   label $frmgre.ttl -text "=== GREEBLE ==="
   pack $frmgre.ttl -side top -fill x

   checkbutton $frmgre.cbgreeble -text "Greebling" -variable ddhgreeble_gre_on -command {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   pack $frmgre.cbgreeble -anchor w

   ddhgreeble_spinbox $frmgre.randpct "Greeble frequency % " 0 100 1 ddhgreeble_gre_rand_pct $width "Percentage of surfaces that will receive greebles"
   ddhgreeble_spinbox $frmgre.mingps "Minimum greebles per surface " 0 100 1 ddhgreeble_gre_mingps $width "Minimum number of greebles per surface"
   ddhgreeble_spinbox $frmgre.maxgps "Maximum greebles per surface " 0 100 1 ddhgreeble_gre_maxgps $width "Maximum number of greebles per surface"
   ddhgreeble_spinbox $frmgre.minht "Greeble minimum height % " 0 100000 1 ddhgreeble_gre_minht $width "Minimum height of each greeble (standard height is 50% of surface area)"
   ddhgreeble_spinbox $frmgre.maxht "Greeble maximum height % " 0 100000 1 ddhgreeble_gre_maxht $width "Maximum height of each greeble (standard height is 50% of surface area)"
   ddhgreeble_spinbox $frmgre.minsiz "Greeble minimum size % " 0 100 1 ddhgreeble_gre_minsiz $width "Minimum size of each greeble (size is a percentage of surface area)"
   ddhgreeble_spinbox $frmgre.maxsiz "Greeble maximum size % " 0 100 1 ddhgreeble_gre_maxsiz $width "Maximum size of each greeble (size is a percentage of surface area)"
   ddhgreeble_spinbox $frmgre.rotinc "Greeble rotation degrees " 0 90 1 ddhgreeble_gre_rotinc $width "Degrees to randomly rotate each greeble.\n90 means greebles will be rotated in 90 degree increments.\n0 means no rotation will occur."

   ###########################################################################
   # Custom

   set frmcust [frame .ddhgreeble.frmcustom]
   pack $frmcust -side top -fill x

   label $frmcust.ttl -text "=== CUSTOM ==="
   pack $frmcust.ttl -side top -fill x

   checkbutton $frmcust.cbcust -text "Use custom greebles" -variable ddhgreeble_use_custom -command {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   add_balloon $frmcust.cbcust "Search for custom greebles in the current document.\nCustom greebles are any AC3D objects (not groups) with \"//CUSTOM_GREEBLE\" at the beginning of a line in the Data field of its properties."
   pack $frmcust.cbcust -anchor w

   checkbutton $frmcust.cbstand -text "Use standard greebles with custom" -variable ddhgreeble_use_standard -command {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   add_balloon $frmcust.cbstand "If using custom greebles, also use standard greebles.\nIf this is not checked and no custom greebles are found, standard greebles will still be used."
   pack $frmcust.cbstand -anchor w

   checkbutton $frmcust.cbnoconf -text "Maintain custom greeble aspect" -variable ddhgreeble_cust_noconform -command {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   add_balloon $frmcust.cbnoconf "Do not distort custom greebles to fit the underlying geometry.\nBest if used on 4-sided faces that approximate squares/rectangles\n(geometry that is not heavily skewed)"
   pack $frmcust.cbnoconf -anchor w

   ###########################################################################
   # Options

   frame .ddhgreeble.frmopt
   pack .ddhgreeble.frmopt -side top -fill x

   label .ddhgreeble.frmopt.ttl -text "=== OPTIONS ==="
   pack .ddhgreeble.frmopt.ttl -side top -fill x

   checkbutton .ddhgreeble.frmopt.cbsepobj -text "Greebles in separate objects" -variable ddhgreeble_separate_objs -command {
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   add_balloon .ddhgreeble.frmopt.cbsepobj "If checked, each bevel/greeble will be created in separate objects.\nAllows the application of different textures to greebles/bevels.\nWARNING: Can create an excessive number of objects that could cause slowdowns\nif greeble is performed on a large number of surfaces."
   pack .ddhgreeble.frmopt.cbsepobj -anchor w

   ddhgreeble_spinbox $frmgre.randseed "Random seed " 0 10000000 1 ddhgreeble_randseed $width "Random seed.\nOne (1) defaults to current time, to a 1 second resolution.\nSet to non-zero to get consistent results between previews."

   # Save settings
   frame .ddhgreeble.frmsaveset
   pack .ddhgreeble.frmsaveset -side top -fill x
   checkbutton .ddhgreeble.frmsaveset.ddhgreeble_writeset -text "Save settings to greeble Data" -variable ddhgreeble_writesettings
   pack .ddhgreeble.frmsaveset.ddhgreeble_writeset -anchor w
   add_balloon .ddhgreeble.frmsaveset.ddhgreeble_writeset "Write the settings used to generate greebles to the new greeble object's Data property"

   checkbutton .ddhgreeble.frmopt.ddhgreeble_realtime -text "Realtime updates" -variable ddhgreeble_realtime -command {
      eval ac3d ddhgreeble_sync_realtime $ddhgreeble_realtime
      if { $ddhgreeble_realtime != "0" } {
         eval ac3d ddhgreeble_go $ddhgreeble_realtime 1 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      }
   }
   pack .ddhgreeble.frmopt.ddhgreeble_realtime -anchor w

   ###########################################################################
   # Go
   frame .ddhgreeble.frmbtn
   pack .ddhgreeble.frmbtn -side top -fill x

   button .ddhgreeble.frmbtn.btnapply -text "Create greebles" -command {
      if { $ddhgreeble_realtime != "0" } {
         .ddhgreeble.frmopt.ddhgreeble_realtime invoke
      }
      eval ac3d ddhgreeble_go 0 0 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
   }
   pack .ddhgreeble.frmbtn.btnapply -side top -fill x -expand 1

   button .ddhgreeble.frmbtn.btnapplyclose -text "Create greebles and close" -command {
      if { $ddhgreeble_realtime != "0" } {
         .ddhgreeble.frmopt.ddhgreeble_realtime invoke
      }
      eval ac3d ddhgreeble_go 0 0 $ddhgreeble_bev_on $ddhgreeble_bev_rand_pct $ddhgreeble_bev_minht $ddhgreeble_bev_maxht $ddhgreeble_bev_minind $ddhgreeble_bev_maxind $ddhgreeble_gre_on $ddhgreeble_gre_rand_pct $ddhgreeble_gre_mingps $ddhgreeble_gre_maxgps $ddhgreeble_gre_minht $ddhgreeble_gre_maxht $ddhgreeble_gre_minsiz $ddhgreeble_gre_maxsiz $ddhgreeble_gre_rotinc $ddhgreeble_randseed "$ddhgreeble_writesettings|$ddhgreeble_use_custom|$ddhgreeble_use_standard|$ddhgreeble_separate_objs|$ddhgreeble_cust_noconform|$ddhgreeble_bev_gridpct"
      wm withdraw .ddhgreeble
   }
   pack .ddhgreeble.frmbtn.btnapplyclose -side top -fill x -expand 1

   ###########################################################################
   # Hook to end realtime on close
   wm protocol .ddhgreeble WM_DELETE_WINDOW {
      if { $ddhgreeble_realtime != "0" } {
         .ddhgreeble.frmopt.ddhgreeble_realtime invoke
      }
#      destroy .ddhgreeble
	wm withdraw .ddhgreeble
   }

}

proc ddhgreeble_dialog {} {

   global ddhgreeble_realtime
   global ddhgreeble_bev_on
   global ddhgreeble_bev_rand_pct
   global ddhgreeble_bev_maxht
   global ddhgreeble_bev_minht
   global ddhgreeble_bev_minind
   global ddhgreeble_bev_maxind
   global ddhgreeble_gre_on
   global ddhgreeble_gre_rand_pct
   global ddhgreeble_gre_mingps
   global ddhgreeble_gre_maxgps
   global ddhgreeble_gre_minht
   global ddhgreeble_gre_maxht
   global ddhgreeble_gre_minsiz
   global ddhgreeble_gre_maxsiz
   global ddhgreeble_gre_rotinc
   global ddhgreeble_randseed
   global ddhgreeble_writesettings
   global ddhgreeble_use_custom
   global ddhgreeble_use_standard
   global ddhgreeble_bev_gridpct
   global ddhgreeble_separate_objs
   global ddhgreeble_cust_noconform
   global ac_platform

   if ![winfo exists .ddhgreeble] {
      set ddhgreeble_realtime 0
      set ddhgreeble_bev_on 1
      set ddhgreeble_bev_rand_pct 85
      set ddhgreeble_bev_minht 5
      set ddhgreeble_bev_maxht 40
      set ddhgreeble_bev_minind 1
      set ddhgreeble_bev_maxind 10
      set ddhgreeble_gre_on 1
      set ddhgreeble_gre_rand_pct 85
      set ddhgreeble_gre_mingps 1
      set ddhgreeble_gre_maxgps 4
      set ddhgreeble_gre_minht 25
      set ddhgreeble_gre_maxht 100
      set ddhgreeble_gre_minsiz 10
      set ddhgreeble_gre_maxsiz 60
      set ddhgreeble_gre_rotinc 90
      set ddhgreeble_use_custom 1
      set ddhgreeble_use_standard 1
      set ddhgreeble_randseed [ expr { int( rand() * 1000000 ) + 1 } ]
      set ddhgreeble_writesettings 1
      set ddhgreeble_bev_gridpct 90
      set ddhgreeble_separate_objs 0
      set ddhgreeble_cust_noconform 0
      ddhgreeble_makeframe
      # Startup in realtime mode
      #.ddhgreeble.frmopt.ddhgreeble_realtime invoke
   }

   wm deiconify .ddhgreeble
#   centre_window_on_screen .ddhgreeble
   if { $ac_platform == "Mac" } {
	   update idletasks
	   exposeUI .ddhgreeble
   }

}

