proc ddhknife_makeframe {} {

   global ddhknife_knife_name
   global ddhknife_slice_surf
   global ddhknife_cut_away
   global ddhknife_delete_knife
   set ddhknife_knife_name ""
   set ddhknife_slice_surf 1
   set ddhknife_cut_away 0
   set ddhknife_delete_knife 0

   new_toplevel .ddhknife "Knife"

   set width 6
   set ypad 3

   # Set knife
   frame .ddhknife.frmset
   pack .ddhknife.frmset -side top -fill x

   entry .ddhknife.frmset.txtknife -textvariable ddhknife_knife_name
   pack .ddhknife.frmset.txtknife -side left -fill x -expand 1
   button .ddhknife.frmset.btnset -text "Set knife" -command {
      eval ac3d ddhknife_set
   }
   pack .ddhknife.frmset.btnset -side right -fill x -expand 1

   # Space
   frame .ddhknife.frmspace1
   pack .ddhknife.frmspace1 -side top -fill x -pady $ypad

   # Slice indicator
   frame .ddhknife.frmopts
   pack .ddhknife.frmopts -side top -fill x

   # AC - added spaces to checkbutton text - a Mac bug messes up the clipping if we don't
   checkbutton .ddhknife.frmopts.chkslice -text "Slice surfaces " -variable ddhknife_slice_surf
   pack .ddhknife.frmopts.chkslice -side top
   checkbutton .ddhknife.frmopts.chkcutaway -text "Cut away object " -variable ddhknife_cut_away
   pack .ddhknife.frmopts.chkcutaway -side top
   checkbutton .ddhknife.frmopts.chkdelknife -text "Delete knife " -variable ddhknife_delete_knife
   pack .ddhknife.frmopts.chkdelknife -side bottom

   # Space
   frame .ddhknife.frmspace2
   pack .ddhknife.frmspace2 -side top -fill x -pady $ypad

   # Slice
   frame .ddhknife.frmbtn
   pack .ddhknife.frmbtn -side top -fill x

   button .ddhknife.frmbtn.btnapply -text "Slice" -command {
      eval ac3d ddhknife_go $ddhknife_slice_surf $ddhknife_cut_away $ddhknife_delete_knife
   }
   pack .ddhknife.frmbtn.btnapply -side left -fill x -expand 1

}

proc ddhknife_dialog {} {

   if ![winfo exists .ddhknife] {
      ddhknife_makeframe
   }

   wm deiconify .ddhknife
   centre_window_on_screen .ddhknife

}

