
proc	makeChooser { parent } {
    set list "tetra cube penta hex octa dodeca icosa prism rhomb stell"
    frame $parent.clues
    pack $parent.clues -side left -fill both

    listbox $parent.clues.list -selectmode single -width 10
    foreach f $list {
        $parent.clues.list insert 0 $f
    }
    pack $parent.clues.list -fill both
	$parent.clues.list selection set 0
    bind $parent.clues.list <Double-1> {
        set shapefac [selection get]
    }
}

proc makeChoice { parent } {
    set platolist "tetrahedron cube octahedron dodecahedron icosahedron"
    frame $parent.poss
    pack $parent.poss -side right -fill both -expand 1
    listbox $parent.poss.possibles -selectmode single -width 30
    pack $parent.poss.possibles -side left -fill y
	set nch 0 
	# number of choices in the listbox
    foreach f $platolist {
        $parent.poss.possibles insert 0 $f
		incr nch
    }

	ttk::scrollbar $parent.poss.scr -command "$parent.poss.possibles yview"
    pack $parent.poss.scr -side right -fill y -expand 1
	return $nch
}

proc makeframe2 { parent } {
    frame $parent.f2
    pack $parent.f2 -side top -fill both

# Choice list

	makeChooser $parent.f2

# and create the list of items that match the clue name
#possibles list

	return [makeChoice $parent.f2]

}
proc makeframe1 { parent } {
    frame $parent.f1 -border 2 -relief raised
    pack $parent.f1 -fill both -expand 1

# ROW 0 - top widgets

    frame $parent.f1.helps
    pack $parent.f1.helps -side top -fill both -expand 1
 
#    label $parent.f1.helps.help1 -text "Select Polyhedron part name, Find:"
#    grid $parent.f1.helps.help1 -row 0 -column 1
#    label $parent.f1.helps.help2 -text "then select detailed name from column 2"
#    grid $parent.f1.helps.help2 -row 1 -column 1

    label $parent.f1.helps.dual -text "Dual"
    grid $parent.f1.helps.dual -row 2 -column 0
    radiobutton $parent.f1.helps.star -value 0 -variable dual 
    grid $parent.f1.helps.star -row 2 -column 1
    radiobutton $parent.f1.helps.stardual -value 1 -variable dual 
    grid $parent.f1.helps.stardual -row 2 -column 2
}
proc makechooser {} {
    toplevel .polymake
    wm title .polymake "PolyMaker"
    wm transient .polymake [winfo toplevel [winfo parent .polymake]]
	set shapelist "none"

    label .polymake.title -text "by Dr. Zvi Har'El algorithm, GWMichel interface"
    pack .polymake.title -side top -fill x

	makeframe1 .polymake

# Choice and select poly frame; npos is number of elements in the choice widget 
	set npos [makeframe2 .polymake ]

# Go buttons, find, close

    frame .polymake.f3
    pack .polymake.f3 -side bottom -fill x

    button .polymake.f3.ok -text "Make" -command {
        set shapefac [selection get]
		ac3d polyhedronmakename $shapefac $dual
		ac3d redraw_orth
		ac3d redraw_3d
    }
    pack .polymake.f3.ok -side left -fill x -expand 1

#    button .polymake.f3.fnd -text "Find" -command 
	
	## AC - removed the button and bound the button release to get the list of possibles

	bind .polymake.f2.clues.list <ButtonRelease-1>  {
        set shapefac [selection get]
		  # get the shapes with this in the name
		ac3d polyhedronfind $dual $shapefac "shapelist"
#puts "SHAOELIST $shapelist"
		.polymake.f2.poss.possibles delete 0 $npos
		set npos 0


		foreach f $shapelist {
		    .polymake.f2.poss.possibles insert 0 $f
			incr npos
		}
    }

#    pack .polymake.f3.fnd -side left -fill x -expand 1

    button .polymake.f3.cancel -text "Close" -command {
      wm withdraw .polymake
    }
    pack .polymake.f3.cancel -side left -fill x -expand 1
	return $npos
}
proc polymake_dialog {} {
  global id
  global dual
  global shapefac
  global shapelist
  global npos
  set dual 0
set id 0

  if ![winfo exists .polymake] {
	set npos [makechooser ]
  }

  wm deiconify .polymake
    centre_window_on_screen .polymake
}








