proc ddhuvmap_radiobutton { rbname labeltext var val balloon } {

   radiobutton $rbname -text $labeltext -variable $var -value $val -command {
      if { $ddhuvmap_realtime != "0" } {
         eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
      }
   }
   add_balloon $rbname $balloon

}

proc ddhuvmap_spinbox { lbl sbx labeltext bmin bmax binc var sbwidth balloon posrow } {

   label $lbl -text $labeltext
   grid $lbl -row $posrow -column 0  -sticky w

   spinbox $sbx -from $bmin -increment $binc -to $bmax -textvariable $var -width $sbwidth -command {
      if { $ddhuvmap_realtime != "0" } {
         eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
      }
   }
   grid $sbx -row $posrow -column 1  -sticky e

   add_balloon $lbl $balloon

   bind $sbx <Return> {
      if { $ddhuvmap_realtime != "0" } {
         eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
      }
   }

}


ac3d add_pref window_geom_uvmap ""

proc ddhuvmap_makeframe {} {
global prefs_window_geom_uvmap

	new_toplevel_tracked .ddhuvmap "UV Map" prefs_window_geom_uvmap
	
#   toplevel .ddhuvmap
#   wm title .ddhuvmap "UV Map"
#   wm transient .ddhuvmap [winfo toplevel [winfo parent .ddhuvmap]]

   set width 6
   set ypad 3

   # Main frame
   frame .ddhuvmap.frmmain
   pack .ddhuvmap.frmmain -side top -fill x
   # Left frame
   set fl [frame .ddhuvmap.frmmain.frame_left]
   pack $fl -side left -fill y -pady 2 -padx 2
   # Right frame
   set fr [frame .ddhuvmap.frmmain.frame_right]
   pack $fr -side right -fill y -pady 2 -padx 2

   ###########################################################################
   # Planar mapping

   set mplanar [frame $fl.th_planar]
   pack $fl.th_planar -side top -fill x
   label $mplanar.lbl -text "Planar mapping"
   grid $mplanar.lbl -row 0 -column 0  -sticky w
   ddhuvmap_radiobutton $mplanar.t_front "Front" ddhuvmap_type 1 "Front projection."
   grid $mplanar.t_front -row 1 -column 0  -sticky w
   ddhuvmap_radiobutton $mplanar.t_back "Back" ddhuvmap_type 2 "Back projection."
   grid $mplanar.t_back -row 1 -column 1  -sticky w
   ddhuvmap_radiobutton $mplanar.t_left "Left" ddhuvmap_type 3 "Left projection."
   grid $mplanar.t_left -row 2 -column 0  -sticky w
   ddhuvmap_radiobutton $mplanar.t_right "Right" ddhuvmap_type 4 "Right projection."
   grid $mplanar.t_right -row 2 -column 1  -sticky w
   ddhuvmap_radiobutton $mplanar.t_top "Top" ddhuvmap_type 5 "Top projection."
   grid $mplanar.t_top -row 3 -column 0  -sticky w
   ddhuvmap_radiobutton $mplanar.t_bottom "Bottom" ddhuvmap_type 6 "Bottom projection."
   grid $mplanar.t_bottom -row 3 -column 1  -sticky w

   ###########################################################################
   # Shape mapping

   set mshape [frame $fr.th_shapes]
   pack $fr.th_shapes -side top -fill x
   label $mshape.lbl -text "Shape mapping"
   pack $mshape.lbl -anchor w
   ddhuvmap_radiobutton $mshape.t_box "Box" ddhuvmap_type 0 "Box projection."
   pack $mshape.t_box -anchor w
   ddhuvmap_radiobutton $mshape.t_sphere "Spherical" ddhuvmap_type 7 "Spherical projection, Y = up/down.\nImage centered toward positive Z axis (front)."
   pack $mshape.t_sphere -anchor w
   ddhuvmap_radiobutton $mshape.t_cyl "Cylindrical" ddhuvmap_type 8 "Cylindrical projection along the Y (up) axis"
   pack $mshape.t_cyl -anchor w
   ddhuvmap_radiobutton $mshape.t_cylcap "Cylindrical cap" ddhuvmap_type 10 "Capped cylindrical projection along the Y (up) axis.\nSame as cylindrical, except maps the top/bottom of the cylinder."
   pack $mshape.t_cylcap -anchor w
   set sf [section_frame $fr.th_sopt "Sphere/Cylinder alignment"]
   pack $fr.th_sopt -side top -fill x
   ddhuvmap_radiobutton $sf.r_x "X axis" ddhuvmap_scaxis 0 "Align the sphere cylinder along the X axis"
   pack $sf.r_x -anchor w
   ddhuvmap_radiobutton $sf.r_y "Y axis" ddhuvmap_scaxis 1 "Align the sphere cylinder along the Y axis"
   pack $sf.r_y -anchor w
   ddhuvmap_radiobutton $sf.r_z "Z axis" ddhuvmap_scaxis 2 "Align the sphere cylinder along the Z axis"
   pack $sf.r_z -anchor w

   checkbutton $sf.spacepoles -text "Space polar coords" -variable ddhuvmap_spacepoles -command {
      if { $ddhuvmap_realtime != "0" } {
         eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
      }
   }
   pack $sf.spacepoles -anchor w

   ###########################################################################
   # Global coordinates

   set mglob [frame $fl.th_glob]
   pack $fl.th_glob -side top -fill x
   label $mglob.lbl -text "Global mapping"
   pack $mglob.lbl -anchor w
   ddhuvmap_radiobutton $mglob.t_glob "Global coordinates" ddhuvmap_type 11 "Map textures along a global axis using Box mapping.\nAllows consistent texturing across different sized/shaped geometry."
   pack $mglob.t_glob -anchor w
   set gf [section_frame $fl.th_gopt "Global options"]
   pack $fl.th_gopt -side top -fill x
   ddhuvmap_spinbox $gf.stretchx_lbl $gf.stretchx_sbx "Stretch X %" 0.001 10000 1 ddhuvmap_gstretchx $width "Scales the texture horizontally by a percentage" 0
   ddhuvmap_spinbox $gf.stretchy_lbl $gf.stretchy_sbx "Stretch Y %" 0.001 10000 1 ddhuvmap_gstretchy $width "Scales the texture vertically by a percentage" 1
   ddhuvmap_spinbox $gf.shiftx_lbl $gf.shiftx_sbx "Shift X %" -100 100 1 ddhuvmap_gshiftx $width "Offsets the texture horizontally by a percentage" 2
   ddhuvmap_spinbox $gf.shifty_lbl $gf.shifty_sbx "Shift Y %" -100 100 1 ddhuvmap_gshifty $width "Offsets the texture vertically by a percentage" 3
   ddhuvmap_spinbox $gf.rot_lbl $gf.rot_sbx "Rotate" -360 360 1 ddhuvmap_grot $width "Rotates the texture" 4

   ###########################################################################
   # Other options

   frame $fr.frmss
   pack $fr.frmss -side bottom -fill x
   checkbutton $fr.frmss.ddhuvmap_css -text "Use subdivision preview" -variable ddhuvmap_ss -command {
      if { $ddhuvmap_realtime != "0" } {
         eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
      }
   }
   pack $fr.frmss.ddhuvmap_css  -anchor w

   add_balloon $fr.frmss.ddhuvmap_css "Use subdivision preview geometry when calculating texture coordinates?\nThis may cause texture coordinates to appear incorrect when subdivision preview is off,\nbut will show correctly upon subdivision preview and/or commit subdivisions."

   frame $fr.frmrealtime
   pack $fr.frmrealtime -side bottom -fill x
   checkbutton $fr.frmrealtime.ddhuvmap_realtime -text "Realtime updates" -variable ddhuvmap_realtime -command {
      if { $ddhuvmap_realtime != "0" } {
         eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
      }
   }
   pack $fr.frmrealtime.ddhuvmap_realtime  -anchor w

   add_balloon $fr.frmrealtime.ddhuvmap_realtime "Realtime updates?.\nUpdates are only saved when you click Apply."

   ###########################################################################
   # Go

   frame .ddhuvmap.frmbtn
   pack .ddhuvmap.frmbtn -side bottom -fill x

   button .ddhuvmap.frmbtn.btnapplyc -text "Apply and Close" -command {
      eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
      wm withdraw .ddhuvmap
   }
   pack .ddhuvmap.frmbtn.btnapplyc -side right -fill x -expand 1

   button .ddhuvmap.frmbtn.btnapply -text "Apply" -command {
      eval ac3d ddhuvmap_go $ddhuvmap_type $ddhuvmap_gstretchx $ddhuvmap_gstretchy $ddhuvmap_gshiftx $ddhuvmap_gshifty $ddhuvmap_grot $ddhuvmap_ss $ddhuvmap_scaxis $ddhuvmap_spacepoles
   }
   pack .ddhuvmap.frmbtn.btnapply -side left -fill x -expand 1

}

proc ddhuvmap_dialog {} {

   global ddhuvmap_realtime
   global ddhuvmap_type
   global ddhuvmap_gstretchx
   global ddhuvmap_gstretchy
   global ddhuvmap_gshiftx
   global ddhuvmap_gshifty
   global ddhuvmap_grot
   global ddhuvmap_ss
   global ddhuvmap_scaxis
   global ddhuvmap_spacepoles

   if ![winfo exists .ddhuvmap] {
      set ddhuvmap_realtime 0
      set ddhuvmap_type 0
      set ddhuvmap_gstretchx 100
      set ddhuvmap_gstretchy 100
      set ddhuvmap_gshiftx 0
      set ddhuvmap_gshifty 0
      set ddhuvmap_grot 0
      set ddhuvmap_ss 1
      set ddhuvmap_scaxis 1
      set ddhuvmap_spacepoles 1
      ddhuvmap_makeframe
   }

   wm deiconify .ddhuvmap
#   centre_window_on_screen .ddhuvmap

}

