# AC3D
# Copyright (c) 2008, Inivis Limited. All rights reserved.

#package require tkpng

#puts [ttk::style theme names]
#ttk::style theme use clam



# main AC3D TCL file defines control panel UI

#set screen [ winfo screen .]
#set screenwidth [winfo screenwidth .]
#set screenheight [winfo screenheight .]
#puts "Screen $screen is $screenwidth x $screenheight"

#set uilayout vertical
set uilayout classic

#tk_setPalette #999999


#ttk::label .test -text "kugkjygkuygkuyg" -relief raised -padding { 10 1 }
#pack .test -side top

# change the default white scheme to slight grey on Mac
if { ($ac_platform == "Mac")  || ($ac_platform == "Sun") } {
	tk_setPalette #e0e0e0
	option add *Entry*background white
	option add *Text*background white
}
	
#puts [winfo name .]
  wm protocol . WM_DELETE_WINDOW { menu_quit }


#puts "platform: $ac_platform OS: $tcl_platform(os)"

catch {
	if {$prefs_default_dir != ""} { cd $prefs_default_dir }
}





#tk appname AC3D
#puts "TCL/TK appname: [tk appname]"


set tk_strictMotif $prefs_tk_strictmotif

#setting no font makes checkbuttons on the MAC not mess up.

if { ($ac_platform == "Linux")  || ($ac_platform == "Sun") } {
  if { $prefs_font_main != "" } {
    option add *font     $prefs_font_main
    }
  if { $prefs_font_menu != ""} {
    option add *Menubutton*font  $prefs_font_menu
    }
}

if { $ac_platform == "Mac" } {
	option add *font $prefs_font_main
}

#option add *font -*-*-*-*-*-*-10-*-*-*-*-*-*-*

#option add *font "{Bitstream Vera Sans} 10"

# try and please the Tucows windows reviewer:
if { $tcl_platform(platform) == "windows" } {
	wm minsize . 745 520
}

# there is an odd default max size on the Mac (smaller than the screen) - set it bigger
if { $ac_platform  == "Mac" } {
	wm maxsize . 8192 9192
}
#option add *highlightThickness 0

option add *Button*borderWidth 1
option add *Checkbutton*borderWidth 1
#option add *Checkbutton*selectColor green
# make all select stuff green (checkbuttons and those in menus)
#option add *selectColor green

option add *Entry*borderWidth 1
option add *Scale*borderWidth 1
option add *Scrollbar*borderWidth 1



#bind all <Option-ButtonPress-1> {event generate %W <ButtonPress-3> -x %x -y %y -rootx %X -rooty %Y -button 3 -time %t}



set highlight 0

# if strict motif is on then you must add one to ypad for same appearance
if { $tk_strictMotif == 1 } {
    set ypad 1
} else {
    set ypad 0
}



# define our own exit proc so we can trap Mac exit 
# shoudl be fine for other platforms too
# menu_quit in ac3dops now calls __exit to really quit

rename exit __exit

proc exit { } {
	menu_quit
}







proc bypass_system_dialogs {} {

    # Mac System 10.4.8 causes an intermittant (1 in 50?) hang problem related to dialogs.  The hang would occur 
	# occasionally when a system dialog was closed by pressing an OK button (e.g. Object->Optimize-Vertices).
	# If a hang occurred, with menus would activate but would all menu items would be disabled and it was not possible to return
	# control back to the program

	# switch off system dialogs so Tcl/Tk uses homegrown versions - Mac OS X AC3D only
	# prevents the hanging bug where closing a dialog sometimes didn't ungrab the AC3D UI


    proc ::tk_messageBox {args} {
        return [eval tk::MessageBox $args]
    }
    
    proc ::tk_chooseColor {args} {
		return [tk::dialog::color:: {*}$args]
	}

	proc ::tk_getOpenFile {args} {
			return [::tk::dialog::file:: open {*}$args]
    }

	proc ::tk_getSaveFile {args} {
			return [::tk::dialog::file:: save {*}$args]
   	}

    proc ::tk_chooseDirectory {args} {
		return [::tk::dialog::file::chooseDir:: {*}$args]
    }
    
	puts "system dialogs bypassed"
}


proc bypass_system_file_dialogs {} {
# now unused
	# switch off system file dialogs so Tcl/Tk uses homegrown versions - Mac OS X AC3D only

	puts "system file dialogs bypassed"
}









proc section_frame {w text} {


return [labelframe $w -text $text]
#return [labelframe $w -text $text -pady 4 -padx 4]


#    frame $w -bd 2 -relief ridge
#	label $w.l -pady 0 -text $text -justify left 
#	pack $w.l -side top
#	frame $w.cont
#	pack $w.cont -fill both
#	return $w.cont


  frame $w -bd 0
  label $w.l -pady 0
  frame $w.f -bd 2 -relief groove
  frame $w.f.f
  pack $w.f.f
  $w.l config -text $text
  set padx 3
  set pady 7
  set ipadx 2
  set ipady 7

  pack $w.f -padx $padx -pady $pady -fill both -expand 1
  place $w.l -x [expr $padx+10] -y $pady -anchor w
  pack $w.f.f -padx $ipadx -pady $ipady -fill both -expand 1
  raise $w.l
  return $w.f.f


}

proc horiz_pack {parent args } {
    foreach i $args {
        pack $i -in $parent -side left -fill both -expand 1 -pady 0 -padx 0 -ipady 0 -ipadx 0
    }
}

proc vert_pack {parent args } {
    foreach i $args {
        pack $i -in $parent -side top -fill both -expand 1 -pady 0 -padx 0
#        pack $i -in $parent -side top  -pady 0 -padx 0
    }
}


set draw_mode move

proc trace_proc { name1 name2 op } {
global currentrb cp
global drawmode_preserve
global oldbg

    upvar $name1 newval

    set n $name1.id($newval)
    upvar #0 $n mhit

	# if it's the same mode we are in at the moment - do nothing
	if { $mhit == $currentrb($name1) } { return }
		
	# raise the current radio button
    $currentrb($name1) configure -relief raised -bg $oldbg


    set currentrb($name1) $mhit
	# sink the new one
    $currentrb($name1) configure -relief sunken
#	puts traceproc
}


proc check_keep_down { name variable value } {
global drawmode_preserve
global $variable

    if { [set $variable] == $value} {
		set drawmode_preserve true	
		$name configure -bg green
	} else {
		set drawmode_preserve false
	}

}

proc ac_axis_selector { name variable } {

	frame $name
	frame $name.a
	label $name.a.lab -text "axis:" -pady 0 -bd 1 
    label $name.a.x -text "X" -relief sunken -pady 0 -bd 1 
    label $name.a.y -text "Y" -relief raised -pady 0 -bd 1
    label $name.a.z -text "Z" -relief raised -pady 0 -bd 1
    label $name.a.c -text "C" -relief raised -pady 0 -bd 1

	add_balloon $name.a.x "Rotation will be around selection's X axis "
	add_balloon $name.a.y "Rotation will be around selection's Y axis "
	add_balloon $name.a.z "Rotation will be around selection's Z axis "
	
	add_balloon $name.a.c "use a custom axis for rotation"


    proc set_custom_axis { var } {
		
		upvar #0 $var.axis axis
		upvar #0 $var.cent cent
		upvar #0 $var.current_axis current_axis
		upvar #0 $var.button button
	
		set asel [ac3d get_axis_from_selection]
		if { $asel == "" } {
			set axis "0 1 0"
		} else {
			set axis $asel
		}
		set cent [ac3d get_selection_centre]
	}
		
    
	set b [button $name.setc -text "Set axis" -command "set_custom_axis $variable" ]
	add_balloon $b "define the custom rotate axis from two selected vertices"
	
	upvar #0 $variable.axis axis
	upvar #0 $variable.cent cent
	upvar #0 $variable.current_axis current_axis
	upvar #0 $variable.button button
		
	set axis "1 0 0"
	set cent "0 0 0"	
	set current_axis "x"
	set button $b

		
    proc set_buttons { var a } {
		
		upvar #0 $var.axis axis
		upvar #0 $var.cent cent
		upvar #0 $var.current_axis current_axis
		upvar #0 $var.button button
	
		set current_axis $a
				
		if {$a == "x"} {
			pack forget $button
		} elseif {$a == "y" } {
			pack forget $button
		} elseif {$a == "z" } {
			pack forget $button
		} elseif {$a == "c" } {
			pack $button
		}
		

#		puts "axis $axis cent $cent"
    }
    

	bind $name.a.x <ButtonPress-1> "%W configure -relief sunken; $name.a.y configure -relief raised; $name.a.z configure -relief raised; $name.a.c configure -relief raised; set_buttons $variable x"
	bind $name.a.y <ButtonPress-1> "%W configure -relief sunken; $name.a.x configure -relief raised; $name.a.z configure -relief raised; $name.a.c configure -relief raised; set_buttons $variable y"
	bind $name.a.z <ButtonPress-1> "%W configure -relief sunken; $name.a.x configure -relief raised; $name.a.y configure -relief raised; $name.a.c configure -relief raised; set_buttons $variable z"
	bind $name.a.c <ButtonPress-1> "%W configure -relief sunken; $name.a.x configure -relief raised; $name.a.y configure -relief raised; $name.a.z configure -relief raised; set_buttons $variable c"

	pack $name.a.x $name.a.y $name.a.z $name.a.c -side left -padx 0
#	pack $name.a.setc -side bottom
	pack $name.a
	pack $name
	
#	pack $name.x $name.y $name.z -side left -padx 0

	
	# default is X set
	uplevel #0 "set $variable x"

	return $name
}



proc axis_selector_do_rotate { var degs} {
	upvar #0 $var.cent cent
	upvar #0 $var.current_axis current_axis
	upvar #0 $var.axis custaxis
	
	set a $current_axis
	
	# for x, y, z rotation, use the center of the selection
	set centrot [ac3d get_selection_centre]
	
		if {$a == "x"} {
			set axis "1 0 0"
		} elseif {$a == "y" } {
			set axis "0 1 0"
		} elseif {$a == "z" } {
			set axis "0 0 1"
		} elseif {$a == "c" } {
			# for custome axis rot - use the last customs axis and center
			set axis $custaxis
			set centrot $cent
		}
	
#	puts "rotating axis $axis    centrot $centrot"
	
	ac3d rotate_full_axis_angle [lindex $axis 0] [lindex $axis 1] [lindex $axis 2] \
		[lindex $centrot 0] [lindex $centrot 1] [lindex $centrot 2]  $degs
}








proc mode_button {name text command variable value { helptext "" } { keepdownable false} { bitmapimage "" } } {
global highlight
global ypad
global tcl_version
global $variable
global currentrb
global bitmap
global oldbg

#ttk::radiobutton $name -text $text -textvariable $variable -value $value
#return $name
#        radiobutton $name -text $text -command $command -padx 0 -pady $ypad -height 1\
#            -highlightthickness  $highlight -indicatoron false \
#			 -bd 1 -variable $variable -value $value


#puts "$name $text"
    # add a bit more vertical spacing on the Mac - looks much nicer
#    if { [ac3d get_platform] == "Mac" } {
#	set pady 2
#    } else {
	set pady 0
#    }

    label $name -text $text -relief raised -pady $pady -bd 1
	set oldbg [$name cget -bg]

#$name configure -bg eeeeee

if { $bitmapimage != "" } {
	$name configure -image $bitmapimage
}


    bind $name <ButtonPress-1> "%W configure -relief sunken"

	if { $keepdownable } {
		set ckd "check_keep_down $name $variable $value"
	} else {
		set ckd "set drawmode_preserve false; set $variable $value"
	}
    bind $name <ButtonRelease-1> "$ckd ; $command; if { \$drawmode_preserve } {$name configure -bg green}"
    catch {$name config -image $bitmap($value)}

    set winname "$variable.id($value)"
    uplevel #0 " set $winname $name "
    upvar #0 $winname poo

    if { [set $variable] == $value} {
        $name configure -relief sunken
		set currentrb($variable) $name
		trace variable $variable w trace_proc
#		puts "tracing $variable"
    }

	if { $helptext != "" } {
		add_balloon $name $helptext
	}
	return $name

}








proc cbutton {name text command {helptext ""} } {
global highlight
global ypad
global tcl_version

# standard buttons are too big
#ttk::button $name -text $text -command $command -width -0 -padding 0
#button $name -text $text -command $command -borderwidth 1 -highlightthickness 0 -padx 0 -pady 0
#return $name

    # add a bit more vertical spacing on the Mac - looks much nicer
#    if { [ac3d get_platform] == "Mac" } {
#	set pady 2
#    } else {
	set pady 1
#    }

	label $name -text $text -relief raised -pady $pady -padx 2 -bd 1
	if { $helptext != ""} {
		add_balloon $name $helptext
	}

	bind $name <ButtonPress-1> { %W configure -relief sunken }
	bind $name <ButtonRelease-1> " if { \[%W cget -relief\] == \"sunken\" } { %W configure -relief raised ; $command } "

	return $name
}



	image create photo tick -file "tcl/images/tick.png"
	image create photo tickempty -file "tcl/images/tickempty.png"

proc ac_checkbutton { name text command variable { helptext "" } } {

#    checkbutton $name -text $text -highlightthickness 0 -variable $variable -command $command
#	if { $helptext != "" } {
#		add_balloon $name $helptext
#	}
#	return $name

		proc cbhit { widget var } {

		# called when a custom check button is hit - toggles value and changes tick
		upvar #0 $var val
		#puts "val of $var is $val"

			if { $val } {
				$widget.cbtick configure -image tickempty
				set val 0
			} else {
				$widget.cbtick configure -image tick
				set val 1
			}
		}


	# handmade widget - primarily so the native mac stuff doesn't appear
	frame $name
	label $name.cbtick -relief sunken -pady 0
	label $name.cblabel -text "$text" -pady 0 -padx 0 

	bind $name.cbtick <ButtonPress-1> "cbhit $name $variable; $command"
	bind $name.cblabel <ButtonPress-1> "cbhit $name $variable; $command"

	$name.cbtick configure -image tick

	pack $name.cbtick -padx 1 -side left
	pack $name.cblabel -side left

	# must initialise the var if it's not already set
	upvar #0 $variable val
	if { ![info exists val] } {	set val 0 }

	if { $val } {
		$name.cbtick configure -image tick
	} else {
		$name.cbtick configure -image tickempty
	}

	if { $helptext != "" } {
		add_balloon $name.cbtick $helptext
		add_balloon $name.cblabel $helptext
	}

	return $name
}




proc ac_checkbutton_simple { name text command variable { helptext "" } } {

	proc bhit { widget var } {

	upvar #0 $var val
	#puts "val of $var is $val"

		if { $val } {
			$widget configure -relief raised
			set val 0
		} else {
			$widget configure -relief sunken
			set val 1
		}

	}

#    checkbutton $name -text $text -highlightthickness 0 -variable $variable -command $command
#	if { $helptext != "" } {
#		add_balloon $name $helptext
#	}
#	return $name

#used to have own widget because didn't know that it was highlightthickness that was making it take up so much space
	label $name -text $text -relief raised -pady 0
	bind $name <ButtonPress-1> "bhit $name $variable; $command"

$name configure -image tick

	# must initialise the var if it's not already set
	upvar #0 $variable val
	if { ![info exists val] } {	set val 0 }

	if { $val } {
		$name configure -relief sunken
	} else {
		$name configure -relief raised
	}

	if { $helptext != "" } {
		add_balloon $name $helptext
	}
	return $name

}




proc maximize_cp {} {

set g [wm maxsize .]
puts $g

}





proc foldbuttontoggle { name } {

global foldbuttonstate
global foldbuttoninner
global foldcanvas

	set inner $foldbuttoninner($name)

	if { $foldbuttonstate($name)} {
		 $name configure -relief sunken
		$name itemconfigure indicator -text "-" 
		pack $inner -side top -fill both -padx 3 -pady 3 -expand 1

	} else {
		$name configure -relief raised
		$name itemconfigure indicator -text "+" 
		pack forget $inner

	}
	set  foldbuttonstate($name)  [expr !$foldbuttonstate($name)] 

	set b [$foldcanvas bbox win]
#	puts "bbox $b"

	set height [$foldcanvas cget -height]
	set height [ lindex $b 3]
	set width [$foldcanvas cget -width] 
#	puts "$width $height" 

	$foldcanvas configure -scrollregion " 0 0 100 $height }
	if { [ catch { set canvas $ac3d_version_revision } ] != 0 } {
	return 1
}

proc positiontext { canv x2 y} {

	$canv move text [expr $x2/2] $y
}

proc foldbutton {name text inner} {
global foldbuttonstate
global foldbuttoninner

	set foldbuttonstate($name) 1
	set foldbuttoninner($name) $inner 
 
	canvas $name -relief raised -height 10 -bd 2
	pack $name -fill x


	$name create text 0 0 -text  $text -justify center -tags text

	$name create text 0 0 -text  "+" -justify right -tags indicator

	set font [$name itemcget text -font]
	set a [font metrics $font -ascent]
	set d [font metrics $font -descent]

	set h [expr $a + $d]
	set amd [expr $a - $d]

	set cw [$name cget -width]
	set cw2 [expr $cw/2]

#	puts "font $font $a $d $h"

	$name configure -height $h 

#	$name move text $cw2 $amd
	$name move indicator 10 $amd

bind $name <Configure> "positiontext $name %w $amd"

	bind $name <ButtonPress-1> " foldbuttontoggle %W"
	return $name
}








proc folditem { parent name title} {
	set f [frame $parent.$name  -relief groove -bd 2  ]	
	pack $f -fill x -expand 1 
	set inner [frame $f.inner ]	
	set togglevar($inner) 0

	foldbutton $f.b  $title $inner

	pack $f.b -side top -fill x -pady 1

#	label $inner.l -text hello -height 10
#	pack $inner.l -fill both
	return $inner
}



proc createfoldcanvas { c } {
global foldcanvas
#set width 100
#set height 200
set region {0 0 10 10}


	set pwidth [$c cget -width]

	scrollbar $c.yscroll -orient vertical -command "$c.canvas yview" -width 10

	pack $c.yscroll -side right -fill y
	update

	set cwidth [expr $pwidth - [$c.yscroll cget -width]]

	canvas $c.canvas  \
		-yscrollcommand "$c.yscroll set" -width $cwidth

	set foldcanvas $c.canvas

	$c.canvas configure -scrollregion $region


	pack $c.canvas -side right -fill both -expand true


	set f [frame $c.canvas.f  -bd 0]
	$c.canvas create window 0 0 -anchor nw -window $f -tags win -width $cwidth

	return $c.canvas.f
}




















	wm title . "Inivis AC3D"

wm geometry . ${prefs_windowwidth}x${prefs_windowheight}+$prefs_windowx+$prefs_windowy


# menu bar

    if { $tcl_version >= 8 } {
menu .mbar -tearoff 0 -type normal
#menu .mbar -tearoff 0 -type toplevel
    } else {
        frame .mbar -relief raised -bd 2
        pack .mbar -side top -fill x
    }


# cp is the main control panel

#    toplevel .cp
#    wm title .cp "AC3D"
#    wm transient .cp [winfo toplevel [winfo parent .cp]]

    frame .bottombar -relief raised -bd 1
    pack .bottombar -side bottom -fill x
	


    

	set cp2 [frame .cp2]
    pack $cp2 -side top -fill x -expand 0


    
frame .mainframe  -borderwidth 1 -relief groove
pack .mainframe -fill both -expand 1


    

    

    
    set cp [frame .mainframe.cp  ]
    pack $cp -side left -fill y -expand 0
    
    set UI(toolbar) [ frame .mainframe.toolbar -bd 3 ]
    pack $UI(toolbar) -side top -fill x 

    set UI(infobar) [frame .mainframe.infobar]
    pack $UI(infobar) -side top -fill x -expand 0

    
    set UI(viewcanvas) [canvas .mainframe.views -relief raised -bd 2 -bg black]
    pack $UI(viewcanvas) -side left -fill both -expand 1

#grid $cp -row 1 -column 0 -sticky ns
#grid $UI(infobar) -row 0 -column 1 -sticky wens
#grid $UI(viewcanvas) -row 1 -column 1 -sticky nsew

#grid columnconfigure .mainframe 1 -weight 1
#grid rowconfigure .mainframe 1 -weight 1





proc accel { a } {
global ac_platform

	if { $ac_platform != "Mac" } {
		return $a
	}

	set pos [string first Ctrl $a]
	if { $pos == -1 } {
		return
	} else {
		return [string replace $a $pos [expr $pos + 3] "Command"]
	}
}


# FILE MENU
    set UI(menu_file) [menu .mbar.file -tearoff 0 ]

    # export menu - part of file menu
    set UI(menu_export) [menu .mbar.file.export -tearoff 0]

    .mbar.file add command -label "New..." -command "menu_clear" -accelerator [accel Ctrl+N ] -underline 0
    .mbar.file add command -label "Open..." -command { menu_open ""  } -accelerator [accel Ctrl+O] -underline 0

    # Recent file menu
    set UI(menu_recent) [menu .mbar.file.recent -tearoff 0]

    .mbar.file add cascade -label "Open Recent" -menu $UI(menu_recent) -underline 5
    
    $UI(menu_recent) add command -label $prefs_recentfiles0 -command { if { $prefs_recentfiles0 != ""} { menu_open $prefs_recentfiles0} }
	$UI(menu_recent) add command -label $prefs_recentfiles1 -command { if { $prefs_recentfiles1 != ""} { menu_open $prefs_recentfiles1} }
    $UI(menu_recent) add command -label $prefs_recentfiles2 -command { if { $prefs_recentfiles2 != ""} { menu_open $prefs_recentfiles2} }
    $UI(menu_recent) add command -label $prefs_recentfiles3 -command { if { $prefs_recentfiles3 != ""} { menu_open $prefs_recentfiles3} }


    .mbar.file add separator
    .mbar.file add command -label "Merge..." -command { menu_merge } 
# used for minimize on Mac #-accelerator [accel Ctrl+M] -underline 0

#   .mbar.file add separator

    .mbar.file add command -label "Import..." -command {menu_import } -accelerator [accel Ctrl+I] -underline 0
    .mbar.file add cascade -label "Export" -menu $UI(menu_export) -underline 0
.mbar.file add command -label "Object Library..." -command { obj_lib_dlg } -underline 7
    .mbar.file add separator
    .mbar.file add command -label "Save" -command "menu_save_last" -underline 0  -accelerator [accel Ctrl+S]
    .mbar.file add command -label "Save As..." -command "menu_save_ac" -underline 5
    .mbar.file add command -label "Save Selection..." -command "menu_save_selection" -underline 7
    .mbar.file add separator
		# only add Print under Windows
	if { $tcl_platform(platform) == "windows" } {
		.mbar.file add command -label "Print Setup..." -command "ac3d windows_print_setup_dialog ."
		.mbar.file add command -label "Print..." -command "dialog_windows_print" -underline 1 -accelerator [accel Ctrl+P]
		.mbar.file add separator

	}

    .mbar.file add command -label "Settings..." -command "show_settings" -underline 2
#    .mbar.file add separator


if {$ac_platform != "Mac" } {
	.mbar.file add separator
    .mbar.file add command -label "Exit..." -command "menu_quit" -underline 1
}


	set filehelplist { "Clear everything" "Open an AC3D file" "" "" "insert a model" \
		"Insert a non AC3D format file" "save the model in a different format" "Open the object library" \
		"" "save the current model" \
        "save the current model with a new name" "save selection as an AC3D file" "" \
        }

	if { $tcl_platform(platform) == "windows" } {
		lappend filehelplist "Adjust printer settings" "Print a view window" ""
	}

    lappend filehelplist  "edit preferences" "" "Exit AC3D" 

	add_menu_balloons .mbar.file $filehelplist




# edit menu
    menubutton .mbar.edit -text "Edit" -menu .mbar.edit.menu -underline 0
    menu .mbar.edit.menu -tearoff 0
	set UI(menu_edit) .mbar.edit.menu
    .mbar.edit.menu add command -label "Undo" -command "ac3d undo" -accelerator [accel Ctrl+Z] -underline 0
    .mbar.edit.menu add command -label "Redo" -command "ac3d redo" -accelerator [accel Ctrl+Y] -underline 0
    .mbar.edit.menu add separator
    .mbar.edit.menu add command -label "Cut" -command "ac3d clipboard_cut" -accelerator [accel Ctrl+X]  -underline 2
    .mbar.edit.menu add command -label "Copy" -command "ac3d clipboard_copy" -accelerator [accel Ctrl+C]  -underline 0
    .mbar.edit.menu add command -label "Paste" -command "ac3d clipboard_paste" -accelerator [accel Ctrl+V]  -underline 0
    .mbar.edit.menu add command -label "Duplicate" -command "ac3d duplicate" -accelerator [accel Ctrl+D]  -underline 0

    .mbar.edit.menu add separator
    .mbar.edit.menu add command -label "Select All" -command "ac3d select_all" -accelerator [accel Ctrl+A]  -underline 7
    .mbar.edit.menu add command -label "Select Nothing" -command "ac3d clear_selection" -accelerator [accel Ctrl+Shift+A] -underline 7


	.mbar.edit.menu add cascade -label "Select Vertices" -menu .selectverticessmenu -underline 0
    menu .selectverticessmenu -tearoff 0
    .selectverticessmenu add command -label "Boundary" -command "ac3d select_boundary_vertices" -underline 0
    .selectverticessmenu add command -label "Outer" -command "ac3d select_outer_vertices" -underline 0
    .selectverticessmenu add command -label "Whole Surfaces" -command "ac3d select_part_selected_surfaces" -underline 0

    add_menu_balloons .mbar.edit.menu.selectverticessmenu { \
		"from the current selection, select only vertices that are on boundary edges" \
		"select only the outermost vertices of the current selection" \
		"select any whole surfaces that are already part selected"\
		}
		
	.mbar.edit.menu add cascade -label "Select Surfaces" -menu .selectsurfacesmenu -underline 0

    menu .selectsurfacesmenu -tearoff 0
    .selectsurfacesmenu add command -label "connected" -command "ac3d select_surfaces_connected"
    .selectsurfacesmenu add command -label "non-planar" -command "ac3d select_surfaces_by_type nonplanar"
	.selectsurfacesmenu add command -label "planar" -command "ac3d select_surfaces_by_type planar"
	.selectsurfacesmenu add command -label "triangle" -command "ac3d select_surfaces_by_type triangle"
	.selectsurfacesmenu add command -label "quad" -command "ac3d select_surfaces_by_type quad"
    .selectsurfacesmenu add command -label "invalid poly" -command "ac3d select_surfaces_by_type invalidpoly"
    .selectsurfacesmenu add command -label "> 4 vertices" -command "ac3d select_surfaces_by_type morethan4vertices"
    .selectsurfacesmenu add command -label "with bad triangulation" -command "ac3d select_surfaces_by_type badtriangulation"


    add_menu_balloons .mbar.edit.menu.selectsurfacesmenu { \
		"select connected surfaces" \
		"select non-planar surfaces" \
		"select planar surfaces" \
		"select triangles" \
		"select quads (four vertices)" \
		"select polys with 1 or 2 vertices" \
		"select polys with > 4 vertices" \
		"select polygons that failed to triangulate (marked with red outline, usually with edges crossing)" \
		}

    .mbar.edit.menu add command -label "Select Loop" -command "ac3d select_loop" -underline 7 -accelerator [accel l]

    .mbar.edit.menu add command -label "Select/Unselect Objects by Name..." -command "dialog_select_by_name"  -underline 19
    
    .mbar.edit.menu add separator
    .mbar.edit.menu add command -label "Group" -command "ac3d group"  -underline 0
    .mbar.edit.menu add command -label "Ungroup" -command "ac3d ungroup"  -underline 3



    .mbar.edit.menu add separator
    .mbar.edit.menu add command -label "Delete" -command "ac3d delete" -accelerator [accel Delete ]

	if { $tcl_platform(platform) == "windows" } {
		.mbar.edit.menu add separator
		.mbar.edit.menu add command -label "Copy 3D View to Windows Clipboard" -command "update; ac3d copy_3d_win_to_clipboard"
	}

	if { $ac_platform == "Mac" } {
		.mbar.edit.menu add separator
		.mbar.edit.menu add command -label "Copy 3D View to Mac Clipboard" -command "update; ac3d copy_3d_win_to_clipboard"
	}

    add_menu_balloons .mbar.edit.menu { \
        "undo this operation" \
		"redo what was undone (also Ctrl+Shift+Z)" \
        "" \
        "cut selected to the AC3D clipboard" \
        "copy selected to the AC3D clipboard" \
        "paste the AC3D clipboard" \
        "make another copy of the selected" \
        "" \
        "select everything" \
        "clear the selection" \
		"select vertices according to some criteria" \
		"select surfaces according to some criteria" \
		"select a loop of vertices/surfaces" \
		"select or unselect objects by entering their names" \
        "" \
		"Group selected objects" \
		"Ungroup selected objects" \
		""\
	    "delete selected" \
		"" \
		"Copy the image in the 3D window to the Windows clipboard" }


# View menu
    menubutton .mbar.view -text "Views" -menu .mbar.view.menu -underline 0
    menu .mbar.view.menu -tearoff 0
	set UI(menu_view) .mbar.view.menu
#    .mbar.view.menu add command -label "Zoom in" -command "ac3d zoom_in" -accelerator [accel z] -underline 5
#    .mbar.view.menu add command -label "Zoom out" -command "ac3d zoom_out" -accelerator [accel x] -underline 5
    .mbar.view.menu add command -label "Fit All" -command "ac3d fit_all" -accelerator [accel Ctrl+Shift+F] -underline 4
    .mbar.view.menu add command -label "Fit Selection" -command "ac3d fit_selected_all" -accelerator [accel Control+F] -underline 0
    .mbar.view.menu add command -label "Look at Selection" -command "ac3d goto_selected_all" -accelerator [accel Ctrl+G] -underline 0
    .mbar.view.menu add separator
#	.mbar.view.menu add cascade -label "Background image" -menu .mbar.view.menu.bgimage -underline 0

    menu .mbar.view.menu.bgimage -tearoff 0
    .mbar.view.menu.bgimage add cascade -label "Set" -menu .mbar.view.menu.bgimage.set -underline 0
    .mbar.view.menu.bgimage add cascade -label "Clear" -menu .mbar.view.menu.bgimage.clear -underline 0




    menu .mbar.view.menu.bgimage.set -tearoff 0
    .mbar.view.menu.bgimage.set add command -label "top-left" -command "ac3d file_select_background_image 0"
    .mbar.view.menu.bgimage.set add command -label "top-right" -command "ac3d file_select_background_image 1"
    .mbar.view.menu.bgimage.set add command -label "bottom-left" -command "ac3d file_select_background_image 2"
    .mbar.view.menu.bgimage.set add command -label "bottom-right" -command "ac3d file_select_background_image 3"

	.mbar.view.menu.bgimage.set add command -label "All" -command "ac3d file_select_background_image -1"

    menu .mbar.view.menu.bgimage.clear -tearoff 0
    .mbar.view.menu.bgimage.clear add command -label "top-left" -command "ac3d clear_background_image 0"
    .mbar.view.menu.bgimage.clear add command -label "top-right" -command "ac3d clear_background_image 1"
    .mbar.view.menu.bgimage.clear add command -label "bottom-left" -command "ac3d clear_background_image 2"
    .mbar.view.menu.bgimage.clear add command -label "bottom-right" -command "ac3d clear_background_image 3"

    .mbar.view.menu.bgimage.clear add command -label "All" -command "ac3d clear_background_image -1"


#    .mbar.view.menu add separator
#    .mbar.view.menu add command -label "3D view to selection" -command "ac3d set_view_3d_selection"
#    .mbar.view.menu add command -label "3D view to cursor" -command "ac3d set_view_3d_cursor"
 #   .mbar.view.menu add command -label "3D view to origin" -command "ac3d set_view_3d_origin"
#    .mbar.view.menu add separator


    .mbar.view.menu add cascade -label "Realtime Mirror" -menu .mbar.view.menu.mirror -underline 0

    menu .mbar.view.menu.mirror -tearoff 0
	.mbar.view.menu.mirror add radiobutton -label "Off" -variable prefs_realtime_mirror -value 0 -command {set prefs_realtime_mirror 0 ; ac3d redraw_all} -underline 0
	.mbar.view.menu.mirror add radiobutton -label "X" -variable prefs_realtime_mirror -value 1 -command { set prefs_realtime_mirror 1 ;ac3d redraw_all} -underline 0
	.mbar.view.menu.mirror add radiobutton -label "Y" -variable prefs_realtime_mirror -value 2 -command {set prefs_realtime_mirror 2 ;ac3d redraw_all} -underline 0
	.mbar.view.menu.mirror add radiobutton -label "Z" -variable prefs_realtime_mirror -value 3 -command {set prefs_realtime_mirror 3 ;ac3d redraw_all} -underline 0


    .mbar.view.menu add separator

    .mbar.view.menu add checkbutton -label "Show View Controls" -variable prefs_show_view_controls -command reconfigure_view_controls -underline 0
    .mbar.view.menu add command -label "Configure Views..." -command "menu_configure_views"  -underline 0
    .mbar.view.menu add command -label "New View..." -command "make_additional_view"  -underline 0
	
    .mbar.view.menu add separator

    .mbar.view.menu add command -label "Reset All" -command "set prefs_realtime_mirror 0; ac3d reset_views; "  -underline 0



    add_menu_balloons .mbar.view.menu { \
        "set the views so that the selection fills the windows" \
		"set the views so that the whole model can be seen" \
        "centre the views around the centre of the selection" \
        "" \
		"mirror the model across the selected axis" \
		"" \
		"Switch display of the control bar displayed at the top of each view window" \
		"Configure the layout of the view windows" \
		"create a new view window" \

		"" \
        "reset the view centering, zoom levels and mirroring" }
        


# Object menu


    menubutton .mbar.object -text "Object" -menu .mbar.object.menu -underline 0

    menu .mbar.object.menu -tearoff 0
	set UI(menu_object) .mbar.object.menu    

	.mbar.object.menu add cascade -label "Texture" -menu .mbar.object.menu.texture -underline 0
	menu .mbar.object.menu.texture -tearoff 0
	.mbar.object.menu.texture add command -label "Set no texture" -command "ac3d set_no_texture"
	.mbar.object.menu.texture add command -label "Set texture repeat/offset..." -command "menu_edit_texture_repeats"
	.mbar.object.menu.texture add command -label "Load texture..." -command "ac3d file_select_texture"
	.mbar.object.menu add separator

	.mbar.object.menu add command -label "Revolve..." -command "menu_revolve" -underline 0
    .mbar.object.menu add cascade -label "Mirror" -menu .mbar.object.menu.mirror
    menu .mbar.object.menu.mirror -tearoff 0
    .mbar.object.menu.mirror add command -label "+X" -command "ac3d object_mirror 0"
    .mbar.object.menu.mirror add command -label "+Y" -command "ac3d object_mirror 1"
	.mbar.object.menu.mirror add command -label "+Z" -command "ac3d object_mirror 2"
	.mbar.object.menu.mirror add command -label " -X" -command "ac3d object_mirror 3"
	.mbar.object.menu.mirror add command -label " -Y" -command "ac3d object_mirror 4"
	.mbar.object.menu.mirror add command -label " -Z" -command "ac3d object_mirror 5"
	.mbar.object.menu.mirror add command -label "X axis" -command "ac3d object_mirror 6"
	.mbar.object.menu.mirror add command -label "Y axis" -command "ac3d object_mirror 7"
	.mbar.object.menu.mirror add command -label "Z axis" -command "ac3d object_mirror 8"

    .mbar.object.menu add cascade -label "Boolean" -menu .mbar.object.menu.boolean
    menu .mbar.object.menu.boolean -tearoff 0
    .mbar.object.menu.boolean add command -label "Subtract" -command "ac3d boolean subtract"
    .mbar.object.menu.boolean add command -label "Intersect" -command "ac3d boolean intersect"
    .mbar.object.menu.boolean add command -label "Union" -command "ac3d boolean union"
    .mbar.object.menu.boolean add command -label "Cut Away" -command "ac3d boolean cut"
    .mbar.object.menu.boolean add separator
    .mbar.object.menu.boolean add command -label "Knife" -command "ac3d boolean knife"
    .mbar.object.menu.boolean add command -label "Knife and Cut Away" -command "ac3d boolean knifecut"

   .mbar.object.menu add separator

    .mbar.object.menu add command -label "Optimize Vertices..." -command "ac3d optimize" -underline 9 -accelerator [accel Ctrl+Shift+V]
    .mbar.object.menu add command -label "Optimize Surfaces..." -command "ac3d optimize_surfaces" -underline 9 
	.mbar.object.menu add command -label "Reduce..." -command "menu_reduce"
	.mbar.object.menu add separator



    .mbar.object.menu add command -label "Subdivide +" -command "ac3d adjust_subdivision_level 1" -underline 1
    .mbar.object.menu add command -label "Subdivide -" -command "ac3d adjust_subdivision_level -1" -underline 2
    .mbar.object.menu add command -label "Commit Subdivision" -command "ac3d commit_subdivisions" -underline 0
 #   .mbar.object.menu add command -label "Clear subdivision" -command "ac3d adjust_subdivision_level -999" -underline 2 // not undoable
     
    .mbar.object.menu add separator

    .mbar.object.menu add command -label "Re-centre" -command "ac3d object_recentre ; ac3d redraw_orth" -underline 3
    .mbar.object.menu add command -label "Minimum-centre" -command "ac3d object_mincentre ; ac3d redraw_orth" -underline 0


    .mbar.object.menu add command -label "Fragment" -command "ac3d object_fragment ; ac3d redraw_all" -underline 0
    .mbar.object.menu add command -label "Merge" -command "ac3d object_merge ; ac3d redraw_all" -underline 1 -accelerator [accel Ctrl+Shift+M]
    .mbar.object.menu add command -label "Explode..." -command "menu_object_explode" -underline 0

    .mbar.object.menu add separator
    .mbar.object.menu add command -label "Extrude Along Path" -command "ac3d extrude_along_path" -underline 1



#    .mbar.object.menu add command -label "Define extrude path" -command "ac3d define_extrude_path" -underline 15


    add_menu_balloons .mbar.object.menu { \
		"handle object textures" \
		"" \
		"create a volume of revolution" \
		"add a mirror image of the geometry" \
		"Boolean operations" \
		"" \
        "remove duplicate vertices" \
        "remove duplicate surface and polygons with 1 or 2 vertices" \
		"reduce surfaces by removing least important vertices" \
		"" \
		"increase surface subdivision level" \
		"decrease surface subdivision level" \
		"subdivide the main object geometry to the subdivision level" \
		"" \
        "recalculate the centre of each object" \
        "calculate the minimum xyz coor and use this as the centre" \
		"put each surface into an individual object" \
        "put all selected surfaces into a single object" \
        "fragment and move each new surface in the direction it faces" 
		"" \
        "extrude defined path (select profile then shift-select path object)"  }
        

# Surface menu

    menubutton .mbar.surface -text "Surface" -menu .mbar.surface.menu -underline 0
    menu .mbar.surface.menu -tearoff 0
	set UI(menu_surface) .mbar.surface.menu    

    .mbar.surface.menu add command -label "Flip Normal" -command "ac3d surface_flip_normals" -underline 0 -accelerator [accel Ctrl+Shift+N]
    .mbar.surface.menu add command -label "Change Vertex Order" -command "ac3d surface_change_vertex_order" -accelerator [accel Ctrl+Shift+O]
	#-underline 14 -accelerator [accel Ctrl+Alt+O
    .mbar.surface.menu add separator
    .mbar.surface.menu add command -label "Flip Triangle Edge" -command "ac3d flip_edge" -underline 0 

#    .mbar.surface.menu add command -label "Remove triangle edge" -command "ac3d quad_from_triangle_pair" -underline 0 
    .mbar.surface.menu add separator

    .mbar.surface.menu add command -label "Divide" -command "ac3d surface_subdivide" -underline 0 -accelerator [accel Ctrl+Shift+D]
    .mbar.surface.menu add command -label "Combine" -command "ac3d combine_surfaces" -underline 0 -accelerator [accel c]
    .mbar.surface.menu add command -label "Flatten" -command "ac3d flatten_surfaces"

    .mbar.surface.menu add command -label "Spike..." -command "menu_spike" -underline 3
    .mbar.surface.menu add command -label "Indent..." -command menu_indent -underline 0 -accelerator [accel i]
    .mbar.surface.menu add command -label "Bevel..." -command menu_bevel -underline 0 -accelerator [accel b]
    .mbar.surface.menu add command -label "Make Hole" -command "ac3d surface_make_hole" -underline 5 -accelerator [accel Ctrl+Shift+H]
    .mbar.surface.menu add command -label "Triangulate" -command "ac3d surface_triangulate"  -underline 0 -accelerator [accel Ctrl+Shift+T]
    .mbar.surface.menu add command -label "Spline" -command "ac3d surface_spline" -underline 1
    .mbar.surface.menu add separator

    .mbar.surface.menu add command -label "Cut Away Object" -command "ac3d surface_create_object"  -underline 9 -accelerator [accel Ctrl+Shift+X]
    .mbar.surface.menu add command -label "Remove Surface Only" -command "ac3d removesurface" -underline 0 
#    .mbar.surface.menu add separator

 #   .mbar.surface.menu add cascade -label "Remap texture coords" -menu .mbar.surface.menu.remaptexture
    menu .mbar.surface.menu.remaptexture -tearoff 0
#define PROJFRONT (0)
#define PROJLEFT (1)
#define PROJTOP (2)
#define PROJBACK (3)
#define PROJRIGHT (4)
#define PROJBOTTOM (5)
#define PROJ3D (6)
    .mbar.surface.menu.remaptexture add command -label "XY (Front)" -command "ac3d remap_textures 0" -underline 4
    .mbar.surface.menu.remaptexture add command -label "ZY (Side)" -command "ac3d remap_textures 1" -underline 4
    .mbar.surface.menu.remaptexture add command -label "XZ (Plan)" -command "ac3d remap_textures 2" -underline 4
    .mbar.surface.menu.remaptexture add command -label "Spherical" -command "ac3d remap_textures 6" -underline 1

    .mbar.surface.menu add separator
    .mbar.surface.menu add command -label "Calculate Surface Area..." -command "ac3d calc_surface_area"  -underline 18




    add_menu_balloons .mbar.surface.menu { \
        "reverse the order of the vertices so that the normal is flipped" \
        "put the first vertex to the end of the surface" \
		"" \
		"flip the edge of two adjacent triangles" \
        "" \
		"split quads into 4 smaller surfaces, triangles into 3" \
		"combine two or more surfaces together to make one surfaces" \
		"move vertices so they lie on a plane" \
        "create a spike on each quad/triangle" \
		"create new surfaces aroundthe inside of each selected surface (flat bevel)"
        "create a beveled surface by creating more surfaces" \
		"make a hole in each selected surface" \
        "divide polygons into triangles" \
		"interpolate points between the current vertices" \
        "" \
		"take selected surfaces and put them into a new object" \
		"remove selected surfaces, leave the vertices"\
        "" \
		"calculate the total surface area of all selected polygons"\
		}




# Vertex menu
    menubutton .mbar.vertex -text "Vertex" -menu .mbar.vertex.menu -underline 5
    menu .mbar.vertex.menu -tearoff 0
	set UI(menu_vertex) .mbar.vertex.menu

   .mbar.vertex.menu add command -label "Snap Together" -command "ac3d snaptogether"  -underline 0 -accelerator [accel Ctrl+T]
    .mbar.vertex.menu add command -label "Snap Together by Distance..." -command "menu_snap_together_distance"
    .mbar.vertex.menu add command -label "Snap to Grid" -command "ac3d snaptogrid" -underline 8
    .mbar.vertex.menu add command -label "Snap Objects by Vertices" -command "ac3d object_snap_together_by_vertices" -underline 16
#    .mbar.vertex.menu add command -label "Snap Object Vertex Pairs" -command "ac3d snap_object_vertex_pairs" -underline 19
    .mbar.vertex.menu add separator

	.mbar.vertex.menu add command -label "Smooth Shape" -command "ac3d smooth_vertices"
    .mbar.vertex.menu add separator

    .mbar.vertex.menu add cascade -label "Align to Axis" -menu .mbar.vertex.menu.alignaxis
    menu .mbar.vertex.menu.alignaxis -tearoff 0
    .mbar.vertex.menu.alignaxis add command -label "X" -command "ac3d align_vertices_to_axis 0" -underline 0
    .mbar.vertex.menu.alignaxis add command -label "Y" -command "ac3d align_vertices_to_axis 1" -underline 0
    .mbar.vertex.menu.alignaxis add command -label "Z" -command "ac3d align_vertices_to_axis 2" -underline 0

    .mbar.vertex.menu add separator
    .mbar.vertex.menu add command -label "Weld" -command "ac3d weld_vertices" -underline 0 
    .mbar.vertex.menu add command -label "Unweld" -command "ac3d unshare_vertices" -underline 0 
    .mbar.vertex.menu add command -label "Insert Vertex" -command "ac3d insert_vertex" -underline 0 -accelerator [accel Ctrl+Shift+I]

    .mbar.vertex.menu add command -label "Divide Triangle Edge" -command "ac3d divide_edge" -underline 0 
    .mbar.vertex.menu add command -label "Extrude Edges" -command "ac3d extrude_edges" -underline 0 -accelerator [accel Ctrl+e]

	.mbar.vertex.menu add command -label "Slice Surface" -command "ac3d surface_slice" -underline 0 -accelerator [accel Ctrl+Shift+L]

	    .mbar.vertex.menu add separator

    .mbar.vertex.menu add command -label "Create Convex Surface/Object" -command "ac3d convexhull" -underline 0
    .mbar.vertex.menu add command -label "Create Ordered Surface" -command "ac3d createsurface" -underline 7 -accelerator [accel Ctrl+Shift+S]
	.mbar.vertex.menu add command -label "Create Quad" -command "ac3d create_quad" -underline 7 -accelerator [accel Ctrl+r]

    .mbar.vertex.menu add cascade -label "Create 2D Mesh" -menu .mbar.vertex.menu.createmesh

    menu .mbar.vertex.menu.createmesh -tearoff 0
    .mbar.vertex.menu.createmesh add command -label "XY (Front)" -command "ac3d delaunay 0" -underline 4
    .mbar.vertex.menu.createmesh add command -label "ZY (Side)" -command "ac3d delaunay 1" -underline 4
    .mbar.vertex.menu.createmesh add command -label "XZ (Plan)" -command "ac3d delaunay 2" -underline 4






    add_menu_balloons .mbar.vertex.menu { \
        "move selected vertices to the same point" \
		"move vertices together that are within a specified distance" \
        "move selected vertices to the nearest grid point" \
        "move one object to another so that the two selected vertices match position" \
		"" \
		"move the selected vertices so the overall shape is smoothed" \
		"" \
		"move all vertices to zero on the specified axis" \
		"" \
		"remove duplicate vertices that are at the same position" \
		"add new vertices so that each surface references a unique vertex" \
        "insert a new vertex between each pair of selected vertices" \
		"insert a new vertex and split the surface at that point" \
		"from two vertices, extrude an edge to create a new surface" \
		"split a surface into two, across two vertices" \
        "" \
		"make a new object with surfaces spanning selected vertices" \
		"create a single surface using vertices in order selected" \
		"from three vertices, create a new vertex and a quad surface" \
		"create a 2D (triangle) mesh from the selected vertices" }





# 3D menu

    menubutton .mbar.3d -text "3D" -menu .mbar.3d.menu -underline 0
    menu .mbar.3d.menu -tearoff 0
	set UI(menu_3d) .mbar.3d.menu

.mbar.3d.menu add checkbutton -label "Wireframe" -variable prefs_view3dmode -command "ac3d redraw_3d" -underline 0 -accelerator [accel w]
    .mbar.3d.menu add checkbutton -label "Texture" -variable prefs_view3dtextures -command "ac3d redraw_3d" -underline 0 -accelerator [accel t]
    .mbar.3d.menu add checkbutton -label "Vertices" -variable prefs_show_vertices_3d -command "ac3d redraw_3d" -underline 0
    .mbar.3d.menu add checkbutton -label "Surfaces" -variable prefs_show_surfaces_3d -command "ac3d redraw_3d" -underline 0
    .mbar.3d.menu add checkbutton -label "Headlight" -variable prefs_headlight -command "ac3d redraw_3d" -underline 4
    .mbar.3d.menu add checkbutton -label "Normals" -variable prefs_show_3d_normals -command "ac3d redraw_3d" -underline 0 -accelerator [accel n]
    .mbar.3d.menu add checkbutton -label "Grid" -variable prefs_grid3d_show -command "ac3d redraw_3d" -underline 0 -accelerator [accel g]
    .mbar.3d.menu add checkbutton -label "Subdivisions" -variable prefs_preview_subdivisions_3d -command "ac3d redraw_3d" -underline 3 -accelerator [accel d]
    .mbar.3d.menu add separator

    .mbar.3d.menu add checkbutton -label "Interactive Wireframe" -variable prefs_wireframe_move -underline 0 
    .mbar.3d.menu add separator

    .mbar.3d.menu add checkbutton -label "Show Axis" -variable prefs_show_axis -command "ac3d redraw_3d" -underline 0
    .mbar.3d.menu add checkbutton -label "Show Hidden Objects" -variable prefs_show_hidden_3d -command "ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add checkbutton -label "Show Locked Objects" -variable prefs_show_locked_3d -command "ac3d redraw_3d" -underline 0 

    .mbar.3d.menu add checkbutton -label "Show Subdivision Originals" -variable prefs_show_proxy_subdivisions_3d -command "ac3d redraw_3d" -underline 0 

#    .mbar.3d.menu add separator

#    .mbar.3d.menu add radiobutton -label "Spin" -variable person_walk_vehicle -value 0 -command {ac3d set_spin_viewer ; ac3d redraw_3d} -underline 0 -accelerator [accel 1]
#    .mbar.3d.menu add radiobutton -label "Walk" -variable person_walk_vehicle -value 1 -command {ac3d set_walk_viewer ; ac3d redraw_3d} -underline 3 -accelerator [accel 2]
#    .mbar.3d.menu add separator
#    .mbar.3d.menu add command -label "FOV..." -command "dialog_FOV" -underline 2

    add_menu_balloons .mbar.3d.menu { \
        "view filled or wireframe polygons?" \
        "view textures?" \
		"view vertices (in vertex mode)"\
		"outline surfaces (when not in vertex mode)"\
        "switch on the viewing light?" \
        "show surface normals?" \
		"view the 3D grid?" \
		"preview any subdivided objects?" \
		"" \
        "display model in wireframe when dragging the mouse?" \
        "" \
        "view the axis guide?" \
        "show hidden objects?" \
        "show locked objects?" 
		"show the original surfaces and vertices from subdivided objects" 
#        "" 
 #       "select spin view mode - mouse and cursor keys spin the model" \
  #      "select walk view mode - cursor keys (with alt/ctrl) move view point" \
   #     "" \
    #    "adjust the field-of-view"
	}



# Orth menu

    menubutton .mbar.orth -text "Orth" -menu .mbar.orth.menu -underline 0
    menu .mbar.orth.menu -tearoff 0
	set UI(menu_orth) .mbar.orth.menu

#adding accelerators to menu checkbuttons or radio buttons causes problems on the MAC

    .mbar.orth.menu add checkbutton -label "Wireframe" -variable prefs_filled_orth -onvalue 0 -offvalue 1 -command "ac3d redraw_orth" -underline 0 -accelerator [accel w]
#not mac! -accelerator [accel w
    .mbar.orth.menu add checkbutton -label "Texture" -variable prefs_orth_textures -command "ac3d redraw_orth" -underline 0 -accelerator [accel t]
#not mac  -accelerator [accel t
    .mbar.orth.menu add checkbutton -label "Vertices" -variable prefs_show_vertices -command "ac3d redraw_orth" -underline 0 
    .mbar.orth.menu add checkbutton -label "Surfaces" -variable prefs_show_surfaces -command "ac3d redraw_orth" -underline 0
    .mbar.orth.menu add checkbutton -label "Headlight" -variable prefs_orth_headlight -command "ac3d redraw_orth" -underline 4
    .mbar.orth.menu add checkbutton -label "Normals" -variable prefs_show_normals_orth -command "ac3d redraw_orth" -underline 0 -accelerator [accel n]
    .mbar.orth.menu add checkbutton -label "Grid" -variable prefs_show_drawgrid -command "ac3d redraw_orth" -underline 0 -accelerator [accel g]
    .mbar.orth.menu add checkbutton -label "Subdivisions" -variable prefs_preview_subdivisions_orth -command "ac3d redraw_orth" -underline 3 -accelerator [accel d]

    .mbar.orth.menu add separator
    .mbar.orth.menu add checkbutton -label "Interactive Wireframe" -variable prefs_move_wireframe_orth -underline 0 

    .mbar.orth.menu add separator
	.mbar.orth.menu add checkbutton -label "Show Axis Guides" -variable prefs_show_orth_axis -command "ac3d redraw_orth" -underline 0

    .mbar.orth.menu add checkbutton -label "Col Wireframe" -variable prefs_use_rgb_for_orth -command "ac3d redraw_orth" -underline 0 
    .mbar.orth.menu add separator
    .mbar.orth.menu add checkbutton -label "Object Centres" -variable prefs_show_objectcentres -command "ac3d redraw_orth" -underline 0 
#    .mbar.orth.menu add checkbutton -label "Selected Vertices" -variable prefs_show_selected_vertices -command "ac3d redraw_orth" -underline 0 
    .mbar.orth.menu add checkbutton -label "Show Subdivision Originals" -variable prefs_show_proxy_subdivisions_orth -command "ac3d redraw_orth" -underline 0 


    add_menu_balloons .mbar.orth.menu { \
        "view the orth model as wireframe or filled?" \
        "view textures on filled polygons?" \
		"show selectable vertices?" \
		"show selectable surface?" \
        "use viewing light?" \
		"show surface normals?" \
        "show the grid?" \
		"preview any subdivided objects?" \
        "" \
        "switch to wireframe when dragging/scaling view?" \
		"" \
		"Display the axis guides?" \
        "use actual surface cols in wireframe?" \
        "" \
        "show object centres?" \
        "show original objects for subdivisions?"\
        }






# tools menu
    menubutton .mbar.tools -text "Tools" -menu .mbar.tools.menu -underline 0
    menu .mbar.tools.menu -tearoff 0
	set UI(menu_tools) .mbar.tools.menu

    if { $ac_platform == "SGI" } {
        .mbar.tools.menu add command -label "Go Stereo" -command "tools_stereo" -underline 4
        }

    .mbar.tools.menu add command -label "Model Info..." -command "menu_info" -underline 6 -accelerator [accel F6]
    .mbar.tools.menu add command -label "Render..." -command "menu_render" -underline 0 -accelerator [accel F7]
    .mbar.tools.menu add command -label "Hierarchy View..." -command "menu_hier" -underline 0 -accelerator [accel F8]
    .mbar.tools.menu add command -label "Object Property Editor..." -command "edit_dive_data" -underline 7 -accelerator [accel F9]
    .mbar.tools.menu add command -label "Texture Coordinate Editor..." -command "menu_uveditor" -underline 0 -accelerator [accel F10]
    .mbar.tools.menu add command -label "Replicator..." -command "menu_replicator" -underline 0 -accelerator [accel F11]
    .mbar.tools.menu add command -label "Create 2D/3D Text..." -command "ttfont_dialog" -underline 0 -accelerator [accel F12]

    .mbar.tools.menu add command -label "Align Objects..." -command menu_align_objects
    .mbar.tools.menu add command -label "Position 3D Cursor..." -command "menu_position_cursor" -underline 4

    .mbar.tools.menu add separator
#    .mbar.tools.menu add command -label "Add simple text..." -command "dialog_addtext" -underline 4


#    .mbar.tools.menu add command -label "TEST" -command "ac3d test"


    add_menu_balloons .mbar.tools.menu { \
        "display information about the current model" \
        "render the current model in an external renderer" \
        "display the model tree" \
        "edit object specific data" \
		"start the texture coordinate editor" \
        "replicate geometry" \
		"create text from a truetype font file" \
		"align objects" \
		"position the 3d cursor" \
		"" \
        
	}



proc start_web_browser_file { file } {
global AC3D_HOME

	set full [ file join $AC3D_HOME $file ]
	set fullfile "file://$full"

	ac3d start_web_browser "$fullfile"
}



# HELP menu
    menubutton .mbar.help -text "Help" -menu .mbar.help.menu -underline 0    

    menu .mbar.help.menu -tearoff 0
	.mbar.help.menu add command -label "Manual..." -underline 0 -command "start_web_browser_file manual/index.htm"
    .mbar.help.menu add separator

    .mbar.help.menu add command -label "About AC3D..." -command "ac3d menu_about" -underline 0
    .mbar.help.menu add command -label "About Importers..." -command "menu_about_importers" -underline 1
    .mbar.help.menu add command -label "About Exporters..." -command "menu_about_exporters" -underline 1
    .mbar.help.menu add command -label "About Plugins..." -command "menu_about_plugins" -underline 6
    .mbar.help.menu add command -label "Online Homepage..." -underline 7 -command "ac3d start_web_browser http://www.inivis.com"
	.mbar.help.menu add command -label "Online Forum..." -underline 7 -command "ac3d start_web_browser http://www.inivis.com/forum"
    .mbar.help.menu add separator
    .mbar.help.menu add command -label "Credits..." -command "ac3d menu_credits" -underline 0
	.mbar.help.menu add separator

#    .mbar.help.menu add command -label "Check for updates..." -underline 5 -command menu_check_for_updates
#    .mbar.help.menu add separator

	if { [ac3d get_app_mode] != 2 } {
		.mbar.help.menu add command -label "Enter License Key..." -command menu_register -underline 0
	} else {
		.mbar.help.menu add command -label "Upgrade License..." -command menu_register -underline 0
	}

    add_menu_balloons .mbar.help.menu { 
		"View the AC3D manual" \
		"" \
		"Information about AC3D" \
		"info on file importers" \
		"info on file exporters" \
		"plugin information" \
		"start up a web browser with the AC3D home page" \
		"start web browser and goto the AC3D community forum" \
		"" \
		"Credits" \
		"" \
		"enter your registration key to fully enable/upgrade AC3D" \
		"" \
		}




# MAC APPLE MENU
	if { $ac_platform == "Mac" } {
		menu .mbar.apple -tearoff 0
		set UI(menu_apple) .mbar.apple.menu
		.mbar.apple add command -label "About AC3D..." -command "ac3d menu_about" -underline 0
	}



# pack the menus into the menubar

    if { $tcl_version >= 8 } {
	    set m .mbar
#		menu $m -tearoff 0 -type toplevel

		if { $ac_platform == "Mac" } {
			$m add cascade -menu .mbar.apple -label "AC3D" -underline 0
		}

		$m add cascade -menu .mbar.file -label "File" -underline 0
		$m add cascade -menu .mbar.edit.menu -label "Edit" -underline 0
		$m add cascade -menu .mbar.view.menu -label "Views" -underline 0
		$m add cascade -menu .mbar.object.menu -label "Object" -underline 0
		$m add cascade -menu .mbar.surface.menu -label "Surface" -underline 0
		$m add cascade -menu .mbar.vertex.menu -label "Vertex" -underline 5
		$m add cascade -menu .mbar.orth.menu -label "Orth" -underline 0
		$m add cascade -menu .mbar.3d.menu -label "3D" -underline 0
		$m add cascade -menu .mbar.tools.menu -label "Tools" -underline 0
		$m add cascade -menu .mbar.help.menu -label "Help " -underline 0
# 18th Dec 2007 - added a space after the Help label to prevent the search menu appearing

		. configure -menu .mbar -bd 1

#        pack .mbar.file .mbar.edit  .mbar.view .mbar.object .mbar.surface .mbar.vertex .mbar.orth .mbar.3d .mbar.tools -side left
#        pack .mbar.help -side right


    } else {    
        pack .mbar.file .mbar.edit .mbar.view .mbar.object .mbar.surface .mbar.vertex .mbar.orth .mbar.3d .mbar.tools -side left
        pack .mbar.help -side right
    }



proc make_coorwindow { w { menu ""} } {

#    if {[winfo exists .coorwindow]} { destroy .coorwindow }

    frame $w.message_frame 
    # -bd 2 -relief groove
    label $w.message_frame.select_mode_info -text "objects/vert selected" -textvariable select_info  -padx 0 -pady 0
    label $w.message_frame.display_line_coors -text "" -textvariable coors -padx 0 -pady 0
    label $w.message_frame.display_line_size -text "" -textvariable size -padx 0 -pady 0

#    pack $w.message_frame.select_mode_info $w.message_frame.display_line_coors $w.message_frame.display_line_size  -in $w.message_frame -side left -fill x
grid  $w.message_frame.select_mode_info -row 0 -column 0  -sticky we
grid  $w.message_frame.display_line_coors -row 0 -column 1 -sticky we
grid  $w.message_frame.display_line_size -row 0 -column 2 -sticky we
grid columnconfigure $w.message_frame 0 -weight 1 -uniform 1
grid columnconfigure $w.message_frame 1 -weight 1 -uniform 1
grid columnconfigure $w.message_frame 2 -weight 1 -uniform 1

label $w.dummy -text " "

#    pack $w.message_frame -in $w -side left -fill x -expand 1 -padx 3
grid $w.message_frame -row 0 -column 0 -sticky we
#grid $w.dummy -row 0 -column 1 -sticky w

grid columnconfigure $w 0 -weight 1 -uniform 1
#grid columnconfigure $w 1 -weight 1 -uniform 1

	if { $menu != "" } {
	    bind $w.message_frame.select_mode_info <3> " tk_popup $menu %X %Y "
		bind $w.message_frame.display_line_coors <3> " tk_popup $menu %X %Y "
		bind $w.message_frame.display_line_size <3> " tk_popup $menu %X %Y "
	}
}


proc coormenu_sep { w } {
global cp

    destroy $w
    new_toplevel .coorwindow "Info"

    if ([winfo exists .coormenu]) {
        destroy .coormenu
    }
    menu .coormenu -tearoff false 
    .coormenu add command -label "put back" -command "destroy .coorwindow; coorwindow_add_to_cp"
    make_coorwindow .coorwindow .coormenu
}

proc coorwindow_add_to_cp { } {
global cp

    if ([winfo exists .coormenu]) {
        destroy .coormenu
    }

    menu .coormenu -tearoff false 
    .coormenu add command -label "Separate coord window" -command "coormenu_sep $cp.message_frame"

    make_coorwindow $cp .coormenu
}




proc update_object_detail_canvas { } {
global object_detail_canvas

	# update is important, so we get the real size of the widgets to resize the canvas
#	update idletasks

	# resize the canvas
	set b [$object_detail_canvas bbox all]
	$object_detail_canvas configure -scrollregion $b


}






proc add_tool_mode_button { win  text command variable toolname helptext { keepdownable false} { bitmapname "" } } {

    set b [mode_button $win  $text $command $variable "$toolname" $helptext $keepdownable ]

#return $b
######## remove the return for icons

	if { $bitmapname != ""} {
		image create photo $toolname -file tcl/images/$bitmapname
		$b configure -width 36 -image $toolname
#	} else {
#		image create photo default -file tcl/images/sphere.png
#		$b configure -width 48 -height 48 -image default
#	}


	return $b
#	pack $b -side left
		
}






# main control panel



proc make_control_panel { } {
global drag_mode draw_mode cp object_detail_frame undo_string
global UI object_detail_canvas ac_platform cp cp2 uilayout

	set w $cp

#    coorwindow_add_to_cp

make_coorwindow $UI(infobar)





#select mode

    set select_mode_frame [ labelframe $cp.select_mode_frame -text "Select"]
    # set select_mode_frame [ labelframe $cp.select_mode_frame -text "Select"  -pady 1 -padx 1]
    set UI(select_mode_tree) [add_tool_mode_button $select_mode_frame.select_mode_tree  " Group "  "ac3d set_select_mode  0; ac3d redraw_all" select_mode tree "Group - Select/manipulate\ngroups and objects" false group.png]
    set UI(select_mode_object) [add_tool_mode_button $select_mode_frame.select_mode_object  " Object "  "ac3d set_select_mode  1 ; ac3d redraw_all" select_mode object "Object - Select/manipulate\nwhole objects (key o)" false object.png]
    set UI(select_mode_surface) [add_tool_mode_button $select_mode_frame.select_mode_surface  " Surface "  "ac3d set_select_mode  2 ; ac3d redraw_all"  select_mode surface "Surface - Select/manipulate individual\nsurfaces (key s)" false surface.png]
    set UI(select_mode_vertex) [add_tool_mode_button $select_mode_frame.select_mode_vertex  " Vertex "  "ac3d set_select_mode  3 ; ac3d redraw_all"  select_mode vertex "Vertex - Select/manipulate individual\nvertices (key v)" false vertex.png]

	if { $uilayout == "vertical" } {
		pack $UI(select_mode_tree) $UI(select_mode_object) $UI(select_mode_surface) $UI(select_mode_vertex) -side top \
			-fill x -expand 1
	} else {			
		grid $UI(select_mode_tree) -row 0 -column 0 -sticky we
		grid $UI(select_mode_object) -row 0 -column 1 -sticky we
		grid $UI(select_mode_surface) -row 0 -column 2 -sticky we
		grid $UI(select_mode_vertex) -row 0 -column 3 -sticky we
	}
	
	pack $select_mode_frame -side top


    set drag_mode move


    set modeframe [labelframe $cp.draw_mode_frame -text "Mode" ]
#    set modeframe [labelframe $cp.draw_mode_frame -text "Mode" -pady 1 -padx 1 ]

#[ section_frame $cp2.draw_mode_frame Mode ]

    add_tool_mode_button $modeframe.drag_mode_move  "MoveSize"  "ac3d set_draw_mode  move" draw_mode move "Move/Size - Left mouse button will select/drag selection, handles resize (key = m)" false movesize.png
    add_tool_mode_button $modeframe.drag_mode_rotate  "Rotate"  "ac3d set_draw_mode  rotate" draw_mode rotate "Rotate - Left mouse button will select/rotate\nselection about mouse pos (key = r)" false rotate.png
    add_tool_mode_button $modeframe.drag_mode_extrude  "Extrude"  "ac3d set_draw_mode  extrude" draw_mode extrude "Extrude - Left mouse button will select/extrude selected surfaces to release point (key = e)" false extrude.png
    set UI(extrude_button) $modeframe.drag_mode_extrude

    add_tool_mode_button $modeframe.draw_mode_polygon  "Poly"  "ac3d set_draw_mode  polygon"  draw_mode polygon "Polygon - Draw a polygon\n (Click left mouse button for each vertex,\n right or middle button to finish)" true polygon.png
    add_tool_mode_button $modeframe.draw_mode_polyline  "Polyline"  "ac3d set_draw_mode  polyline"  draw_mode polyline "Polyline - Draw a polygon outline\n (Click left mouse button for each vertex,\n right or middle button to finish)" true polyline.png
    add_tool_mode_button $modeframe.draw_mode_line "Line"   "ac3d set_draw_mode  line"  draw_mode line "Line - Draw a line\n (Click left mouse button for each vertex,\n right or middle button to finish)" true line.png
    add_tool_mode_button $modeframe.draw_mode_rect  " Rect "  "ac3d set_draw_mode  rect"  draw_mode rect "Rect - Draw a rectangle" true rect.png
    add_tool_mode_button $modeframe.draw_mode_circle  "Ellipse"  "ac3d set_draw_mode  circle"  draw_mode circle "Ellipse - Draw an circle/ellipse" true ellipse.png
    add_tool_mode_button $modeframe.draw_mode_disk  "Disk"  "ac3d set_draw_mode  disk"  draw_mode disk "Disk - Draw a disk" true disk.png
    add_tool_mode_button $modeframe.draw_mode_cube  "Box"  "ac3d set_draw_mode  box"  draw_mode box  "Box - Draw a cuboid" true box.png
    add_tool_mode_button $modeframe.draw_mode_sphere  "Sphere"  "ac3d set_draw_mode  sphere" draw_mode sphere "Sphere - Draw a sphere" true sphere.png
    add_tool_mode_button $modeframe.draw_mode_cone  "Cylinder"  "ac3d set_draw_mode  cylinder"  draw_mode cylinder "Cylinder - Draw a cylinder" true cylinder.png
    add_tool_mode_button $modeframe.draw_mode_mesh  "Mesh"  "ac3d set_draw_mode  mesh"  draw_mode mesh "Mesh - Draw a mesh" true mesh.png
    add_tool_mode_button $modeframe.draw_mode_block  "Block"  "ac3d set_draw_mode  block"  draw_mode block "Block - Draw a block object" true "block.png"
    add_tool_mode_button $modeframe.draw_mode_light  "Light"  "ac3d set_draw_mode  light"  draw_mode light "Light - Click to position a new light" true light.png

	label $modeframe.s1 -text " " -height 1
	label $modeframe.s2 -text " " -height 1



if {$uilayout == "vertical"} {
	pack $modeframe.drag_mode_move  $modeframe.drag_mode_rotate $modeframe.drag_mode_extrude $modeframe.drag_mode_extrude \
	  $modeframe.s1\
	$modeframe.draw_mode_polygon $modeframe.draw_mode_polyline $modeframe.draw_mode_line \
	$modeframe.s2 \
	$modeframe.draw_mode_rect $modeframe.draw_mode_circle $modeframe.draw_mode_disk \
	$modeframe.draw_mode_cube $modeframe.draw_mode_sphere $modeframe.draw_mode_cone $modeframe.draw_mode_mesh \
	$modeframe.draw_mode_light -side top
}



if {$uilayout != "vertical"} {
    grid $modeframe.drag_mode_move  -row 0 -column 0 -sticky we
    grid $modeframe.drag_mode_rotate  -row 0 -column 1 -sticky we
    grid $modeframe.drag_mode_extrude  -row 0 -column 2 -sticky we
    grid $modeframe.draw_mode_polygon  -row 2 -column 0 -sticky we
    grid $modeframe.draw_mode_polyline -row 2 -column 1 -sticky we 
    grid $modeframe.draw_mode_line  -row 2 -column 2 -sticky we
    grid $modeframe.draw_mode_circle -row 4 -column 0 -sticky we
    grid $modeframe.draw_mode_disk  -row 4 -column 1 -sticky we
    grid $modeframe.draw_mode_rect -row 4 -column 2 -sticky we
    grid $modeframe.draw_mode_mesh -row 5 -column 0 -sticky we
    grid $modeframe.draw_mode_block -row 5 -column 1 -sticky we
    grid $modeframe.draw_mode_cube -row 5 -column 2 -sticky we
    grid $modeframe.draw_mode_cone -row 6 -column 0 -sticky we
    grid $modeframe.draw_mode_sphere -row 6 -column 1 -sticky we
    grid $modeframe.draw_mode_light -row 6 -column 2 -sticky we

	grid columnconfigure $modeframe 0 -weight 1
	grid columnconfigure $modeframe 1 -weight 1
	grid columnconfigure $modeframe 2 -weight 1
	grid rowconfigure $modeframe 0 -pad 8
}

	pack $modeframe -side top -fill x -pady 2
	
	

trace variable draw_mode w draw_mode_changed

if { $uilayout == "vertical" } {
	new_toplevel .test "Misc"
	set w .test

}
	# OBJECT DETAIL FRAME
	set object_detail_outer [frame $w.fr -bd 0]

	set canvas [canvas $object_detail_outer.canvas -width 100 -height 50 \
	 -scrollregion { 0 0 1 1} \
		-yscrollcommand "$object_detail_outer.yscroll set" ]

	set sb [ttk::scrollbar $object_detail_outer.yscroll -orient vertical -command "$object_detail_outer.canvas yview" ]

# in Linux we can make the scrollbar narrower
#if { $ac_platform == "Linux" } { $sb configure -width 8 }

	pack $sb -fill y -side right

	pack $canvas -fill both -expand 1

	set object_detail_frame  [frame $object_detail_outer.canvas.f -bd 0 -width 200]
	$canvas create window 0 0 -anchor nw -window $object_detail_frame

	set object_detail_canvas $canvas

	bind $object_detail_frame <Configure> {update_object_detail_canvas }

	set UI(object_detail_frame) $object_detail_frame


    set undo_string "Undo"
	


# VISIBILTY
	# HIDE/LOCK
    set hide_frame [section_frame $w.select_hide_frame Visibility ]
	set hide_label [label $hide_frame.hide_label -text "Hide:"]
    set UI(hide_selected) [cbutton $hide_frame.hide_selected " Sel " "ac3d hide_selected" "Hide selected objects from the display"]
    set UI(hide_unselected) [cbutton $hide_frame.hide_unselected " Unsel " "ac3d hide_unselected" "Hide objects not selected"]
    set UI(unhide) [cbutton $hide_frame.unhide " None " "ac3d unhide" "Restore hidden objects"]

	grid $hide_label  -row 0 -column 0 -sticky w
	grid $UI(hide_selected)  -row 0 -column 1 -sticky w
	grid $UI(hide_unselected)  -row 0 -column 2 -sticky w
	grid $UI(unhide) -row 0 -column 3 -sticky w

	set lock_label [label $hide_frame.lock_label -text "Lock:"]
    set UI(lock_selected) [cbutton $hide_frame.lock_selected " Sel " "ac3d lock_selected" "lock selected objects"]
    set UI(lock_unselected) [cbutton $hide_frame.lock_unselected " Unsel " "ac3d lock_unselected" "lock objects not selected"]
    set UI(unlock) [cbutton $hide_frame.unlock " None " "ac3d unlock" "Unlock all objects"]

	grid $lock_label  -row 1 -column 0 -sticky w
	grid $UI(lock_selected)  -row 1 -column 1 -sticky w
	grid $UI(lock_unselected) -row 1 -column 2 -sticky w
	grid $UI(unlock) -row 1 -column 3 -sticky w


	# SURFACE TYPE
    set surface_frame [section_frame $w.surface_type_frame "Set Surface type"]
 
    set sf2 [frame $surface_frame.surface_type_frame2 -bg red]

    set UI(function_surface_poly) [cbutton $sf2.function_surface_poly  "Poly"  "ac3d set_surface_type 0"]
    add_balloon $sf2.function_surface_poly "Set selected surfaces to polygons"
    set UI(function_surface_polyline) [cbutton $sf2.function_surface_polyline  "Polyline"  "ac3d set_surface_type 1"]
    add_balloon $sf2.function_surface_polyline "Set selected surfaces to closed lines"
    set UI(function_surface_line) [cbutton $sf2.function_surface_line  "Line"  "ac3d set_surface_type 2"]
    add_balloon $sf2.function_surface_line "Set selected surfaces to lines"
    horiz_pack $sf2 $sf2.function_surface_poly $sf2.function_surface_polyline $sf2.function_surface_line

    set sf3 [frame $surface_frame.surface_type_frame3 ]
    set UI(function_surface_smooth) [ cbutton $sf3.function_surface_smooth "Smooth" "ac3d surface_set_shaded 1 "]
    add_balloon $sf3.function_surface_smooth "Set smooth-shaded surfaces"
    set UI(function_surface_flat) [cbutton $sf3.function_surface_flat "Flat" "ac3d surface_set_shaded 0 "]
    add_balloon $sf3.function_surface_flat "Set flat-shaded surfaces"
    set UI(function_surface_one_sided) [ cbutton $sf3.function_surface_one_sided "1S" "ac3d surface_set_twosided 0 "]
    add_balloon $sf3.function_surface_one_sided "Set single-sided surfaces"
    set UI(function_surface_two_sided) [cbutton $sf3.function_surface_two_sided "2S"  "ac3d surface_set_twosided 1"]
    add_balloon $sf3.function_surface_two_sided "Set double-sided surfaces"

    horiz_pack $sf3 \
        $sf3.function_surface_smooth $sf3.function_surface_flat $sf3.function_surface_one_sided $sf3.function_surface_two_sided

    vert_pack $surface_frame $sf2 $sf3





	# the palette
	make_palette $w.palette_frame


	# object name
    labelframe $w.other_frame3 -text "Object name"
    add_balloon $w.other_frame3 "Name of current object"


    set UI(current_object_name_entry) [entry $w.current_object_name_entry -relief sunken -bd 2 -textvariable current_object_name]
    bind $UI(current_object_name_entry) <KeyRelease> {
        ac3d set_current_object_name $current_object_name
        hier_update
        }

    pack $UI(current_object_name_entry)\
        -in $w.other_frame3 -side left -fill x -expand 1 -pady 3


	# PACK THE MAIN STUFF
    pack $object_detail_outer -side top -fill both -expand 1

    
    pack  $w.palette_frame $w.other_frame3 $w.surface_type_frame  $w.select_hide_frame \
	  -in $w -side bottom -fill x -expand 0

}


make_control_panel        



# in ac3dview.tcl:
make_views 



proc viewbutton {name label value } {
    radiobutton $name -text $label -command configure_views -value $value \
    -variable viewsetting -indicatoron false -highlightthickness 0
}



set toolbarbc 0

proc toolbar_add_button { label command help { icon "" } } {
global toolbarbc UI

    set b [cbutton $UI(toolbar).$toolbarbc $label $command]
    add_balloon $b $help
    
    if { $icon != ""} {
		image create photo photo$toolbarbc -file $icon
		$b configure -width [ image width photo$toolbarbc ] -height [ image height photo$toolbarbc ] -image photo$toolbarbc
	}
	
	pack $b -side left -padx 1 -pady 1

	incr toolbarbc
	return $b
}


proc toolbar_add_space { } {
global toolbarbc UI

    set l [label $UI(toolbar).$toolbarbc -text ""]
	pack $l -side left -padx 1 -pady 1

	incr toolbarbc
	return $l
}

proc toolbar_add_label { text } {
global toolbarbc UI

    set l [label $UI(toolbar).$toolbarbc -text $text]
	pack $l -side left -padx 1 -pady 1

	incr toolbarbc
	return $l
}


# put some most used functions in the toolbar

	source tcl/toolbar.tcl

    toolbar_add_space

    # render button
	set UI(renderbutton) [toolbar_add_button "Render..." {puts [do_render]} "Call tools->render directly"]


	# pack the render button now?
	if { $prefs_show_render_button } {
		pack $UI(renderbutton) -side left
	} else {
		pack forget $UI(renderbutton)
	}


image create photo viewtopleft -file "tcl/images/viewtopleft.png"
image create photo viewtopright -file "tcl/images/viewtopright.png"
image create photo viewbottomleft -file "tcl/images/viewbottomleft.png"
image create photo viewbottomright -file "tcl/images/viewbottomright.png"
image create photo viewall -file "tcl/images/viewall.png"
		
 

mode_button $UI(toolbar).all "ALL" configure_views viewsetting all "Tile all windows \[F5]" false "viewall"
mode_button $UI(toolbar).xyz "3" configure_views viewsetting xyz  "bottom-right view \[F4]" false "viewbottomright"
mode_button $UI(toolbar).xy "0" configure_views viewsetting xy "top-left view \[F1]" false "viewtopleft"
mode_button $UI(toolbar).zy "1" configure_views viewsetting zy "top-right view \[F2]" false "viewtopright"
mode_button $UI(toolbar).xz "2" configure_views viewsetting xz  "bottom-left \[F3]" false "viewbottomleft"


pack $UI(toolbar).all -side right 
pack $UI(toolbar).xyz -side right 
pack $UI(toolbar).xz -side right 
pack $UI(toolbar).zy -side right
pack $UI(toolbar).xy -side right


    # bottombar

#ac_checkbutton .setting_show_centres "+" "ac3d redraw_orth" prefs_show_objectcentres  "Show/hide object centres"
#ac_checkbutton .setting_show_grid "Grid" "" prefs_show_drawgrid "Switch drawn grid"
ac_checkbutton .setting_gridlock "Gridsnap  " ""  prefs_gridsnap "snap to grid when drawing and dragging"
#ac_checkbutton .setting_lock_move_axis "Lock move axis" "" prefs_lock_move_axis "Automatically lock manipulation movement to one axis only?\n(the drag axis is normally locked by holding down the Control key when first dragging)"
ac_checkbutton .setting_select_transparent "Select through" "" prefs_select_transparent "Select all the way through geometry?"

#ac_checkbutton .setting_realtimefeedback "Feedback  " "" prefs_realtime_manipulation "show realtime manipulation or drag a box?"

    pack \
       .setting_gridlock .setting_select_transparent \
	   -in .bottombar -side left -padx 3 -pady 2



    canvas .progressbar -width 3c -height 0.3c -relief sunken -bd 0 
     .progressbar create rectangle -20 -20 -20 -20 -fill blue -tags rect 
    add_balloon .progressbar "This is a progress bar"
    pack .progressbar -in .bottombar -side right

    label .message -textvariable message
    add_balloon .message "This is a message area"
    pack .message -in .bottombar -fill x -expand 0
set message_bg [.message cget -background]
set message_fg [.message cget -foreground]







proc get_cmd {sock} {
global prefs_allow_socket_commands
global errorInfo

    gets $sock cmd

    set result Error

    if { !$prefs_allow_socket_commands } {
        set result "Socket commands not authorized - settings->allow_socket_commands is not enabled"
    } else {
		if { $cmd == "exit" } {
			set cmd menu_quit
		}
        catch { set result [ uplevel #0 $cmd ] } errmsg
        if {$errmsg != 0} { set result $errmsg }
    }

    set len [string length $result]
    if { $len == 0 } {
       puts $sock "0"
    } else {
        # remember to add one to the length of the string
        puts $sock [expr $len+1]
    }

    set err [catch {flush $sock} ]
    if {$err == 1} 	{ 
        puts "Socket connection $sock gone"; close $sock ; return;
        }
    if { $len > 0 } {
        set err [catch {puts $sock $result}]
        set err [catch {flush $sock}]
        }

}


proc send_sock { str } {
global rsock

    set len [string length $str]
    puts $rsock $len
    flush $rsock
    if {$len > 0} {
        puts $rsock $str
        flush $rsock
        }
}



set listensock 0
set rsock 0

proc do_connection {sock ip port} {

	fileevent $sock readable "get_cmd $sock"
	puts "New socket connected to AC3D (socket id $sock, remote ip:port $ip:$port)"

	close_current_command_socket
	set_command_socket $sock
}


proc enable_socket_commands {} {

	global prefs_tcl_socket_port
	global listensock

	set sock 0

	set err [catch {set sock [socket -server do_connection $prefs_tcl_socket_port]} ]

	if { $err != 0 } {
		set sock 0
	}

	if { $sock != 0 } {
		puts "tcl socket id: $sock"
	}

	set listensock $sock
}


proc disable_socket_commands {} {

	global listensock

	if { $listensock != 0 } {

		close_current_command_socket

		set err [catch { close $listensock }]
		set listensock 0
	}

#	puts "Command socket connections disabled"
}


proc set_command_socket { sock } {

	global rsock

	set rsock $sock
}


proc close_current_command_socket {} {

	global rsock

	if { $rsock != 0 } {
		set err [catch { close $rsock }]
		puts "tcl socket $rsock disconnected by AC3D"
		set rsock 0
	}
}


proc set_socket_commands {} {

	global prefs_allow_socket_commands
	global prefs_tcl_socket_port
	global listensock

	if { $prefs_allow_socket_commands } {

		if { $listensock != 0 } {
			return
		} else {
			enable_socket_commands
		}

		if { $listensock != 0 } {
			puts "Command socket connections enabled on port $prefs_tcl_socket_port"
		} else {
			puts "Failed to enable AC3D tcl socket on port $prefs_tcl_socket_port"
		}

	} else {
		disable_socket_commands
	}
}

# init command socket settings
set_socket_commands



#fconfigure $sock -blocking true
#puts "tcl_socket_port $prefs_tcl_socket_port"












if { [file exists "tcl/patch.tcl"]} { 
    source "tcl/patch.tcl"
} 



set last_draw_mode nothing






proc get_next_grid_row { w } {

	set s [ grid size $w]
	set next [expr [lindex $s 1] + 1] 
	return $next
}


proc param_setting_spin { parent var { text "" } { balloon "" } {from 0} {to ""} { width ""} } {

	set row [get_next_grid_row $parent]

    set lab [label $parent.splinlab$var$row -text $text]
    if { $balloon != "" } {
        add_balloon $lab $balloon
        }

	set spin [spinbox  $parent.spin$var$row -textvariable $var -from $from -to $to -width $width]
    if {$width != ""} {
        $spin configure -width $width
    }

    grid $lab -row $row -column 0 -stick e
    grid $spin -row $row -column 1  -sticky w

}


proc param_setting_edit { parent var { text "" } { balloon "" } { width ""} } {

	set row [get_next_grid_row $parent]

    set lab [label $parent.editlab$var$row -text $text]
    if { $balloon != "" } {
        add_balloon $lab $balloon
        }

	set entry [entry $parent.edittext$var$row -textvariable $var]

    if {$width != ""} {
        $entry configure -width $width
    }

	grid $lab -row $row -column 0  -stick e
	grid $entry -row $row -column 1 -sticky w

}

proc param_setting_edit_point { parent var0 var1 var2 { text "" } { balloon "" } { width ""} } {

	set row [get_next_grid_row $parent]

    set lab [label $parent.editlab$var0$row -text $text]
    if { $balloon != "" } {
        add_balloon $lab $balloon
        }

	set f [frame $parent.edittext$var0$row ]

    if {$width != ""} {
        set ew $width 
    } else {
		set ew 4
	}

	set entry1 [entry $f.v0 -textvariable $var0 -width $ew]
	set entry2 [entry $f.v1 -textvariable $var1 -width $ew]
	set entry3 [entry $f.v2 -textvariable $var2 -width $ew]

	pack  $entry1 $entry2 $entry3 -side left


	grid $lab -row $row -column 0  -stick e
	grid $f -row $row -column 1 -sticky w

}


proc param_setting_bool { parent var { text "" } { balloon "" } } {

	set row [get_next_grid_row $parent]

    set lab [label $parent.boollab$var$row -text $text]
    if { $balloon != "" } {
        add_balloon $lab $balloon
        }

	set check [ac_checkbutton $parent.boolcheck$var$row "" "" $var ""]

#    set check [checkbutton $parent.boolcheck$var$row -text "" -variable $var -highlightthickness 0 -padx 0 -pady 0 ]
#    if { $balloon != "" } {
 #       add_balloon $check $balloon
  #      }

	grid $lab -row $row -column 0  -stick e
	grid $check -row $row -column 1 -sticky w
}


proc param_setting_title { parent text } {
global prefs_font_bold

	set row [get_next_grid_row $parent]
	set f [frame $parent.labelframe$text]
    set lab [ label $f.label$text -text "$text" -font $prefs_font_bold -fg blue]
    pack $lab -side left -fill x
	$lab configure -font "bold 9"

    grid $f -row $row -column 0 -columnspan 2 -sticky we
}



proc param_setting_button { parent text command { balloon "" } } {

	set row [get_next_grid_row $parent]
    set but [ button $parent.label$text$row -text $text -command $command]
	if { $balloon != "" } {
        add_balloon $but $balloon
        }
    grid $but -row $row -column 0 -columnspan 2

}


proc param_setting_frame { parent } {

	set row [get_next_grid_row $parent]
	set f [frame $parent.frame$row ]
    grid $f -row $row -column 0 -columnspan 2 
	return $f
}





proc setting_edit { parent var { text "" } { balloon "" } { width ""} } {

    set f [ frame $parent.fr$var ]

	if { $text != "" } {
		label $f.lel$var -text $text
		if { $balloon != "" } {
			add_balloon $f.lel$var $balloon
		}
		pack $f.lel$var $f.le$var -side left
	}

   entry $f.le$var -textvariable $var

    if {$width != ""} {
        $f.le$var configure -width $width
    }

    pack $f.le$var -side left
    pack $f -side top
    return $f
}




set move_x 0
set move_y 0
set move_z 0
set size_x 1
set size_y 1
set size_z 1
set shift_x 0.1
set shift_y 0
set shift_z 0

set rotate_angle 90
set rotate_angle2 90

set scale_x 100
set scale_y 100
set scale_z 100

set extrudex 0
set extrudey 0
set extrudez 1

#hack for Macs where UI doesn't update after a grid manage
proc exposeUI {win} {
update idletasks
event generate $win <Expose>
	return;

    set kids [winfo children $win]
	foreach i $kids { 
		exposeUI $i
	}
}


proc draw_mode_changed { name1 name2 op } {
global draw_mode last_draw_mode drag_mode last_drag_mode
global object_detail_canvas UIPARAM UI ac_platform

#puts "ac3d.tcl:draw_mode_changed drawmode $draw_mode  dragmode $drag_mode"

#pack propagate $object_detail_frame  0

if {$name1 == "draw_mode" } {
    if {$draw_mode == $last_draw_mode } {return}




    # remove any widgets that are in there
    set todie [winfo children $UI(object_detail_frame)]

#    foreach die $todie { destroy $die }

	# unpack all/any widgets from the frame
foreach die $todie { grid forget $die }
#puts "todie $todie"

#puts "DRAWMODE $draw_mode"

	# test to see if we've already made the correct parmeter frame for this mode
	set res [catch { set causeanerrorifnotdefined "$UIPARAM($draw_mode)" } ]

	if { $res == 0 } {
		#puts "UI already built for $draw_mode"
		set pane $UIPARAM($draw_mode) 
		grid $pane 

		set last_draw_mode $draw_mode
		set last_drag_mode $drag_mode

		# force Mac to update widgets (tk bug)
		if { $ac_platform == "Mac" } {
			exposeUI $pane
		}

		return

	} else {
		#puts "not defined - making for $draw_mode"
		set UIPARAM($draw_mode) [frame $UI(object_detail_frame).$draw_mode]
		set object_detail_frame $UIPARAM($draw_mode)
		grid  $UIPARAM($draw_mode)
	}


	set entry_width 5

	if { ($draw_mode == "polygon") || ($draw_mode == "polyline") || ($draw_mode == "line")} {
        param_setting_bool $object_detail_frame prefs_snap_near "Nearsnap" "snap to near points when drawing\npolys/polylines/lines"
		display_message "Click to add each vertex, right-mouse-button to finish"

    } elseif {$draw_mode == "sphere"} {
        param_setting_title $object_detail_frame "Sphere parameters:"
        param_setting_spin $object_detail_frame prefs_num_surface_div "Segments" "number segments of new sphere" 3 999 3
        param_setting_bool $object_detail_frame prefs_sphere_triangles "Triangles" "construct new spheres from triangles or quads?"
		display_message "Click (or press/drag) to add sphere.  Hold down Ctrl to drag regular shape."

    } elseif { $draw_mode == "mesh" } {
        param_setting_title $object_detail_frame "Mesh parameters:"
        param_setting_bool $object_detail_frame prefs_mesh_triangles "Triangles" "construct new meshes from triangles or quads?"
        param_setting_spin  $object_detail_frame prefs_meshx "X sections" "X sections for squares in new 'Mesh' objects" 1 999 3
        param_setting_spin $object_detail_frame  prefs_meshy "Y sections" "Y sections for squares in new 'Mesh' objects" 1 999 3
		display_message "Click (or press/drag) to add mesh.  Hold down Ctrl to drag regular shape."

    } elseif { $draw_mode == "block" } {
        param_setting_title $object_detail_frame "Block parameters:"
        param_setting_spin  $object_detail_frame prefs_blockx "X sections" "X sections for squares in new 'Block' objects" 1 999 3
        param_setting_spin $object_detail_frame  prefs_blocky "Y sections" "Y sections for squares in new 'Block' objects" 1 999 3
        param_setting_spin $object_detail_frame  prefs_blockz "Z sections" "Z sections for squares in new 'Block' objects" 1 999 3
		display_message "Click (or press/drag) to add block.  Hold down Ctrl to drag regular shape."

    } elseif { $draw_mode == "grid" } {
        param_setting_title $object_detail_frame "Grid parameters:"
        param_setting_spin  $object_detail_frame prefs_grid_object_x "X sections" "X sections for squares in new grid" 1 999 3
        param_setting_spin $object_detail_frame  prefs_grid_object_y "Y sections" "Y sections for squares in new grid" 1 999 3
		display_message "Click (or press/drag) to add grid.  Hold down Ctrl to drag regular shape."

    } elseif { $draw_mode == "circle"} {
        param_setting_title $object_detail_frame "Ellipse parameters:"
        param_setting_spin $object_detail_frame prefs_ellipse_segments "Points" "number of points in circle" 3 255 3
		display_message "Click (or press/drag) to add ellipse.  Hold down Ctrl to drag regular shape."

    } elseif { $draw_mode == "disk"} {
        param_setting_title $object_detail_frame "Disk parameters:"
        param_setting_spin $object_detail_frame prefs_disk_segments "Segments" "segments of disk" 3 999 4
		display_message "Click (or press/drag) to add disk.  Hold down Ctrl to drag regular shape."

    } elseif { $draw_mode == "cylinder"} {
        param_setting_title $object_detail_frame "Cylinder parameters:"
        param_setting_spin $object_detail_frame prefs_cylinder_segments "Segments" "segments of cylinder" 3 999 3
		param_setting_bool $object_detail_frame prefs_cylinder_has_ends "Cap ends" "add surfaces to the ends of the new cylinder?"
		display_message "Click (or press/drag) to add cylinder.  Hold down Ctrl to drag regular shape."

    } elseif { $draw_mode == "light"} {
		display_message "click to position a new light"

    } elseif { $draw_mode == "box"} {
		display_message "Click (or press/drag) to add box.  Hold down Ctrl to drag regular shape."

    } elseif {$draw_mode == "extrude"} {
        param_setting_title $object_detail_frame "Extrude parameters:"
        param_setting_bool $object_detail_frame prefs_extrude_cap_end "Cap end" "Cap the end of the extrusion?"
		param_setting_bool $object_detail_frame prefs_extrude_flip_cap "Flip new surfaces" "Flip the direction of the new surfaces?"
		param_setting_bool $object_detail_frame prefs_extrude_delete_original "Remove original" "Remove the original surfaces?"

        param_setting_title $object_detail_frame "Numeric:"
        param_setting_spin $object_detail_frame prefs_extrude_num "Sections" "number sections in extrude" 1 999 3

		set extrude_entry_width 6
        param_setting_edit  $object_detail_frame extrudex "x" "X distance" $extrude_entry_width
        param_setting_edit  $object_detail_frame extrudey "y" "Y distance" $extrude_entry_width
        param_setting_edit  $object_detail_frame extrudez "z" "Z distance" $extrude_entry_width

		param_setting_button $object_detail_frame "Extrude by distance"  {ac3d extrude_dist $extrudex $extrudey $extrudez $prefs_extrude_num } "extrude now with the above distance and all of the above settings"

		display_message "Drag the selection to extrude. Hold down Ctrl to fix drag direction."


        param_setting_title $object_detail_frame "By normal direction:"
        param_setting_edit  $object_detail_frame prefs_extrude_normal_distance "Dist" "Distance" $extrude_entry_width
		param_setting_button $object_detail_frame "Extrude by normal"  {ac3d extrude_normal_dist $prefs_extrude_normal_distance 1 } "extrude in the direction of the surface-normals"

#		param_setting_button $object_detail_frame "Extrude in place"  {ac3d extrude_dist  0 0 0 1} "extrude the seelction but don't move it"


    } elseif {$draw_mode == "rotate"} {
		

#        set lab3 [label $object_detail_frame.rotate -text "Numeric :"]
#		grid config $lab3 -row 0 -column 0 -columnspan 4

		frame $object_detail_frame.rf
		# rotate axis angle
		
		
		
		# rotate axis angle
		set a1 [label $object_detail_frame.axislab -text "axis:"]
		set s2 [ac_axis_selector $object_detail_frame.rot rotate_axis2]
		set s3 [entry $object_detail_frame.angle -width 4 -textvariable rotate_angle2]
		

		
		set srl [label $object_detail_frame.srl -text "Rotate"]
		set sb [cbutton $object_detail_frame.rb1 "+" { axis_selector_do_rotate rotate_axis2 $rotate_angle2 } "rotate the selection around the selected axis" ]
		set sbm [cbutton $object_detail_frame.rb2 "-"  { axis_selector_do_rotate rotate_axis2 -$rotate_angle2 } "rotate the selection around the selected axis" ]


		grid config $s2 -row 14 -column 1 -sticky e -padx 2 -columnspan 2
		grid config $s3 -row 14 -column 3 -sticky e -padx 0
		grid config $srl -row 15 -column 1 -sticky we -pady 3 -columnspan 1
		grid config $sb -row 15 -column 2 -sticky we -pady 3 -columnspan 1
		grid config $sbm -row 15 -column 3 -sticky we -pady 3 -columnspan 1
		





		grid config $object_detail_frame.rf -row 15 -column 0 -sticky w 
		       	
		frame $object_detail_frame.roc 
		param_setting_bool $object_detail_frame.roc prefs_rotate_about_object_centre "Use obj center" "Mouse rotates about object center ('Loc' in object properties)"
       	grid config $object_detail_frame.roc -columnspan 2
       	
		display_message "Hold down left mb over selection and drag left/right to rotate."


    } elseif {$draw_mode == "move"} {
		set labx [label $object_detail_frame.labx -text "x" -pady 0]
		set laby [label $object_detail_frame.laby -text "y"  -pady 0]
		set labz [label $object_detail_frame.labz -text "z"  -pady 0]
		grid config $labx -row 0 -column 1 -sticky we
		grid config $laby -row 0 -column 2 -sticky we
		grid config $labz -row 0 -column 3 -sticky we


        set m1 [setting_edit  $object_detail_frame move_x "" "X cor" $entry_width]
        set m2 [setting_edit  $object_detail_frame move_y "" "Y cor" $entry_width]
        set m3 [setting_edit  $object_detail_frame move_z "" "Z cor" $entry_width]
		set mb [cbutton $object_detail_frame.sb1 "Move to"  {ac3d move_to  $move_x $move_y $move_z} "Move the centre of the selection to this point"]


		set mget [cbutton $object_detail_frame.mget ">"  {    set pos [ac3d get_selection_centre]; set move_x [lindex $pos 0];\
			set move_y [lindex $pos 1];\
			set move_z [lindex $pos 2]} "fill these fields with the current selection centre"]

		grid config $m1 -row 1 -column 1 -sticky e
		grid config $m2 -row 1 -column 2 -sticky e
		grid config $m3 -row 1 -column 3 -sticky e
		grid config $mb -row 2 -column 1 -sticky we -pady 3 -columnspan 3
		grid config $mget -row 1 -column 0 -sticky e -padx 0
#$object_detail_frame configure -bg red

		set sp1 [frame $object_detail_frame.sp1 -height 6 -width 1]
		grid config $sp1 -row 3 -column 0 -sticky e




		set s1 [setting_edit  $object_detail_frame size_x "" "X width" $entry_width]
        set s2 [setting_edit  $object_detail_frame size_y "" "Y height" $entry_width]
        set s3 [setting_edit  $object_detail_frame size_z "" "Z depth" $entry_width]
		set sb [cbutton $object_detail_frame.sb2 "Size to"  {ac3d size_to  $size_x $size_y $size_z} "Size the selection to these dimensions"]
		set sget [cbutton $object_detail_frame.sget ">"  {    set pos [ac3d get_selection_size]; set size_x [lindex $pos 0];\
			set size_y [lindex $pos 1];\
			set size_z [lindex $pos 2]} "fill these fields with the current selection size"]

#	set sp1 [label  $object_detail_frame.sp1 -text " " -pady 0]
#		grid config $sp1 -row 3 -column 0 -sticky e

		grid config $sget -row 5 -column 0 -sticky e
		grid config $s1 -row 5 -column 1 -sticky e
		grid config $s2 -row 5 -column 2 -sticky e
		grid config $s3 -row 5 -column 3 -sticky e
		grid config $sb -row 6 -column 1 -sticky we -pady 3 -columnspan 3

		set sp2 [frame $object_detail_frame.sp2  -height 6 -width 1]
		grid config $sp2 -row 7 -column 0 -sticky e
		

		# RELATIVE MOVE
		set sh1 [setting_edit  $object_detail_frame shift_x "" "X distance" $entry_width]
        set sh2 [setting_edit  $object_detail_frame shift_y "" "Y distance" $entry_width]
        set sh3 [setting_edit  $object_detail_frame shift_z "" "Z distance" $entry_width]
		set shl [label $object_detail_frame.ssl -text "Move"]
		set shb [cbutton $object_detail_frame.ssh2 "+"  {ac3d move  $shift_x $shift_y $shift_z} "Move the selection this distance (add)"]
		set shbm [cbutton $object_detail_frame.ssh2m "-"  {ac3d move  -$shift_x -$shift_y -$shift_z} "Move the selection this distance (subtract)"]

		grid config $sh1 -row 8 -column 1 -sticky e
		grid config $sh2 -row 8 -column 2 -sticky e
		grid config $sh3 -row 8 -column 3 -sticky e
		grid config $shl -row 9 -column 1 -sticky e -sticky we -pady 3 -columnspan 1
		grid config $shb -row 9 -column 2 -sticky e -sticky we -pady 3 -columnspan 1
		grid config $shbm -row 9 -column 3 -sticky e -sticky we -pady 3 -columnspan 1

		set sp3 [frame $object_detail_frame.sp3  -height 6 -width 1]
		grid config $sp3 -row 10 -column 0 -sticky e


		# SCALE
        set s1 [setting_edit  $object_detail_frame scale_x "" "X scale percentage" $entry_width]
        set s2 [setting_edit  $object_detail_frame scale_y "" "Y scale percentage" $entry_width]
        set s3 [setting_edit  $object_detail_frame scale_z "" "Z scale percentage" $entry_width]
		set sb [cbutton $object_detail_frame.sc1 "Scale"  {ac3d scale [expr $scale_x/100.0] [expr $scale_y/100.0] [expr $scale_z/100.0]} "scale the selection\n(100% means there will be no change)"]
set sl [label $object_detail_frame.sl -text "%" ]
		grid config $sl -row 11 -column 0 -sticky e

		grid config $s1 -row 11 -column 1 -sticky e 
		grid config $s2 -row 11 -column 2 -sticky e 
		grid config $s3 -row 11 -column 3 -sticky e
		grid config $sb -row 12 -column 1 -sticky we  -pady 3 -columnspan 3

		set sp4 [frame $object_detail_frame.sp4  -height 6 -width 1]
		grid config $sp4 -row 13 -column 0 -sticky e


		# rotate axis angle
		set s2 [ac_axis_selector $object_detail_frame.rot rotate_axis]
		set s3 [entry $object_detail_frame.angle -width 4 -textvariable rotate_angle]
		
		
		set srl [label $object_detail_frame.srl -text "Rotate"]
		set sb [cbutton $object_detail_frame.rb1 "+" { axis_selector_do_rotate rotate_axis $rotate_angle } "rotate the selection around the selected axis" ]
		set sbm [cbutton $object_detail_frame.rb2 "-"  { axis_selector_do_rotate rotate_axis -$rotate_angle } "rotate the selection around the selected axis" ]

		grid config $s2 -row 14 -column 1 -sticky e -padx 2 -columnspan 2
		grid config $s3 -row 14 -column 3 -sticky e -padx 0
		grid config $srl -row 15 -column 1 -sticky we -pady 3 -columnspan 1
		grid config $sb -row 15 -column 2 -sticky we -pady 3 -columnspan 1
		grid config $sbm -row 15 -column 3 -sticky we -pady 3 -columnspan 1
		
		display_message "Select/move/resize with left mb.  Hold Ctrl for more control dragging/sizing."

    }



}

    set last_draw_mode $draw_mode
    set last_drag_mode $drag_mode
}


recent_file_menu_check

wm deiconify .
raise .

catch { console hide }




