# AC3D
# Copyright (c) 2008, Inivis Limited. All rights reserved.


set Tree(font) "times 8"

#"-adobe-helvetica-medium-r-normal-*-14-100-100-100-p-76-iso8859-1"


option add *highlightThickness 0


set Tree(activetextcol) grey50

#switch $tcl_platform(platform) {
#  unix {
#    set Tree(font) -adobe-helvetica-medium-r-normal-*-11-80-100-100-p-56-iso8859-1
#  }
#  windows {
#  puts "tree win"
#    set Tree(font) -adobe-helvetica-medium-r-normal-*-14-100-100-100-p-76-iso8859-1
#  }
#}




#
# Create a new tree widget.  $args become the configuration arguments to
# the canvas widget from which the tree is constructed.
#
proc Tree:create {w args} {
  global Tree
  set Tree(font) "-adobe-helvetica-medium-r-normal-*-11-100-100-100-p-76-iso8859-1"
  
  eval canvas $w $args
  bind $w <Destroy> "Tree:delitem $w /"
  Tree:dfltconfig $w /
  Tree:buildwhenidle $w
  set Tree($w:selection) {}
  set Tree($w:selidx) {}
}

# Initialize a element of the tree.
# Internal use only
#
proc Tree:dfltconfig {w v} {
  global Tree
  set Tree($w:$v:children) {}
#  set Tree($w:$v:folded) 1
  set Tree($w:$v:icon) {}
  set Tree($w:$v:tags) {}
}

#
# Pass configuration options to the tree widget
#
proc Tree:config {w args} {
  eval $w config $args
}

#
# Insert a new element $v into the tree $w.
#
proc Tree:newitem {w v text selected hidden locked args} {
  global Tree
  set dir [file dirname $v]
  set n [file tail $v]
#  if {![info exists Tree($w:$dir:folded)]} {
#    error "parent item \"$dir\" is missing"
#  }
#  set i [lsearch -exact $Tree($w:$dir:children) $n]
#  if {$i>=0} {
#    error "item \"$v\" already exists"
#  }
  lappend Tree($w:$dir:children) $n
#  set Tree($w:$dir:children) [lsort $Tree($w:$dir:children)]
  
  # record the text that's going to be on the label
#  puts "puttin text in $w:$v:text"
  
  set Tree($w:$v:text) $text
  set Tree($w:$v:selected) $selected
  set Tree($w:$v:hidden) $hidden
  set Tree($w:$v:locked) $locked
  
  set folded [ ac3d entity_get_value $n folded ]
  if { $folded } { set Tree($w:$v:folded) 1 } else {set Tree($w:$v:folded) 0}
 
  Tree:dfltconfig $w $v
  foreach {op arg} $args {
    switch -exact -- $op {
      -image {set Tree($w:$v:icon) $arg}
      -tags {set Tree($w:$v:tags) $arg}
    }
  }
  Tree:buildwhenidle $w
}

#
# Delete element $v from the tree $w.  If $v is /, then the widget is
# deleted.
#
proc Tree:delitem {w v} {
  global Tree
  if {![info exists Tree($w:$v:folded)]} {return}

  if {[string compare $v /]==0} {
    # delete the whole widget
    catch {destroy $w}
    foreach t [array names Tree $w:*] {
    unset Tree($t)
    }
  }
  foreach c $Tree($w:$v:children) {
    catch {Tree:delitem $w $v/$c}
  }
  unset Tree($w:$v:folded)
  unset Tree($w:$v:children)
  unset Tree($w:$v:icon)
  unset Tree($w:$v:text)
  unset Tree($w:$v:selected)
  
  set dir [file dirname $v]
  set n [file tail $v]
  set i [lsearch -exact $Tree($w:$dir:children) $n]
  if {$i>=0} {
    set Tree($w:$dir:children) [lreplace $Tree($w:$dir:children) $i $i]
  }
  Tree:buildwhenidle $w
}

#
# Change the selection to the indicated item
#
proc Tree:setselection {w v} {
  global Tree
  set Tree($w:selection) $v
  Tree:drawselection $w
}

# 
# Retrieve the current selection
#
proc Tree:getselection w {
  global Tree
  return $Tree($w:selection)
}

#
# Bitmaps used to show which parts of the tree can be opened.
#
set maskdata "#define solid_width 9\n#define solid_height 9"
append maskdata {
  static unsigned char solid_bits[] = {
   0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01,
   0xff, 0x01, 0xff, 0x01, 0xff, 0x01
  };
}
set data "#define open_width 9\n#define open_height 9"
append data {
  static unsigned char open_bits[] = {
   0xff, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7d, 0x01, 0x01, 0x01,
   0x01, 0x01, 0x01, 0x01, 0xff, 0x01
  };
}
image create bitmap Tree:openbm -data $data -maskdata $maskdata \
  -foreground black  -background white
set data "#define closed_width 9\n#define closed_height 9"
append data {
  static unsigned char closed_bits[] = {
   0xff, 0x01, 0x01, 0x01, 0x11, 0x01, 0x11, 0x01, 0x7d, 0x01, 0x11, 0x01,
   0x11, 0x01, 0x01, 0x01, 0xff, 0x01
  };
}
image create bitmap Tree:closedbm -data $data -maskdata $maskdata \
  -foreground black -background white

# Internal use only.
# Draw the tree on the canvas
proc Tree:build w {
  global Tree
  $w delete all
  catch {unset Tree($w:buildpending)}
  set Tree($w:y) 30
  Tree:buildlayer $w / 10
  $w config -scrollregion [$w bbox all]
  Tree:drawselection $w
}

# Internal use only.
# Build a single layer of the tree on the canvas.  Indent by $in pixels
proc Tree:buildlayer {w v in} {
  global Tree
  
  if {$v=="/"} {
    set vx {}
  } else {
    set vx $v
  }
  set start [expr $Tree($w:y)-10]
  
  # set y in case there are no kids
  set y 0
  
#  puts $v
#  puts $Tree($w:$v:children)
  
  
  foreach c $Tree($w:$v:children) {
    set y $Tree($w:y)
    incr Tree($w:y) 20
    $w create line $in $y [expr $in+10] $y -fill gray50 
    set icon $Tree($w:$vx/$c:icon)
    set taglist x
    foreach tag $Tree($w:$vx/$c:tags) {
      lappend taglist $tag
    }
    set x [expr $in+12]
    if {[string length $icon]>0} {
      set k [$w create image $x $y -image $icon -anchor w -tags $taglist]

if { 1 == 1	} {
  # hidden?
      incr x 20
            set hidden $Tree($w:$vx/$c:hidden)
      if { $hidden } {
		set test [$w create image $x $y -image hidden0 -anchor w -tags $taglist]
		$w bind $test <1>  "ac3d object_hide $c ; ac3d redraw_all; hier_make_list; sync_ui"
	  } else {
		set test [$w create image $x $y -image hidden1 -anchor w -tags $taglist]
		$w bind $test <1>  "ac3d object_unhide $c ; ac3d redraw_all; hier_make_list; sync_ui"
	  }	  
	  
	  # locked?
      incr x 20
      set locked $Tree($w:$vx/$c:locked)
      if { $locked } {
	      set test [$w create image $x $y -image locked0 -anchor w -tags $taglist]
	      $w bind $test <1>  "ac3d object_lock $c ; ac3d redraw_all; hier_make_list; sync_ui"

	  } else {
	      set test [$w create image $x $y -image locked1 -anchor w -tags $taglist]
	      $w bind $test <1>  "ac3d object_unlock $c ; ac3d redraw_all; hier_make_list; sync_ui"

	  }



}
      incr x 20
      set Tree($w:tag:$k) $vx/$c


    }
    
    
    set text $Tree($w:$vx/$c:text)
	set isselected $Tree($w:$vx/$c:selected)
#	if { $isselected } { set text "$text***" }

    set j [$w create text $x $y -text "$text" -font $Tree(font) \
                                -anchor w -tags $taglist -activefill $Tree(activetextcol)]
    set Tree($w:tag:$j) $vx/$c
    set Tree($w:$vx/$c:tag) $j
    
    if { $isselected } {
		set bbox [$w bbox $j]
		if {[llength $bbox]==4} {
			set i [eval $w create rectangle $bbox -fill #cccccc -outline {{}}]
#			set Tree($w:selidx) $i
			$w lower $i
		}
	}
	
    if {[string length $Tree($w:$vx/$c:children)]} {
      if {$Tree($w:$vx/$c:folded)} {
         set j [$w create image $in $y -image Tree:closedbm]
         $w bind $j <1> "set Tree($w:$vx/$c:folded) 0; ac3d entity_set_value $c folded 0 ; Tree:build $w"
       } else {  
         set j [$w create image $in $y -image Tree:openbm]
         $w bind $j <1> "set Tree($w:$vx/$c:folded) 1; ac3d entity_set_value $c folded 1 ; Tree:build $w"
         Tree:buildlayer $w $vx/$c [expr $in+18]
      }
    }
  }
  set j [$w create line $in $start $in [expr $y+1] -fill gray50 ]
  $w lower $j
}

# Open a branch of a tree
#
proc Tree:open {w v} {
  global Tree
  if {[info exists Tree($w:$v:folded)] && $Tree($w:$v:folded)==0
      && [info exists Tree($w:$v:children)] 
      && [string length $Tree($w:$v:children)]>0} {
    set Tree($w:$v:folded) 0
    Tree:build $w
    set ob [file tail $v]
    ac3d entity_set_value $ob folded 0
  }
}

proc Tree:close {w v} {
  global Tree
  if {[info exists Tree($w:$v:folded)] && $Tree($w:$v:folded)==1} {
    set Tree($w:$v:folded) 1
    Tree:build $w
    set ob [file tail $v]
    ac3d entity_set_value $ob folded 1
  }
}


proc Tree:is_selected { w v } {
	global Tree
	set isselected $Tree($w:$v:selected)
	return $isselected
}





# Internal use only.
# Draw the selection highlight
proc Tree:drawselection w {
  global Tree
  if {[string length $Tree($w:selidx)]} {
    $w delete $Tree($w:selidx)
  }
  set v $Tree($w:selection)
  if {[string length $v]==0} return
  if {![info exists Tree($w:$v:tag)]} return
  set bbox [$w bbox $Tree($w:$v:tag)]
  if {[llength $bbox]==4} {
    set i [eval $w create rectangle $bbox -fill skyblue -outline {{}}]
    set Tree($w:selidx) $i
    $w lower $i
  } else {
    set Tree($w:selidx) {}
  }
}

# Internal use only
# Call Tree:build then next time we're idle
proc Tree:buildwhenidle w {
  global Tree
  if {![info exists Tree($w:buildpending)]} {
    set Tree($w:buildpending) 1
    after idle "Tree:build $w"
  }
}

#
# Return the full pathname of the label for widget $w that is located
# at real coordinates $x, $y
#
proc Tree:labelat {w x y} {
  set x [$w canvasx $x]
  set y [$w canvasy $y]
  global Tree
  foreach m [$w find overlapping $x $y $x $y] {
    if {[info exists Tree($w:tag:$m)]} {
      return $Tree($w:tag:$m)
    }
  }
  return ""
}


image create photo ifile -file tcl/images/tinysphere.png
image create photo idir -file tcl/images/tinygroup.png
image create photo ilight -file tcl/images/tinylight.png

image create photo hidden0 -file tcl/images/tinyhidden0.png
image create photo hidden1 -file tcl/images/tinyhidden1.png
image create photo locked0 -file tcl/images/tinylocked0.png
image create photo locked1 -file tcl/images/tinylocked1.png



proc hier_view_prop {} {
global hier_current
global oblist

    set ob $hier_current
    set w .hier$hier_current

    if [winfo exists $w] { destroy $w}

    new_toplevel $w "Object Properties"

	
    set str "Name:"
    set name [ac3d object_get_name $ob]
    set str "$str $name"

    set children [ac3d object_get_children $ob]
    set numkids [llength $children]
    set str "$str\nChildren: $numkids"

    set surfaces [ac3d object_get_surfaces $ob]
    set numsurf [llength $surfaces]
    set str "$str\nSurfaces: $numsurf"

    set vertices [ac3d object_get_vertices $ob]
    set numvert [llength $vertices]
    set str "$str\nVertices: $numvert"

    set cen [ac3d object_get_centre $ob]
    set str "$str\nT: $cen"

    set url [ac3d object_get_url $ob]
    set str "$str\nURL: $url"

    set data [ac3d object_get_data $ob]
    set str "$str\nData: $data"

    label $w.lab -text $str -justify left
    pack  $w.lab -side top 
    button $w.close -text "Close" -command "destroy $w"
    pack $w.close -side bottom
    centre_window_on_screen $w

}


proc hier_hide_object {  } {
global hier_current UI

    set ob $hier_current
    ac3d object_hide $ob
    ac3d redraw_all
    hier_make_list
    sync_ui

}

proc hier_unhide_object { } {
global hier_current UI

    set ob $hier_current
    ac3d object_unhide $ob
    ac3d redraw_all
    hier_make_list 
    sync_ui

}

proc hier_move_to_head { } {
global hier_current UI

    set ob $hier_current
    ac3d object_move_to_head $ob
    ac3d redraw_all
    hier_make_list
    sync_ui
}

proc hier_move_to_tail { } {
global hier_current UI

    set ob $hier_current
    ac3d object_move_to_tail $ob
    ac3d redraw_all
    hier_make_list
    sync_ui
}


proc hier_move_up { } {
global hier_current UI

    set ob $hier_current
    ac3d object_move_up $ob
    ac3d redraw_all
    hier_make_list
    sync_ui
}

proc hier_move_down { } {
global hier_current UI

    set ob $hier_current
    ac3d object_move_down $ob
    ac3d redraw_all
    hier_make_list
    sync_ui
}


proc hier_edit_object_data { } {
     global current_object_data
global hier_current
global oblist

#puts "display_object_data $current_object_data"


    set ob $hier_current
    set name [ac3d object_get_name $ob]


if [winfo exists .d5] { destroy .d5 }

    new_toplevel .d5 "AC3D Object Data"

    frame .d5.hf
    pack .d5.hf -side top

    frame .d5.bottomhf
    pack .d5.bottomhf -side bottom
    button .d5.bottomhf.close -text "Close" -command "\
        ac3d object_set_data $ob \[.d5.object_data get 0.0 end-1c]; 
        destroy .d5"

    pack .d5.bottomhf.close

    label .d5.object_data_label -text "Object data for: $name"
    add_balloon .d5.object_data_label "Object data string - saved with object (in .ac files)\ninserted in some output formats"
    pack .d5.object_data_label -side top

     text .d5.object_data -width 60 -height 10 \
             -yscrollcommand ".d5.ys set" \
             -xscrollcommand ".d5.xs set" \
             -wrap none -padx 4 -pady 4 \
             -exportselection true 
#             -insertwidth $cursorwidth -insertbackground $cursorcolour 

	bind .d5.object_data <KeyRelease> " ac3d object_set_data $ob \[.d5.object_data get 0.0 end-1c]; "

     ttk::scrollbar .d5.ys -command ".d5.object_data yview" 
     ttk::scrollbar .d5.xs -command ".d5.object_data xview" -orient horizontal
     pack .d5.ys -in .d5 -side left -fill y -expand 0
     pack .d5.xs -in .d5 -side bottom -fill both -expand 0
     pack .d5.object_data -in .d5 -side left -fill both -expand 1


#    bind .d5.object_data <Leave> {
#        ac3d set_current_object_data  [.d5.object_data get 0.0 end-1c]
#        }




    set data [ac3d object_get_data $ob]

        .d5.object_data delete 0.0 end
        .d5.object_data insert end $data

    # fill in the fields
#    display_object_data
	centre_window_on_screen .d5


}





















proc make_level_new { tree object level path} {
global oblist

    set name [ac3d object_get_name $object]
    set str ""
#    for { set n 0 } { $n < $level} {incr n} {
 #       set str "$str      "
  #  }


	set kids [ac3d object_get_children $object]

	set type [ac3d entity_get_class_name $object]

	set str "$str - $type "

#puts "object $name - kids $kids"


	if { $name == "" } {
		set str "$str $name"
	} else {
		set str "$str '$name'";
	}

    if { [ac3d object_is_visible $object]} {
        set str "$str \[hidden/locked]"
    }

    if { [ac3d object_is_hidden $object]} {
        set hidden true
    } else {
		set hidden false
	}
	
	if { [ac3d object_is_locked $object]} {
        set locked true
    } else {
		set locked false
	}

	set selected [ac3d object_is_selected $object]
	
	if { $kids != "" } {
		Tree:newitem $tree $path $str $selected $hidden $locked -image idir
	} else {
		if { $type == "light" } {
		Tree:newitem $tree $path $str $selected $hidden $locked -image ilight
		} else {
		Tree:newitem $tree $path $str $selected $hidden $locked -image ifile		
		}
	}	


    if {$kids != ""} {
        foreach k $kids {
           make_level_new $tree $k [expr $level+1] $path/$k
        }
    }
}



set lastworld ""

proc hier_make_list { } {
global UI lastworld

	set tree $UI(tree)

	if { $lastworld != "" } {
		# clear the tree
		Tree:delitem $tree /$lastworld
	}

    set world [ac3d get_world]
	set lastworld $world
	
    make_level_new $tree $world 0 /$world
}



proc item_clicked { w item } {
global Tree

  if {![info exists Tree($w:$item:selected)]} {
	return
	}
	  
	set issel [ Tree:is_selected $w $item ]
	
	set ob [file tail $item]
	
    if { !$issel} {
        ac3d object_select $ob
    } else {
        ac3d object_deselect $ob
    }
    
    sync_ui
    ac3d redraw_all
}



proc hier_handle_drop { dragged droppedon } {

	ac3d object_reparent $dragged $droppedon
}




	menu .hiermenu -tearoff false 
	set UI(hiermenu) .hiermenu
	.hiermenu add command -label "View properties..." -command "hier_view_prop"
#	.hiermenu add command -label "Hide" -command "hier_hide_object"
#	.hiermenu add command -label "Unhide" -command "hier_unhide_object"
	.hiermenu add command -label "Move to head" -command "hier_move_to_head"
	.hiermenu add command -label "Move to tail" -command "hier_move_to_tail"
	.hiermenu add command -label "Move up" -command "hier_move_up"
	.hiermenu add command -label "Move down" -command "hier_move_down"
		
	.hiermenu add command -label "Edit object data..." -command "hier_edit_object_data"
		
		
		

# add pref to save hier position and size
ac3d add_pref window_geom_hier ""
	    

proc menu_hier {} {
global hier_current
global ac_platform
global UI hier_pressed_item

    if {![winfo exists .hier] } {
		new_toplevel_tracked .hier "Hierarchy" prefs_window_geom_hier

	       
	    if { $ac_platform == "Mac" } {
			bind .hier <ButtonPress-2> {
				event generate %W <ButtonPress-3> -x %x -y %y -rootx %X -rooty %Y -button 3 -time %t
			}
		}
		

		acbind .hier <Control-z> "ac3d undo"
		acbind .hier <Control-Z> "ac3d redo"
	    
	    frame .hier.functions 
		pack .hier.functions -side top -fill x -expand 0 -padx 2 -pady 2 
		button .hier.functions.b1 -text "Select all" -command " ac3d select_all ; hier_make_list"
		button .hier.functions.b2 -text "Select none" -command " ac3d clear_selection ; hier_make_list"
		button .hier.functions.group -text "Group" -command " ac3d group ; hier_make_list "
		button .hier.functions.ungroup -text "Ungroup" -command " ac3d ungroup ; hier_make_list"
		pack .hier.functions.b1 .hier.functions.b2 .hier.functions.group .hier.functions.ungroup \
			-side left -padx 1 -ipadx 4
			

		
		
		Tree:create .hier.tree -width 150 -height 150 -yscrollcommand {.hier.sb set} -bg white -borderwidth 1 -relief sunken
		set tree .hier.tree
		set UI(tree) $tree
		ttk::scrollbar .hier.sb -orient vertical -command {.hier.tree yview}
		pack .hier.sb -side left -fill y
		pack .hier.tree -side top -fill both -expand 1 -padx 1 -pady 1

		label .hier.selinfo -textvariable select_info -justify left
		pack .hier.selinfo -side top
		
		frame .hier.buttons
		button .hier.buttons.close -text "Close" -command { wm withdraw .hier }
		button .hier.buttons.refresh -text "Refresh" -command { hier_make_list }
		pack .hier.buttons.close .hier.buttons.refresh -side left
		pack .hier.buttons -side bottom -expand 0




		set hier_pressed_item ""

		$tree bind x <ButtonPress-1> {
			set lbl [Tree:labelat %W %x %y]
			set hier_pressed_item $lbl
		}

		$tree bind x <Motion> {
			if { $hier_pressed_item != "" } {
				set lbl [Tree:labelat %W %x %y]
				if { $lbl != "" } {
					%W configure -cursor target
				} else {
					%W configure -cursor ""
				}
				
			} else {
				%W configure -cursor ""
			}
		}

		$tree bind x <ButtonRelease-1> {
			set lbl [Tree:labelat %W %x %y]

			if { $hier_pressed_item == $lbl} {
				item_clicked %W $lbl
			} else {
				if { $lbl != "" } {
					set dragged [file tail $hier_pressed_item]
					set droppedon [file tail $lbl]
					hier_handle_drop $dragged $droppedon
				}
			}
			
			set hier_pressed_item ""
			%W configure -cursor ""
		}
		
		$tree bind x <Double-1> {
			Tree:open %W [Tree:labelat %W %x %y]
		}


		$tree bind x <3> {
			set lbl [Tree:labelat %W %x %y]
			set hier_current [file tail $lbl]
			if { $hier_current != "" } {
				tk_popup .hiermenu %X %Y
			} 
		}

  } else {
    
    wm deiconify .hier
    raise .hier
  }
  
  

	hier_make_list
}

proc hier_trace_select_mode { name1 name2 op } {
global select_mode

  if ![winfo exists .hier] return

   if { $select_mode == "tree"} {
       set_sensitive true .hier.functions.group .hier.functions.ungroup
   } else {
       set_sensitive false .hier.functions.group .hier.functions.ungroup
   }

}


proc hier_trace_select_info { name1 name2 op } {
global select_mode

  if ![winfo exists .hier] return
    hier_make_list

}

proc hier_update { } {

  if ![winfo exists .hier] return
    hier_make_list

}


#could probably add hier_make_list in sync_ui proc but do this instead:
trace variable select_mode w hier_trace_select_mode
trace variable select_info w hier_trace_select_info
