# http://www.mail-archive.com/vtcl@neuron.com/msg01306.html


proc clipboard_create {} {
    event add <<Cut>>   <Control-Key-X>
    event add <<Copy>>  <Control-Key-C>
    event add <<Paste>> <Control-Key-V>
    set   m .clipboardmenu
    menu $m -tearoff 0
    $m add command -label "Cut"        -accel "Ctrl+X"
    $m add command -label "Copy"       -accel "Ctrl+C"
    $m add command -label "Paste"      -accel "Ctrl+V"
    $m add command -label "Delete"     -accel "Delete"
    $m add separator
    $m add command -label "Select All" -accel "Ctrl+/"
}

proc clipboard_doit {w opt} {
    event generate $w <$opt>
}

proc clipboard_post {w x y} {
    set m .clipboardmenu
    if {[winfo class $w] == "Text"} {
        set sel [$w tag ranges sel]
    } {
        if {[$w selection present]} {
            set sel "1"
        } {
            set sel ""
        }
    }
    if {$sel == ""} {
        set selstate disabled
    } {
        set selstate normal
    }
    set editstate [$w cget -state]
    if {$editstate == "disabled"} {
        set cutstate $editstate
    } {
        set cutstate $selstate
    }
    if {[catch {selection get -displayof $w -selection CLIPBOARD} sel] || $sel == ""} {
        set pastestate disabled
    } {
        set pastestate $editstate
    }
    $m  entryconfig "Cut"        -command "clipboard_doit $w <Cut>" -state $cutstate
    $m  entryconfig "Copy"       -command "clipboard_doit $w <Copy>" -state $selstate 
    $m  entryconfig "Paste"      -command "clipboard_doit $w <Paste>" -state $pastestate
    $m  entryconfig "Delete"     -command "clipboard_doit $w  Delete" -state $cutstate
    $m  entryconfig "Select All" -command "clipboard_doit $w Control-slash"
    tk_popup $m $x $y
}

    
    # Clipboard popup memu
    clipboard_create
    bind Text  <3>     "+focus %W; clipboard_post %W %X %Y"
    bind Entry <3>     "+focus %W; clipboard_post %W %X %Y"
#    bind Text  <Enter> "+focus %W"
 #   bind Entry <Enter> "+focus %W"

