# Copyright (c) 2008, Inivis Limited. All rights reserved.

# current object - properties dialog


proc set_object_data { string } {
#update the global variable for object data and change display if needed
global current_object_data UI

#puts "updating object prop"
#puts "got object data $string"

	set current_object_data $string
	if [winfo exists .d] {
		$UI(prop_object_data) delete 0.0 end
		$UI(prop_object_data) insert end $current_object_data
	}
}
 

set gridr 0

proc current_float_entry { parent label var help {command ""} } {
global GRIDROW

	label $parent.floatlab$label -text $label
	add_balloon $parent.floatlab$label $help
	grid $parent.floatlab$label -column 0 -row $GRIDROW($parent)  -sticky e
	entry $parent.float$label -textvariable $var -width 10
	grid $parent.float$label -column 1 -row $GRIDROW($parent) -sticky w
	if { $command != "" } {
		bind $parent.float$label <Return> $command
		bind $parent.float$label <FocusOut> $command
	}
	incr GRIDROW($parent)

	return $parent.float$label
}

proc current_string_entry { parent label var help {command ""}} {
global GRIDROW

	label $parent.stringlab$label -text $label 
	add_balloon $parent.stringlab$label $help
	grid $parent.stringlab$label -column 0 -row $GRIDROW($parent) -sticky e
	entry $parent.string$label -textvariable $var -width 20
	grid $parent.string$label -column 1 -row $GRIDROW($parent) -sticky we
	incr GRIDROW($parent)

	if { $command != "" } {
		bind $parent.string$label <Return> $command
	}
	return $parent.string$label
}


proc current_int_entry { parent label var fromi toi help {command ""}} {
global GRIDROW

	label $parent.floatlab$label -text $label
	add_balloon $parent.floatlab$label $help
	grid $parent.floatlab$label -column 0 -row $GRIDROW($parent) -sticky e
	spinbox $parent.float$label -textvariable $var -from $fromi -to $toi -width 3
	grid $parent.float$label -column 1 -row $GRIDROW($parent) -sticky w

	if { $command != "" } {
			button $parent.floatbut$label -text "Set" -command $command
			grid $parent.floatbut$label -column 2 -row $gridr -sticky w
	}

	incr GRIDROW($parent)

	return $parent.float$label
}

proc current_boolean_entry { parent label var help {command ""}} {
global GRIDROW

#	label $parent.floatlab$label -text $label
#	add_balloon $parent.floatlab$label $help
#	grid $parent.floatlab$label -column 0 -row $GRIDROW($parent) -sticky e
	checkbutton $parent.float$label -variable $var -text $label
	add_balloon $parent.float$label $help
#	spinbox $parent.float$label -textvariable $var -from $fromi -to $toi -width 3
	grid $parent.float$label -column 1 -row $GRIDROW($parent) -sticky w

	if { $command != "" } {
			$parent.float$label configure -command $command
	}

	incr GRIDROW($parent)

	return $parent.float$label
}



proc current_scale_entry { parent label var fromi toi help {command ""}} {
global GRIDROW

	label $parent.floatlab$label -text $label
	add_balloon $parent.floatlab$label $help
	grid $parent.floatlab$label -column 0 -row $GRIDROW($parent) -sticky se
	frame $parent.scalef$label
	scale $parent.scalef$label.float$label -variable $var -from $fromi -to $toi -orient horiz -length 150 -width 10
	pack $parent.scalef$label.float$label -side left -anchor se
	grid $parent.scalef$label -column 1 -row $GRIDROW($parent) -sticky w

	if { $command != "" } {
			button $parent.scalef$label.floatbut$label -text "Set" -command $command
			pack $parent.scalef$label.floatbut$label -side left -anchor se
	}

	incr GRIDROW($parent)

	return $parent.float$label
}


ac3d add_pref window_geom_object_properties ""

proc edit_dive_data {} {
global current_object_data current_crease_angle UI CURRENT gridr GRIDROW
global ac_platform prefs_subdiv_max_level

#puts "display_object_data $current_object_data"

if ![winfo exists .d] {

	new_toplevel_tracked .d "AC3D Object Properties" prefs_window_geom_object_properties

	label .d.object_data_message -text "Object Properties:" -justify left
	pack .d.object_data_message -side top -fill x -anchor w -pady 10

	set UI(object_data_message) .d.object_data_message

	frame .d.bottomhf
	pack .d.bottomhf -side bottom
	button .d.bottomhf.close -text "Close" -command "destroy .d"
	pack .d.bottomhf.close -padx 5 -pady 5


set top .d


#set top $UI(object_detail_frame)


	############################

	set UI(object_properties_frame) [frame $top.prop]
	pack $UI(object_properties_frame) -side top -fill x -padx 5
	set propparent $UI(object_properties_frame)

	set UI(object_properties_frame2) [frame $top.prop2]
	pack $UI(object_properties_frame2) -side top -fill x -padx 5
	set propparent2 $UI(object_properties_frame2)

	# init row count for parent (incremented when new attributes are added
	set GRIDROW($propparent) 0
	set GRIDROW($propparent2) 0

grid columnconfigure $propparent 1 -weight 1
grid columnconfigure $propparent2 1 -weight 1

	#object name
	set UI(prop_object_name) [ current_string_entry $propparent "Name" current_object_name 	"name of the current object.\nit can also be changed on the control panel"]
	bind $UI(prop_object_name) <KeyRelease> {
		ac3d set_current_object_name $current_object_name
		}

	#object url
	set UI(prop_object_url) [ current_string_entry $propparent "URL" current_object_url "If there is a URL present, then the exported VRML object will have an anchor/link to it"]
	bind $UI(prop_object_url) <KeyRelease> {
		ac3d set_current_object_url $current_object_url
		}

	# object centre
	# the command to execute when return is pressed in a field
	set setloc { ac3d entity_set_value $CURRENT(object) "loc" "$CURRENT(loc_x) $CURRENT(loc_y) $CURRENT(loc_z)" ; ac3d redraw_all}

	set UI(current_loc_x) [ current_float_entry $propparent "Loc x" CURRENT(loc_x) "object centre x" $setloc ]
	set UI(current_loc_y) [ current_float_entry $propparent "Loc y" CURRENT(loc_y) "object centre y" $setloc ]
	set UI(current_loc_z) [ current_float_entry $propparent "Loc z" CURRENT(loc_z) "object centre z" $setloc ]


	set setshowname { ac3d entity_set_value $CURRENT(object) "showname" "$CURRENT(showname)" ; ac3d redraw_all}

	set UI(current_showname) [ current_boolean_entry $propparent "Show name" CURRENT(showname) "show object name?" $setshowname ]


	# subdivision level
#	set setsubdiv { ac3d entity_set_value $CURRENT(object) "subdivision_level" "$CURRENT(subdiv_level)"; ac3d object_calc_normals $CURRENT(object) ; ac3d redraw_all}
	set setsubdiv { ac3d object_set_subdivision_level $CURRENT(object) "$CURRENT(subdiv_level)"}

	set UI(current_subdiv_level) [ current_scale_entry $propparent2 "Subdiv preview" CURRENT(subdiv_level) 0 $prefs_subdiv_max_level  "Subdivision level.\nEach subdivision level will (more than) quadruple the number of surfaces.\nConvert object to the actual subdivided polygons with Object->Commit-Subdivision." $setsubdiv]


	##############################

	# CREASE ANGLE
	set setcreaseangle {
		set co [ ac3d get_current_object]
		ac3d entity_set_value $co "crease" $CURRENT(crease_angle)
		ac3d object_calc_normals $co
		ac3d redraw_all
	}
	set UI(prop_crease_button) [ current_scale_entry $propparent2 "Crease angle" CURRENT(crease_angle) 0 180 "Crease angle - if the angle between two surfaces in the object is less than the specified angle,\nthey will be drawn with a hard edge. (Surface-type FLAT forces flat shading)" $setcreaseangle]


	set UI(object_data_frame) [frame $top.offrame]
	set w $UI(object_data_frame)
	pack $w -fill both -expand 1
	label $w.object_data_label -text "Object data text:"
	add_balloon $w.object_data_label "Object data text - saved with object (in .ac files)\ninserted in some output formats"
	pack $w.object_data_label -side top -anchor w -pady 2

	set UI(prop_object_data) [ text $w.object_data -width 40 -height 5 \
			 -yscrollcommand "$w.ys set" \
			 -xscrollcommand "$w.xs set" \
			 -wrap none -padx 4 -pady 4 \
			 -exportselection true ]

#			  -insertwidth $cursorwidth -insertbackground $cursorcolour 

	 ttk::scrollbar $w.ys -command "$w.object_data yview" 
	 ttk::scrollbar $w.xs -command "$w.object_data xview" -orient horizontal
	 pack $w.ys -in $w -side left -fill y -expand 0
	 pack $w.xs -in $w -side bottom -fill both -expand 0
	 pack $w.object_data -in $w -side left -fill both -expand 1 -padx 5


	bind $w.object_data <KeyRelease> {
		ac3d set_current_object_data  [$UI(prop_object_data) get 0.0 end-1c]
		}

} else {
    wm deiconify .d
	raise .d
}


#menu .popup -tearoff 0
#.popup add command -label "Cut" -command "ac3d menu_about"
#.popup add command -label "Copy" -command "ac3d menu_about"
#.popup add command -label "Paste" -command { puts "entry $currententry" ; tk::EntryInsert $currententry [ selection get ]} 


#bind Entry <ButtonPress-3> {
#set currententry %W
#tk_popup .popup %X %Y
#}

	# make sure that the fields are disabled if they need to be:
	sync_ui

	# fill in the fields
#	 display_object_data

}





proc get_object_data {} {
# put the text from the text widget into the tcl variable UI
	 global current_object_data

	if { [winfo exists .d] } {
		set current_object_data [$UI(prop_object_data) get 0.0 end-1c]
	}
}


proc disable_object_data {} {
global current_object_url
global current_object_name
global current_object_data
global UI



	set_sensitive FALSE  $UI(current_object_name_entry)
	set current_object_url ""
	set current_object_name ""
	set_object_data ""
	catch { $UI(object_data_message) configure -text "Select a single object to view/edit properties"}

	if { [winfo exists .d] } {
		pack forget $UI(object_properties_frame) $UI(object_properties_frame2) $UI(object_data_frame)
		set_sensitive FALSE $UI(prop_object_data) $UI(prop_object_name) $UI(prop_object_url)
#		set_sensitive FALSE $UI(prop_crease_scale) $UI(prop_crease_button)
	}

	

}

proc enable_object_data {} {
# should only be called when one object is selcted
global current_object_url
global current_object_name
global current_object_data current_crease_angle
global UI
global CURRENT

#puts "enable object data"



	set_sensitive TRUE	$UI(current_object_name_entry)

	set ob [ac3d get_selected_objects]
	set current_object_name  [ac3d object_get_name $ob]


#puts "REFRESHING CURRENT"

	# if properties window exists - check the object type and enable/disable accordingly
	if { [winfo exists .d] } {

		if { ![winfo exists .d] } {
			return;
		}

		set current_object_url	[ac3d object_get_url $ob]

		set_object_data [ac3d object_get_data $ob]
		catch { $UI(object_data_message) configure -text "Editing object properties"}

		set obtype [ac3d object_get_type $ob]
	#puts "object type is $obtype"

#	puts "REFRESHING CURRENT RESOURCES"

		#remove all properties
		pack forget $UI(object_properties_frame) $UI(object_properties_frame2) $UI(object_data_frame)

		# add the core properties
		pack $UI(object_properties_frame) -side top -fill x -padx 5

		if { $obtype == "poly" } {
			pack $UI(object_properties_frame2) -side top -fill x -padx 5
		} else {
			pack forget $UI(object_properties_frame2)
		}
		pack $UI(object_data_frame) -fill both -expand 1

		if { $obtype != "poly" } {


		} else {
			set c [ac3d entity_get_value $ob "crease" ]
			#puts "crease $c"
			set CURRENT(crease_angle) $c
		}

		set loc [ ac3d entity_get_value $ob "loc" ]
		set CURRENT(loc_x) [lindex $loc 0]
		set CURRENT(loc_y) [lindex $loc 1]
		set CURRENT(loc_z) [lindex $loc 2]

		set sub  [ac3d entity_get_value $ob "subdivision_level"]
		set CURRENT(subdiv_level) $sub
	#	puts "subdiv level = $CURRENT(subdiv_level)"

	#set t [ac3d entity_get_class $ob ]
	#puts "entity class $t"

		set CURRENT(showname) [ ac3d entity_get_value $ob, "showname" ]


		set CURRENT(object) $ob

		if { [winfo exists .d] } {
			set_sensitive TRUE $UI(prop_object_data) $UI(prop_object_name) $UI(prop_object_url)
		   }
	}
}
