# AC3D
# Copyright (c) 2008, Inivis Limited. All rights reserved.

# TCL stuff to handle editing of palette entries


# popup menu bound to each palette button

menu .palette_menu -tearoff 0
.palette_menu add command -label "Edit material..." -command {create_palette_window  $current_palette_index}
.palette_menu add command -label "Select surfaces with this material" -command {ac3d select_surfaces_by_material $current_palette_index }
.palette_menu add command -label "Append new material" -command "new_palette_entry"



proc popup_palette_menu { x y entry colindex} {
global current_palette_edit select_mode current_palette_index

#puts "popup_palette_menu $entry $colindex"

	if { ($select_mode == "surface") || ($select_mode == "vertex") } {
		.palette_menu entryconfigure 1 -state normal
	} else {
		.palette_menu entryconfigure 1 -state disabled
	}

    set current_palette_edit $entry
	set current_palette_index $colindex
    tk_popup .palette_menu $x $y

}


proc add_palette_button { colrgb colindex } {
#global .palette_frame.canvas
global tcl_platform ac_platform
global cp ac_platform
global UI

    set parent $UI(palette_inner_frame)

    set newname [ format "$parent.%04d" $colindex ]
#puts "ADD_PALETTE BUTTON $colrgb $colindex"

	if {$tcl_platform(platform) == "windows"} {
		button $newname -text $colindex -background $colrgb \
			-command "ac3d set_col $colindex" -bd 1 -padx 0 -pady 0 \
			-activebackground $colrgb -highlightthickness 0\
			-bitmap "" -default disabled
		$newname configure -width 3 -height 1

	} else {

		if { $ac_platform == "Mac" } {
			label $newname -background $colrgb -width 3 -height 1 -bd 1 -text $colindex -relief raised
			bind $newname <Button-1> "$newname configure -relief sunken"
			bind $newname <ButtonRelease-1> "ac3d set_col $colindex; $newname configure -relief raised"
			} else {
    
			button $newname -text $colindex -background $colrgb \
				-command "ac3d set_col $colindex" -bd 1 -padx 0 -pady 0 \
				-activebackground $colrgb -highlightthickness 0\
				-bitmap ""
			$newname configure -width 3 -height 1
		}

	}

    
    pack $newname -side left -in $parent

#update
    set width [winfo reqwidth $newname]
    set height [winfo reqheight $newname ]
#puts "$width $height"

    set newwidth "[expr ($width * ($colindex + 1))]"
#puts "newwidth $newwidth"

    $parent configure -width $newwidth
    set region  "0 0 $newwidth 0"

	$UI(palette_canvas) configure -scrollregion $region


    bind $newname <3> "popup_palette_menu %X %Y %W $colindex" 
    bind $newname <2> "popup_palette_menu %X %Y %W $colindex" 


	# on the mac, make control+mouse button do the same as button3
    if { $ac_platform == "Mac" } {
		bind $newname <Control-ButtonPress-1> {event generate %W <ButtonPress-3> \
		-x %x -y %y -rootx %X -rooty %Y -button 3 -time %t}
	}

    add_balloon $newname "Set all selected surfaces to this col\n(right click for a popup menu)"

#mac needs this update to make the palette buttons show when AC3D starts
update idletasks
}




proc remove_palette_button { id } {
# called from inside AC3D when a material is removed
# umm, not yet implemented...

	set p [get_palette_button_path id]

	# need to remove the button and renumber the others... yuk
}









proc new_palette_entry { } {
global current_palette_edit UI

    # extract the number of the palette entry from the end of the buttns name
    # there must be an easier way of doing this...
    set buttonid [ string range $current_palette_edit [expr [ string length $UI(palette_inner_frame)]+1] end ]

    ac3d new_palette_entry $buttonid
}


set SCALEWIDTH 9



proc create_scaleXXX { name text entry} {
global SCALEWIDTH UI

    set len 5c
    set res 0.0039215686
    scale $name -width $SCALEWIDTH -label $text -from 0.0 -to 1.0 -length $len -orient horizontal -command "newcolour $entry" -resolution $res
}



proc get_palette_button_path { id} {
global UI

    set palframe $UI(palette_inner_frame)
    set palbuttonname [ format "$palframe.%04d" $id ]
	return $palbuttonname
}



proc newcolourXXX { index value } {
global prefs_realtimecolour
global progset
global current_palette_edit UI

    set index $current_palette_edit

#puts $index
        
        if { $progset == 0} {
          show_col_on_palbutton
          if { $prefs_realtimecolour} {
            ac3d set_palette_entry $index [.c.f1.diffuse_red get ] [.c.f1.diffuse_green get ]  [.c.f1.diffuse_blue get]\
                [.c.f2.ambient_red get ] [.c.f2.ambient_green get ]  [.c.f2.ambient_blue get] \
                [.c.f3.emissive_red get] [.c.f3.emissive_green get] [.c.f3.emissive_blue get]  \
                [.c.f4.specular_red get] [.c.f4.specular_green get] [.c.f4.specular_blue get] \
                [.c.f5.shininess get] [.c.f5.transparency get]
            ac3d redraw_3d
          }
        }

    } 

proc show_col_on_palbutton {} {

global current_palette_edit
global cp
global UI


    set palframe $UI(palette_inner_frame)

	set palbuttonname [get_palette_button_path $current_palette_edit]

#puts $palbuttonname

# perhaps average out diff/amb/emm for a better approximation for button????

    set r  [expr int([.c.f1.diffuse_red get ] * 255)]
    set g  [expr int([.c.f1.diffuse_green get ] * 255)]
    set b  [expr int([.c.f1.diffuse_blue get ] * 255)]
        
    set col  [format #%02x%02x%02x $r $g $b ]
        
    $palbuttonname configure  -background $col -activebackground $col

}

  
proc okpal { } {
global current_palette_edit current_palette_edit_name

    set index $current_palette_edit

	set mat [ac3d palette_get_material $index]
	set res [ ac3d entity_set_value $mat "name" $current_palette_edit_name]
}



# called when a coloured button e.g. diffuse is pressed - brings up system rgb col editor
proc material_edit_col { entry resname button} {
global prefs_realtimecolour

	set mat [ac3d palette_get_material $entry]
	set rgb [ ac3d entity_get_value $mat $resname]

	set deccol [rgbstring2dec $rgb]
	
	set color [tk_chooseColor -title "Material $entry $resname" -parent $button -initialcolor $deccol] 
#	puts "col $color"
	
	if {$color != "" } {
#		puts "set col on button and redraw views"
		
		if { $resname == "diffuse" } {
			set palbuttonname [get_palette_button_path $entry]
			$palbuttonname configure -background $color -activebackground $color
		}
		
		#set col on popup button
		$button configure -bg $color
		 
		set float3 [rgb2dec $color]
		scan $color "#%2x%2x%2x" r g b  
#		puts "RGB $r $g $b"
		set rf [expr $r/255.0]
		set gf [expr $g/255.0]
		set bf [expr $b/255.0]
#		puts "RGBF $rf $gf $bf"

	ac3d entity_set_value $mat $resname "$rf $gf $bf"
	palette_fill_values $entry	

	if { $prefs_realtimecolour } {
		ac3d redraw_all	
	}
	
	}
}



proc set_mat_from_rgb_slider { entry resourcename } {

	set mat [ac3d palette_get_material $entry]
	# update entity values from slider settings
	
	set r [$PALETTE($resourcename:rscale) get]
	set g [$PALETTE($resourcename:gscale) get]
	set b [$PALETTE($resourcename:bscale) get]

	set rgbstr "$r $g $b"
	ac3d entity_set_value $mat $resourcename $rgbstr
}



proc palette_slider_moved { resourcename sliderval} {
global PALETTE prefs_realtimecolour current_palette_entry

	set mat [ac3d palette_get_material $current_palette_entry]
	# update entity values from slider settings
	
	set r [$PALETTE($resourcename:rscale) get]
	set g [$PALETTE($resourcename:gscale) get]
	set b [$PALETTE($resourcename:bscale) get]

	set rgbstr "$r $g $b"
	ac3d entity_set_value $mat $resourcename $rgbstr
	
	# update button col
	set buttoncol [rgbstring2dec $rgbstr]
	$PALETTE($resourcename:button) configure -bg $buttoncol		
				
	if {$resourcename == "diffuse" } {
		set palbuttonname [get_palette_button_path $current_palette_entry]
		$palbuttonname configure -background $buttoncol -activebackground $buttoncol
	}
	
	if { $prefs_realtimecolour } {
		ac3d redraw_all	
	}
}



set palette_window_rows 1

# adds a single colour RGB entry e.g. emissive to the palette window

proc add_palette_window_col { entry resourcename labeltext top} {
global palette_window_rows SCALEWIDTH PALETTE current_palette_entry

	label $top.label$resourcename -text $labeltext

	set tf [frame $top.frame$resourcename]

	set PALETTE($resourcename:button) [cbutton $tf.button$resourcename "       " "material_edit_col \$current_palette_entry $resourcename $tf.button$resourcename" ]
	pack $PALETTE($resourcename:button) -side left -anchor nw

	grid $top.label$resourcename -row $palette_window_rows -column 0 -sticky ne 
	grid $tf -row $palette_window_rows -column 1 -sticky nw 

	set f [ Fold:create $tf.fold$resourcename ]
	set cont [Fold:get_container $f]
	set sr [scale $cont.r  -width $SCALEWIDTH -from 0.0 -to 1.0 -length 5c -orient horizontal -resolution 0.0039215686]
	set sg [scale $cont.g  -width $SCALEWIDTH -from 0.0 -to 1.0 -length 5c -orient horizontal -resolution 0.0039215686]
	set sb [scale $cont.b  -width $SCALEWIDTH -from 0.0 -to 1.0 -length 5c -orient horizontal -resolution 0.0039215686]

	label $cont.rl -text "R"
	label $cont.gl -text "G"
	label $cont.bl -text "B"

	grid $cont.rl -row 0 -column 0
	grid $cont.gl -row 1 -column 0
	grid $cont.bl -row 2 -column 0


	grid $sr -row 0 -column 1
	grid $sg -row 1 -column 1
	grid $sb -row 2 -column 1
	
	pack $f -side left
	

	set PALETTE($resourcename:rscale) $sr
	set PALETTE($resourcename:gscale) $sg
	set PALETTE($resourcename:bscale) $sb

	$PALETTE($resourcename:rscale) configure -command "palette_slider_moved $resourcename"
	$PALETTE($resourcename:gscale) configure -command "palette_slider_moved $resourcename"
	$PALETTE($resourcename:bscale) configure -command "palette_slider_moved $resourcename"
	
	
	incr palette_window_rows
}


proc palette_fill_values { entry } {
# read values from AC3D material and set the button colos and slider values
global PALETTE current_palette_entry

	set mat [ac3d palette_get_material $entry]
	set name [ ac3d entity_get_value $mat name]
	
	proc fill_resource { mat resourcename } {
	# fill for one named (rgbized) resource 
	global PALETTE
		set rgb [ ac3d entity_get_value $mat $resourcename]
		set buttoncol [rgbstring2dec $rgb]
		
		# set the col on the button
		$PALETTE($resourcename:button) configure -bg $buttoncol 		
		set	r [lindex $rgb 0]
		set g [lindex $rgb 1]
		set b [lindex $rgb 2]

		# set the values on the scale widgets
		$PALETTE($resourcename:rscale) set $r
		$PALETTE($resourcename:gscale) set $g
		$PALETTE($resourcename:bscale) set $b
	}
	
	fill_resource $mat "diffuse"
	fill_resource $mat "ambient"
	fill_resource $mat "emissive"
	fill_resource $mat "specular"
	
	set trans [ ac3d entity_get_value $mat "transparency"]
	$PALETTE(transparency:scale) set $trans
	
	set shi [ ac3d entity_get_value $mat "shininess"]
	$PALETTE(shininess:scale) set $shi	
}


proc Fold:refresh { w } {
global FOLD

	set cs $FOLD($w:state)
	if { $cs == 1 } {
		pack $FOLD($w:subframe) -side left -expand 1 -fill both
	} else {
		pack forget $FOLD($w:subframe) 

	}

}

proc Fold:change_state { w } {
global FOLD

	if { $FOLD($w:state) == 0 } {
		set FOLD($w:state) 1
		$FOLD($w:button) configure -text " - "
	} else {
		set FOLD($w:state) 0
		$FOLD($w:button) configure -text " + "
	}
	
	Fold:refresh $w	
}


proc Fold:create { window { text "" } } {
global FOLD

	set f [frame $window]
	set FOLD($window:state) 0
	set FOLD($window:topframe) [frame $window.topf]
	pack $FOLD($window:topframe) -side top -fill x -expand 1
	
	set FOLD($window:button) [cbutton $window.topf.b " + " "Fold:change_state $window"]
	set FOLD($window:label) [label $window.topf.label -text $text]
	pack $FOLD($window:button) -side left -expand 0
	pack $FOLD($window:label) -side left 
	pack $FOLD($window:topframe) -side top -fill x -expand 1

	set FOLD($window:subframe) [frame $window.subframe]

	Fold:refresh $window
	return $window
}

proc Fold:get_container { w } {
global FOLD
	return $FOLD($w:subframe)
}

proc Fold:is_folded { w } {
global FOLD
	return !$FOLD($w:state)
}


proc palette_shininess_slider_moved { value } {
global PALETTE prefs_realtimecolour current_palette_entry

	set mat [ac3d palette_get_material $current_palette_entry]
	ac3d entity_set_value $mat shininess $value 

	if { $prefs_realtimecolour } {
		ac3d redraw_all	
	}
	
}


proc palette_transparency_slider_moved { value } {
global PALETTE prefs_realtimecolour current_palette_entry

	set mat [ac3d palette_get_material $current_palette_entry]
	ac3d entity_set_value $mat transparency $value 

	if { $prefs_realtimecolour } {
		ac3d redraw_all	
	}
}

proc palette_name_changed { } {
global PALETTE prefs_realtimecolour current_palette_entry current_palette_edit_name

	set mat [ac3d palette_get_material $current_palette_entry]
	ac3d entity_set_value $mat name $current_palette_edit_name
}


proc create_palette_window { entry } {
global prefs_realtimecolour SCALEWIDTH ac_platform
global prefs_allow_material_rename palette_window_rows
global current_palette_edit_name PALETTE current_palette_entry

	set mat [ac3d palette_get_material $entry]
	set rgb [ ac3d entity_get_value $mat diffuse]
	set name [ ac3d entity_get_value $mat name]
	set current_palette_edit_name $name
	set current_palette_entry $entry
	
if { ![winfo exists .c] } {
	set title "Edit material $entry"
    new_toplevel .c $title
    .c configure -borderwidth 6
    
	label .c.namelabel -text "Name: "
	
	
	entry  .c.name -textvariable current_palette_edit_name
	bind  .c.name <KeyRelease> { palette_name_changed }

	if { $prefs_allow_material_rename } {
	    grid .c.namelabel -column 0 -row 0 -sticky e
	    grid .c.name -column 1 -row 0  -sticky we
	} else {
		grid remove .c.namelabel
		grid remove .c.name
	}
	
	add_palette_window_col $entry "diffuse" "Diffuse " .c
	add_palette_window_col $entry "ambient" "Ambient " .c
	add_palette_window_col $entry "emissive" "Emissive " .c
	add_palette_window_col $entry "specular" "Specular " .c

	label .c.shininesslabel -text "Shininess"
    scale .c.shininess  -width $SCALEWIDTH  -label "" -from 0.0 -to 128.0 -length 5c -orient horizontal  -resolution 1 \
		-command { palette_shininess_slider_moved }
	
	set PALETTE(shininess:scale) .c.shininess
			
	label .c.transparencylabel -text "Transparency"
    scale .c.transparency  -width $SCALEWIDTH -label "" -from 0.0 -to 1.0 -length 5c -orient horizontal -resolution 0.0039215686 \
		-command { palette_transparency_slider_moved}	
	
	set PALETTE(transparency:scale) .c.transparency
	
	grid .c.shininesslabel -row $palette_window_rows -column 0 -sticky e
	grid .c.shininess -row $palette_window_rows -column 1
	incr palette_window_rows
	
	grid .c.transparencylabel -row $palette_window_rows -column 0  -sticky e
	grid .c.transparency -row $palette_window_rows -column 1
	incr palette_window_rows

	checkbutton .c.realtimeupdate -text "Realtime update " -variable prefs_realtimecolour
	add_balloon .c.realtimeupdate "Redraw the AC3D views everytime an update to the material is made?"
	grid .c.realtimeupdate -row $palette_window_rows -column 0  -sticky e
	
    frame .c.f
    button .c.f.close -text "Close" -command "okpal; wm withdraw .c; grab release .c; ac3d redraw_all"
    grid .c.f.close -row $palette_window_rows -column 1
    grid .c.f -row $palette_window_rows -column 1 -columnspan 2
       
    centre_window_on_screen .c
    } else {
    	set title "Edit material $entry"
    	wm title .c $title
		wm deiconify .c
	}
	
    palette_fill_values $entry

    #added update for Mac - sometimes a blank window popped up
    update idletasks
   
#	grab .c
    
}






# rgb2dec --
#
#   Turns #rgb into 3 elem list of decimal vals.
#
# Arguments:
#   c		The #rgb hex of the color to translate
# Results:
#   Returns a #RRGGBB or #RRRRGGGGBBBB color
#
proc rgb2dec c {
    set c [string tolower $c]
    if {[regexp -nocase {^#([0-9a-f])([0-9a-f])([0-9a-f])$} $c x r g b]} {
	# double'ing the value make #9fc == #99ffcc
	scan "$r$r $g$g $b$b" "%x %x %x" r g b
    } else {
	if {![regexp {^#([0-9a-f]+)$} $c junk hex] || \
		[set len [string length $hex]]>12 || $len%3 != 0} {
	    if {[catch {winfo rgb . $c} rgb]} {
		return -code error "bad color value \"$c\""
	    } else {
		return $rgb
	    }
	}
	set len [expr {$len/3}]
    	scan $hex "%${len}x%${len}x%${len}x" r g b
    }
    return [list $r $g $b]
}

# dec2rgb --
#
#   Takes a color name or dec triplet and returns a #RRGGBB color.
#   If any of the incoming values are greater than 255,
#   then 16 bit value are assumed, and #RRRRGGGGBBBB is
#   returned, unless $clip is set.
#
# Arguments:
#   r		red dec value, or list of {r g b} dec value or color name
#   g		green dec value, or the clip value, if $r is a list
#   b		blue dec value
#   clip	Whether to force clipping to 2 char hex
# Results:
#   Returns a #RRGGBB or #RRRRGGGGBBBB color
#
proc dec2rgb {r {g 0} {b UNSET} {clip 0}} {
    if {![string compare $b "UNSET"]} {
	set clip $g
	if {[regexp {^-?(0-9)+$} $r]} {
	    foreach {r g b} $r {break}
	} else {
	    foreach {r g b} [winfo rgb . $r] {break}
	}
    } 
    set max 255
    set len 2
    if {($r > 255) || ($g > 255) || ($b > 255)} {
	if {$clip} {
	    set r [expr {$r>>8}]; set g [expr {$g>>8}]; set b [expr {$b>>8}]
	} else {
	    set max 65535
	    set len 4
	}
    }
    return [format "#%.${len}X%.${len}X%.${len}X" \
	    [expr {($r>$max)?$max:(($r<0)?0:$r)}] \
	    [expr {($g>$max)?$max:(($g<0)?0:$g)}] \
	    [expr {($b>$max)?$max:(($b<0)?0:$b)}]]
}

# shade --
#
#   Returns a shade between two colors
#
# Arguments:
#   orig	start #rgb color
#   dest	#rgb color to shade towards
#   frac	fraction (0.0-1.0) to move $orig towards $dest
# Results:
#   Returns a shade between two colors based on the
# 
proc shade {orig dest frac} {
    if {$frac >= 1.0} { return $dest } elseif {$frac <= 0.0} { return $orig }
    foreach {origR origG origB} [rgb2dec $orig] \
	    {destR destG destB} [rgb2dec $dest] {
	set shade [format "\#%02x%02x%02x" \
		[expr {int($origR+double($destR-$origR)*$frac)}] \
		[expr {int($origG+double($destG-$origG)*$frac)}] \
		[expr {int($origB+double($destB-$origB)*$frac)}]]
	return $shade
    }
}

# complement --
#
#   Returns a complementary color
#   Does some magic to avoid bad complements of grays
#
# Arguments:
#   orig	start #rgb color
# Results:
#   Returns a complement of a color
# 
proc complement {orig {grays 1}} {
    foreach {r g b} [rgb2dec $orig] {break}
    set R [expr {(~$r)%256}]
    set G [expr {(~$g)%256}]
    set B [expr {(~$b)%256}]
    if {$grays && abs($R-$r) < 32 && abs($G-$g) < 32 && abs($B-$b) < 32} {
	set R [expr {($r+128)%256}]
	set G [expr {($g+128)%256}]
	set B [expr {($b+128)%256}]
    }
    return [format "\#%02x%02x%02x" $R $G $B]
}



proc make_palette { w } {
	global UI

	set UI(palette_frame) $w
	set UI(palette_inner_frame) [ ScrolledHorizCanvas $UI(palette_frame) 10 18 {0 0 1000 0} ]
	set UI(palette_canvas) $UI(palette_frame).canvas
	
#puts "palette $UI(palette_frame) $UI(palette_inner_frame)"

#	frame $w.palstuff
#	label $w.palstuff.current -text 0 -width 4
#	button $w.palstuff.set -text Set
#	button $w.palstuff.edit -text Edit...
#	pack $w.palstuff.current $w.palstuff.set $w.palstuff.edit -side left
#	pack $w.palstuff -side bottom

	return $w
}















