# AC3D
# Copyright (c) 2008, Inivis Limited. All rights reserved.


proc add_import_menu_item { label command } {
global UI

    $UI(menu_import) add command -label $label -command $command
}

proc add_export_menu_item { label command } {
global UI

    $UI(menu_export) add command -label $label -command $command
}

proc add_tools_menu_item { label command help } {
global balloon_menu_help UI

    $UI(menu_tools)  add command -label $label -command $command
    set balloon_menu_help(.mbar.tools.menu) [concat $balloon_menu_help(.mbar.tools.menu) "{ $help }"]
}

proc add_surface_menu_item { label command help} {
global balloon_menu_help UI

    $UI(menu_surface) add command -label $label -command $command
    set balloon_menu_help($UI(menu_surface)) [concat $balloon_menu_help($UI(menu_surface)) "{ $help }"]
}


proc add_vertex_menu_item { label command help} {
global balloon_menu_help UI

    $UI(menu_vertex) add command -label $label -command $command
    set balloon_menu_help($UI(menu_vertex)) [concat $balloon_menu_help($UI(menu_vertex)) "{ $help }"]
}


proc add_object_menu_item { label command help} {
global balloon_menu_help UI

    $UI(menu_object) add command -label $label -command $command
    set balloon_menu_help($UI(menu_object)) [concat $balloon_menu_help($UI(menu_object)) "{ $help }"]
}




proc get_ac3d_path { name } {
global prefs_plugin_dir
global AC3D_HOME

    if { $name == "plugins" } {
        return [eval "set temp $prefs_plugin_dir"]
    }
    return name
}




proc load_plugins { } {

set path [get_ac3d_path plugins]

    set oldd [pwd]
    set e [ catch { cd $path} ]

    if { $e } {
        puts "can't change to plugin dir '$path'"
    } else {
        set pwd [pwd]
        set plist ""
        catch { set plist [ glob *.p] }
puts $plist
        foreach p $plist {
            ac3d plugin_load "$path/$p"
            }
    }
    cd $oldd
}



ac3d add_pref window_geom_replcator ""


proc menu_replicator {} {
global rep_num rotx roty rotz movex movey movez scalex scaley scalez about replicator_dup
global ac_platform

if ![winfo exists .replicator] {

    new_toplevel_tracked .replicator "AC3D Replicator" prefs_window_geom_replcator
    set p .replicator

    label $p.l1 -text " "
	grid $p.l1 -row 0 -column 0 -columnspan 2

    set rep_num 1
    set rotx 0
    set roty 0
    set rotz 0
    set movex 0
    set movey 0
    set movez 0
    set scalex 1.0
    set scaley 1.0
    set scalez 1.0
	# rotate about origin as default
    set about 2
	set replicator_dup duplicate

	set padx 10
	set ipadx 0

    frame $p.num
    label $p.lab -text "Copies"
	grid $p.lab -row 1 -column 0 -sticky e -padx $padx -ipadx $ipadx
	spinbox $p.num.val -textvariable rep_num -from 1 -to 999 -increment 1 -width 4
    pack $p.num.val -side left
    grid $p.num -row 1 -column 1  -sticky w -padx $padx -ipadx $ipadx


	frame $p.dup
	label $p.dupl -text "Mode"
	grid $p.dupl -row 2 -column 0
	radiobutton $p.dup.d -text "Duplicate" -variable replicator_dup -value duplicate
	radiobutton $p.dup.d2 -text "Extrude" -variable replicator_dup -value extrude
	grid $p.dup.d -row 1 -column 0
	grid $p.dup.d2 -row 1 -column 1
	grid $p.dup -row 2 -column 1

    frame $p.move
    label $p.lab2 -text "Translation (m)"
    grid $p.lab2 -row 3 -column 0  -sticky e -padx $padx -ipadx $ipadx

    entry  $p.move.x -relief sunken -bd 2 -textvariable movex  -width 5
    pack $p.move.x -side left

    entry  $p.move.y -relief sunken -bd 2 -textvariable movey  -width 5
    pack $p.move.y -side left

    entry  $p.move.z -relief sunken -bd 2 -textvariable movez  -width 5
    pack $p.move.z -side left
   
    grid $p.move -row 3 -column 1 -sticky w -padx $padx -ipadx $ipadx



    frame $p.rot
    label $p.lab3 -text "Rotation (degrees)"
    grid $p.lab3 -row 4 -column 0 -sticky e -padx $padx -ipadx $ipadx

    entry  $p.rot.x -relief sunken -bd 2 -textvariable rotx -width 5
    pack $p.rot.x -side left

    entry  $p.rot.y -relief sunken -bd 2 -textvariable roty -width 5
    pack $p.rot.y -side left

    entry  $p.rot.z -relief sunken -bd 2 -textvariable rotz  -width 5
    pack $p.rot.z -side left

    grid $p.rot -row 4 -column 1 -sticky w -padx $padx -ipadx $ipadx


    frame $p.about
    label $p.lab4 -text "Rotate about"
    grid $p.lab4 -row 5 -column 0 -sticky ne -padx $padx -ipadx $ipadx

    radiobutton $p.about.sel -text "Selection" -variable about -value 0
    radiobutton $p.about.cur -text "3D Cursor" -variable about -value 1
    radiobutton $p.about.ori -text "Origin" -variable about -value 2
    pack $p.about.ori $p.about.sel $p.about.cur  -side left

    grid $p.about -row 5 -column 1 -sticky w -padx $padx -ipadx $ipadx


    frame $p.scale
    label $p.lab5 -text "Scale"
	grid $p.lab5 -row 6 -column 0 -sticky e -padx $padx -ipadx $ipadx

    entry  $p.scale.x -relief sunken -bd 2 -textvariable scalex -width 5
    pack $p.scale.x -side left
  
    entry  $p.scale.y -relief sunken -bd 2 -textvariable scaley -width 5
    pack $p.scale.y -side left

    entry  $p.scale.z -relief sunken -bd 2 -textvariable scalez  -width 5
    pack $p.scale.z -side left

    grid $p.scale -row 6 -column 1 -sticky w -padx $padx -ipadx $ipadx

#separator $p.sep
#pack $p.sep

frame $p.bf

    button $p.bf.replicate -text "Go" \
        -command send_replicate;

    button $p.bf.close -text "Close" -command "wm withdraw $p"

     pack $p.bf.replicate  -side left -expand 1 -padx 3m -pady 2m
     pack  $p.bf.close -side left -expand 1 -padx 3m -pady 2m

	grid $p.bf -row 7 -column 0 -columnspan 2


  proc send_replicate {} {
  global dest
global rep_num
global rotx
global roty
global rotz
global movex
global movey
global movez
global scalex
global scaley
global scalez
global about replicator_dup
global select_mode prefs_extrude_cap_end
global prefs_allow_redraws

	if { ( $replicator_dup == "extrude" ) && ( ($select_mode != "surface") && ($select_mode != "vertex") ) } {
			tk_messageBox -type ok -title "AC3D replicator" -message \
				"Extruding works only in Surface or Vertex select mode.\n\nPlease change the select mode."

			return;
	}




    for { set n 0 } { $n < $rep_num } { incr n } {
        
set prefs_allow_redraws false
			if { $replicator_dup == "duplicate" } {
				ac3d clone_selection
			} else {
				set tempcap $prefs_extrude_cap_end
				set prefs_extrude_cap_end true
				# hack - set extrude dist to very small number so vertices aren't all optimized
				ac3d extrude_dist 0.0001 0.0001 0.0001 1
				set prefs_extrude_cap_end $tempcap
			}

			if { ( ($movex != 0 ) || ($movey != 0) || ($movez != 0)) } {
				ac3d move $movex $movey $movez
			}

        if {$about == 0} {
			if { ( ($rotx != 0 ) || ($roty != 0) || ($rotz != 0)) } {
	            ac3d rotate $rotx $roty $rotz
			}
        } elseif {$about == 1} {
			if { ( ($rotx != 0 ) || ($roty != 0) || ($rotz != 0)) } {
	            set cursor [ac3d get_3d_cursor]
		        ac3d rotate_about $rotx $roty $rotz [lindex $cursor 0] [lindex $cursor 1] [lindex $cursor 2]
			}
        } else {
			if { ( ($rotx != 0 ) || ($roty != 0) || ($rotz != 0)) } {
	            ac3d rotate_about $rotx $roty $rotz 0 0 0
			}
        } 
        
		if { ( ($scalex != 1.0 ) || ($scaley != 1.0) || ($scalez != 1.0)) } {
			ac3d scale $scalex $scaley $scalez;
		}

		set prefs_allow_redraws true
		ac3d redraw_all
	}


    ac3d redraw_all

  }

}  else {
    wm deiconify .replicator
    raise .replicator
}
#    centre_window_on_screen .replicator


}



proc dialog_rotate {} {
global rotator_rotx rotator_roty rotator_rotz

    set p .rotator

    if ![winfo exists .rotator] {

        set rotator_rotx 0
        set rotator_roty 0
        set rotator_rotz 0

        new_toplevel $p "Rotate"

        frame $p.rot
        label $p.rot.lab -text "Rotation (degrees)"
        pack $p.rot.lab -side left

        entry  $p.rot.x -relief sunken -bd 2 -textvariable rotator_rotx -width 8
        pack $p.rot.x -side left

        entry  $p.rot.y -relief sunken -bd 2 -textvariable rotator_roty -width 8
        pack $p.rot.y -side left

        entry  $p.rot.z -relief sunken -bd 2 -textvariable rotator_rotz  -width 8
        pack $p.rot.z -side left

        pack $p.rot

        frame $p.bf
        button $p.bf.rotate -text "Rotate" \
            -command { ac3d rotate [expr $rotator_rotx] [expr $rotator_roty]  [expr $rotator_rotz]; ac3d redraw_all }

        button $p.bf.close -text "Close" -command "wm withdraw $p"

        pack $p.bf.rotate  -side left
        pack  $p.bf.close -side left

        pack $p.bf -side top
        centre_window_on_screen $p

    }  else {
        wm deiconify $p
        raise $p
    }

    focus $p.rot.x
}



proc process_user_scripts { } {
# called at AC3D main startup - sources any *.tcl files

	#look in the 'scripts' directory within the AC3D installation.
	set path scripts

	if { ! [file exists scripts] } {
#		puts "no user script dir"
		return 1
	} else {
#		puts "user scripts dir found"
	}

    set oldd [pwd]
    set e [ catch { cd $path} ]

    if { $e } {
        puts "can't change to user script dir '$path'"
		return 0
    } else {
        set pwd [pwd]
        set plist ""
        catch { set plist [ glob *.tcl] }
		set plist [lsort $plist]

        foreach p $plist {
			puts "running user script $path/$p"
			
			if {[catch {uplevel #0 [list source $p]} msg]} {
				puts "$path/$p: $msg\n"
			}


#            set f [ catch { source "$p" } ]

            }
    }
    cd $oldd

	return 1
}































