# AC3D
# Copyright (c) 2008, Inivis Limited. All rights reserved.






proc do_render { } {
global prefs_render_command_new render_desc_list render_id_list UI prefs_render_command_param
global prefs_render_filename prefs_render_type prefs_render_command_new
global ac_platform

	if { [file exists $prefs_render_command_new] == 0 } {
		set result "The render program:\n$prefs_render_command_new\ndoes not exist or is not accessable.\nPlease set render program above."
		return $result
		}

	set result "Exporting $prefs_render_filename"

		set res [ac3d exporter_write_file $prefs_render_type $prefs_render_filename]

		if { $res != "OK" } {
			set result "$result\n$res"
			return $result;
		} else {
			set result "$result\nOK"
		}


		# if render command is not empty, look for %s and replace %s with the render_filename

		if { $prefs_render_command_param != "" } {
			regsub -all %s $prefs_render_command_param $prefs_render_filename ns
		} else {
			set ns ""
		}

		if { $ac_platform == "Windows" } {
			# to replace \ with \\ and backslash quotes
			regsub -all {[\]\[""\\$]} $prefs_render_command_new {\\&} command_slashed
			regsub -all {[\] [\ $]} $ns {\\&} param_slashed
			set commandline "exec  \"$command_slashed\" $param_slashed & "
		} elseif {$ac_platform == "Mac" } {
			# for old carbon programs? set carboncom "/System/Library/Frameworks/Carbon.framework/Versions/Current/Support/LaunchCFMApp"
			set carboncom open
			regsub -all " " $prefs_render_command_new "\\ " command_slashed
 			set commandline "$carboncom $command_slashed $ns"
       } else {
			set commandline "exec \"$prefs_render_command_new\" $ns & "
		}

puts "command line:\n$commandline"

		set result "$result\nExecuting: $commandline"

	if { $ac_platform == "Mac" } {
		ac3d execute "$commandline"
	} else {
		catch { set res [ eval $commandline ] }
	}
#ac3d execute $commandline

		if { $res == "" } { set res "Failed - check program path" }

		set result "$result\nResult: $res"
		return $result
}


proc combobox_changed { c value} {
global combo_value render_desc_list render_id_list prefs_render_type

	set i [lsearch $render_desc_list $combo_value]

	set id [lindex $render_id_list $i]
	set prefs_render_type $id
}



ac3d add_pref window_geom_render ""

proc menu_render { } {
global prefs_render_command render_desc_list render_id_list UI
global prefs_render_filename prefs_render_type prefs_render_command_new
global ac_platform

    new_toplevel_tracked .render "Render" prefs_window_geom_render

	frame .render.f
	pack .render.f -side top -fill both -expand 1

	set render .render.f

	set ids [ac3d exporters_get_names]
	set descs [ac3d exporters_get_descs]

	set render_desc_list $descs
	set render_id_list $ids

	set width 60

#puts "ids $ids"

#source tcl/combobox.tcl
#package require combobox 2.2
catch {namespace import combobox::*}


	combobox $render.exporterid -editable false -textvariable combo_value -command "combobox_changed"

	eval $render.exporterid  list insert end $descs

	set current 1
	catch {set current [lsearch $ids $prefs_render_type]} { set current 1 }

	$render.exporterid select $current


    label $render.ftlabel -text "Output file type:"
	add_balloon $render.ftlabel "Selects the type of file that AC3D will generate"

    label $render.fnamelabel -text "Output filename:"
    entry $render.filename -relief sunken -bd 2 -width $width -textvariable prefs_render_filename
	add_balloon $render.fnamelabel "The name of the file that is generated by AC3D and is then passed to the render command"
	button $render.fnamebrowse -text "Browse..." -command {
		set res [tk_getSaveFile -title "Select output filename" -initialfile $prefs_render_filename -parent .render]
		if {$res != "" } {
			if { $ac_platform == "Windows" } {
				regsub -all "/" $res {\\} res 
			}

			set prefs_render_filename $res

		}
	}
	grid $render.fnamebrowse -row 2 -column 4 -sticky w


    grid $render.ftlabel -row 0 -column 0  -sticky e
    grid $render.exporterid -row 0 -column 1 -sticky w
	grid $render.fnamelabel -row 2 -column 0 -sticky e
	grid $render.filename -row 2 -column 1 -sticky w

	label $render.commandlabel -text "Render program:"
	grid $render.commandlabel -row 3 -column 0 -sticky e
	add_balloon $render.commandlabel "The command that is executed when 'render' is pressed to start the external render.\nUse a '%s' in the this text to indicate where the filename is to be inserted."
    entry $render.command -relief sunken -bd 2 -width $width -textvariable prefs_render_command_new
	grid $render.command -row 3 -column 1 -sticky we

	button $render.commandbrowse -text "Browse..." -command {
#		set res [tk_getOpenFile -title "Select render program" -initialfile $prefs_render_command_new -parent .render]
		set res [tk_getOpenFile -title "Select render program"  -parent .render]
		if {$res != "" } {
			if { $ac_platform == "Windows" } {
				regsub -all "/" $res {\\} res 
			}
			set prefs_render_command_new $res
		}
	}

	grid $render.commandbrowse -row 3 -column 4 -sticky w



	label $render.commandplabel -text "Render parameters:"
	grid $render.commandplabel -row 4 -column 0 -sticky e
	add_balloon $render.commandplabel "parameters - use a '%s' in the this text to indicate where the filename is to be inserted."
    entry $render.commandp -relief sunken -bd 2 -width $width -textvariable prefs_render_command_param
	grid $render.commandp -row 4 -column 1 -sticky we


	label $render.tlabel -text "Result:"
	grid $render.tlabel -row 7 -column 0  -sticky we
	text $render.output  -height 5 -width $width
	grid $render.output -row 7 -column 1 -columnspan 2  -sticky we
	add_balloon $render.tlabel "Command line output and status report"

	set UI(renderoutput) $render.output

    button $render.ok -text "Render" -command {
		set res [do_render]
		$UI(renderoutput) delete 0.0 end
		$UI(renderoutput) insert end $res
		}

	set srb [ac_checkbutton $render.srb "Show Render button on toolbar"  \
		 { \
			if { $prefs_show_render_button } { \
				pack $UI(renderbutton) -side left \
			} else { \
				pack forget $UI(renderbutton)  \
			 }
		 } prefs_show_render_button ]

	grid $srb -row 8 -column 1 -stick w


    button $render.cancel -text "Close" -command "destroy .render"
    grid $render.ok -row 9 -column 0 -pady 5

    grid $render.cancel -row 9 -column 1


	grid configure $render  -ipadx 10 -ipady 10
	grid columnconfigure $render 0 -weight 20

#    centre_window_on_screen .render

#	focus .render.value
#	grab $render
}


