# AC3D
# Copyright (c) 2008, Inivis Limited. All rights reserved.

set tips { \
"Welcome to AC3D.\nThese tips contain useful information to help you learn more about using AC3D.  For more detailed information see the official AC3D manual (via the Help menu)."\
"For most buttons, you can get popup help by leaving the mouse pointer over them for a second."\
"The status bar (at the bottom of the AC3D window) displays descriptions of the menu functions when you browse the AC3D menus."\
"To copy an image of a view-window to the system clipboard (ready to paste into another program), use the item at the bottom of the Camera menu, on each view."\
"For a description of an input field, get popup help by placing the the mouse pointer over the field label."\
"To undo the last operation use Edit->Undo or press control+z" \
"To redo an operation that was undone, use Edit->Redo (or press control+y, or control+shift+z)"\
"You can use the cursor keys to navigate in the 2D (orthographic) windows.  Hold down shift to move in larger steps."\
"To navigate using the mouse, zoom using the right mouse button and dragging, pan a view by using the middle mouse button and dragging (or Control+right mouse button)."\
"The Orth menu controls the three orthographic (2D) windows. The 3D window is controlled independently via the 3D menu."\
"Use the keyboard shortcuts to change edit mode: 'v' for vertex, 's' for surface, 'o' for object."\
"You can switch between wireframe and filled viewing modes by pressing 'w'."\
"To uniformly scale the selection, hold down the control key whilst dragging a handle."\
"To constrain movement horizontally or vertically, hold down the control key before dragging the selection."\
"To edit the attributes of a material, right click on a colored palette button and select 'Edit...'."\
"When you select a single surface, the index of a material is displayed in the help text (at the bottom of the AC3D window)."\
"When extruding, hold down the control key to constrain the drag movement to either left/right or up/down." \
"Use background images to help you trace accurate shape outlines.  Use View->Orth/3D->Set-Background-image."\
"Adjust the position of background images with Alt+cursor keys.  Use shift+alt and cursor up/down to zoom the image."\
"To turn a polygon into triangles, use Surface->triangulate."\
"After an 'Object->merge' (to put all surfaces and vertices into a single object) select Object->optimize-vertices to remove any duplicates vertices."\
"Press the delete or backspace key to delete the current selection."\
"Clean up objects by removing unused vertices with Object->Optimize vertices"\
"To remove any invalid polygons i.e. polygons with less than 3 vertices (shown as cyan lines), use Object->optimize-surfaces."\
"The text at the top of the control panel displays details about the current selection.  This includes the size and details about the number of objects/surfaces or vertices selected."\
"To find the distance between two points, select two vertices and read the distance from the information box at the top left of the main window"\
"To get information about total number of objects, surfaces and vertices in the current model, use Tools->Model-info."\
"You can store textual information, comments etc for each object - use Tools->Object-property-editor"\
"Use the hide and lock controls on the control panel to temporarily remove obscuring objects. (e.g. if selection becomes difficult because the view is cluttered)"\
"To create a polygon with N sides - make an ellipse with the number of points set to N.  Then set the surface type to Poly." \
"Maximize or minimize the current view by pressing the space key."\
"The panel at the top of AC3D displays information (size etc) about the current selection."\
"Surfaces shown by a red outline have overlapping edges.  Move the vertices to correct this."\
"Cyan lines indicate an invalid polygon (surfaces with 2 vertices).  Remove these by using Object->Optimize surfaces."\
"To zoom in on the selection so it fits into the current view, press the 'f' key."\
"You can align a number of vertices by selecting them and resizing so the selection is flat."\
"The Object Library (from the File menu) allows you to organise, store and retrive individual objects."\
"Visit www.inivis.comfor latest news about AC3D, including new plugins and other resources"\
}

#puts "current TIP $prefs_current_tip"


proc next_tip {} {
global prefs_current_tip
global tips

	if { [ expr $prefs_current_tip + 1 ] >= [llength $tips] } {
		set prefs_current_tip 0 
	} else {
		incr prefs_current_tip
	}	
}

proc prev_tip {} {
global prefs_current_tip
global tips

	if { [ expr $prefs_current_tip -1 ] < 0 } {
		set prefs_current_tip [ expr [llength $tips] -1 ]
	} else {
		incr prefs_current_tip -1
	}	
}

proc set_tip {lab id} {
global tips

	set t [lindex $tips $id]
	$lab delete 0.0 end
	$lab insert end $t
	$lab see end 
}



proc show_tip {} {
global tips
global prefs_current_tip
global prefs_show_startup_tips


	set w [new_toplevel .tip "AC3D Tip"]
	
	label $w.title -text "Did you know...?"
	pack $w.title -side top -fill x
	#
	button $w.close -text "Close" -command "destroy $w; next_tip"
	pack $w.close -side bottom

	frame $w.f
	pack $w.f -side bottom -fill x
	checkbutton $w.f.show -text "Show tips at startup " -variable prefs_show_startup_tips
	pack $w.f.show -side left

	button $w.f.next -text "Next tip" -command { next_tip; set_tip .tip.tip $prefs_current_tip }
	add_balloon $w.f.next "Display the next tip"
	pack $w.f.next -side right

	button $w.f.prev -text "Prev tip" -command { prev_tip; set_tip .tip.tip $prefs_current_tip}
	add_balloon $w.f.prev "Display the previous tip"
	pack $w.f.prev -side right


	text $w.tip -width 50 -height 4 -bd 1 -bg white -wrap word 
	pack $w.tip -side top -fill both -padx 10 -pady 10

	set_tip $w.tip $prefs_current_tip

	centre_window_on_screen $w
	grab $w
}

