# @version: $Id: ttfont.tcl,v 1.4 2008/05/12 08:22:49 ac Exp $
# @author:  Andy Colebourne <andy@ac3d.org>, Rune Madsen <Rune@DataIT.net>

# TTFont TCL code for a dialog that gets lets the user select a true type (or other) font,
# enter text to be rendered, as well as various font parameters.
#
# Note - the standard tk_GetOpenFile dialog doesn't work for selecting fonts in Windows
# because Microsoft in all their wisdom decided nobody should be able to open files in
# the system font directory - it's not just a tcl/tk thing.



proc ttfont_get_fontdir { current } {
	set filename [tk_chooseDirectory -title "Select font folder" \
		    -initialdir $current -mustexist 1 -parent . ]
	return $filename
}


proc ttfont_fill_font_list { w fdir } {

	global fontname
	global fontdir
	global prefs_ttfont_path

	regsub "\\\\" $fdir "/" fdir
	regsub "//+" $fdir "/" fdir
	set fontdir $fdir
	set prefs_ttfont_path $fdir

	set files [glob -nocomplain "$fdir/*.ttf"]
	set list [lsort -dictionary -increasing $files]

	$w delete 0 end

	foreach f $list {
		regsub ".*/" $f "" f
		$w insert end $f
	}
}



proc ttfont_launch_create {} {

	global fontdir
	global fontname
	global fonttext
	global objecttype
	global pointsize
	global extrudedepth
	global beveldepth
	global bevelangle
	global fontdetail

	if { $fontname=="" } {
		tk_messageBox -type ok -title "Text creation error" -message "Please select a font."
		return
	}

	if { $fonttext=="" } {
		tk_messageBox -type ok -title "Text creation error" -message "Please enter text, then click the \"create\" button."
		return
	}

	ac3d ttfont_create_text $fontdir/$fontname $fonttext $objecttype $pointsize $extrudedepth $beveldepth $bevelangle $fontdetail
}


ac3d add_pref window_geom_ttfont ""

proc ttfont_dialog {} {

	global env
	global tcl_platform
	global prefs_ttfont_path

	global ttinitialize
	global fontlistwidget
	global fontdir

	global fonttext
	global objecttype
	global pointsize
	global extrudedepth
	global beveldepth
	global bevelangle
	global fontdetail
	global prefs_window_geom_ttfont
	
	set fontdir $prefs_ttfont_path

	if { $fontdir == "" } {

		if { $tcl_platform(platform) == "windows" } {

			if [ info exists env(windir) ] {
				set fontdir $env(windir)/FONTS
			} elseif [ info exists env(systemroot) ] {
				set fontdir $env(systemroot)/FONTS
			} else {
				set fontdir "c:/windows/fonts"
			}

		} elseif { $tcl_platform(platform) == "unix" } {
			set fontdir "/"
		} else {
			set fontdir ""
		}
	}
	set prefs_ttfont_path $fontdir

	if [info exists ttinitialize] {
		set ttinitialize false
	} else {
		set ttinitialize true
	}

	if ![winfo exists .tt] {

		new_toplevel_tracked .tt "Create TrueType Text" prefs_window_geom_ttfont
#		wm title .tt 
#		wm transient .tt [winfo toplevel [winfo parent .tt]]

		frame .tt.f1
		label .tt.f1.l -text "Font path"
		entry .tt.f1.fontname -textvariable fontdir -width 0
		button .tt.f1.browse -text "Browse..." -command { set fontdirtest [ttfont_get_fontdir $fontdir]; if { $fontdirtest != "" } {set fontdir $fontdirtest ; ttfont_fill_font_list $fontlistwidget $fontdir} }

		bind .tt.f1.fontname <KeyRelease> {
			ttfont_fill_font_list $fontlistwidget $fontdir
		}

		pack .tt.f1.l -side left
		pack .tt.f1.browse -side right -padx 3
		pack .tt.f1.fontname -fill x -expand true

		pack .tt.f1 -side top -expand 0

		# list of files in the font dir
		set f [frame .tt.listframe]

		set fontlistwidget [listbox $f.list -yscrollcommand "$f.yscroll set" -height 8 -width 0 -selectmode single]

		add_balloon $fontlistwidget "Available fonts"

		bind $fontlistwidget <ButtonRelease> {
			set fontname [selection get]
		}

		ttk::scrollbar $f.yscroll -orient vertical -command " $f.list yview "

		pack $f.yscroll -side right -fill y -expand 0
		pack $f.list -side left -fill both -expand 1
		pack $f -fill both -expand 1 -padx 3 -pady 3


		# fill the font list
		ttfont_fill_font_list $fontlistwidget $fontdir


		frame .tt.f2
		frame .tt.f2.a
		frame .tt.f2.b

		label .tt.f2.a.fontl -text "Font"
		entry .tt.f2.a.currentfontname -textvariable fontname
		pack .tt.f2.a.fontl -side left
		pack .tt.f2.a.currentfontname -fill x

		label .tt.f2.b.textl -text "Text"
		entry .tt.f2.b.text -textvariable fonttext
		bind .tt.f2.b.text <Return> { .tt.f9.go flash ; .tt.f9.go invoke }

		add_balloon .tt.f2.a.currentfontname "Selected font"
		add_balloon .tt.f2.b.text "Text to render"

		pack .tt.f2.b.textl -side left 
		pack .tt.f2.b.text -side left -fill x -expand true
		pack .tt.f2.a -side top -fill x
		pack .tt.f2.b -side top -fill x
		pack .tt.f2 -side top -pady 3

		frame .tt.f3

		labelframe .tt.f3.c -text "Object type"
		radiobutton .tt.f3.c.objectoutline -text Outline -value "Outline" -variable objecttype -command { active_options_toggle }
		radiobutton .tt.f3.c.objectsolid -text Solid -value "Solid" -variable objecttype -command { active_options_toggle }
		radiobutton .tt.f3.c.objectextrude -text Extruded -value "Extrude" -variable objecttype -command { active_options_toggle }
		radiobutton .tt.f3.c.objectbevel -text Beveled -value "Bevel" -variable objecttype -command { active_options_toggle }

		add_balloon .tt.f3.c "Choose object type to render"

		labelframe .tt.f3.a -text "Parameters"
		label .tt.f3.a.pointsizel -text "Font size"
		entry .tt.f3.a.pointsize -textvariable pointsize -width 5
		label .tt.f3.a.extrudedepthl -text "Extrude depth"
		entry .tt.f3.a.extrudedepth -textvariable extrudedepth -width 5 -state disabled
		label .tt.f3.a.beveldepthl -text "Bevel depth"
		entry .tt.f3.a.beveldepth -textvariable beveldepth -width 5 -state disabled
		label .tt.f3.a.bevelpct -text "%"
		label .tt.f3.a.bevelanglel -text "Bevel angle"
		spinbox .tt.f3.a.bevelangle -textvariable bevelangle -from "-90" -to 90 -increment 5 -width 5 -state disabled
		label .tt.f3.a.detaill -text "Font detail"
		spinbox .tt.f3.a.detail -textvariable fontdetail -from 1 -to 10 -increment 1 -width 5 -validate all -vcmd { if { "%P"=="" } { return 1 }; catch { if { %P < 1 } { return 0 } }; return 1 }

		add_balloon .tt.f3.a.pointsize "Font point size"
		add_balloon .tt.f3.a.extrudedepth "Extrude depth"
		add_balloon .tt.f3.a.beveldepth "Bevel depth as percentage of extrude depth"
		add_balloon .tt.f3.a.bevelangle "Bevel angle"
		add_balloon .tt.f3.a.detail "Detail level for font"

		pack .tt.f3.c.objectoutline .tt.f3.c.objectsolid .tt.f3.c.objectextrude .tt.f3.c.objectbevel -side top -anchor w
		pack .tt.f3.c -side left -padx 3 -pady 3 -anchor nw

		grid .tt.f3.a.pointsizel .tt.f3.a.pointsize -sticky w
		grid .tt.f3.a.extrudedepthl .tt.f3.a.extrudedepth -sticky w
		grid .tt.f3.a.beveldepthl .tt.f3.a.beveldepth .tt.f3.a.bevelpct -sticky w
		grid .tt.f3.a.bevelanglel .tt.f3.a.bevelangle - -sticky w
		grid .tt.f3.a.detaill .tt.f3.a.detail - -sticky sw

		pack .tt.f3.a -side right -padx 3 -pady 3 -ipadx 2 -ipady 4 -anchor nw

		frame .tt.f9
		button .tt.f9.go -text "Create" -command ttfont_launch_create
		button .tt.f9.stop -text "Close" -command { wm withdraw .tt }
		pack .tt.f9.go .tt.f9.stop -side left -padx 3

		pack .tt.f1 -side top -fill x -expand 0
		pack .tt.f2 -side top -fill x -expand 0
		pack .tt.f3 -side top -fill x -expand 0
		pack .tt.f9 -side top -pady 3 -expand 0


		# Initialize some dialog defaults
		if { $ttinitialize == true } {
			set pointsize 1
			set extrudedepth 0.1
			set beveldepth 40
			set bevelangle 45
			set fontdetail 5

			.tt.f3.c.objectsolid select
		}
		active_options_toggle
	}
		
	wm deiconify .tt
#	centre_window_on_screen .tt

	# set focus on text entry widget:
	focus .tt.f2.b.text
}


proc active_options_toggle {} {

	global objecttype

	set w .tt.f3.a

	switch $objecttype {
		"Outline" -
		"Solid" { $w.extrudedepth configure -state disabled; $w.beveldepth configure -state disabled; $w.bevelangle configure -state disabled }
		"Extrude" { $w.extrudedepth configure -state normal; $w.beveldepth configure -state disabled; $w.bevelangle configure -state disabled }
		"Bevel" { $w.extrudedepth configure -state normal; $w.beveldepth configure -state normal; $w.bevelangle configure -state normal }
	}
}
