# Copyright (c) 2008, Inivis Limited. All rights reserved.

# General utility stuff

# option add *font -*-*-*-*-*-*-10-*-*-*-*-*-*-*

#package require tkpng

# Mac style for popup window (e.g. TCE)  "floating" or "document"
#if { $ac_platform == "Mac" } {
#	ac3d add_pref mac_tool_window_style "floating"
#}

proc new_toplevel { name title } {
global ac_platform tcl_platform prefs_mac_tool_window_style

    if {($tcl_platform(platform) eq "macintosh")
            || ([tk windowingsystem] eq "aqua")} {
		toplevel $name -class Dialog ; ::tk::unsupported::MacWindowStyle style $name floating { collapseBox closeBox resizable verticalZoom horizontalZoom} 
    } else {
		toplevel $name -class Dialog
	}


	if { $ac_platform != "Mac" } {
        wm transient $name [winfo toplevel [winfo parent $name]]
    }

    wm title $name $title


	return $name
}

proc new_toplevel_document { name title } {
global ac_platform tcl_platform prefs_mac_tool_window_style

    if {($tcl_platform(platform) eq "macintosh")
            || ([tk windowingsystem] eq "aqua")} {
		toplevel $name -class Dialog ; ::tk::unsupported::MacWindowStyle style $name document { collapseBox closeBox resizable verticalZoom horizontalZoom} 
    } else {
		toplevel $name -class Dialog
	}


#	if { $ac_platform != "Mac" } {
#        wm transient $name [winfo toplevel [winfo parent $name]]
#    }

    wm title $name $title


	return $name
}



proc new_toplevel_with_menu { name title } {
global ac_platform tcl_platform

    toplevel $name -class Dialog

	if { $ac_platform != "Mac" } {
        wm transient $name [winfo toplevel [winfo parent $name]]
    }

    wm title $name $title

# mac floatProcs can't have a menu - poo.
#    if {($tcl_platform(platform) eq "macintosh")
#            || ([tk windowingsystem] eq "aqua")} {
#		::tk::unsupported::MacWindowStyle style $name floatProc
#    }

	return $name
}


proc new_toplevel_tracked { name title trackvarname} {

	set win [ new_toplevel $name $title ]
	track_window_geometry $win $trackvarname
	upvar #0 $trackvarname geom
	
	if { $geom == "" } { 
#	puts "centering window"
		centre_window_on_screen $win
	} else {
		wm geometry $win $geom
	}
	
}


proc new_toplevel_document_tracked { name title trackvarname} {

	set win [ new_toplevel_document $name $title ]
	track_window_geometry $win $trackvarname
	upvar #0 $trackvarname geom
	
	if { $geom == "" } { 
#	puts "centering window"
		centre_window_on_screen $win
	} else {
		wm geometry $win $geom
	}
	
}




# experimental animation stuff 

set fps 25
set playing false
set max_time 60

proc anim_update_bar { } {
global animbar

	set ct [ ac3d animator_get_current_time ]
	set olds [ $animbar cget -state ]
	$animbar configure -state normal
	$animbar set $ct
	$animbar configure -to [ac3d animator_get_max_time]
	$animbar configure -state $olds

}



proc anim_play { } {
global playing fps animbar

	set t [expr 1000 / $fps ]
	if { $playing } {
		ac3d animator_advance_animation 0.5; ac3d redraw_3d
		after $t anim_play
		}

	anim_update_bar
}

proc anim_bar_moved { val } {

	ac3d animator_set_current_time $val

	ac3d redraw_3d
}



proc anim { } {
global animbar

	set t [new_toplevel .anim "Anim"]

	set animbar [scale $t.bar -from 0 -to 100 -orient horiz -command anim_bar_moved -length 300]
	pack $t.bar -side bottom

	button $t.play -text "play" -command "anim_update_bar; $animbar configure -state disabled; set playing true; anim_play"
	button $t.stop -text "stop" -command "set playing false; $animbar configure -state normal;"

	button $t.advf -text ">" -command "ac3d animator_advance_animation 1; ac3d redraw_3d ; anim_update_bar"
	button $t.advb -text "<" -command "ac3d animator_advance_animation -1; ac3d redraw_3d ; anim_update_bar"
	button $t.advbeg -text "|<" -command "ac3d animator_set_current_time 1; ac3d redraw_3d ; anim_update_bar"
	button $t.advend -text ">|" -command "ac3d animator_set_current_time [ac3d animator_get_max_time]; ac3d redraw_3d ; anim_update_bar"


	pack $t.advbeg $t.advb $t.play $t.advf $t.advend $t.stop -side left

}

#anim


# A Notebook widget for Tcl/Tk
# $Revision: 1.15 $
#
# Copyright (C) 1996,1997,1998 D. Richard Hipp
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.
#
# Author contact information:
#   drh@acm.org
#   http://www.hwaci.com/drh/

# modified slightly by Andy - changed size of buttons and width of lines.

#
# Create a new notebook widget
#
proc Notebook:create {w args} {
  global Notebook
  set Notebook($w,width) 400
  set Notebook($w,height) 400
  set Notebook($w,pages) {}
  set Notebook($w,top) 0
  set Notebook($w,pad) 5
  set Notebook($w,fg,on) black
  set Notebook($w,fg,off) grey50
  set Notebook($w,lw) 1
  canvas $w -bd 0 -highlightthickness 0 -takefocus 0
  set Notebook($w,bg) [$w cget -bg]
  bind $w <1> "Notebook:click $w %x %y"
  bind $w <Configure> "Notebook:scheduleExpand $w"
  eval Notebook:config $w $args
}

#
# Change configuration options for the notebook widget
#
proc Notebook:config {w args} {
  global Notebook
  foreach {tag value} $args {
    switch -- $tag {
      -width {
        set Notebook($w,width) $value
      }
      -height {
        set Notebook($w,height) $value
      }
      -pages {
        set Notebook($w,pages) $value
      }
      -pad {
        set Notebook($w,pad) $value
      }
      -bg {
        set Notebook($w,bg) $value
      }
      -fg {
        set Notebook($w,fg,on) $value
      }
      -disabledforeground {
        set Notebook($w,fg,off) $value
      }
    }
  }

  #
  # After getting new configuration values, reconstruct the widget
  #
  $w delete all
  set Notebook($w,x1) $Notebook($w,pad)
  set Notebook($w,x2) [expr $Notebook($w,x1)+2]
  set Notebook($w,x3) [expr $Notebook($w,x2)+$Notebook($w,width)]
  set Notebook($w,x4) [expr $Notebook($w,x3)+2]
  set Notebook($w,y1) [expr $Notebook($w,pad)+2]
  set Notebook($w,y2) [expr $Notebook($w,y1)+2]

  # button height:
  set Notebook($w,y5) [expr $Notebook($w,y1)+20] 

  set Notebook($w,y6) [expr $Notebook($w,y5)+2]
  set Notebook($w,y3) [expr $Notebook($w,y6)+$Notebook($w,height)]
  set Notebook($w,y4) [expr $Notebook($w,y3)+2]
  set x $Notebook($w,x1)
  set cnt 0

  # button text y offset
  set y7 [expr $Notebook($w,y1)+5]

  set wid $Notebook($w,lw)

  foreach p $Notebook($w,pages) {
    set Notebook($w,p$cnt,x5) $x
    set id [$w create text 0 0 -text $p -anchor nw -tags "p$cnt t$cnt"]
    set bbox [$w bbox $id]
    set width [lindex $bbox 2]
    $w move $id [expr $x+10] $y7

	# button white highlight:
    $w create line \
       $x $Notebook($w,y5)\
       $x $Notebook($w,y2) \
       [expr $x+2] $Notebook($w,y1) \
       [expr $x+$width+16] $Notebook($w,y1) \
       -width $wid -fill white -tags p$cnt

	# black button shadow
    $w create line \
       [expr $x+$width+16] $Notebook($w,y1) \
       [expr $x+$width+18] $Notebook($w,y2) \
       [expr $x+$width+18] $Notebook($w,y5) \
       -width $wid -fill black -tags p$cnt

    set x [expr $x+$width+20]
    set Notebook($w,p$cnt,x6) [expr $x-2]
    if {![winfo exists $w.f$cnt]} {
      frame $w.f$cnt -bd 0
    }
    $w.f$cnt config -bg $Notebook($w,bg)
    place $w.f$cnt -x $Notebook($w,x2) -y $Notebook($w,y6) \
      -width $Notebook($w,width) -height $Notebook($w,height)
    incr cnt
  }

  # main frame white highlight
  $w create line \
     $Notebook($w,x1) [expr $Notebook($w,y5)-2] \
     $Notebook($w,x1) $Notebook($w,y3) \
     -width $wid -fill white

  # main frame black shadow
  $w create line \
     $Notebook($w,x1) $Notebook($w,y3) \
     $Notebook($w,x2) $Notebook($w,y4) \
     $Notebook($w,x3) $Notebook($w,y4) \
     $Notebook($w,x4) $Notebook($w,y3) \
     $Notebook($w,x4) $Notebook($w,y6) \
     $Notebook($w,x3) $Notebook($w,y5) \
     -width $wid -fill black

  $w config -width [expr $Notebook($w,x4)+$Notebook($w,pad)] \
            -height [expr $Notebook($w,y4)+$Notebook($w,pad)] \
            -bg $Notebook($w,bg)
  set top $Notebook($w,top)
  set Notebook($w,top) -1
  Notebook:raise.page $w $top
}

#
# This routine is called whenever the mouse-button is pressed over
# the notebook.  It determines if any page should be raised and raises
# that page.
#
proc Notebook:click {w x y} {
  global Notebook
  if {$y<$Notebook($w,y1) || $y>$Notebook($w,y6)} return
  set N [llength $Notebook($w,pages)]
  for {set i 0} {$i<$N} {incr i} {
    if {$x>=$Notebook($w,p$i,x5) && $x<=$Notebook($w,p$i,x6)} {
      Notebook:raise.page $w $i
      break
    }
  }
}

#
# For internal use only.  This procedure raised the n-th page of
# the notebook
#
proc Notebook:raise.page {w n} {
  global Notebook
  if {$n<0 || $n>=[llength $Notebook($w,pages)]} return
  set top $Notebook($w,top)
  if {$top>=0 && $top<[llength $Notebook($w,pages)]} {
    $w move p$top 0 2
  }

set wid $Notebook($w,lw)
  $w move p$n 0 -2
  $w delete topline
  if {$n>0} {
    $w create line \
       $Notebook($w,x1) $Notebook($w,y6) \
       $Notebook($w,x2) $Notebook($w,y5) \
       $Notebook($w,p$n,x5) $Notebook($w,y5) \
       $Notebook($w,p$n,x5) [expr $Notebook($w,y5)-2] \
       -width $wid -fill white -tags topline
  }
  $w create line \
    $Notebook($w,p$n,x6) [expr $Notebook($w,y5)-2] \
    $Notebook($w,p$n,x6) $Notebook($w,y5) \
    -width $wid -fill white -tags topline
  $w create line \
    $Notebook($w,p$n,x6) $Notebook($w,y5) \
    $Notebook($w,x3) $Notebook($w,y5) \
    -width $wid -fill white -tags topline
  set Notebook($w,top) $n
  raise $w.f$n
}

#
# Change the page-specific configuration options for the notebook
#
proc Notebook:pageconfig {w name args} {
  global Notebook
  set i [lsearch $Notebook($w,pages) $name]
  if {$i<0} return
  foreach {tag value} $args {
    switch -- $tag {
      -state {
        if {"$value"=="disabled"} {
          $w itemconfig t$i -fg $Notebook($w,fg,off)
        } else {
          $w itemconfig t$i -fg $Notebook($w,fg,on)
        }
      }
      -onexit {
        set Notebook($w,p$i,onexit) $value
      }
    }
  }
}

#
# This procedure raises a notebook page given its name.  But first
# we check the "onexit" procedure for the current page (if any) and
# if it returns false, we don't allow the raise to proceed.
#
proc Notebook:raise {w name} {
  global Notebook
  set i [lsearch $Notebook($w,pages) $name]
  if {$i<0} return
  if {[info exists Notebook($w,p$i,onexit)]} {
    set onexit $Notebook($w,p$i,onexit)
    if {"$onexit"!="" && [eval uplevel #0 $onexit]!=0} {
      Notebook:raise.page $w $i
    }
  } else {
    Notebook:raise.page $w $i
  }
}

#
# Return the frame associated with a given page of the notebook.
#
proc Notebook:frame {w name} {
  global Notebook
  set i [lsearch $Notebook($w,pages) $name]
  if {$i>=0} {
    return $w.f$i
  } else {
    return {}
  }
}

#
# Try to resize the notebook to the next time we become idle.
#
proc Notebook:scheduleExpand w {
  global Notebook

  if {[info exists Notebook($w,expand)]} return
  set Notebook($w,expand) 1
  after idle "Notebook:expand $w"
}

#
# Resize the notebook to fit inside its containing widget.
#
proc Notebook:expand w {
  global Notebook
  set wi [expr [winfo width $w]-($Notebook($w,pad)*2+4)]
# had to make the 36 into a 26 to stop widget contracting
# this is because I changed y7 by -10
  set hi [expr [winfo height $w]-($Notebook($w,pad)*2+26)]
  Notebook:config $w -width $wi -height $hi
  catch {unset Notebook($w,expand)}
}




########## SIMPLE GLOBAL ENTITY BROWSER
return;


proc print_entity { e } {

	set cl [ac3d entity_get_class $e ]
	set class_name [ac3d entity_get_class_name $e]
	puts "ENTITY of class '$class_name'"

	set res [ac3d entity_class_get_resources $cl]
	foreach r $res {
		set resname [ac3d resource_get_name $r]
		set restype [ac3d resource_get_type $r]

		set val [ac3d entity_get_value $e $resname]
		puts "    resource: $resname  type: $restype  value: \"$val\""
		
	}

	puts "\n"
}


proc print_all { } {

	set all [ac3d entitymanager_get_all]

	foreach e $all {
		print_entity $e

	}
}

proc print_by_class { cl } {

	set all [ac3d entitymanager_get_by_class $cl]

	foreach e $all {
		print_entity $e

	}
}





toplevel .all
button .all.b -text "Print all entities" -command print_all
pack .all.b -fill x
button .all.b2 -text "Print all objects" -command { print_by_class object }
pack .all.b2 -fill x
button .all.b3 -text "Print all materials" -command { print_by_class material }
pack .all.b3 -fill x
button .all.b4 -text "Print all cameras" -command { print_by_class camera }
pack .all.b4 -fill x
button .all.b5 -text "Print all views" -command { print_by_class view }
pack .all.b5 -fill x
button .all.b6 -text "Print all images" -command { print_by_class image }
pack .all.b6 -fill x










