# AC3D
# Copyright (c) 2008, Inivis Limited. All rights reserved.

# AC3D UV Editor

# uvmode is surface or vertex
set uvmode surface



proc uv_do_sensitivity { } {
global uvmode
global UI

	set numvert [ac3d uv_get_selected_vertices]
	set numsurf [ac3d uv_get_selected_surfaces]

#	puts "num selected $numvert $numsurf";

	# if nothing is selected - disable everything
	if { ( $numvert == 0 ) && ($numsurf == 0) } {
		set_sensitive false $UI(uvsnap) $UI(uvsnapleft) $UI(uvsnapright) $UI(uvsnaptop) $UI(uvsnapbottom) $UI(uvsnapwidth)  $UI(uvsnapheight)  $UI(uvsnapmax)
		set_sensitive false $UI(uvremap0) $UI(uvremap1) $UI(uvremap2) $UI(uvremap3) $UI(uvremap4) $UI(uvremap5) $UI(uvremap6)
		set_sensitive false $UI(uvflip0) $UI(uvflip1)
		set_sensitive false $UI(uvrotate0) $UI(uvrotate1)
		set_sensitive false $UI(uvmoveget) $UI(uvmove) $UI(uvmoveabs) $UI(uvmoveabsneg)
		return; 
	}
	
	# something is selected

	# don't allow flip or rotate > 0 surfaces or more than one vertex is selected
	if { ( $numvert >1 ) || ($numsurf >0) } {
		set_sensitive true $UI(uvflip0) $UI(uvflip1)
		set_sensitive true $UI(uvrotate0) $UI(uvrotate1)
	} else {
		set_sensitive false $UI(uvflip0) $UI(uvflip1)
		set_sensitive false $UI(uvrotate0) $UI(uvrotate1)
	}

	set_sensitive TRUE $UI(uvsnapleft) $UI(uvsnapright) $UI(uvsnaptop) $UI(uvsnapbottom)  $UI(uvsnapwidth)  $UI(uvsnapheight)  $UI(uvsnapmax)
	set_sensitive TRUE $UI(uvmoveget) $UI(uvmove) $UI(uvmoveabs) $UI(uvmoveabsneg)


	if { $uvmode == "surface" } {
		set_sensitive true $UI(uvremap0) $UI(uvremap1) $UI(uvremap2) $UI(uvremap3) $UI(uvremap4) $UI(uvremap5) $UI(uvremap6)
		set_sensitive false $UI(uvsnap) 
	} else {
		set_sensitive false $UI(uvremap0) $UI(uvremap1) $UI(uvremap2) $UI(uvremap3) $UI(uvremap4) $UI(uvremap5) $UI(uvremap6)
		if { $numvert > 1} {
			set_sensitive true $UI(uvsnap)
		} else {
			set_sensitive false $UI(uvsnap)
		}
	}
}


# add pref for TCE window position and size
ac3d add_pref "window_geom_tce" ""

# TCE can be child of main window or a new main window
ac3d add_pref "tce_is_floating" "true"

# setting for TCE rotation
ac3d add_pref "uv_rot_degs" "90"

proc menu_uveditor { } {
global uvmode
global prefs_uveditor_bgcol prefs_uveditor_edgecol uveditor_tile
global UI tcl_platform ac_platform 
global prefs_whiteboard_accel prefs_mousewheel_factor prefs_force_window_focus
global prefs_tce_is_floating

    if [winfo exists .uvedit] { wm deiconify .uvedit; raise .uvedit; return }

#	new_toplevel_with_menu .uvedit "AC3D Texture Coordinate Editor"
# changed to home grown menus so that new window can be child of main app window

	if { $prefs_tce_is_floating } {
		new_toplevel_tracked .uvedit "AC3D Texture Coordinate Editor" prefs_window_geom_tce
	} else {
		new_toplevel_document_tracked .uvedit "AC3D Texture Coordinate Editor" prefs_window_geom_tce
	}
	
	wm protocol .uvedit WM_DELETE_WINDOW { ac3d closeuv; destroy .uvedit }


	# UV FILE MENU
	if {$ac_platform == "Mac" } {
		frame .uvedit.mbar -bd 1 -relief raised
		ac_menubutton .uvedit.mbar.file "File" .uvedit.mbar.file.menu
		pack .uvedit.mbar.file -side left
	} else {
		menu .uvedit.mbar -tearoff 0 -type normal
		menubutton .uvedit.mbar.file -text "Window" -menu .mbar.file.menu -underline 0
		.uvedit.mbar add cascade -menu .uvedit.mbar.file.menu -label "Window" -underline 0
	}

	menu .uvedit.mbar.file.menu -tearoff 0

	if { $tcl_platform(platform) == "windows" } {
		.uvedit.mbar.file.menu add command -label "Copy UV-map to Windows clipboard" -command "update; ac3d uv_copy_map_to_clipboard"
		.uvedit.mbar.file.menu add command -label "Copy window image to Windows clipboard" -command "update; ac3d uv_copy_to_clipboard"
		.uvedit.mbar.file.menu add separator
	}

	if {$ac_platform == "Mac" } {
		.uvedit.mbar.file.menu add command -label "Copy UV-map to Mac clipboard" -command "update; ac3d uv_copy_map_to_clipboard"
		.uvedit.mbar.file.menu add command -label "Copy window image to Mac clipboard" -command "update; ac3d uv_copy_to_clipboard"
		.uvedit.mbar.file.menu add separator
	}

	.uvedit.mbar.file.menu add command -label "Close" -command "ac3d closeuv; destroy .uvedit"


	# UV EDIT MENU
	if {$ac_platform == "Mac" } {
		ac_menubutton .uvedit.mbar.edit "Edit" .uvedit.mbar.edit.menu
		pack .uvedit.mbar.edit -side left
	} else {
		menubutton .uvedit.mbar.edit -text "Edit" -menu .mbar.file.menu -underline 0
		.uvedit.mbar add cascade -menu .uvedit.mbar.edit.menu -label "Edit" -underline 0
	}
	menu .uvedit.mbar.edit.menu -tearoff 0

	.uvedit.mbar.edit.menu add command -label "Select all" -command "ac3d uv_select_all" -accelerator [accel Ctrl+A]
    .uvedit.mbar.edit.menu add separator
    .uvedit.mbar.edit.menu add command -label "Undo" -command "ac3d undo" -accelerator [accel Ctrl+Z] -underline 0
    .uvedit.mbar.edit.menu add command -label "Redo" -command "ac3d redo" -accelerator [accel Ctrl+Shift+Z] -underline 0
    .uvedit.mbar.edit.menu add separator
    .uvedit.mbar.edit.menu add command -label "Refresh subdivisions" -command "ac3d remake_subdivisions" -underline 1

	# UV VIEW MENU
	if {$ac_platform == "Mac" } {
		ac_menubutton .uvedit.mbar.view "View" .uvedit.mbar.view.menu
		pack .uvedit.mbar.view -side left
	} else {
		menubutton .uvedit.mbar.view -text "View" -menu .mbar.view.menu -underline 0
		.uvedit.mbar add cascade -menu .uvedit.mbar.view.menu -label "View" -underline 0
	}

	menu .uvedit.mbar.view.menu -tearoff 0

	.uvedit.mbar.view.menu add command -label "Reset" -command "ac3d uv_view_reset"
	.uvedit.mbar.view.menu add separator
	.uvedit.mbar.view.menu add checkbutton -label "Antialias lines" -variable prefs_uveditor_antialias -command "ac3d uv_redisplay"
	.uvedit.mbar.view.menu add checkbutton -label "Tile texture" -variable prefs_uveditor_tile -command { ac3d uv_redisplay }
	.uvedit.mbar.view.menu add checkbutton -label "Stipple selected surfaces" -variable prefs_uveditor_selected_surface_stipple -command { ac3d uv_redisplay }
	.uvedit.mbar.view.menu add checkbutton -label "Stipple unselected surfaces" -variable prefs_uveditor_unselected_surface_stipple -command { ac3d uv_redisplay }


	# add the menu to the top of the window
	if {$ac_platform == "Mac" } {
		pack .uvedit.mbar -fill x -ipady 2 -ipadx 2
	} else {
		.uvedit configure -menu .uvedit.mbar -bd 1
	}


	set UI(uv_toolbar) [ frame .uvedit.toolbar ]



	
	set UI(uv_coor) [label $UI(uv_toolbar).uvcoor -text ""]
	pack $UI(uv_coor) -side left


	set cp [frame .uvedit.cp -padx 3]
	set gl [ frame .uvedit.gl -border 2 -relief sunken]
	set togl [togl $gl.win -rgba true -double true]

	set UI(uveditview) $togl

	set uvinfolab [ label .uvedit.info -text " "]
	pack $uvinfolab -side bottom -fill x -expand 0

	set uvinfolab2 [ label .uvedit.info2 -text " "]
	pack $uvinfolab2 -side bottom -fill x -expand 0

	pack $cp -side left -fill y
	pack $UI(uv_toolbar)  -side top -fill x

	pack $gl -fill both -expand 1
	pack $togl -fill both -expand 1


	set sb [section_frame $cp.uvmodetitle "Select by" ]
	pack $cp.uvmodetitle -fill x

	set surfacemodebutton [radiobutton $sb.select_mode_surface  -text "Surface " -variable uvmode -value surface -indicatoron true -padx 0 -pady 0 -command \
		{ ac3d uv_selectmode 0 ; uv_do_sensitivity } ]
	pack $surfacemodebutton -anchor w
	set vertexmodebutton [radiobutton $sb.select_mode_vertex  -text "Vertex " -variable uvmode -value vertex -indicatoron true -padx 0 -pady 0 -command "ac3d uv_selectmode 0" -indicatoron true -padx 0 -pady 0 -command \
		{ ac3d uv_selectmode 1 ; uv_do_sensitivity } ]
	pack $vertexmodebutton -anchor w


	set self [section_frame $cp.sel "Select" ]
	pack $self -fill x
	cbutton $self.b  "All" "ac3d uv_select_all " "select everything"
	cbutton $self.b2  "None" "ac3d uv_clear_selection " "select nothing"
	pack $self.b $self.b2 -side left -fill both -expand 1



	set remf [section_frame $cp.remap "Remap" ]
	pack $remf -fill x

	set UI(uvremap0) [cbutton $remf.b6  "front" "ac3d uv_remap 0" "map selected surfaces from front"]
	grid $remf.b6 -row 0 -column 0  -sticky we
	set UI(uvremap3) [cbutton $remf.b9  "back" "ac3d uv_remap 3" "map selected surfaces from back"]
	grid $UI(uvremap3) -row 0 -column 1  -sticky we

	set UI(uvremap1) [cbutton $remf.b7  "left" "ac3d uv_remap 1 " "map selected surfaces left"]
	grid $remf.b7 -row 1 -column 0  -sticky we
	set UI(uvremap4) [cbutton $remf.b10  "right" "ac3d uv_remap 4 " "map selected surfaces right"]
	grid $UI(uvremap4) -row 1 -column 1  -sticky we

	set UI(uvremap2) [cbutton $remf.b8  "top" "ac3d uv_remap 2" "map selected surfaces top"]
	grid $remf.b8 -row 2 -column 0  -sticky we

	set UI(uvremap5) [cbutton $remf.b11  "bottom" "ac3d uv_remap 5" "map selected surfaces bottom"]
	grid $UI(uvremap5) -row 2 -column 1  -sticky we

	set UI(uvremapr) [checkbutton $remf.rr -text "Keep size ratio" -variable prefs_uv_map_keep_ratio ]
	grid $UI(uvremapr) -row 3 -column 0 -columnspan 2  -sticky w
	add_balloon $UI(uvremapr) "when mapping, retain the proportions of the vertices in the model?"
	
	set UI(uvremap6) [cbutton $remf.b12  "spherical" "ac3d uv_remap 6" "map selected surfaces spherically"]
	grid $UI(uvremap6) -row 4 -column 0 -columnspan 2  -sticky we
	grid columnconfigure $remf 0 -weight 1
	grid columnconfigure $remf 0 -weight 1



	set fp [ section_frame $cp.flip "Flip" ]
	pack $cp.flip -fill x 
	set UI(uvflip0) [cbutton $fp.b  "Horiz" "ac3d uv_flip 1" "flip selection horizontaly"]

	set UI(uvflip1) [cbutton $fp.b2  "Vert" "ac3d uv_flip 0" "flip selection vertically"]
	pack $fp.b $fp.b2 -side left -fill both -expand 1


	set rp [ section_frame $cp.rotate "Rotate" ]
	pack $cp.rotate -fill x


	spinbox $rp.degs -width 4 -textvariable prefs_uv_rot_degs -from 0 -to 360 -increment 1
	pack $rp.degs -side left
	

	set UI(uvrotate1) [cbutton $rp.b4  "CCW" {ac3d uv_rotate -$prefs_uv_rot_degs} "rotate the selection this number of degrees counter-clockwise"]
	pack $rp.b4 -side left -fill both -expand 1

	set UI(uvrotate0) [cbutton $rp.b3  "CW" {ac3d uv_rotate $prefs_uv_rot_degs} "rotate the selection this number of degrees clockwise"]
	pack $rp.b3 -side left -fill both -expand 1






	set snapf [section_frame $cp.snapf "Snap" ]
	pack $snapf -fill x
	
	set UI(uvsnap) [cbutton $snapf.b5  "Together" "ac3d uv_snap_together" "move all selected uvs to the same point"]
	grid $UI(uvsnap) -row 0 -column 0 -columnspan 2 -sticky we
	set UI(uvsnapleft) [cbutton $snapf.b6  " Left" "ac3d uv_snap_to_side left" "move the selection to the left side"]
	grid $UI(uvsnapleft) -row 1 -column 0 -sticky we 
	set UI(uvsnapright) [cbutton $snapf.b7  "Right" "ac3d uv_snap_to_side right" "move the selection to the right side"]
	grid $UI(uvsnapright) -row 1 -column 1 -sticky we
	set UI(uvsnaptop) [cbutton $snapf.b8  " Top " "ac3d uv_snap_to_side top" "move the selection to the top side"]
	grid $UI(uvsnaptop) -row 2 -column 0 -sticky we
	set UI(uvsnapbottom) [cbutton $snapf.b9  "Bottom" "ac3d uv_snap_to_side bottom" "move the selection to the bottom side"]
	grid $UI(uvsnapbottom) -row 2 -column 1 -sticky we

	set UI(uvsnapwidth) [cbutton $snapf.b10  "Width" "ac3d uv_snap_to_edges 1" "size the selection to fit the width of the texture"]
	grid $UI(uvsnapwidth) -row 3 -column 0 -sticky we

	set UI(uvsnapheight) [cbutton $snapf.b11  "Height" "ac3d uv_snap_to_edges 2" "size the selection to fit the height of the texture"]
	grid $UI(uvsnapheight) -row 3 -column 1 -sticky we

	set UI(uvsnapmax) [cbutton $snapf.b12  "Max" "ac3d uv_snap_to_edges 3" "size the selection to fit the texture"]
	grid $UI(uvsnapmax) -row 4 -column 0 -sticky we -columnspan 2


	grid columnconfigure $snapf 0 -weight 1
	grid columnconfigure $snapf 0 -weight 1

	set movef [section_frame $cp.movef "Move" ]
	pack $cp.movef -fill x
	set UI(uvmoveget) [ cbutton $cp.movef.bg ">" { set pos [ ac3d uv_get_bb_centre ]; set prefs_uv_move_x [lindex $pos 0]; set prefs_uv_move_y [lindex $pos 1] } "put the current position the fields"]
	grid $UI(uvmoveget) -row 0 -column 0

	entry $movef.mx -width 6 -textvariable prefs_uv_move_x
	grid $movef.mx -row 0 -column 1
	entry $movef.my -width 6  -textvariable prefs_uv_move_y
	grid $movef.my -row 0 -column 2

	set UI(uvmove) [cbutton $movef.b1  "Move to" {ac3d uv_move_to $prefs_uv_move_x $prefs_uv_move_y} "move (center of) selection to this point"]
	grid $UI(uvmove) -row 1 -column 0  -columnspan 3


	set movef [section_frame $cp.sizef "Size" ]
	pack $cp.sizef -fill x
	set UI(uvsizeget) [ cbutton $cp.sizef.bg ">" { set pos [ ac3d uv_get_bb_size ]; set prefs_uv_size_x [lindex $pos 0]; set prefs_uv_size_y [lindex $pos 1] } "put the current size the fields"]
	grid $UI(uvsizeget) -row 0 -column 0

	entry $cp.sizef.mx -width 6 -textvariable prefs_uv_size_x
	grid $cp.sizef.mx -row 0 -column 1
	entry $cp.sizef.my -width 6  -textvariable prefs_uv_size_y
	grid $cp.sizef.my -row 0 -column 2

	set UI(uvmove) [cbutton $cp.sizef.b1  "Size to" {ac3d uv_size_to $prefs_uv_size_x $prefs_uv_size_y} "size selection to these dimensions"]
	grid $UI(uvmove) -row 1 -column 0  -columnspan 3


	set shiftf [section_frame $cp.shiftf "Shift" ]
	pack $cp.shiftf -fill x
	entry $shiftf.mx -width 7 -textvariable prefs_uv_shift_x
	grid $shiftf.mx -row 0 -column 0
	entry $shiftf.my -width 7  -textvariable prefs_uv_shift_y
	grid $shiftf.my -row 0 -column 1

	set UI(uvmoveabs) [cbutton $shiftf.b2  "  +  " {ac3d uv_move_relative $prefs_uv_shift_x $prefs_uv_shift_y } "shift selected uvs by this amount"]
	grid $UI(uvmoveabs) -row 1 -column 0  -sticky e
	set UI(uvmoveabsneg) [cbutton $shiftf.b3  "  -  " {ac3d uv_move_relative -$prefs_uv_shift_x -$prefs_uv_shift_y } "shift selected uvs by this amount"]
	grid $UI(uvmoveabsneg) -row 1 -column 1  -sticky w




	# UI cols
	set b2 [ coledit_button $cp.bgbuttonb prefs_uveditor_bgcol "Background"  "ac3d uv_redisplay"]
	pack $b2  -fill x -side bottom

	set b [ coledit_button $cp.bgbutton prefs_uveditor_selectedcol "Selected"  "ac3d uv_redisplay"]
	pack $b  -fill x -side bottom
	
	set b1 [ coledit_button $cp.bgbutton2 prefs_uveditor_edgecol "Edges"  "ac3d uv_redisplay"]
	pack $b1 -fill x -side bottom

	set movef [section_frame $cp.defaultsize "Default size" ]
	pack $cp.defaultsize -fill x



	# set default texture size
	entry $cp.defaultsize.mx -width 6 -textvariable prefs_uv_default_texture_width
	grid $cp.defaultsize.mx -row 0 -column 1
	entry $cp.defaultsize.my -width 6  -textvariable prefs_uv_default_texture_height
	grid $cp.defaultsize.my -row 0 -column 2
	set UI(uvsetts) [cbutton $cp.defaultsize.b1  "Set default size" {ac3d uv_update_texture_size } "set the size of the default texture (outlined on TCE display)"]
	grid $UI(uvsetts) -row 1 -column 0  -columnspan 3
	


	# ZOOM (binding code is in ac3dview.tcl)
	image create photo zoom -file tcl/images/zoom.png
	set UVZoomButton [label $UI(uv_toolbar).zoom -image zoom -bd 1 -relief flat -highlightthickness 0]
	pack  $UVZoomButton -side right
	zoombind $UVZoomButton $UI(uveditview)
	add_balloon $UVZoomButton "hold down and drag mouse up/down to zoom view"


	# PAN
	image create photo pan -file tcl/images/pan.png
	set UVPanButton [label $UI(uv_toolbar).pan -image pan -text Pan -borderwidth 1 -relief flat -highlightthickness 0]
	pack  $UVPanButton -side right
	panbind $UVPanButton $UI(uveditview)
	add_balloon $UVPanButton "hold down and drag mouse to move (pan) this view"



	# view scale buttons
	label $UI(uv_toolbar).space -text "  "
	pack $UI(uv_toolbar).space -side right	
	button $UI(uv_toolbar).scale200 -text "200%" -command "ac3d uv_set_scale 2.0"
	pack $UI(uv_toolbar).scale200 -side right
	button $UI(uv_toolbar).scale100 -text "100%" -command "ac3d uv_set_scale 1.0"
	pack $UI(uv_toolbar).scale100 -side right
	button $UI(uv_toolbar).scale50 -text "50%" -command "ac3d uv_set_scale .5"
	pack $UI(uv_toolbar).scale50 -side right
	label $UI(uv_toolbar).view -text "View at:"
	pack $UI(uv_toolbar).view -side right	

	set UI(uv_scale) [ label $UI(uv_toolbar).scale -text "" ]
	pack $UI(uv_toolbar).scale -side right	
	
	# tell AC3D about this UV editor
	ac3d inituv $togl

	# set the mode in the C code
	if {$uvmode == "surface" } {
		ac3d uv_selectmode 0
	} else {
		ac3d uv_selectmode 1
	}

	acbind .uvedit <Control-z> "ac3d undo"
	acbind .uvedit <Control-Z> "ac3d redo"

    acbind .uvedit <Control-t> {ac3d uv_snap_together} 
    acbind .uvedit <Control-a> {ac3d uv_select_all}

	if { $prefs_force_window_focus } {
		bind .uvedit <Enter> {focus -force .uvedit}
	} else {
		bind .uvedit <Enter> {focus .uvedit}
	}

	bind .uvedit <MouseWheel> {
# these didn't give correct values on the Mac
#		set x %X
#		set y %Y

		# these work on the Mac
		set x [winfo pointerx %W]
		set y [winfo pointery %W]


		set d %D
		set w %W
		set over [winfo containing $x $y]

		# warning - constant!
		set z [expr $d/$prefs_mousewheel_factor]
#	puts "mousewheel $x $y $d over window: '$over' w: $w "

		# zoom the uv editor if necc
		catch {	if {$over == $UI(uveditview) } { uvedit_zoom $z } }
	}


	bind .uvedit s { set uvmode surface ; ac3d uv_selectmode 0 ; uv_do_sensitivity } 
	bind .uvedit v { set uvmode vertex; ac3d uv_selectmode 1 ; uv_do_sensitivity } 

#	bind $gl <Configure> { puts "conf"}

#	centre_window_on_screen .uvedit
	uv_do_sensitivity
}



# zoom called from mousewheel binding

proc uvedit_zoom { a} {
	ac3d uv_zoom $a
}

